<?php ($business_name = \App\CentralLogics\Helpers::get_settings('business_name')); ?>
<?php $__env->startSection('title', translate('messages.landing_page') . ' | ' . $business_name != 'null' ? $business_name : 'Sixam Mart'); ?>
<?php $__env->startSection('content'); ?>

    <!-- Basic Settings -->
    <?php ($front_end_url = \App\Models\BusinessSetting::where(['key' => 'front_end_url'])->first()); ?>
    <?php ($front_end_url = $front_end_url ? $front_end_url->value : null); ?>
    <?php ($landing_page_text = \App\Models\BusinessSetting::where(['key' => 'landing_page_text'])->first()); ?>
    <?php ($landing_page_text = isset($landing_page_text->value) ? json_decode($landing_page_text->value, true) : null); ?>
    <?php ($landing_page_links = \App\Models\BusinessSetting::where(['key' => 'landing_page_links'])->first()); ?>
    <?php ($landing_page_links = isset($landing_page_links->value) ? json_decode($landing_page_links->value, true) : null); ?>
    <?php ($landing_page_images = \App\Models\BusinessSetting::where(['key' => 'landing_page_images'])->first()); ?>
    <?php ($landing_page_images = isset($landing_page_images->value) ? json_decode($landing_page_images->value, true) : null); ?>
    <!-- ==== Banner Section Starts Here ==== -->
    <?php ($logo = \App\Models\BusinessSetting::where(['key' => 'logo'])->first()); ?>
    <section class="banner-section position-relative">
        <div class="container">
            <div class="banner-content wow fadeInUp">
                <h1 class="title"><?php echo e($landing_data['fixed_header_title']); ?></h1>
                <img class="w-100 onerror-image" data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>"
                    src="<?php echo e(\App\CentralLogics\Helpers::get_full_url('business', $logo?->value ?? '', $logo?->storage[0]?->value ?? 'public', 'favicon')); ?>"
                    alt="">
                <div class="text">
                    <?php echo e($landing_data['fixed_header_sub_title']); ?>

                </div>
            </div>
        </div>
        <!-- Banner Left Shape -->
        <svg class="banner-shape-1" width="132" height="473" viewBox="0 0 132 473" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g filter="url(#filter0_d_28_1582)">
                <path
                    d="M-170.449 366.997C-202.388 263.253 -154.424 117.259 -63.3687 41.0217C27.6863 -35.2161 -1.97721 87.2815 29.9148 191.14C61.8543 294.884 143.365 340.594 52.2624 416.947C-38.7925 493.185 -138.557 470.855 -170.496 367.112L-170.449 366.997Z"
                    fill="url(#paint0_linear_28_1582)" />
            </g>
            <defs>
                <filter id="filter0_d_28_1582" x="-223.34" y="-52.7559" width="354.4" height="524.974"
                    filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix" />
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                        result="hardAlpha" />
                    <feOffset dx="-3" dy="-30" />
                    <feGaussianBlur stdDeviation="20" />
                    <feComposite in2="hardAlpha" operator="out" />
                    <feColorMatrix type="matrix" values="0 0 0 0 0.756863 0 0 0 0 0.764706 0 0 0 0 0.760784 0 0 0 0.3 0" />
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_28_1582" />
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_28_1582" result="shape" />
                </filter>
                <linearGradient id="paint0_linear_28_1582" x1="-163.328" y1="59.7571" x2="-97.2459" y2="402.968"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#00E77B" />
                    <stop offset="1" stop-color="white" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Banner Right Shape -->
        <div class="banner-shape-2">
            <svg width="149" height="509" viewBox="0 0 149 509" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g filter="url(#filter0_d_28_1581)">
                    <path
                        d="M61.4363 387.423C18.1773 292.928 45.4979 148.359 122.423 64.6325C199.349 -19.0943 186.47 100.887 229.698 195.498C272.957 289.994 356.033 323.218 279.077 407.059C202.152 490.786 104.664 482.034 61.4055 387.538L61.4363 387.423Z"
                        fill="url(#paint0_linear_28_1581)" shape-rendering="crispEdges" />
                </g>
                <defs>
                    <filter id="filter0_d_28_1581" x="0.901855" y="0.379639" width="349.631" height="508.173"
                        filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                            result="hardAlpha" />
                        <feOffset dy="4" />
                        <feGaussianBlur stdDeviation="20" />
                        <feComposite in2="hardAlpha" operator="out" />
                        <feColorMatrix type="matrix"
                            values="0 0 0 0 0.757083 0 0 0 0 0.766667 0 0 0 0 0.762186 0 0 0 0.3 0" />
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_28_1581" />
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_28_1581" result="shape" />
                    </filter>
                    <linearGradient id="paint0_linear_28_1581" x1="57.8403" y1="199.019" x2="149.108" y2="392.15"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#AAFFD7" stop-opacity="0" />
                        <stop offset="0.728676" stop-color="#00E77B" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Banner Bottom Image -->
        <svg class="banner-img" width="1433" height="257" viewBox="0 0 1433 257" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <path d="M839.112 147.392H823.547V157.346H839.112V147.392Z" fill="#00C066" />
            <path d="M814.86 162.957H799.295V172.911H814.86V162.957Z" fill="#00C066" />
            <path
                d="M884.614 150.649V129.474H872.85V115.719H864.886V129.474H853.122V150.649H846.606V103.049H833.394V98.5247H815.838V94H798.463V98.5247H781.993V103.049H767.695V150.468H760.094V129.293H748.329V115.538H740.366V129.293H728.602V150.468H721V225.579H738.375V198.973H750.32V225.579H797.015V194.63H817.286V225.579H845.52V225.76H862.895V199.154H874.84V225.76H892.215V150.649H884.614ZM727.244 159.699H734.122V165.129H727.244V159.699ZM727.335 174.902H734.212V180.332H727.335V174.902ZM734.303 195.535H727.425V190.105H734.303V195.535ZM752.311 146.487H736.384V143.229H752.311V146.487ZM752.311 141.781H736.384V138.523H752.311V141.781ZM752.311 137.075H736.384V133.818H752.311V137.075ZM754.573 159.699H761.451V165.129H754.573V159.699ZM754.664 174.902H761.541V180.332H754.664V174.902ZM761.632 195.535H754.754V190.105H761.632V195.535ZM789.776 186.485H777.107V180.875H789.776V186.485ZM789.776 170.377H777.107V164.767H789.776V170.377ZM789.776 154.269H777.107V148.659H789.776V154.269ZM789.776 138.161H777.107V132.551H789.776V138.161ZM789.776 122.053H777.107V116.443H789.776V122.053ZM813.485 186.485H800.816V180.875H813.485V186.485ZM813.485 170.377H800.816V164.767H813.485V170.377ZM813.485 154.269H800.816V148.659H813.485V154.269ZM813.485 138.161H800.816V132.551H813.485V138.161ZM813.485 122.053H800.816V116.443H813.485V122.053ZM837.195 186.485H824.526V180.875H837.195V186.485ZM837.195 170.377H824.526V164.767H837.195V170.377ZM837.195 154.269H824.526V148.659H837.195V154.269ZM837.195 138.161H824.526V132.551H837.195V138.161ZM837.195 122.053H824.526V116.443H837.195V122.053ZM851.764 159.88H858.642V165.31H851.764V159.88ZM851.855 175.083H858.732V180.513H851.855V175.083ZM858.823 195.716H851.945V190.286H858.823V195.716ZM876.831 146.668H860.904V143.41H876.831V146.668ZM876.831 141.962H860.904V138.704H876.831V141.962ZM876.831 137.256H860.904V133.999H876.831V137.256ZM879.094 159.88H885.971V165.31H879.094V159.88ZM879.184 175.083H886.062V180.513H879.184V175.083ZM886.152 195.716H879.275V190.286H886.152V195.716Z"
                fill="#F2F2F2" />
            <path
                d="M753.648 116.125L754.898 116.918L754.139 115.537C754.354 115.366 754.62 115.271 754.895 115.267C754.902 115.267 754.909 115.267 754.916 115.267C755.002 115.269 755.089 115.262 755.175 115.248L755.599 115.517L755.417 115.187C755.718 115.082 755.977 114.885 756.159 114.624L756.918 115.105L756.438 114.233C756.64 113.973 756.897 113.761 757.191 113.612C757.485 113.464 757.809 113.382 758.138 113.374C758.927 113.374 759.63 113.844 760.084 114.575C760.218 114.793 760.407 114.973 760.633 115.095C760.859 115.216 761.113 115.276 761.37 115.268C761.384 115.267 761.398 115.267 761.412 115.267C762.283 115.267 762.989 116.255 762.989 117.473C762.989 118.691 762.283 119.679 761.412 119.679C761.221 119.678 761.032 119.631 760.863 119.541C760.566 119.397 760.242 119.319 759.912 119.313C759.583 119.306 759.256 119.372 758.954 119.504C758.699 119.619 758.422 119.678 758.143 119.679C757.863 119.68 757.587 119.621 757.331 119.508C757.031 119.378 756.707 119.314 756.381 119.32C756.055 119.327 755.733 119.403 755.439 119.544C755.271 119.632 755.085 119.678 754.895 119.679C754.024 119.679 753.318 118.691 753.318 117.473C753.313 117.003 753.426 116.539 753.648 116.125Z"
                fill="#F2F2F2" />
            <path
                d="M814.868 158.171L807.647 165.391L804.226 161.97L802.894 163.302L807.643 168.051L816.2 159.503L814.868 158.171Z"
                fill="#00C066" />
            <path
                d="M837.854 141.701L830.633 148.921L827.212 145.5L825.88 146.832L830.629 151.581L839.186 143.033L837.854 141.701Z"
                fill="#00C066" />
            <path
                d="M490.657 108.744V83.4212H476.589V66.9722H467.066V83.4212H452.997V108.744H445.206V51.8217H429.406V46.4109H408.412V41H387.634V46.4109H367.939V51.8217H350.84V108.528H341.75V83.2048H327.682V66.7557H318.159V83.2048H304.09V108.528H295V198.348H315.778V166.532H330.062V198.348H385.903V161.338H410.143V198.348H443.907V198.564H464.685V166.749H478.97V198.564H499.747V108.744H490.657ZM302.467 119.566H310.692V126.059H302.467V119.566ZM302.575 137.746H310.8V144.239H302.575V137.746ZM310.908 162.42H302.683V155.927H310.908V162.42ZM332.443 103.766H313.397V99.8702H332.443V103.766ZM332.443 98.1388H313.397V94.2429H332.443V98.1388ZM332.443 92.5115H313.397V88.6156H332.443V92.5115ZM335.149 119.566H343.373V126.059H335.149V119.566ZM335.257 137.746H343.481V144.239H335.257V137.746ZM343.59 162.42H335.365V155.927H343.59V162.42ZM377.245 151.598H362.095V144.889H377.245V151.598ZM377.245 132.335H362.095V125.626H377.245V132.335ZM377.245 113.073H362.095V106.363H377.245V113.073ZM377.245 93.8101H362.095V87.1006H377.245V93.8101ZM377.245 74.5474H362.095V67.8379H377.245V74.5474ZM405.598 151.598H390.448V144.889H405.598V151.598ZM405.598 132.335H390.448V125.626H405.598V132.335ZM405.598 113.073H390.448V106.363H405.598V113.073ZM405.598 93.8101H390.448V87.1006H405.598V93.8101ZM405.598 74.5474H390.448V67.8379H405.598V74.5474ZM433.951 151.598H418.801V144.889H433.951V151.598ZM433.951 132.335H418.801V125.626H433.951V132.335ZM433.951 113.073H418.801V106.363H433.951V113.073ZM433.951 93.8101H418.801V87.1006H433.951V93.8101ZM433.951 74.5474H418.801V67.8379H433.951V74.5474ZM451.374 119.782H459.599V126.275H451.374V119.782ZM451.482 137.963H459.707V144.456H451.482V137.963ZM459.815 162.636H451.591V156.143H459.815V162.636ZM481.35 103.983H462.304V100.087H481.35V103.983ZM481.35 98.3552H462.304V94.4594H481.35V98.3552ZM481.35 92.7279H462.304V88.8321H481.35V92.7279ZM484.056 119.782H492.28V126.275H484.056V119.782ZM484.164 137.963H492.388V144.456H484.164V137.963ZM492.497 162.636H484.272V156.143H492.497V162.636Z"
                fill="#F2F2F2" />
            <path
                d="M334.041 67.4579L335.537 68.4065L334.629 66.7552C334.886 66.55 335.204 66.4364 335.533 66.4324C335.541 66.4324 335.55 66.4325 335.558 66.4326C335.661 66.4343 335.765 66.4266 335.868 66.4097L336.375 66.7311L336.157 66.336C336.517 66.2107 336.827 65.9752 337.044 65.663L337.952 66.2383L337.378 65.1962C337.62 64.8848 337.927 64.6311 338.279 64.4534C338.631 64.2757 339.017 64.1784 339.411 64.1687C340.355 64.1687 341.195 64.7298 341.738 65.6041C341.898 65.8657 342.125 66.0802 342.395 66.2259C342.665 66.3715 342.969 66.4431 343.276 66.4333C343.293 66.4327 343.309 66.4324 343.326 66.4324C344.368 66.4324 345.212 67.6134 345.212 69.0702C345.212 70.5271 344.368 71.7081 343.326 71.7081C343.097 71.7072 342.872 71.6508 342.67 71.5436C342.315 71.3713 341.927 71.278 341.533 71.2703C341.139 71.2626 340.748 71.3406 340.387 71.499C340.082 71.636 339.751 71.7073 339.417 71.7081C339.082 71.7088 338.752 71.6391 338.446 71.5035C338.088 71.3481 337.7 71.2717 337.31 71.2792C336.92 71.2868 336.535 71.3782 336.183 71.5472C335.983 71.6521 335.76 71.7072 335.533 71.7081C334.492 71.7081 333.647 70.5271 333.647 69.0702C333.641 68.5083 333.777 67.9538 334.041 67.4579Z"
                fill="#F2F2F2" />
            <path
                d="M1410 43.3978H1351.91V30.8356C1351.91 30.4408 1351.84 30.0498 1351.69 29.6849C1351.53 29.3201 1351.31 28.9886 1351.03 28.7094C1350.76 28.4303 1350.42 28.2089 1350.06 28.058C1349.69 27.9071 1349.3 27.8296 1348.91 27.83H1331.85V14.4468C1331.85 13.9451 1331.65 13.4639 1331.3 13.1092C1330.94 12.7545 1330.46 12.5552 1329.96 12.5552H1307.98C1307.48 12.5559 1307 12.7555 1306.64 13.1101C1306.29 13.4646 1306.09 13.9453 1306.09 14.4468V27.83H1286.04C1285.65 27.8288 1285.25 27.9057 1284.89 28.0563C1284.52 28.2068 1284.19 28.428 1283.91 28.7072C1283.63 28.9864 1283.41 29.3182 1283.26 29.6834C1283.11 30.0486 1283.03 30.4402 1283.03 30.8356V43.3891H1227.65C1227.48 43.3898 1227.33 43.4547 1227.22 43.5694C1227.1 43.6841 1227.04 43.8394 1227.04 44.0012V210.794C1227.04 210.956 1227.1 211.111 1227.22 211.226C1227.33 211.34 1227.48 211.405 1227.65 211.406H1264.46C1264.62 211.405 1264.78 211.34 1264.89 211.226C1265.01 211.111 1265.07 210.956 1265.07 210.794V188.344C1265.07 188.182 1265.14 188.027 1265.25 187.912C1265.37 187.798 1265.52 187.733 1265.68 187.732H1281.23C1281.4 187.733 1281.55 187.798 1281.67 187.913C1281.78 188.027 1281.84 188.183 1281.84 188.344V210.782C1281.84 210.944 1281.91 211.098 1282.02 211.213C1282.13 211.328 1282.29 211.393 1282.45 211.394H1355.2C1355.36 211.393 1355.52 211.328 1355.63 211.213C1355.74 211.099 1355.81 210.944 1355.81 210.782V188.344C1355.81 188.183 1355.87 188.028 1355.99 187.914C1356.1 187.799 1356.26 187.734 1356.42 187.732H1371.97C1372.13 187.732 1372.28 187.797 1372.4 187.912C1372.51 188.026 1372.58 188.182 1372.58 188.344V210.782C1372.58 210.944 1372.64 211.1 1372.76 211.214C1372.87 211.329 1373.03 211.394 1373.19 211.394H1410C1410.17 211.393 1410.32 211.328 1410.43 211.213C1410.55 211.099 1410.61 210.944 1410.61 210.782V44.0099C1410.61 43.8481 1410.55 43.6928 1410.44 43.5781C1410.32 43.4634 1410.17 43.3986 1410 43.3978ZM1258.48 179.951C1258.48 180.112 1258.42 180.266 1258.3 180.379C1258.19 180.493 1258.03 180.557 1257.87 180.558H1235.13C1235.05 180.558 1234.98 180.543 1234.9 180.512C1234.83 180.482 1234.76 180.437 1234.7 180.381C1234.65 180.325 1234.6 180.258 1234.57 180.184C1234.54 180.11 1234.53 180.031 1234.53 179.951V172.185C1234.53 172.104 1234.54 172.025 1234.57 171.951C1234.6 171.876 1234.65 171.809 1234.7 171.752C1234.76 171.695 1234.83 171.65 1234.9 171.619C1234.98 171.588 1235.05 171.573 1235.13 171.573H1257.87C1258.04 171.574 1258.19 171.639 1258.3 171.754C1258.42 171.869 1258.48 172.023 1258.48 172.185V179.951ZM1258.48 159.884C1258.48 160.045 1258.42 160.199 1258.3 160.313C1258.19 160.428 1258.04 160.492 1257.87 160.493H1235.13C1235.05 160.493 1234.98 160.477 1234.9 160.446C1234.83 160.415 1234.76 160.37 1234.7 160.313C1234.65 160.257 1234.6 160.189 1234.57 160.115C1234.54 160.041 1234.53 159.961 1234.53 159.881V152.123C1234.53 152.043 1234.54 151.963 1234.57 151.889C1234.6 151.815 1234.65 151.747 1234.7 151.69C1234.76 151.633 1234.83 151.588 1234.9 151.557C1234.98 151.527 1235.05 151.511 1235.13 151.511H1257.87C1257.95 151.511 1258.03 151.527 1258.11 151.558C1258.18 151.589 1258.25 151.634 1258.3 151.691C1258.36 151.748 1258.41 151.816 1258.44 151.89C1258.47 151.964 1258.48 152.043 1258.48 152.123V159.884ZM1258.48 139.822C1258.48 139.983 1258.42 140.138 1258.3 140.252C1258.19 140.366 1258.04 140.43 1257.87 140.431H1235.13C1234.97 140.431 1234.82 140.367 1234.7 140.253C1234.59 140.138 1234.53 139.983 1234.53 139.822V132.061C1234.53 131.981 1234.54 131.901 1234.57 131.827C1234.6 131.753 1234.65 131.685 1234.7 131.629C1234.76 131.572 1234.83 131.526 1234.9 131.496C1234.98 131.465 1235.05 131.449 1235.13 131.449H1257.87C1258.04 131.451 1258.19 131.516 1258.3 131.63C1258.42 131.745 1258.48 131.9 1258.48 132.061V139.822ZM1258.48 119.754C1258.48 119.834 1258.47 119.913 1258.44 119.987C1258.41 120.061 1258.36 120.128 1258.3 120.185C1258.25 120.242 1258.18 120.287 1258.11 120.317C1258.03 120.348 1257.95 120.364 1257.87 120.364H1235.13C1235.05 120.364 1234.98 120.348 1234.9 120.318C1234.83 120.288 1234.76 120.243 1234.7 120.186C1234.65 120.129 1234.6 120.062 1234.57 119.988C1234.54 119.914 1234.53 119.834 1234.53 119.754V111.991C1234.53 111.911 1234.54 111.831 1234.57 111.757C1234.6 111.683 1234.65 111.616 1234.7 111.559C1234.76 111.502 1234.83 111.458 1234.9 111.427C1234.98 111.397 1235.05 111.381 1235.13 111.381H1257.87C1257.95 111.381 1258.03 111.397 1258.11 111.428C1258.18 111.459 1258.25 111.504 1258.3 111.56C1258.36 111.617 1258.41 111.684 1258.44 111.758C1258.47 111.832 1258.48 111.911 1258.48 111.991V119.754ZM1258.48 99.6897C1258.48 99.851 1258.42 100.006 1258.3 100.12C1258.19 100.235 1258.04 100.3 1257.87 100.302H1235.13C1235.05 100.302 1234.98 100.286 1234.9 100.255C1234.83 100.224 1234.76 100.179 1234.7 100.122C1234.65 100.065 1234.6 99.998 1234.57 99.9237C1234.54 99.8495 1234.53 99.7699 1234.53 99.6897V91.9232C1234.53 91.8433 1234.54 91.7642 1234.57 91.6905C1234.6 91.6167 1234.65 91.5497 1234.7 91.4934C1234.76 91.4371 1234.83 91.3924 1234.9 91.3622C1234.98 91.3318 1235.05 91.3164 1235.13 91.3168H1257.87C1258.03 91.3176 1258.19 91.3817 1258.3 91.4953C1258.42 91.6088 1258.48 91.7626 1258.48 91.9232V99.6897ZM1258.48 79.6279C1258.48 79.7885 1258.42 79.9423 1258.3 80.0558C1258.19 80.1694 1258.03 80.2335 1257.87 80.2343H1235.13C1235.05 80.2346 1234.98 80.2192 1234.9 80.1889C1234.83 80.1586 1234.76 80.114 1234.7 80.0577C1234.65 80.0014 1234.6 79.9344 1234.57 79.8606C1234.54 79.7869 1234.53 79.7078 1234.53 79.6279V71.8614C1234.53 71.6996 1234.59 71.5443 1234.7 71.4296C1234.82 71.3149 1234.97 71.25 1235.13 71.2493H1257.87C1258.04 71.2508 1258.19 71.316 1258.3 71.4306C1258.42 71.5452 1258.48 71.7001 1258.48 71.8614V79.6279ZM1258.48 59.5603C1258.48 59.6404 1258.47 59.7196 1258.44 59.7937C1258.41 59.8678 1258.36 59.9352 1258.3 59.992C1258.25 60.0488 1258.18 60.094 1258.11 60.125C1258.03 60.156 1257.95 60.1721 1257.87 60.1725H1235.13C1235.05 60.1725 1234.98 60.1566 1234.9 60.1258C1234.83 60.095 1234.76 60.0499 1234.7 59.993C1234.65 59.9361 1234.6 59.8686 1234.57 59.7944C1234.54 59.7201 1234.53 59.6406 1234.53 59.5603V51.7996C1234.53 51.7194 1234.54 51.6399 1234.57 51.5656C1234.6 51.4914 1234.65 51.4238 1234.7 51.367C1234.76 51.3101 1234.83 51.2649 1234.9 51.2341C1234.98 51.2034 1235.05 51.1875 1235.13 51.1875H1257.87C1257.95 51.1879 1258.03 51.204 1258.11 51.235C1258.18 51.2659 1258.25 51.3111 1258.3 51.368C1258.36 51.4248 1258.41 51.4922 1258.44 51.5663C1258.47 51.6403 1258.48 51.7196 1258.48 51.7996V59.5603ZM1312.38 179.96C1312.38 180.04 1312.37 180.119 1312.34 180.193C1312.31 180.266 1312.26 180.333 1312.21 180.39C1312.15 180.446 1312.08 180.491 1312.01 180.521C1311.93 180.551 1311.86 180.567 1311.78 180.566H1289.04C1288.88 180.566 1288.72 180.503 1288.61 180.389C1288.49 180.276 1288.43 180.121 1288.43 179.96V172.185C1288.43 172.023 1288.49 171.867 1288.61 171.753C1288.72 171.638 1288.88 171.573 1289.04 171.573H1311.78C1311.86 171.573 1311.94 171.588 1312.01 171.619C1312.08 171.65 1312.15 171.695 1312.21 171.752C1312.26 171.809 1312.31 171.876 1312.34 171.951C1312.37 172.025 1312.39 172.104 1312.38 172.185V179.96ZM1312.38 159.892C1312.39 159.973 1312.37 160.052 1312.34 160.126C1312.31 160.201 1312.26 160.268 1312.21 160.325C1312.15 160.382 1312.08 160.427 1312.01 160.458C1311.94 160.489 1311.86 160.505 1311.78 160.505H1289.04C1288.88 160.505 1288.72 160.44 1288.61 160.325C1288.49 160.21 1288.43 160.055 1288.43 159.892V152.123C1288.43 151.961 1288.49 151.805 1288.61 151.69C1288.72 151.575 1288.88 151.511 1289.04 151.511H1311.78C1311.86 151.511 1311.94 151.527 1312.01 151.557C1312.08 151.588 1312.15 151.633 1312.21 151.69C1312.26 151.747 1312.31 151.815 1312.34 151.889C1312.37 151.963 1312.39 152.043 1312.38 152.123V159.892ZM1312.38 139.831C1312.38 139.992 1312.32 140.147 1312.21 140.261C1312.09 140.376 1311.94 140.44 1311.78 140.44H1289.04C1288.88 140.44 1288.72 140.376 1288.61 140.262C1288.49 140.147 1288.43 139.992 1288.43 139.831V132.061C1288.43 131.899 1288.49 131.744 1288.61 131.629C1288.72 131.515 1288.88 131.45 1289.04 131.449H1311.78C1311.86 131.449 1311.94 131.465 1312.01 131.496C1312.08 131.526 1312.15 131.572 1312.21 131.629C1312.26 131.685 1312.31 131.753 1312.34 131.827C1312.37 131.901 1312.39 131.981 1312.38 132.061V139.831ZM1312.38 119.763C1312.39 119.843 1312.37 119.923 1312.34 119.997C1312.31 120.071 1312.26 120.138 1312.21 120.195C1312.15 120.251 1312.08 120.296 1312.01 120.327C1311.94 120.357 1311.86 120.373 1311.78 120.372H1289.04C1288.96 120.373 1288.88 120.357 1288.81 120.327C1288.73 120.296 1288.66 120.251 1288.61 120.195C1288.55 120.138 1288.5 120.071 1288.47 119.997C1288.44 119.923 1288.43 119.843 1288.43 119.763V111.991C1288.43 111.91 1288.44 111.831 1288.47 111.757C1288.5 111.683 1288.55 111.616 1288.61 111.559C1288.66 111.502 1288.73 111.457 1288.81 111.427C1288.88 111.397 1288.96 111.381 1289.04 111.381H1311.78C1311.86 111.381 1311.94 111.397 1312.01 111.427C1312.08 111.458 1312.15 111.502 1312.21 111.559C1312.26 111.616 1312.31 111.683 1312.34 111.757C1312.37 111.831 1312.39 111.911 1312.38 111.991V119.763ZM1312.38 99.6984C1312.39 99.7786 1312.37 99.8582 1312.34 99.9324C1312.31 100.007 1312.26 100.074 1312.21 100.131C1312.15 100.188 1312.08 100.233 1312.01 100.264C1311.94 100.295 1311.86 100.311 1311.78 100.311H1289.04C1288.88 100.31 1288.72 100.245 1288.61 100.13C1288.49 100.016 1288.43 99.8605 1288.43 99.6984V91.9232C1288.43 91.7618 1288.49 91.6076 1288.61 91.4941C1288.72 91.3805 1288.88 91.3168 1289.04 91.3168H1311.78C1311.86 91.3164 1311.93 91.3318 1312.01 91.3622C1312.08 91.3924 1312.15 91.4371 1312.21 91.4934C1312.26 91.5497 1312.31 91.6167 1312.34 91.6905C1312.37 91.7642 1312.38 91.8433 1312.38 91.9232V99.6984ZM1312.38 79.6366C1312.38 79.7165 1312.37 79.7956 1312.34 79.8693C1312.31 79.9431 1312.26 80.0101 1312.21 80.0664C1312.15 80.1227 1312.08 80.1673 1312.01 80.1976C1311.93 80.2279 1311.86 80.2433 1311.78 80.243H1289.04C1288.88 80.243 1288.72 80.1793 1288.61 80.0657C1288.49 79.9522 1288.43 79.798 1288.43 79.6366V71.8614C1288.43 71.6993 1288.49 71.544 1288.61 71.4294C1288.72 71.3148 1288.88 71.25 1289.04 71.2493H1311.78C1311.94 71.25 1312.09 71.3149 1312.21 71.4296C1312.32 71.5443 1312.38 71.6996 1312.38 71.8614V79.6366ZM1312.38 59.569C1312.39 59.6493 1312.37 59.7288 1312.34 59.8031C1312.31 59.8773 1312.26 59.9448 1312.21 60.0017C1312.15 60.0586 1312.08 60.1037 1312.01 60.1345C1311.94 60.1653 1311.86 60.1812 1311.78 60.1812H1289.04C1288.88 60.1812 1288.72 60.1167 1288.61 60.0019C1288.49 59.8871 1288.43 59.7314 1288.43 59.569V51.7996C1288.43 51.6373 1288.49 51.4816 1288.61 51.3668C1288.72 51.252 1288.88 51.1875 1289.04 51.1875H1311.78C1311.86 51.1875 1311.94 51.2034 1312.01 51.2341C1312.08 51.2649 1312.15 51.3101 1312.21 51.367C1312.26 51.4238 1312.31 51.4914 1312.34 51.5656C1312.37 51.6399 1312.39 51.7194 1312.38 51.7996V59.569ZM1349.23 179.969C1349.23 180.049 1349.21 180.128 1349.18 180.202C1349.15 180.275 1349.11 180.342 1349.05 180.399C1348.99 180.455 1348.93 180.499 1348.85 180.53C1348.78 180.56 1348.7 180.575 1348.62 180.575H1325.87C1325.71 180.575 1325.56 180.511 1325.44 180.398C1325.33 180.284 1325.26 180.13 1325.26 179.969V172.185C1325.26 172.023 1325.33 171.868 1325.44 171.753C1325.56 171.638 1325.71 171.573 1325.87 171.573H1348.61C1348.77 171.573 1348.93 171.637 1349.04 171.752C1349.16 171.867 1349.22 172.022 1349.22 172.185L1349.23 179.969ZM1349.23 159.901C1349.23 159.982 1349.21 160.061 1349.18 160.136C1349.15 160.21 1349.11 160.278 1349.05 160.335C1348.99 160.392 1348.93 160.437 1348.85 160.467C1348.78 160.498 1348.7 160.514 1348.62 160.513H1325.87C1325.71 160.512 1325.56 160.448 1325.44 160.333C1325.33 160.218 1325.26 160.063 1325.26 159.901V152.123C1325.26 151.961 1325.33 151.806 1325.44 151.691C1325.56 151.576 1325.71 151.512 1325.87 151.511H1348.61C1348.69 151.51 1348.77 151.526 1348.84 151.557C1348.92 151.587 1348.99 151.632 1349.04 151.689C1349.1 151.746 1349.14 151.814 1349.18 151.888C1349.21 151.963 1349.22 152.042 1349.22 152.123L1349.23 159.901ZM1349.23 139.839C1349.23 140.001 1349.16 140.156 1349.05 140.27C1348.94 140.384 1348.78 140.449 1348.62 140.449H1325.87C1325.71 140.448 1325.56 140.383 1325.44 140.269C1325.33 140.155 1325.26 140.001 1325.26 139.839V132.061C1325.26 131.899 1325.33 131.744 1325.44 131.629C1325.56 131.515 1325.71 131.45 1325.87 131.449H1348.61C1348.77 131.449 1348.93 131.514 1349.04 131.628C1349.16 131.743 1349.22 131.899 1349.22 132.061L1349.23 139.839ZM1349.23 119.772C1349.23 119.852 1349.21 119.931 1349.18 120.006C1349.15 120.08 1349.11 120.147 1349.05 120.204C1348.99 120.26 1348.93 120.305 1348.85 120.335C1348.78 120.366 1348.7 120.381 1348.62 120.381H1325.87C1325.79 120.381 1325.71 120.365 1325.64 120.335C1325.57 120.304 1325.5 120.259 1325.44 120.203C1325.39 120.146 1325.34 120.079 1325.31 120.005C1325.28 119.931 1325.26 119.852 1325.26 119.772V111.991C1325.26 111.911 1325.28 111.832 1325.31 111.758C1325.34 111.684 1325.39 111.617 1325.44 111.56C1325.5 111.503 1325.57 111.458 1325.64 111.428C1325.71 111.397 1325.79 111.381 1325.87 111.381H1348.61C1348.69 111.381 1348.77 111.397 1348.84 111.427C1348.92 111.457 1348.99 111.502 1349.04 111.559C1349.1 111.616 1349.14 111.683 1349.17 111.757C1349.21 111.831 1349.22 111.91 1349.22 111.991L1349.23 119.772ZM1349.23 99.7071C1349.23 99.8694 1349.17 100.025 1349.05 100.14C1348.94 100.255 1348.78 100.319 1348.62 100.319H1325.87C1325.71 100.318 1325.56 100.254 1325.44 100.139C1325.33 100.024 1325.26 99.8689 1325.26 99.7071V91.9232C1325.26 91.7621 1325.33 91.6079 1325.44 91.4942C1325.56 91.3806 1325.71 91.3168 1325.87 91.3168H1348.61C1348.69 91.3164 1348.77 91.3318 1348.84 91.3621C1348.92 91.3924 1348.98 91.4369 1349.04 91.4932C1349.1 91.5495 1349.14 91.6165 1349.17 91.6903C1349.2 91.764 1349.22 91.8432 1349.22 91.9232L1349.23 99.7071ZM1349.23 79.6453C1349.23 79.7253 1349.21 79.8045 1349.18 79.8782C1349.15 79.952 1349.11 80.019 1349.05 80.0753C1348.99 80.1316 1348.93 80.1761 1348.85 80.2064C1348.78 80.2367 1348.7 80.2521 1348.62 80.2517H1325.87C1325.71 80.2517 1325.56 80.1879 1325.44 80.0742C1325.33 79.9606 1325.26 79.8064 1325.26 79.6453V71.8614C1325.26 71.6998 1325.33 71.545 1325.44 71.4304C1325.56 71.3159 1325.71 71.2508 1325.87 71.2493H1348.61C1348.77 71.25 1348.93 71.3148 1349.04 71.4294C1349.16 71.544 1349.22 71.6993 1349.22 71.8614L1349.23 79.6453ZM1349.23 59.5778C1349.23 59.6582 1349.21 59.738 1349.18 59.8125C1349.15 59.8869 1349.11 59.9545 1349.05 60.0115C1348.99 60.0684 1348.93 60.1135 1348.85 60.1441C1348.78 60.1747 1348.7 60.1903 1348.62 60.1899H1325.87C1325.71 60.1891 1325.56 60.1243 1325.44 60.0096C1325.33 59.8949 1325.26 59.7396 1325.26 59.5778V51.7996C1325.26 51.6378 1325.33 51.4825 1325.44 51.3678C1325.56 51.2531 1325.71 51.1883 1325.87 51.1875H1348.61C1348.69 51.1871 1348.77 51.2027 1348.84 51.2333C1348.92 51.2639 1348.99 51.309 1349.04 51.3659C1349.1 51.4228 1349.14 51.4905 1349.18 51.5649C1349.21 51.6394 1349.22 51.7192 1349.22 51.7996L1349.23 59.5778ZM1403.14 179.951C1403.14 180.113 1403.07 180.267 1402.96 180.38C1402.84 180.494 1402.69 180.558 1402.53 180.558H1379.78C1379.7 180.558 1379.62 180.543 1379.55 180.512C1379.47 180.482 1379.4 180.438 1379.35 180.381C1379.29 180.325 1379.25 180.258 1379.22 180.184C1379.18 180.11 1379.17 180.031 1379.17 179.951V172.185C1379.17 172.022 1379.23 171.867 1379.35 171.752C1379.46 171.637 1379.62 171.573 1379.78 171.573H1402.52C1402.6 171.572 1402.68 171.587 1402.75 171.617C1402.83 171.648 1402.9 171.693 1402.95 171.75C1403.01 171.807 1403.06 171.874 1403.09 171.949C1403.12 172.024 1403.14 172.104 1403.14 172.185V179.951ZM1403.14 159.884C1403.14 160.046 1403.07 160.202 1402.96 160.317C1402.84 160.431 1402.69 160.496 1402.53 160.496H1379.78C1379.7 160.496 1379.62 160.481 1379.55 160.45C1379.47 160.419 1379.4 160.374 1379.35 160.317C1379.29 160.26 1379.24 160.193 1379.21 160.118C1379.18 160.044 1379.17 159.964 1379.17 159.884V152.123C1379.17 152.042 1379.18 151.963 1379.21 151.888C1379.24 151.814 1379.29 151.746 1379.35 151.689C1379.4 151.632 1379.47 151.587 1379.55 151.557C1379.62 151.526 1379.7 151.51 1379.78 151.511H1402.52C1402.68 151.511 1402.83 151.575 1402.95 151.69C1403.06 151.805 1403.13 151.961 1403.13 152.123L1403.14 159.884ZM1403.14 139.822C1403.14 139.984 1403.07 140.139 1402.96 140.253C1402.84 140.367 1402.69 140.431 1402.53 140.431H1379.78C1379.62 140.431 1379.46 140.367 1379.35 140.253C1379.23 140.139 1379.17 139.984 1379.17 139.822V132.061C1379.17 131.899 1379.23 131.743 1379.35 131.628C1379.46 131.514 1379.62 131.449 1379.78 131.449H1402.52C1402.6 131.448 1402.68 131.464 1402.75 131.494C1402.83 131.524 1402.9 131.569 1402.95 131.626C1403.01 131.683 1403.06 131.751 1403.09 131.825C1403.12 131.9 1403.14 131.98 1403.14 132.061V139.822ZM1403.14 119.754C1403.14 119.835 1403.12 119.914 1403.09 119.988C1403.06 120.062 1403.01 120.13 1402.96 120.186C1402.9 120.243 1402.83 120.288 1402.76 120.318C1402.68 120.348 1402.61 120.364 1402.53 120.364H1379.78C1379.7 120.364 1379.62 120.348 1379.55 120.318C1379.47 120.288 1379.4 120.243 1379.35 120.186C1379.29 120.13 1379.25 120.062 1379.21 119.988C1379.18 119.914 1379.17 119.835 1379.17 119.754V111.991C1379.17 111.91 1379.18 111.831 1379.21 111.757C1379.25 111.683 1379.29 111.616 1379.35 111.559C1379.4 111.502 1379.47 111.457 1379.55 111.427C1379.62 111.397 1379.7 111.381 1379.78 111.381H1402.52C1402.6 111.381 1402.68 111.397 1402.75 111.427C1402.82 111.457 1402.89 111.502 1402.95 111.559C1403.01 111.616 1403.05 111.683 1403.08 111.757C1403.11 111.831 1403.13 111.91 1403.13 111.991L1403.14 119.754ZM1403.14 99.6897C1403.14 99.8518 1403.07 100.007 1402.96 100.122C1402.84 100.236 1402.69 100.301 1402.53 100.302H1379.78C1379.62 100.302 1379.46 100.237 1379.35 100.123C1379.23 100.008 1379.17 99.852 1379.17 99.6897V91.9232C1379.17 91.8432 1379.18 91.764 1379.22 91.6903C1379.25 91.6165 1379.29 91.5495 1379.35 91.4932C1379.4 91.4369 1379.47 91.3924 1379.55 91.3621C1379.62 91.3318 1379.7 91.3164 1379.78 91.3168H1402.52C1402.68 91.3168 1402.83 91.3805 1402.95 91.4941C1403.06 91.6076 1403.13 91.7618 1403.13 91.9232L1403.14 99.6897ZM1403.14 79.6279C1403.14 79.7893 1403.07 79.9435 1402.96 80.057C1402.84 80.1706 1402.69 80.2343 1402.53 80.2343H1379.78C1379.7 80.2346 1379.62 80.2193 1379.55 80.189C1379.47 80.1587 1379.4 80.1142 1379.35 80.0579C1379.29 80.0016 1379.25 79.9346 1379.22 79.8608C1379.18 79.7871 1379.17 79.7079 1379.17 79.6279V71.8614C1379.17 71.6993 1379.23 71.544 1379.35 71.4294C1379.46 71.3148 1379.62 71.25 1379.78 71.2493H1402.52C1402.6 71.2485 1402.68 71.2637 1402.75 71.2941C1402.83 71.3245 1402.9 71.3694 1402.95 71.4263C1403.01 71.4832 1403.06 71.5509 1403.09 71.6256C1403.12 71.7002 1403.14 71.7804 1403.14 71.8614V79.6279ZM1403.14 59.5603C1403.14 59.7227 1403.07 59.8784 1402.96 59.9932C1402.84 60.108 1402.69 60.1725 1402.53 60.1725H1379.78C1379.7 60.1729 1379.62 60.1573 1379.55 60.1267C1379.47 60.0961 1379.4 60.051 1379.35 59.9941C1379.29 59.9371 1379.24 59.8695 1379.21 59.7951C1379.18 59.7206 1379.17 59.6408 1379.17 59.5603V51.7996C1379.17 51.7192 1379.18 51.6394 1379.21 51.5649C1379.24 51.4905 1379.29 51.4228 1379.35 51.3659C1379.4 51.309 1379.47 51.2639 1379.55 51.2333C1379.62 51.2027 1379.7 51.1871 1379.78 51.1875H1402.52C1402.68 51.1875 1402.83 51.252 1402.95 51.3668C1403.06 51.4816 1403.13 51.6373 1403.13 51.7996L1403.14 59.5603Z"
                fill="#F2F2F2" />
            <path
                d="M1431.81 17.6933L1428.3 19.9156L1430.43 16.0483C1429.83 15.5674 1429.08 15.3009 1428.31 15.2911H1428.26C1428.01 15.2933 1427.77 15.2749 1427.53 15.236L1426.34 15.9903L1426.85 15.0648C1426.01 14.7698 1425.28 14.2177 1424.77 13.4866L1422.65 14.853L1423.99 12.4102C1422.75 10.919 1421.09 10.0051 1419.23 10.0051C1417.02 10.0051 1415.05 11.3194 1413.78 13.3676C1413.4 13.9811 1412.87 14.4841 1412.24 14.8251C1411.61 15.1661 1410.89 15.3329 1410.18 15.3085H1410.06C1407.62 15.3085 1405.64 18.0763 1405.64 21.4881C1405.64 24.8999 1407.62 27.6676 1410.06 27.6676C1410.59 27.6654 1411.12 27.533 1411.6 27.2817C1412.43 26.8786 1413.34 26.6605 1414.26 26.6425C1415.18 26.6245 1416.1 26.8069 1416.94 27.1773C1417.66 27.4967 1418.43 27.6618 1419.22 27.6618C1420 27.6618 1420.77 27.4967 1421.49 27.1773C1422.33 26.8134 1423.23 26.6342 1424.15 26.6517C1425.06 26.6692 1425.96 26.8831 1426.79 27.2788C1427.26 27.5244 1427.78 27.6537 1428.31 27.656C1430.75 27.656 1432.73 24.8883 1432.73 21.4765C1432.74 20.158 1432.43 18.8569 1431.81 17.6933Z"
                fill="#E6FFF3" />
            <path opacity="0.03"
                d="M1425.2 26.7479C1423.93 26.5077 1422.62 26.6501 1421.43 27.157C1420.72 27.4774 1419.94 27.643 1419.16 27.643C1418.38 27.643 1417.6 27.4774 1416.89 27.157C1416.04 26.7866 1415.12 26.6042 1414.2 26.6222C1413.28 26.6402 1412.37 26.8583 1411.54 27.2614C1411.07 27.5127 1410.54 27.6451 1410 27.6473C1407.83 27.6473 1406.03 25.4627 1405.65 22.5818C1406.08 22.268 1406.45 21.874 1406.73 21.4213C1408 19.3731 1409.97 18.0588 1412.18 18.0588C1414.39 18.0588 1416.34 19.3557 1417.61 21.3836C1417.99 21.9952 1418.52 22.4987 1419.15 22.8453C1419.78 23.1919 1420.49 23.3699 1421.21 23.3622H1421.26C1422.98 23.3332 1424.48 24.7171 1425.2 26.7479Z"
                fill="black" />
            <path opacity="0.03"
                d="M1383.71 6.0838C1382.81 5.91532 1381.89 6.01631 1381.05 6.37392C1380.55 6.59793 1380.01 6.7137 1379.46 6.7137C1378.91 6.7137 1378.36 6.59793 1377.86 6.37392C1377.27 6.115 1376.63 5.98742 1375.98 5.99994C1375.34 6.01246 1374.7 6.16479 1374.12 6.44645C1373.79 6.62309 1373.42 6.71573 1373.04 6.71627C1371.52 6.71627 1370.26 5.18734 1370 3.17101C1370.3 2.95025 1370.56 2.67233 1370.76 2.35287C1371.65 0.919679 1373.03 0 1374.57 0C1376.12 0 1377.47 0.908074 1378.37 2.32096C1378.64 2.75002 1379.01 3.10323 1379.45 3.34624C1379.89 3.58925 1380.39 3.71378 1380.89 3.70773H1380.93C1382.15 3.70483 1383.19 4.67382 1383.71 6.0838Z"
                fill="#E5FFF3" />
            <path
                d="M622.105 188.998C621.796 189.01 621.486 188.968 621.202 188.876C620.917 188.783 620.666 188.642 620.467 188.463C620.267 188.285 620.126 188.074 620.054 187.848C619.983 187.621 619.982 187.385 620.052 187.159C620.123 186.932 620.263 186.721 620.461 186.542C620.659 186.363 620.91 186.221 621.194 186.127C621.478 186.033 621.787 185.99 622.097 186.002C622.407 186.013 622.709 186.079 622.979 186.193L622.627 186.92L623.352 186.395C623.545 186.528 623.701 186.687 623.812 186.864C623.923 187.042 623.986 187.234 623.997 187.43C624.007 187.569 623.99 187.708 623.948 187.843C623.849 188.159 623.616 188.443 623.284 188.651C622.951 188.86 622.538 188.981 622.105 188.998Z"
                fill="#00C066" />
            <path opacity="0.1"
                d="M622.12 188.999C621.771 189.01 621.424 188.958 621.112 188.849C620.8 188.74 620.534 188.577 620.34 188.376C620.146 188.175 620.031 187.942 620.005 187.701C619.98 187.46 620.045 187.219 620.194 187C620.355 187.077 620.494 187.175 620.601 187.289C620.722 187.448 620.856 187.603 621.002 187.751C621.318 188.007 621.857 188.091 622.346 188.077C622.834 188.062 623.304 187.964 623.791 187.932C623.858 187.932 623.927 187.932 624 187.923C623.898 188.22 623.66 188.485 623.32 188.679C622.981 188.873 622.56 188.985 622.12 188.999Z"
                fill="black" />
            <path
                d="M704.001 188.952C704.009 188.785 704.059 188.622 704.146 188.479C704.233 188.336 704.355 188.217 704.5 188.134L704.725 188.576L704.717 188.04C704.824 188.008 704.936 187.995 705.047 188.001C705.245 188.011 705.435 188.079 705.594 188.196C705.753 188.314 705.874 188.476 705.941 188.662C706.008 188.848 706.018 189.05 705.97 189.242C705.923 189.434 705.819 189.607 705.673 189.74C705.526 189.873 705.344 189.96 705.148 189.989C704.952 190.018 704.752 189.989 704.574 189.905C704.395 189.82 704.245 189.685 704.143 189.515C704.041 189.346 703.992 189.15 704.001 188.952Z"
                fill="#00C066" />
            <path opacity="0.1"
                d="M704.112 188.937C704.345 188.971 704.578 189.071 704.807 189.09C704.924 189.11 705.044 189.092 705.155 189.038C705.267 188.983 705.367 188.894 705.448 188.776C705.517 188.631 705.58 188.481 705.637 188.327C705.7 188.191 705.787 188.079 705.89 188C705.97 188.212 706.008 188.45 705.999 188.689C705.986 189.023 705.886 189.339 705.715 189.58C705.545 189.82 705.316 189.968 705.072 189.995C704.828 190.023 704.585 189.929 704.387 189.73C704.19 189.532 704.053 189.242 704 188.916C704.039 188.927 704.076 188.931 704.112 188.937Z"
                fill="black" />
            <g opacity="0.4">
                <path
                    d="M789.961 211.128C790.168 210.766 790.275 210.355 790.271 209.938C790.271 208.863 789.607 207.991 788.784 207.991C787.961 207.991 787.297 208.863 787.297 209.938C787.293 210.355 787.4 210.766 787.607 211.128C787.404 211.492 787.297 211.901 787.297 212.318C787.297 212.735 787.404 213.145 787.607 213.508C787.404 213.872 787.297 214.282 787.297 214.698C787.297 215.115 787.404 215.525 787.607 215.888C787.404 216.252 787.297 216.662 787.297 217.078C787.297 217.495 787.404 217.905 787.607 218.268C787.4 218.63 787.293 219.041 787.297 219.458C787.297 220.534 787.961 221.405 788.784 221.405C789.607 221.405 790.271 220.534 790.271 219.458C790.275 219.041 790.168 218.631 789.961 218.269C790.164 217.906 790.271 217.496 790.271 217.079C790.271 216.663 790.164 216.253 789.961 215.889C790.164 215.526 790.271 215.116 790.271 214.699C790.271 214.282 790.164 213.873 789.961 213.509C790.164 213.146 790.271 212.736 790.271 212.319C790.271 211.902 790.164 211.493 789.961 211.129V211.128Z"
                    fill="#3F3D56" />
                <path
                    d="M788.779 209.505C789.601 209.505 790.266 208.633 790.266 207.558C790.266 206.482 789.601 205.611 788.779 205.611C787.958 205.611 787.292 206.482 787.292 207.558C787.292 208.633 787.958 209.505 788.779 209.505Z"
                    fill="#3F3D56" />
                <path
                    d="M788.779 207.125C789.601 207.125 790.266 206.253 790.266 205.178C790.266 204.102 789.601 203.23 788.779 203.23C787.958 203.23 787.292 204.102 787.292 205.178C787.292 206.253 787.958 207.125 788.779 207.125Z"
                    fill="#3F3D56" />
                <path
                    d="M783.211 188.892C783.008 188.633 782.823 188.36 782.657 188.076L786.565 187.434L782.338 187.466C781.933 186.583 781.712 185.628 781.689 184.657C781.665 183.686 781.84 182.721 782.203 181.82L787.873 184.762L782.643 180.918C783.132 180.068 783.79 179.328 784.577 178.745C785.364 178.161 786.264 177.746 787.218 177.526C788.173 177.306 789.163 177.285 790.127 177.464C791.09 177.644 792.006 178.02 792.817 178.57C793.629 179.119 794.318 179.83 794.842 180.658C795.366 181.487 795.714 182.414 795.863 183.382C796.013 184.351 795.961 185.34 795.711 186.287C795.461 187.235 795.018 188.121 794.411 188.889C794.727 189.292 794.999 189.728 795.223 190.188L790.151 192.827L795.56 191.011C795.94 192.134 796.033 193.334 795.833 194.502C795.632 195.671 795.144 196.77 794.412 197.703C795.239 198.753 795.753 200.016 795.897 201.345C796.04 202.675 795.806 204.018 795.222 205.221C794.638 206.424 793.727 207.438 792.594 208.148C791.46 208.858 790.15 209.234 788.812 209.234C787.475 209.234 786.165 208.858 785.031 208.148C783.898 207.438 782.987 206.424 782.403 205.221C781.819 204.018 781.585 202.675 781.728 201.345C781.872 200.016 782.386 198.753 783.213 197.703C782.226 196.446 781.689 194.895 781.689 193.297C781.689 191.7 782.226 190.148 783.213 188.892H783.211Z"
                    fill="#00C066" />
                <path opacity="0.1"
                    d="M795.939 193.297C795.942 194.896 795.405 196.448 794.415 197.703C795.242 198.754 795.757 200.016 795.9 201.346C796.043 202.675 795.81 204.018 795.225 205.221C794.641 206.424 793.73 207.439 792.597 208.148C791.464 208.858 790.153 209.234 788.816 209.234C787.479 209.234 786.168 208.858 785.035 208.148C783.901 207.439 782.991 206.424 782.407 205.221C781.822 204.018 781.589 202.675 781.732 201.346C781.875 200.016 782.39 198.754 783.217 197.703C782.256 196.49 795.939 192.497 795.939 193.297Z"
                    fill="black" />
                <path
                    d="M794.841 220.837C795.037 220.477 794.816 220.034 794.557 219.712C794.298 219.389 793.992 219.055 793.999 218.644C794.008 218.055 794.634 217.706 795.137 217.394C795.509 217.162 795.851 216.887 796.158 216.574C796.286 216.454 796.392 216.312 796.471 216.155C796.574 215.924 796.571 215.662 796.566 215.41C796.544 214.568 796.502 213.728 796.44 212.887"
                    stroke="#3F3D56" stroke-width="4" stroke-miterlimit="10" />
                <path
                    d="M797.391 212.842C797.384 212.688 797.338 212.538 797.258 212.407C797.177 212.275 797.065 212.166 796.932 212.088L796.726 212.496L796.733 212.003C796.546 211.948 796.346 211.954 796.162 212.019C795.979 212.085 795.821 212.208 795.711 212.369C795.602 212.53 795.547 212.722 795.554 212.917C795.56 213.112 795.629 213.3 795.749 213.453C795.87 213.606 796.036 213.717 796.223 213.77C796.411 213.823 796.611 213.815 796.793 213.747C796.976 213.679 797.132 213.555 797.24 213.392C797.347 213.229 797.4 213.037 797.391 212.842Z"
                    fill="#00C066" />
                <path
                    d="M795.749 219.066C795.657 219.247 795.507 219.392 795.323 219.478C795.14 219.565 794.933 219.588 794.735 219.545C794.537 219.501 794.359 219.394 794.228 219.239C794.097 219.083 794.022 218.889 794.013 218.687C794.007 218.56 794.027 218.433 794.072 218.314C794.14 218.14 794.258 217.99 794.413 217.884C794.567 217.779 794.75 217.723 794.936 217.724C795.123 217.725 795.305 217.783 795.459 217.89C795.612 217.997 795.729 218.148 795.794 218.323L795.22 218.791L795.851 218.645C795.851 218.792 795.817 218.936 795.749 219.066Z"
                    fill="#00C066" />
                <path
                    d="M795.296 217.28C795.176 217.286 795.055 217.268 794.942 217.227C794.828 217.186 794.724 217.123 794.634 217.042C794.545 216.96 794.473 216.862 794.421 216.753C794.37 216.643 794.341 216.525 794.335 216.404C794.328 216.261 794.355 216.117 794.415 215.986C794.47 215.863 794.551 215.754 794.653 215.666C794.755 215.578 794.875 215.513 795.005 215.476V215.856L795.213 215.444C795.334 215.438 795.454 215.457 795.568 215.498C795.681 215.539 795.786 215.602 795.875 215.683C795.964 215.764 796.037 215.862 796.088 215.972C796.139 216.081 796.169 216.199 796.174 216.32C796.18 216.426 796.167 216.532 796.135 216.633C796.079 216.814 795.968 216.974 795.818 217.09C795.668 217.205 795.486 217.272 795.296 217.28Z"
                    fill="#00C066" />
                <path opacity="0.1"
                    d="M797.268 213.087C797.055 213.111 796.849 213.176 796.636 213.189C796.422 213.203 796.189 213.151 796.054 212.986C795.991 212.89 795.934 212.79 795.884 212.686C795.826 212.596 795.746 212.521 795.652 212.469C795.593 212.586 795.559 212.713 795.553 212.844C795.547 212.975 795.569 213.105 795.618 213.227C795.666 213.348 795.74 213.458 795.834 213.549C795.929 213.639 796.041 213.709 796.164 213.753C796.288 213.796 796.419 213.813 796.549 213.802C796.679 213.791 796.806 213.753 796.92 213.689C797.034 213.625 797.134 213.538 797.211 213.433C797.289 213.328 797.344 213.207 797.371 213.079C797.337 213.081 797.302 213.083 797.268 213.087Z"
                    fill="black" />
                <path opacity="0.1"
                    d="M795.296 217.281C795.176 217.286 795.055 217.268 794.942 217.227C794.828 217.186 794.724 217.123 794.634 217.042C794.545 216.96 794.473 216.862 794.421 216.753C794.37 216.644 794.341 216.525 794.335 216.405C794.328 216.261 794.355 216.117 794.415 215.986C794.49 216.037 794.556 216.101 794.609 216.176C794.67 216.283 794.736 216.386 794.809 216.485C794.963 216.659 795.224 216.72 795.46 216.714C795.695 216.708 795.907 216.653 796.133 216.635C796.077 216.816 795.966 216.974 795.817 217.09C795.667 217.205 795.485 217.272 795.296 217.281Z"
                    fill="black" />
                <path opacity="0.1"
                    d="M795.749 219.067C795.657 219.247 795.507 219.392 795.323 219.478C795.14 219.565 794.933 219.588 794.735 219.545C794.537 219.501 794.359 219.394 794.228 219.239C794.097 219.084 794.022 218.89 794.013 218.687C794.007 218.56 794.027 218.433 794.072 218.314C794.149 218.364 794.217 218.424 794.275 218.494C794.351 218.607 794.433 218.716 794.52 218.821C794.71 219.005 795.012 219.082 795.28 219.088C795.436 219.09 795.593 219.083 795.749 219.067Z"
                    fill="black" />
                <path
                    d="M793.455 220.683C793.455 220.683 794.181 220.399 794.404 220.244C794.627 220.089 795.521 219.901 795.575 220.149C795.629 220.397 796.661 221.394 795.844 221.401C795.028 221.408 793.94 221.536 793.722 221.401C793.503 221.266 793.455 220.683 793.455 220.683Z"
                    fill="#656380" />
                <path opacity="0.2"
                    d="M795.856 221.314C795.037 221.32 793.952 221.448 793.734 221.314C793.568 221.212 793.501 220.849 793.479 220.681H793.455C793.455 220.681 793.5 221.266 793.719 221.399C793.937 221.532 795.022 221.405 795.842 221.399C796.078 221.399 796.159 221.313 796.156 221.188C796.122 221.265 796.034 221.313 795.856 221.314Z"
                    fill="black" />
                <path d="M798.52 221.267H782.482V221.457H798.52V221.267Z" fill="#3F3D56" />
            </g>
            <g opacity="0.5">
                <path
                    d="M1072.72 248.157C1073.03 247.582 1072.68 246.876 1072.27 246.361C1071.85 245.846 1071.37 245.313 1071.38 244.658C1071.39 243.717 1072.39 243.161 1073.19 242.663C1073.79 242.293 1074.33 241.854 1074.82 241.355C1075.03 241.163 1075.2 240.936 1075.32 240.685C1075.49 240.317 1075.48 239.899 1075.47 239.497C1075.44 238.154 1075.37 236.812 1075.27 235.471"
                    stroke="#3F3D56" stroke-width="4" stroke-miterlimit="10" />
                <path
                    d="M1076.79 235.399C1076.78 235.153 1076.71 234.914 1076.58 234.704C1076.45 234.494 1076.27 234.319 1076.06 234.196L1075.73 234.846L1075.74 234.06C1075.44 233.972 1075.12 233.981 1074.83 234.086C1074.54 234.191 1074.29 234.386 1074.11 234.644C1073.94 234.901 1073.85 235.208 1073.86 235.519C1073.87 235.83 1073.98 236.129 1074.17 236.374C1074.36 236.618 1074.63 236.796 1074.93 236.88C1075.23 236.964 1075.55 236.951 1075.84 236.843C1076.13 236.734 1076.38 236.536 1076.55 236.276C1076.72 236.017 1076.81 235.709 1076.79 235.399Z"
                    fill="#00C066" />
                <path
                    d="M1074.17 245.332C1074.02 245.619 1073.79 245.85 1073.49 245.988C1073.2 246.126 1072.87 246.164 1072.55 246.095C1072.24 246.026 1071.95 245.854 1071.74 245.606C1071.54 245.359 1071.41 245.049 1071.4 244.726C1071.39 244.523 1071.42 244.32 1071.5 244.131C1071.6 243.852 1071.79 243.613 1072.04 243.445C1072.29 243.277 1072.58 243.188 1072.87 243.19C1073.17 243.192 1073.46 243.284 1073.71 243.455C1073.95 243.625 1074.14 243.866 1074.24 244.146L1073.33 244.892L1074.33 244.659C1074.34 244.893 1074.28 245.124 1074.17 245.332Z"
                    fill="#00C066" />
                <path
                    d="M1073.45 242.482C1073.26 242.491 1073.06 242.461 1072.88 242.396C1072.7 242.331 1072.54 242.23 1072.39 242.1C1072.25 241.971 1072.13 241.814 1072.05 241.64C1071.97 241.465 1071.92 241.276 1071.92 241.084C1071.9 240.854 1071.95 240.625 1072.04 240.416C1072.13 240.22 1072.26 240.045 1072.42 239.905C1072.59 239.764 1072.78 239.661 1072.98 239.603V240.208L1073.32 239.551C1073.51 239.542 1073.7 239.571 1073.88 239.637C1074.06 239.702 1074.23 239.803 1074.37 239.932C1074.52 240.062 1074.63 240.219 1074.71 240.393C1074.79 240.568 1074.84 240.756 1074.85 240.949C1074.86 241.118 1074.84 241.287 1074.79 241.449C1074.7 241.738 1074.52 241.992 1074.28 242.177C1074.04 242.362 1073.75 242.468 1073.45 242.482Z"
                    fill="#00C066" />
                <path opacity="0.1"
                    d="M1076.59 235.789C1076.26 235.827 1075.93 235.932 1075.59 235.953C1075.25 235.974 1074.87 235.892 1074.66 235.629C1074.56 235.475 1074.47 235.315 1074.39 235.15C1074.29 235.006 1074.17 234.887 1074.02 234.803C1073.92 234.989 1073.87 235.194 1073.86 235.402C1073.85 235.611 1073.88 235.819 1073.96 236.013C1074.04 236.206 1074.16 236.382 1074.31 236.526C1074.46 236.671 1074.64 236.782 1074.83 236.852C1075.03 236.922 1075.24 236.949 1075.45 236.931C1075.66 236.914 1075.86 236.852 1076.04 236.75C1076.22 236.649 1076.38 236.509 1076.5 236.341C1076.63 236.174 1076.72 235.981 1076.76 235.777C1076.71 235.78 1076.65 235.783 1076.59 235.789Z"
                    fill="black" />
                <path opacity="0.1"
                    d="M1073.45 242.481C1073.26 242.49 1073.06 242.461 1072.88 242.396C1072.7 242.331 1072.54 242.23 1072.39 242.1C1072.25 241.97 1072.13 241.814 1072.05 241.639C1071.97 241.465 1071.92 241.276 1071.92 241.084C1071.9 240.854 1071.95 240.625 1072.04 240.416C1072.16 240.497 1072.27 240.6 1072.35 240.719C1072.45 240.889 1072.56 241.054 1072.67 241.212C1072.92 241.489 1073.33 241.586 1073.71 241.577C1074.09 241.568 1074.42 241.48 1074.79 241.452C1074.7 241.74 1074.52 241.993 1074.28 242.177C1074.04 242.362 1073.75 242.468 1073.45 242.481Z"
                    fill="black" />
                <path opacity="0.1"
                    d="M1074.17 245.332C1074.02 245.62 1073.79 245.851 1073.49 245.989C1073.2 246.127 1072.87 246.164 1072.55 246.095C1072.24 246.026 1071.95 245.854 1071.74 245.607C1071.54 245.359 1071.41 245.049 1071.4 244.726C1071.39 244.523 1071.42 244.321 1071.5 244.131C1071.62 244.21 1071.73 244.307 1071.82 244.419C1071.94 244.599 1072.07 244.773 1072.21 244.94C1072.51 245.233 1073 245.356 1073.42 245.367C1073.67 245.37 1073.92 245.358 1074.17 245.332Z"
                    fill="black" />
                <path
                    d="M1070.51 247.912C1070.51 247.912 1071.67 247.458 1072.02 247.211C1072.38 246.964 1073.81 246.664 1073.89 247.06C1073.98 247.455 1075.63 249.046 1074.32 249.057C1073.02 249.068 1071.28 249.272 1070.94 249.057C1070.59 248.842 1070.51 247.912 1070.51 247.912Z"
                    fill="#656380" />
                <path opacity="0.2"
                    d="M1074.34 248.918C1073.03 248.928 1071.3 249.133 1070.96 248.918C1070.69 248.756 1070.58 248.176 1070.55 247.908H1070.51C1070.51 247.908 1070.58 248.842 1070.93 249.054C1071.28 249.266 1073.01 249.063 1074.32 249.054C1074.7 249.054 1074.83 248.916 1074.82 248.718C1074.77 248.841 1074.63 248.916 1074.34 248.918Z"
                    fill="black" />
                <path d="M1078.59 248.844H1053V249.147H1078.59V248.844Z" fill="#3F3D56" />
            </g>
            <g opacity="0.1">
                <path
                    d="M1175.77 77.7027C1136.68 47.572 1082.3 46.3409 1042.62 75.6982C1021.65 91.2177 1005.39 114.961 1008.35 151.113C1009.39 163.9 1012.3 174.391 1016.55 182.978C1033.75 217.792 1104.37 216.451 1108.29 216.446C1110.84 216.444 1113.38 216.501 1115.92 216.617C1124.82 217.025 1133.67 218.145 1142.4 219.964C1154.83 222.556 1170.66 223.859 1184.81 218.949C1187.21 218.119 1189.55 217.104 1191.8 215.912C1199.57 211.781 1208.27 207.833 1213.36 198.035C1217.18 190.681 1219.97 181.46 1221.31 169.975C1226.19 128.148 1201.81 97.7729 1175.77 77.7027Z"
                    fill="#F2F2F2" />
                <path d="M1168.14 76.5935V88.365H1152.82V216.743H1184.8V93.2516V88.365V76.5935H1168.14Z" fill="#575A89" />
                <path d="M1083.74 155.663V135.452H1064.2V155.663H1056.87V216.965H1090.85V155.663H1083.74Z"
                    fill="#575A89" />
                <path d="M1087.07 188.535H1060.64V217.187H1087.07V188.535Z" fill="#3F3D56" />
                <path opacity="0.1" d="M1064.86 188.535H1060.64V217.187H1064.86V188.535Z" fill="black" />
                <path d="M1141.49 70.1523V77.0376H1102.4V70.1523H1090.85V217.187H1152.82V70.1523H1141.49Z"
                    fill="#3F3D56" />
                <path opacity="0.1" d="M1150.15 70.1523H1141.49V77.0376H1150.15V70.1523Z" fill="black" />
                <path opacity="0.1" d="M1099.51 70.1523H1090.85V217.187H1099.51V70.1523Z" fill="black" />
                <path d="M1046.65 112.13V106.578H1040.88V112.13H1030.44V217.187H1056.87V112.13H1046.65Z" fill="#3F3D56" />
                <path opacity="0.1" d="M1043.98 106.578H1040.88V112.131H1043.98V106.578Z" fill="black" />
                <path opacity="0.1" d="M1033.55 112.13H1030.44V217.187H1033.55V112.13Z" fill="black" />
                <path opacity="0.1" d="M1150.15 126.79H1141.49V217.187H1150.15V126.79Z" fill="black" />
                <path opacity="0.1" d="M1056.87 112.13H1048.87V131.454H1056.87V112.13Z" fill="black" />
                <path d="M1112.84 88.8093H1100.4V94.1399H1112.84V88.8093Z" fill="#FF6584" />
                <path d="M1139.27 143.669H1126.83V149H1139.27V143.669Z" fill="#FF6584" />
                <path d="M1112.84 182.094H1100.4V187.424H1112.84V182.094Z" fill="#FF6584" />
                <path d="M1049.98 136.118H1037.54V141.448H1049.98V136.118Z" fill="#FF6584" />
                <path d="M1080.19 191.645H1067.75V196.975H1080.19V191.645Z" fill="#FF6584" />
                <path opacity="0.1" d="M1084.63 160.327H1063.31V169.212H1084.63V160.327Z" fill="black" />
                <path opacity="0.1" d="M1177.91 98.582H1156.59V107.466H1177.91V98.582Z" fill="black" />
                <path opacity="0.1" d="M1177.91 117.461H1156.59V126.345H1177.91V117.461Z" fill="black" />
                <path opacity="0.1" d="M1177.91 136.34H1156.59V145.224H1177.91V136.34Z" fill="black" />
                <path opacity="0.1" d="M1177.91 155.219H1156.59V164.103H1177.91V155.219Z" fill="black" />
                <path opacity="0.1" d="M1177.91 174.098H1156.59V182.982H1177.91V174.098Z" fill="black" />
                <path opacity="0.1" d="M1177.91 192.977H1156.59V201.861H1177.91V192.977Z" fill="black" />
                <path d="M1192.13 138.783V114.573H1176.58V138.783H1171.03V217.187H1197.46V138.783H1192.13Z"
                    fill="#3F3D56" />
                <path opacity="0.1" d="M1181.47 114.573H1176.58V138.783H1181.47V114.573Z" fill="black" />
                <path opacity="0.1" d="M1175.92 138.783H1171.03V217.187H1175.92V138.783Z" fill="black" />
                <path opacity="0.1" d="M1197.46 178.096H1184.35V185.87H1197.46V178.096Z" fill="black" />
                <path d="M1197.24 166.546H1184.8V171.877H1197.24V166.546Z" fill="#FF6584" />
            </g>
            <g clip-path="url(#clip0_28_850)">
                <path
                    d="M833.827 189.562L825.349 189.644C824.95 187.715 823.611 182.655 824.817 181.275C824.872 180.756 825.129 180.277 825.534 179.939C825.939 179.601 826.461 179.43 826.991 179.46C828.305 177.438 830.494 177.742 831.973 179.005C833.462 179.51 834.023 180.407 833.827 181.624C834.929 182.573 835.133 183.727 834.638 185.041L833.827 189.562Z"
                    fill="#2F2E41" />
                <path
                    d="M833.011 194.696L826.894 193.864L825.671 192.106C827.356 191.007 827.952 189.473 827.176 187.389L831.411 187.296C831.212 189.152 831.837 190.589 833.575 191.459L833.011 194.696Z"
                    fill="#FFB9B9" />
                <path
                    d="M825.448 248.927L825.214 252.07C825.203 252.213 825.224 252.356 825.274 252.489C825.324 252.623 825.403 252.745 825.505 252.846C825.607 252.948 825.73 253.027 825.865 253.078C826.001 253.129 826.146 253.151 826.291 253.142L827.933 253.044C828.009 253.04 828.083 253.019 828.15 252.983C828.217 252.947 828.275 252.897 828.32 252.837C828.365 252.776 828.396 252.707 828.411 252.633C828.426 252.56 828.424 252.484 828.405 252.411L827.494 248.827L825.448 248.927Z"
                    fill="#E6E6E6" />
                <path
                    d="M830.765 248.827L829.853 252.411C829.835 252.484 829.833 252.56 829.847 252.633C829.862 252.707 829.893 252.776 829.938 252.837C829.983 252.897 830.041 252.947 830.108 252.983C830.175 253.019 830.249 253.04 830.325 253.044L831.968 253.142C832.113 253.151 832.258 253.129 832.393 253.078C832.529 253.027 832.651 252.948 832.753 252.846C832.855 252.745 832.934 252.623 832.984 252.489C833.034 252.356 833.055 252.213 833.044 252.07L832.81 248.927L830.765 248.827Z"
                    fill="#E6E6E6" />
                <path
                    d="M832.917 249.364L830.7 249.145L828.494 225.961L827.66 249.07L825.482 248.994L821.812 216.989H835.834L832.917 249.364Z"
                    fill="#00C066" />
                <path
                    d="M829.529 188.869C831.868 188.869 833.763 187.005 833.763 184.706C833.763 182.407 831.868 180.544 829.529 180.544C827.19 180.544 825.294 182.407 825.294 184.706C825.294 187.005 827.19 188.869 829.529 188.869Z"
                    fill="#FFB9B9" />
                <path
                    d="M837.904 217.729L820.777 217.914C823.319 208.403 824.839 199.568 822.189 193.494L826.424 191.459C828.465 193.552 830.739 193.336 833.199 191.274L837.245 192.291C836.552 200.256 836.863 208.787 837.904 217.729Z"
                    fill="#00C066" />
                <path
                    d="M816.072 207.924L826.706 212.086L829.083 212.773C829.19 212.804 829.301 212.814 829.411 212.801C829.521 212.788 829.628 212.754 829.724 212.7C829.82 212.645 829.904 212.573 829.971 212.486C830.038 212.399 830.086 212.3 830.113 212.194C830.16 212.009 830.139 211.813 830.053 211.641C829.968 211.47 829.823 211.334 829.645 211.257L827.176 210.514L819.742 206.259L821.295 202.235L818.048 200.524L816.072 207.924Z"
                    fill="#FFB9B9" />
                <path
                    d="M816.166 200.339C818.189 201.114 819.799 202.439 821.06 204.224L825.012 198.581L822.189 193.494L816.166 200.339Z"
                    fill="#00C066" />
                <path
                    d="M834.302 184.032C832.583 183.596 830.893 183.537 829.25 184.089C828.204 184.587 826.948 184.541 825.55 184.13V179.978L833.094 180.175L834.302 184.032Z"
                    fill="#2F2E41" />
                <path
                    d="M826.67 203.074C826.338 203.074 826.019 203.204 825.784 203.435C825.549 203.667 825.417 203.98 825.416 204.307L825.911 214.493C825.912 214.82 826.044 215.134 826.279 215.365C826.514 215.596 826.833 215.726 827.166 215.726H832.825C833.158 215.726 833.477 215.596 833.712 215.365C833.947 215.134 834.079 214.82 834.08 214.493L834.575 204.307C834.574 203.98 834.442 203.667 834.207 203.435C833.972 203.204 833.653 203.074 833.321 203.074H826.67Z"
                    fill="#3F3D56" />
                <path
                    d="M842.73 207.154L833.461 210.782L832.762 211.056C832.739 211.064 832.717 211.071 832.694 211.079L830.351 211.756C830.051 211.843 829.637 211.446 829.394 211.172C829.274 211.04 829.206 210.871 829.202 210.694C829.199 210.517 829.26 210.344 829.374 210.208C829.407 210.171 829.442 210.137 829.481 210.107C829.571 210.038 829.677 209.992 829.79 209.973L832.13 209.52C832.214 209.504 832.295 209.475 832.369 209.433L833.461 208.807L839.128 205.564C839.286 205.474 839.406 205.332 839.467 205.163C839.528 204.994 839.526 204.809 839.461 204.642L838.379 201.838C838.313 201.666 838.312 201.477 838.378 201.305C838.443 201.133 838.57 200.99 838.734 200.903L840.527 199.959C840.629 199.905 840.743 199.875 840.859 199.87C840.975 199.866 841.09 199.887 841.197 199.933C841.304 199.978 841.398 200.047 841.474 200.134C841.549 200.221 841.604 200.323 841.633 200.434L843.189 206.259C843.237 206.437 843.216 206.627 843.132 206.792C843.047 206.957 842.904 207.086 842.73 207.154Z"
                    fill="#FFB9B9" />
                <path
                    d="M843.268 199.321C841.245 200.097 839.635 201.421 838.374 203.206L834.422 197.564L837.245 192.291L843.268 199.321Z"
                    fill="#00C066" />
                <path
                    d="M832.347 188.411C830.495 189.168 828.552 189.138 826.53 188.411C827.119 187.424 826.239 186.651 825.788 185.654L833.337 185.434C832.76 186.299 831.908 187.322 832.347 188.411Z"
                    fill="white" />
                <path
                    d="M833.257 185.599L833.17 185.513L833.293 185.391L834.033 184.543L834.127 184.622L833.384 185.473L833.257 185.599Z"
                    fill="white" />
                <path d="M825.27 185.083L825.191 185.177L825.933 185.785L826.013 185.691L825.27 185.083Z" fill="white" />
                <path d="M833.47 186.314L832.171 188.321L832.275 188.386L833.575 186.379L833.47 186.314Z" fill="white" />
                <path d="M825.407 186.314L825.302 186.379L826.602 188.386L826.706 188.321L825.407 186.314Z"
                    fill="white" />
                <path
                    d="M833.708 208.635V210.839L832.928 211.145C832.903 211.155 832.878 211.163 832.852 211.171L830.237 211.927C829.902 212.024 829.44 211.581 829.169 211.275C829.035 211.128 828.959 210.939 828.955 210.741C828.951 210.543 829.019 210.351 829.147 210.199C829.183 210.158 829.223 210.12 829.266 210.086C829.366 210.009 829.485 209.957 829.611 209.936L832.223 209.431C832.317 209.413 832.407 209.38 832.49 209.333L833.708 208.635Z"
                    fill="white" />
                <path
                    d="M834.84 200.774H834.392C834.392 194.556 833.09 190.223 831.821 190.223L831.709 189.783C832.847 189.783 833.573 191.587 833.981 193.1C834.535 195.151 834.84 197.876 834.84 200.774Z"
                    fill="#3F3D56" />
                <path
                    d="M824.553 199.235H824.106C824.106 193.541 825.417 190.003 827.348 190.003L827.236 190.443C825.901 190.443 824.553 193.162 824.553 199.235Z"
                    fill="#3F3D56" />
                <path
                    d="M834.616 201.983C835.233 201.983 835.734 201.491 835.734 200.884C835.734 200.277 835.233 199.785 834.616 199.785C833.998 199.785 833.498 200.277 833.498 200.884C833.498 201.491 833.998 201.983 834.616 201.983Z"
                    fill="#3F3D56" />
                <path
                    d="M822.764 201.873H822.317C822.317 200.298 823.22 199.016 824.329 199.016V199.455C823.466 199.455 822.764 200.54 822.764 201.873Z"
                    fill="#3F3D56" />
                <path
                    d="M826.342 201.873H825.895C825.895 200.54 825.193 199.455 824.329 199.455V199.016C825.439 199.016 826.342 200.298 826.342 201.873Z"
                    fill="#3F3D56" />
                <path
                    d="M826.118 202.423C826.365 202.423 826.566 202.226 826.566 201.983C826.566 201.74 826.365 201.543 826.118 201.543C825.871 201.543 825.671 201.74 825.671 201.983C825.671 202.226 825.871 202.423 826.118 202.423Z"
                    fill="#3F3D56" />
                <path
                    d="M822.541 202.423C822.788 202.423 822.988 202.226 822.988 201.983C822.988 201.74 822.788 201.543 822.541 201.543C822.294 201.543 822.093 201.74 822.093 201.983C822.093 202.226 822.294 202.423 822.541 202.423Z"
                    fill="#3F3D56" />
                <path
                    d="M768.642 187.209L760.788 188.516C760.594 188.549 760.394 188.51 760.228 188.406C760.062 188.302 759.941 188.142 759.888 187.955C759.32 185.942 758.134 183.316 759.286 181.997C759.345 181.442 759.619 180.931 760.051 180.57C760.483 180.209 761.041 180.026 761.607 180.059C763.01 177.9 765.348 178.224 766.927 179.572C768.517 180.112 769.116 181.069 768.907 182.369C769.594 182.96 769.954 183.626 770.03 184.357C770.066 184.763 770.013 185.173 769.875 185.557C769.737 185.942 769.518 186.294 769.231 186.589L768.642 187.209Z"
                    fill="#2F2E41" />
                <path
                    d="M767.421 193.288L761.332 192.935C761.929 191.589 762.167 190.293 761.929 189.062H766.466C766.456 190.007 766.934 191.641 767.421 193.288Z"
                    fill="#9F616A" />
                <path
                    d="M760.092 248.595L759.842 251.951C759.83 252.103 759.852 252.256 759.906 252.399C759.959 252.542 760.044 252.672 760.152 252.78C760.261 252.888 760.393 252.973 760.537 253.027C760.682 253.082 760.837 253.105 760.992 253.096L762.745 252.991C762.827 252.986 762.906 252.964 762.977 252.926C763.049 252.887 763.111 252.834 763.159 252.77C763.207 252.705 763.24 252.631 763.256 252.552C763.271 252.474 763.269 252.393 763.25 252.315L762.276 248.488L760.092 248.595Z"
                    fill="#E6E6E6" />
                <path
                    d="M765.769 248.488L764.796 252.315C764.776 252.393 764.774 252.474 764.79 252.552C764.805 252.631 764.838 252.705 764.887 252.77C764.935 252.834 764.997 252.887 765.068 252.926C765.14 252.964 765.219 252.986 765.3 252.991L767.054 253.096C767.208 253.105 767.363 253.082 767.508 253.027C767.653 252.973 767.784 252.888 767.893 252.78C768.002 252.672 768.086 252.542 768.139 252.399C768.193 252.256 768.215 252.103 768.204 251.951L767.954 248.595L765.769 248.488Z"
                    fill="#E6E6E6" />
                <path
                    d="M768.067 249.061L765.7 248.828L763.344 224.071L762.454 248.748L760.129 248.666L756.21 214.49H771.182L768.067 249.061Z"
                    fill="#00C066" />
                <path
                    d="M764.317 190.487C766.815 190.487 768.839 188.497 768.839 186.042C768.839 183.587 766.815 181.597 764.317 181.597C761.82 181.597 759.795 183.587 759.795 186.042C759.795 188.497 761.82 190.487 764.317 190.487Z"
                    fill="#9F616A" />
                <path
                    d="M769.414 183.919C767.579 183.605 765.774 183.562 764.02 183.96C762.903 184.32 761.561 184.287 760.069 183.99V180.993L768.125 181.136L769.414 183.919Z"
                    fill="#2F2E41" />
                <path
                    d="M767.327 189.609C765.349 190.417 763.274 190.385 761.115 189.609C761.743 188.555 760.804 187.729 760.322 186.665L768.384 186.429C767.767 187.354 766.858 188.446 767.327 189.609Z"
                    fill="white" />
                <path d="M759.767 186.058L759.688 186.152L760.481 186.801L760.56 186.708L759.767 186.058Z"
                    fill="white" />
                <path d="M768.53 187.371L767.142 189.515L767.247 189.58L768.635 187.437L768.53 187.371Z" fill="white" />
                <path d="M759.912 187.371L759.807 187.437L761.195 189.58L761.299 189.515L759.912 187.371Z"
                    fill="white" />
                <path
                    d="M755.721 206.315L752.258 204.202L755.211 195.701C755.54 194.824 756.171 194.087 756.994 193.619L757.989 193.053L758.076 201.629L755.721 206.315Z"
                    fill="#00C066" />
                <path
                    d="M770.687 210.444L770.175 206.131C770.147 203.854 770.541 201.653 771.481 199.625L771.958 193.288L766.705 191.175C766.689 191.28 766.675 191.385 766.66 191.491L764.198 192.701L761.796 192.164L761.81 191.41L757.034 193.522C758.613 200.74 757.752 208.235 755.036 217.088L761.328 218.779L761.38 215.809L766.987 215.416C767.045 216.379 767.091 217.326 767.118 218.251C770.282 219.396 770.391 219.377 773.274 217.738C772.126 215.365 771.217 212.896 770.687 210.444Z"
                    fill="#00C066" />
                <path d="M778.764 205.258L775.54 204.202L770.384 198.302L771.958 193.288L779.122 203.146L778.764 205.258Z"
                    fill="#00C066" />
                <path
                    d="M768.661 209.827C768.714 210.054 768.856 210.252 769.057 210.376C769.258 210.501 769.501 210.542 769.732 210.491L772.469 209.881L772.073 208.165L769.337 208.774C769.105 208.825 768.904 208.965 768.777 209.163C768.65 209.36 768.609 209.599 768.661 209.827V209.827Z"
                    fill="#E6E6E6" />
                <path
                    d="M771.123 207.84L772.675 210.657C775.285 209.941 777.548 207.685 779.719 205.024L779.122 203.146L775.421 204.085L771.123 207.84Z"
                    fill="#00C066" />
                <path d="M750.885 199.005L753.865 199.528L760.676 209.047L757.057 208.21L750.885 199.005Z"
                    fill="#E6E6E6" />
                <path
                    d="M750.357 198.889C750.311 198.889 750.267 198.902 750.228 198.925C750.189 198.949 750.158 198.982 750.136 199.021C750.115 199.061 750.105 199.105 750.107 199.15C750.109 199.194 750.124 199.237 750.149 199.275L756.515 208.769C756.55 208.822 756.605 208.86 756.668 208.875L759.63 209.56C759.68 209.571 759.733 209.568 759.78 209.549C759.828 209.531 759.869 209.499 759.898 209.457C759.927 209.415 759.942 209.366 759.941 209.315C759.941 209.265 759.925 209.216 759.895 209.175L752.905 199.405C752.886 199.379 752.862 199.356 752.834 199.338C752.807 199.321 752.775 199.309 752.743 199.303L750.404 198.893C750.389 198.89 750.373 198.889 750.357 198.889Z"
                    fill="#3F3D56" />
                <path
                    d="M754.328 205.677L754.505 207.429L757.297 207.157C757.533 207.133 757.751 207.019 757.901 206.839C758.052 206.658 758.123 206.426 758.1 206.194C758.076 205.961 757.96 205.748 757.776 205.6C757.592 205.452 757.356 205.382 757.12 205.405L754.328 205.677Z"
                    fill="#E6E6E6" />
                <path
                    d="M751.9 205.474C751.904 206.072 752.148 206.643 752.579 207.064C753.01 207.486 753.593 207.722 754.2 207.723H754.659L754.994 204.985L752.226 204.006L751.9 205.474Z"
                    fill="#00C066" />
                <path
                    d="M768.163 186.732L768.076 186.646L768.208 186.517L768.998 185.611L769.092 185.69L768.299 186.599L768.163 186.732Z"
                    fill="white" />
                <path d="M851.902 252.952H742V253.196H851.902V252.952Z" fill="#3F3D56" />
                <path
                    d="M783.956 252.831H809.946V221.843C809.946 220.202 808.302 218.867 806.281 218.867H787.621C785.6 218.867 783.956 220.202 783.956 221.843V252.831Z"
                    fill="#E6E6E6" />
                <path
                    d="M785.936 251.549H807.966V225.284C807.966 223.893 806.572 222.761 804.859 222.761H789.042C787.329 222.761 785.936 223.893 785.936 225.284V251.549Z"
                    fill="white" />
                <path
                    d="M783.759 216.456C783.117 216.456 782.594 216.88 782.594 217.402V220.132C782.594 220.654 783.117 221.078 783.759 221.078H810.142C810.785 221.078 811.307 220.654 811.307 220.132V217.402C811.307 216.88 810.785 216.456 810.142 216.456H783.759Z"
                    fill="#3F3D56" />
                <path
                    d="M789.176 248.181C788.874 248.182 788.585 248.3 788.372 248.51C788.159 248.72 788.039 249.004 788.038 249.3C788.039 249.597 788.159 249.881 788.372 250.09C788.585 250.3 788.874 250.418 789.176 250.419H791.307V248.181H789.176Z"
                    fill="#3F3D56" />
                <path
                    d="M793.262 248.181H791.19V250.419H793.262C793.564 250.418 793.853 250.3 794.066 250.09C794.279 249.881 794.399 249.597 794.4 249.3C794.399 249.004 794.279 248.72 794.066 248.51C793.853 248.3 793.564 248.182 793.262 248.181Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M794.005 248.456C794.184 248.658 794.283 248.917 794.284 249.186C794.283 249.482 794.162 249.766 793.949 249.976C793.736 250.185 793.447 250.304 793.145 250.304H791.19V250.419H793.262C793.564 250.418 793.853 250.3 794.066 250.091C794.279 249.881 794.399 249.597 794.4 249.3C794.4 249.14 794.365 248.981 794.296 248.836C794.228 248.69 794.129 248.56 794.005 248.456Z"
                    fill="black" />
                <path
                    d="M798.79 231.329C798.582 231.114 798.297 230.988 797.995 230.979C797.694 230.971 797.401 231.08 797.181 231.282C796.962 231.486 796.834 231.767 796.825 232.063C796.817 232.36 796.927 232.648 797.134 232.864L798.595 234.388L800.251 232.853L798.79 231.329Z"
                    fill="#3F3D56" />
                <path
                    d="M801.593 234.252L800.171 232.77L798.515 234.304L799.936 235.787C800.144 236.002 800.429 236.127 800.731 236.136C801.032 236.145 801.325 236.036 801.545 235.833C801.764 235.629 801.892 235.348 801.901 235.052C801.91 234.756 801.799 234.468 801.593 234.252Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M801.899 234.971C801.873 235.238 801.749 235.487 801.55 235.671C801.33 235.874 801.037 235.983 800.736 235.974C800.434 235.965 800.149 235.839 799.941 235.624L798.6 234.226L798.515 234.304L799.936 235.786C800.144 236.002 800.429 236.127 800.731 236.136C801.032 236.145 801.325 236.036 801.545 235.833C801.664 235.723 801.757 235.589 801.818 235.44C801.879 235.291 801.907 235.131 801.899 234.971Z"
                    fill="black" />
                <path
                    d="M792.726 234.857C792.518 234.642 792.233 234.516 791.931 234.508C791.63 234.499 791.337 234.608 791.117 234.81C790.898 235.014 790.77 235.295 790.761 235.592C790.752 235.888 790.863 236.176 791.069 236.392L792.531 237.916L794.187 236.381L792.726 234.857Z"
                    fill="#3F3D56" />
                <path
                    d="M795.528 237.779L794.107 236.297L792.45 237.832L793.872 239.314C794.079 239.529 794.365 239.655 794.666 239.664C794.968 239.673 795.261 239.564 795.481 239.361C795.7 239.157 795.827 238.876 795.836 238.58C795.845 238.284 795.734 237.996 795.528 237.779Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M795.835 238.499C795.808 238.766 795.684 239.015 795.486 239.199C795.266 239.402 794.973 239.511 794.671 239.502C794.37 239.493 794.084 239.367 793.877 239.152L792.535 237.754L792.45 237.832L793.872 239.315C794.079 239.53 794.365 239.655 794.666 239.664C794.968 239.673 795.261 239.564 795.481 239.361C795.599 239.251 795.692 239.117 795.754 238.968C795.815 238.819 795.842 238.659 795.835 238.499Z"
                    fill="black" />
                <path
                    d="M798.79 238.142C798.582 237.927 798.297 237.801 797.995 237.792C797.694 237.783 797.401 237.892 797.181 238.095C796.962 238.299 796.834 238.58 796.825 238.876C796.817 239.173 796.927 239.46 797.134 239.677L798.595 241.201L800.251 239.666L798.79 238.142Z"
                    fill="#3F3D56" />
                <path
                    d="M801.593 241.064L800.171 239.582L798.515 241.117L799.936 242.599C800.144 242.814 800.429 242.94 800.731 242.949C801.032 242.958 801.325 242.849 801.545 242.646C801.764 242.442 801.892 242.161 801.901 241.865C801.91 241.568 801.799 241.281 801.593 241.064Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M801.899 241.783C801.873 242.051 801.749 242.299 801.55 242.484C801.33 242.686 801.037 242.795 800.736 242.787C800.434 242.778 800.149 242.652 799.941 242.437L798.6 241.038L798.515 241.117L799.936 242.599C800.144 242.814 800.429 242.94 800.731 242.949C801.032 242.957 801.325 242.849 801.545 242.646C801.664 242.536 801.757 242.401 801.818 242.253C801.879 242.104 801.907 241.944 801.899 241.783Z"
                    fill="black" />
                <path
                    d="M802.49 245.133C802.706 244.926 802.83 244.644 802.836 244.348C802.841 244.051 802.726 243.765 802.518 243.551C802.307 243.338 802.02 243.216 801.719 243.211C801.417 243.206 801.126 243.318 800.908 243.523L799.376 244.978L800.957 246.588L802.49 245.133Z"
                    fill="#3F3D56" />
                <path
                    d="M799.551 247.923L801.041 246.508L799.46 244.899L797.969 246.314C797.753 246.52 797.629 246.803 797.623 247.099C797.618 247.395 797.733 247.682 797.941 247.896C798.152 248.108 798.439 248.231 798.74 248.236C799.042 248.241 799.333 248.129 799.551 247.923Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M798.823 248.233C798.551 248.21 798.296 248.091 798.107 247.899C797.898 247.685 797.783 247.398 797.789 247.102C797.794 246.805 797.918 246.523 798.134 246.317L799.541 244.981L799.46 244.899L797.969 246.314C797.753 246.52 797.629 246.803 797.623 247.099C797.618 247.395 797.733 247.682 797.941 247.896C798.055 248.011 798.193 248.101 798.345 248.159C798.497 248.217 798.66 248.243 798.823 248.233Z"
                    fill="black" />
                <path
                    d="M794.321 241.605C794.538 241.398 794.662 241.116 794.667 240.819C794.673 240.523 794.558 240.237 794.349 240.023C794.139 239.81 793.852 239.688 793.55 239.683C793.249 239.678 792.957 239.79 792.74 239.995L791.208 241.45L792.789 243.06L794.321 241.605Z"
                    fill="#3F3D56" />
                <path
                    d="M791.382 244.395L792.873 242.98L791.291 241.371L789.801 242.786C789.585 242.992 789.46 243.275 789.455 243.571C789.45 243.867 789.564 244.154 789.773 244.368C789.983 244.58 790.27 244.703 790.572 244.708C790.873 244.713 791.165 244.6 791.382 244.395Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M790.655 244.705C790.382 244.682 790.128 244.563 789.938 244.37C789.729 244.157 789.615 243.87 789.62 243.574C789.625 243.277 789.75 242.995 789.966 242.788L791.372 241.453L791.291 241.371L789.801 242.786C789.585 242.992 789.46 243.275 789.455 243.571C789.45 243.867 789.564 244.154 789.773 244.368C789.887 244.483 790.024 244.573 790.176 244.631C790.328 244.689 790.492 244.715 790.655 244.705Z"
                    fill="black" />
                <path
                    d="M805.955 237.347C806.171 237.14 806.296 236.858 806.301 236.562C806.306 236.265 806.192 235.979 805.983 235.765C805.773 235.552 805.486 235.43 805.184 235.425C804.882 235.42 804.591 235.532 804.373 235.738L802.841 237.192L804.423 238.802L805.955 237.347Z"
                    fill="#3F3D56" />
                <path
                    d="M803.016 240.137L804.507 238.722L802.925 237.113L801.435 238.528C801.218 238.734 801.094 239.017 801.089 239.313C801.084 239.61 801.198 239.896 801.407 240.11C801.617 240.322 801.904 240.445 802.206 240.45C802.507 240.455 802.799 240.343 803.016 240.137Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M802.288 240.447C802.016 240.424 801.762 240.306 801.572 240.113C801.363 239.899 801.249 239.612 801.254 239.316C801.259 239.02 801.383 238.737 801.6 238.531L803.006 237.195L802.925 237.113L801.435 238.528C801.218 238.734 801.094 239.017 801.089 239.313C801.084 239.61 801.198 239.896 801.407 240.11C801.52 240.225 801.658 240.315 801.81 240.373C801.962 240.431 802.125 240.457 802.288 240.447Z"
                    fill="black" />
                <path
                    d="M803.369 246.171C803.162 245.956 802.876 245.83 802.575 245.822C802.273 245.813 801.98 245.922 801.76 246.124C801.542 246.328 801.414 246.609 801.405 246.906C801.396 247.202 801.507 247.49 801.713 247.706L803.174 249.23L804.831 247.695L803.369 246.171Z"
                    fill="#3F3D56" />
                <path
                    d="M806.172 249.093L804.751 247.611L803.094 249.146L804.516 250.628C804.723 250.843 805.009 250.969 805.31 250.978C805.612 250.987 805.904 250.878 806.125 250.675C806.343 250.471 806.471 250.19 806.48 249.894C806.489 249.598 806.378 249.31 806.172 249.093Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M806.479 249.813C806.452 250.08 806.328 250.329 806.129 250.513C805.909 250.716 805.617 250.825 805.315 250.816C805.014 250.807 804.728 250.681 804.52 250.466L803.179 249.068L803.094 249.146L804.516 250.628C804.723 250.844 805.009 250.969 805.31 250.978C805.612 250.987 805.904 250.878 806.125 250.675C806.243 250.565 806.336 250.431 806.397 250.282C806.458 250.133 806.486 249.973 806.479 249.813Z"
                    fill="black" />
                <path
                    d="M795.325 246.049C795.117 245.834 794.831 245.708 794.53 245.7C794.229 245.691 793.936 245.8 793.716 246.003C793.497 246.207 793.369 246.487 793.36 246.784C793.351 247.08 793.462 247.368 793.668 247.584L795.13 249.108L796.786 247.573L795.325 246.049Z"
                    fill="#3F3D56" />
                <path
                    d="M798.127 248.972L796.706 247.49L795.05 249.025L796.471 250.507C796.678 250.722 796.964 250.848 797.266 250.856C797.567 250.865 797.86 250.756 798.08 250.553C798.299 250.349 798.427 250.069 798.435 249.772C798.444 249.476 798.334 249.188 798.127 248.972Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M798.434 249.691C798.407 249.958 798.283 250.207 798.085 250.391C797.865 250.594 797.572 250.703 797.27 250.694C796.969 250.685 796.683 250.56 796.476 250.344L795.135 248.946L795.05 249.025L796.471 250.507C796.678 250.722 796.964 250.847 797.266 250.856C797.567 250.865 797.86 250.756 798.08 250.553C798.198 250.443 798.292 250.309 798.353 250.16C798.414 250.011 798.441 249.851 798.434 249.691Z"
                    fill="black" />
                <path
                    d="M797.589 242.036C797.589 242.408 797.459 242.768 797.219 243.056C796.98 243.344 796.647 243.543 796.276 243.617C796.059 243.66 795.836 243.66 795.619 243.617C795.249 243.542 794.915 243.344 794.676 243.056C794.437 242.768 794.306 242.408 794.306 242.036C794.306 241.664 794.437 241.303 794.676 241.015C794.915 240.727 795.249 240.529 795.619 240.454C795.836 240.411 796.059 240.411 796.276 240.454C796.647 240.529 796.98 240.727 797.219 241.015C797.459 241.303 797.589 241.664 797.589 242.036Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M796.276 240.454V243.617C796.059 243.66 795.836 243.66 795.619 243.617V240.454C795.836 240.411 796.059 240.411 796.276 240.454Z"
                    fill="black" />
                <path
                    d="M798.332 235.588C798.332 235.96 798.201 236.32 797.962 236.609C797.723 236.897 797.389 237.095 797.019 237.169C796.802 237.212 796.579 237.212 796.362 237.169C795.991 237.095 795.658 236.897 795.419 236.609C795.18 236.32 795.049 235.96 795.049 235.588C795.049 235.216 795.18 234.855 795.419 234.567C795.658 234.279 795.991 234.081 796.362 234.007C796.579 233.964 796.802 233.964 797.019 234.007C797.389 234.081 797.723 234.279 797.962 234.567C798.201 234.855 798.332 235.216 798.332 235.588Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M797.018 234.007V237.169C796.802 237.212 796.578 237.212 796.362 237.169V234.007C796.578 233.964 796.802 233.964 797.018 234.007Z"
                    fill="black" />
                <path
                    d="M798.332 244.834C798.332 245.205 798.201 245.566 797.962 245.854C797.723 246.142 797.389 246.34 797.019 246.415C796.802 246.458 796.579 246.458 796.362 246.415C795.991 246.34 795.658 246.142 795.419 245.854C795.18 245.566 795.049 245.205 795.049 244.833C795.049 244.462 795.18 244.101 795.419 243.813C795.658 243.525 795.991 243.327 796.362 243.252C796.579 243.209 796.802 243.209 797.019 243.252C797.389 243.327 797.723 243.525 797.962 243.813C798.201 244.101 798.332 244.462 798.332 244.834Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M797.018 243.252V246.415C796.802 246.458 796.578 246.458 796.362 246.415V243.252C796.578 243.209 796.802 243.209 797.018 243.252Z"
                    fill="black" />
                <path
                    d="M802.416 249.335C802.416 249.707 802.285 250.068 802.046 250.356C801.807 250.644 801.473 250.842 801.103 250.916C800.886 250.959 800.663 250.959 800.446 250.916C800.075 250.842 799.742 250.644 799.503 250.356C799.264 250.067 799.133 249.707 799.133 249.335C799.133 248.963 799.264 248.602 799.503 248.314C799.742 248.026 800.075 247.828 800.446 247.754C800.663 247.711 800.886 247.711 801.103 247.754C801.473 247.828 801.807 248.026 802.046 248.314C802.285 248.602 802.416 248.963 802.416 249.335Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M801.103 247.754V250.916C800.886 250.959 800.663 250.959 800.446 250.916V247.754C800.663 247.711 800.886 247.711 801.103 247.754Z"
                    fill="black" />
                <path
                    d="M806.024 241.053C806.296 241.311 806.47 241.654 806.515 242.023C806.56 242.393 806.473 242.766 806.271 243.08C806.152 243.263 805.997 243.421 805.815 243.545C805.503 243.755 805.127 243.854 804.75 243.823C804.373 243.792 804.018 243.635 803.745 243.377C803.473 243.118 803.3 242.776 803.255 242.406C803.21 242.037 803.296 241.664 803.498 241.35C803.617 241.167 803.772 241.009 803.954 240.885C804.266 240.674 804.642 240.576 805.019 240.607C805.397 240.637 805.751 240.795 806.024 241.053Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M803.954 240.885L806.271 243.08C806.152 243.263 805.997 243.421 805.815 243.545L803.499 241.35C803.617 241.167 803.772 241.009 803.954 240.885Z"
                    fill="black" />
                <path
                    d="M806.519 244.581C806.791 244.839 806.965 245.182 807.01 245.551C807.055 245.921 806.969 246.294 806.766 246.608C806.647 246.791 806.492 246.949 806.31 247.073C805.998 247.283 805.622 247.382 805.245 247.351C804.868 247.32 804.513 247.163 804.241 246.905C803.968 246.647 803.795 246.304 803.75 245.935C803.705 245.565 803.791 245.192 803.994 244.878C804.112 244.695 804.267 244.537 804.449 244.413C804.761 244.202 805.137 244.104 805.514 244.135C805.892 244.165 806.246 244.323 806.519 244.581Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M804.449 244.413L806.766 246.608C806.647 246.791 806.492 246.949 806.31 247.072L803.994 244.878C804.113 244.695 804.267 244.537 804.449 244.413Z"
                    fill="black" />
                <path
                    d="M791.791 245.433C792.064 245.691 792.237 246.034 792.282 246.403C792.327 246.772 792.241 247.145 792.038 247.459C791.919 247.643 791.764 247.801 791.582 247.924C791.27 248.135 790.894 248.233 790.517 248.203C790.14 248.172 789.785 248.014 789.513 247.756C789.24 247.498 789.067 247.155 789.022 246.786C788.977 246.417 789.063 246.044 789.266 245.729C789.385 245.546 789.54 245.388 789.721 245.265C790.033 245.054 790.41 244.956 790.787 244.986C791.164 245.017 791.519 245.175 791.791 245.433Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M789.722 245.265L792.038 247.459C791.919 247.643 791.764 247.801 791.582 247.924L789.266 245.729C789.385 245.546 789.54 245.388 789.722 245.265Z"
                    fill="black" />
                <path opacity="0.2" d="M786.493 216.456H785.874V220.957H786.493V216.456Z" fill="black" />
                <path opacity="0.2" d="M790.082 216.456H789.463V220.957H790.082V216.456Z" fill="black" />
                <path opacity="0.2" d="M793.671 216.456H793.052V220.957H793.671V216.456Z" fill="black" />
                <path opacity="0.2" d="M797.26 216.456H796.641V220.957H797.26V216.456Z" fill="black" />
                <path opacity="0.2" d="M800.849 216.456H800.23V220.957H800.849V216.456Z" fill="black" />
                <path opacity="0.2" d="M804.438 216.456H803.82V220.957H804.438V216.456Z" fill="black" />
                <path opacity="0.2" d="M808.028 216.456H807.409V220.957H808.028V216.456Z" fill="black" />
            </g>
            <g clip-path="url(#clip1_28_850)">
                <path d="M697.373 242.757L694.278 242.757L692.806 230.863L697.374 230.863L697.373 242.757Z"
                    fill="#FFB8B8" />
                <path
                    d="M698.163 245.746L688.183 245.746V245.62C688.183 244.594 688.592 243.609 689.321 242.884C690.049 242.158 691.037 241.75 692.067 241.75H692.068L698.163 241.75L698.163 245.746Z"
                    fill="#2F2E41" />
                <path d="M711.033 235.176L709.024 237.522L698.987 230.917L701.952 227.455L711.033 235.176Z"
                    fill="#FFB8B8" />
                <path
                    d="M713.828 236.518L707.35 244.081L707.254 244C706.47 243.334 705.985 242.384 705.903 241.361C705.822 240.338 706.152 239.325 706.821 238.544L706.821 238.544L710.777 233.924L713.828 236.518Z"
                    fill="#2F2E41" />
                <path d="M675.397 184.263L674.434 193.116L713.38 192.562L696.395 164.989L682.528 164.493L675.397 184.263Z"
                    fill="#2F2E41" />
                <path opacity="0.28"
                    d="M675.397 184.263L674.434 193.116L713.38 192.562L696.395 164.989L682.528 164.493L675.397 184.263Z"
                    fill="black" />
                <path
                    d="M683.056 185.783L681.681 193.883V201.124L692.767 204.729C692.767 204.729 691.469 232.851 693.199 234.642L693.156 238.966L697.992 239.185L698.032 236.142L700.082 213.396L701.29 196.696L699.332 184.035L683.056 185.783Z"
                    fill="#2F2E41" />
                <path
                    d="M691.644 192.756L681.681 201.123C681.681 201.123 681.098 216.22 682.579 217.991C683.85 219.512 700.392 232.628 700.392 232.628C700.392 232.628 703.332 235.315 704.98 235.358C706.628 235.401 708.544 231.958 708.544 231.958L704.728 229.069C704.728 229.069 694.843 219.876 691.908 216.22C690.723 214.745 690.723 214.598 690.723 214.598L691.128 208.462L695.2 197.075L691.644 192.756Z"
                    fill="#2F2E41" />
                <path
                    d="M681.067 152.674L676.771 152.279L672.874 152.926L664.623 152.928L663.92 158.886L671.45 160.565L673.285 159.669L680.934 162.573L681.067 152.674Z"
                    fill="#2F2E41" />
                <path
                    d="M686.197 152.656C686.197 152.656 695.314 151.805 697.387 153.427C699.46 155.05 703.902 187.214 703.902 187.214L686.197 188.21L683.023 186.034L683.924 169.976L686.197 152.656Z"
                    fill="#CCCCCC" />
                <path d="M688.98 152.455L678.923 152.675L669.547 194.886L676.951 196.509L688.98 152.455Z" fill="#2F2E41" />
                <path
                    d="M696.129 152.098L704.051 154.569L703.601 171.912L713.38 192.647L701.884 193.853L692.796 171.464L696.129 152.098Z"
                    fill="#2F2E41" />
                <path
                    d="M709.192 194.753C709.469 194.51 709.69 194.208 709.838 193.871C709.987 193.533 710.059 193.167 710.049 192.798C710.04 192.43 709.95 192.068 709.785 191.738C709.621 191.408 709.385 191.117 709.096 190.888L710.689 185.349L707.547 183.563L705.407 191.417C705.052 191.927 704.897 192.549 704.972 193.165C705.046 193.781 705.345 194.349 705.812 194.76C706.278 195.171 706.88 195.398 707.503 195.396C708.126 195.395 708.727 195.166 709.192 194.753Z"
                    fill="#FFB8B8" />
                <path
                    d="M699.46 155.05L704.147 154.645C704.147 154.645 708.355 159.03 709.313 162.426C710.27 165.821 711.307 176.444 711.307 176.444L710.874 191.984L705.395 188.277L705.028 174.91L699.46 155.05Z"
                    fill="#2F2E41" />
                <path
                    d="M698.329 147.239C700.089 144.031 698.906 140.009 695.686 138.255C692.466 136.502 688.429 137.681 686.669 140.889C684.909 144.097 686.092 148.119 689.312 149.873C692.532 151.627 696.569 150.448 698.329 147.239Z"
                    fill="#FFB8B8" />
                <path
                    d="M691.758 141.3C690.887 141.1 689.982 141.322 689.099 141.466C688.216 141.61 687.243 141.658 686.496 141.167C685.944 140.805 685.605 140.205 685.287 139.628C685.154 139.422 685.065 139.191 685.026 138.949C684.989 138.522 685.261 138.133 685.551 137.816C686.894 136.345 688.858 135.54 690.838 135.284C692.47 135.041 694.139 135.244 695.665 135.871C697.168 136.528 698.46 137.731 699.051 139.256C699.323 140.037 699.493 140.85 699.557 141.674C699.646 142.28 699.657 142.895 699.591 143.504C699.511 143.956 699.392 144.4 699.235 144.831L698.256 147.776C698.185 148.054 698.054 148.313 697.871 148.535C697.777 148.643 697.65 148.719 697.509 148.749C697.369 148.78 697.222 148.764 697.091 148.705C697.17 148.385 697.181 148.053 697.126 147.728C697.096 147.566 697.017 147.417 696.901 147.3C696.784 147.184 696.636 147.104 696.473 147.072C696.113 147.034 695.804 147.313 695.462 147.433C695.306 147.479 695.141 147.494 694.979 147.477C694.816 147.46 694.659 147.411 694.515 147.334C694.372 147.256 694.245 147.151 694.142 147.024C694.039 146.898 693.962 146.753 693.916 146.597C693.906 146.565 693.898 146.533 693.892 146.501C693.837 146.164 693.928 145.804 693.8 145.488C693.65 145.117 693.252 144.923 692.953 144.657C692.68 144.406 692.485 144.083 692.39 143.726C692.296 143.368 692.305 142.991 692.418 142.639C692.498 142.393 692.724 142.282 692.679 142C692.62 141.631 692.073 141.373 691.758 141.3Z"
                    fill="#2F2E41" />
                <path d="M617.887 169.284H534V117H617.887V169.284Z" fill="white" />
                <path d="M617.887 169.284H534V117H617.887V169.284ZM534.383 168.903H617.504V117.382H534.383V168.903Z"
                    fill="#3F3D56" />
                <path d="M607.64 241.7H559.76V189.416H607.64V241.7Z" fill="white" />
                <path d="M607.64 241.7H559.76V189.416H607.64V241.7ZM560.143 241.319H607.257V189.798H560.143V241.319Z"
                    fill="#3F3D56" />
                <path d="M601.129 236.762H591.169V237.164H601.129V236.762Z" fill="#3F3D56" />
                <path d="M601.129 237.969H591.169V238.371H601.129V237.969Z" fill="#3F3D56" />
                <path d="M601.129 239.176H591.169V239.578H601.129V239.176Z" fill="#3F3D56" />
                <path
                    d="M583.7 198.766V202.964C586.2 202.964 588.644 203.703 590.723 205.087C592.801 206.47 594.421 208.437 595.378 210.739C596.335 213.04 596.585 215.572 596.098 218.015C595.61 220.458 594.406 222.702 592.638 224.464L595.617 227.432C597.975 225.084 599.58 222.092 600.23 218.834C600.88 215.577 600.547 212.2 599.271 209.132C597.995 206.064 595.835 203.441 593.063 201.596C590.292 199.751 587.033 198.766 583.7 198.766Z"
                    fill="#E6E6E6" />
                <path
                    d="M595.617 227.432L592.638 224.464C590.477 226.617 587.606 227.917 584.556 228.123C581.506 228.33 578.485 227.427 576.052 225.584L573.502 228.927C576.747 231.384 580.775 232.587 584.841 232.312C588.907 232.037 592.736 230.303 595.617 227.432Z"
                    fill="#575A89" />
                <path
                    d="M571.059 215.558C571.059 213.904 571.386 212.267 572.022 210.739C572.657 209.211 573.588 207.822 574.762 206.653C575.936 205.483 577.329 204.556 578.863 203.923C580.396 203.29 582.04 202.964 583.7 202.964V198.766C580.172 198.766 576.732 199.869 573.867 201.92C571.001 203.971 568.854 206.866 567.728 210.197C566.602 213.529 566.553 217.128 567.589 220.488C568.625 223.849 570.693 226.8 573.502 228.927L576.052 225.584C574.499 224.411 573.241 222.895 572.374 221.155C571.508 219.416 571.058 217.5 571.059 215.558Z"
                    fill="#00C066" />
                <path d="M678.503 209.261H630.623V156.977H678.503V209.261Z" fill="white" />
                <path d="M678.503 209.261H630.623V156.977H678.503V209.261ZM631.006 208.879H678.12V157.358H631.006V208.879Z"
                    fill="#3F3D56" />
                <path d="M646.136 188.939H637.518V202.678H646.136V188.939Z" fill="#575A89" />
                <path d="M658.585 179.589H649.967V202.678H658.585V179.589Z" fill="#E6E6E6" />
                <path d="M671.034 168.712H662.416V202.678H671.034V168.712Z" fill="#00C066" />
                <path d="M673.907 203.06H635.219V163.178H635.602V202.678H673.907V203.06Z" fill="#3F3D56" />
                <path
                    d="M664.58 158.369C666.036 158.369 667.217 157.192 667.217 155.74C667.217 154.289 666.036 153.112 664.58 153.112C663.123 153.112 661.942 154.289 661.942 155.74C661.942 157.192 663.123 158.369 664.58 158.369Z"
                    fill="#FFB8B8" />
                <path
                    d="M718.78 246H677.673C677.615 246 677.559 245.977 677.518 245.936C677.477 245.895 677.454 245.839 677.454 245.781C677.454 245.723 677.477 245.667 677.518 245.626C677.559 245.585 677.615 245.562 677.673 245.562H718.78C718.838 245.562 718.894 245.585 718.936 245.626C718.977 245.667 719 245.723 719 245.781C719 245.839 718.977 245.895 718.936 245.936C718.894 245.977 718.838 246 718.78 246Z"
                    fill="#CCCCCC" />
                <path
                    d="M606.237 158.35H545.65C545.6 158.35 545.551 158.33 545.516 158.295C545.48 158.259 545.46 158.211 545.46 158.161V129.228C545.46 129.178 545.48 129.13 545.516 129.095C545.551 129.059 545.6 129.039 545.65 129.039C545.7 129.039 545.748 129.059 545.784 129.095C545.819 129.13 545.839 129.178 545.839 129.228V157.972H606.237C606.262 157.972 606.286 157.977 606.31 157.986C606.333 157.996 606.354 158.01 606.371 158.027C606.389 158.045 606.403 158.066 606.413 158.089C606.422 158.111 606.427 158.136 606.427 158.161C606.427 158.186 606.422 158.21 606.413 158.233C606.403 158.256 606.389 158.277 606.371 158.295C606.354 158.312 606.333 158.326 606.31 158.336C606.286 158.345 606.262 158.35 606.237 158.35Z"
                    fill="#3F3D56" />
                <path
                    d="M558.595 156.272H553.084C552.935 156.272 552.792 156.213 552.686 156.107C552.581 156.002 552.521 155.86 552.521 155.711V148.143C552.521 147.994 552.581 147.851 552.686 147.746C552.792 147.641 552.935 147.582 553.084 147.582H558.595C558.744 147.582 558.887 147.641 558.993 147.746C559.098 147.851 559.157 147.994 559.158 148.143V155.711C559.157 155.86 559.098 156.002 558.993 156.107C558.887 156.213 558.744 156.272 558.595 156.272Z"
                    fill="#00C066" />
                <path
                    d="M568.644 156.272H563.133C562.984 156.272 562.841 156.213 562.736 156.107C562.63 156.002 562.571 155.86 562.571 155.711V140.964C562.571 140.815 562.63 140.673 562.736 140.567C562.841 140.462 562.984 140.403 563.133 140.403H568.644C568.793 140.403 568.936 140.462 569.042 140.567C569.147 140.673 569.207 140.815 569.207 140.964V155.711C569.207 155.86 569.147 156.002 569.042 156.107C568.936 156.213 568.793 156.272 568.644 156.272Z"
                    fill="#00C066" />
                <path
                    d="M578.693 156.272H573.183C573.034 156.272 572.89 156.213 572.785 156.107C572.679 156.002 572.62 155.86 572.62 155.711V148.143C572.62 147.994 572.679 147.851 572.785 147.746C572.89 147.641 573.034 147.582 573.183 147.582H578.693C578.843 147.582 578.986 147.641 579.091 147.746C579.197 147.851 579.256 147.994 579.256 148.143V155.711C579.256 155.86 579.197 156.002 579.091 156.107C578.986 156.213 578.843 156.272 578.693 156.272Z"
                    fill="#00C066" />
                <path
                    d="M588.742 156.272H583.232C583.086 156.275 582.945 156.22 582.839 156.12C582.734 156.02 582.673 155.882 582.669 155.736V138.105C582.673 137.959 582.734 137.821 582.839 137.721C582.945 137.621 583.086 137.566 583.232 137.569H588.742C588.888 137.566 589.029 137.621 589.135 137.721C589.24 137.821 589.302 137.959 589.305 138.105V155.736C589.302 155.882 589.24 156.02 589.135 156.12C589.029 156.22 588.888 156.275 588.742 156.272Z"
                    fill="#00C066" />
                <path
                    d="M598.792 156.272H593.281C593.132 156.271 592.989 156.212 592.883 156.107C592.778 156.002 592.718 155.86 592.718 155.711V133.029C592.718 132.881 592.778 132.738 592.883 132.633C592.989 132.528 593.132 132.469 593.281 132.469H598.792C598.941 132.469 599.084 132.528 599.19 132.633C599.295 132.738 599.354 132.881 599.355 133.029V155.711C599.354 155.86 599.295 156.002 599.19 156.107C599.084 156.212 598.941 156.271 598.792 156.272Z"
                    fill="#00C066" />
                <path
                    d="M555.839 145.315C556.468 145.315 556.977 144.807 556.977 144.181C556.977 143.555 556.468 143.048 555.839 143.048C555.211 143.048 554.702 143.555 554.702 144.181C554.702 144.807 555.211 145.315 555.839 145.315Z"
                    fill="#3F3D56" />
                <path
                    d="M565.889 137.947C566.517 137.947 567.026 137.44 567.026 136.814C567.026 136.188 566.517 135.68 565.889 135.68C565.26 135.68 564.751 136.188 564.751 136.814C564.751 137.44 565.26 137.947 565.889 137.947Z"
                    fill="#3F3D56" />
                <path
                    d="M575.938 145.315C576.566 145.315 577.076 144.807 577.076 144.181C577.076 143.555 576.566 143.048 575.938 143.048C575.31 143.048 574.8 143.555 574.8 144.181C574.8 144.807 575.31 145.315 575.938 145.315Z"
                    fill="#3F3D56" />
                <path
                    d="M585.987 134.358C586.616 134.358 587.125 133.85 587.125 133.224C587.125 132.598 586.616 132.091 585.987 132.091C585.359 132.091 584.85 132.598 584.85 133.224C584.85 133.85 585.359 134.358 585.987 134.358Z"
                    fill="#3F3D56" />
                <path
                    d="M596.037 130.202C596.665 130.202 597.174 129.694 597.174 129.068C597.174 128.442 596.665 127.935 596.037 127.935C595.408 127.935 594.899 128.442 594.899 129.068C594.899 129.694 595.408 130.202 596.037 130.202Z"
                    fill="#3F3D56" />
                <path
                    d="M575.962 144.435L565.889 136.918L555.953 144.332L555.726 144.03L565.889 136.446L575.914 143.927L585.876 133.065L585.916 133.049L595.966 129.015L596.107 129.365L586.098 133.383L575.962 144.435Z"
                    fill="#3F3D56" />
            </g>
            <g clip-path="url(#clip2_28_850)">
                <path
                    d="M324.041 242.677C325.844 246.159 329.671 247.654 329.671 247.654C329.671 247.654 330.574 243.503 328.771 240.021C326.968 236.539 323.141 235.044 323.141 235.044C323.141 235.044 322.237 239.195 324.041 242.677Z"
                    fill="#2F2E41" />
                <path
                    d="M325.28 241.531C328.536 243.571 329.789 247.622 329.789 247.622C329.789 247.622 325.765 248.366 322.509 246.327C319.254 244.287 318 240.236 318 240.236C318 240.236 322.025 239.492 325.28 241.531Z"
                    fill="#00C066" />
                <path d="M398.271 140.425H377.958V140.727H398.271V140.425Z" fill="#F2F2F2" />
                <path d="M392.757 140.651H392.467V143.446H392.757V140.651Z" fill="#F2F2F2" />
                <path d="M383.907 140.651H383.616V143.446H383.907V140.651Z" fill="#F2F2F2" />
                <path d="M408.572 154.928H388.259V155.23H408.572V154.928Z" fill="#F2F2F2" />
                <path d="M394.063 152.209H393.773V155.004H394.063V152.209Z" fill="#F2F2F2" />
                <path d="M402.913 152.209H402.623V155.004H402.913V152.209Z" fill="#F2F2F2" />
                <path d="M435.558 161.726H415.246V162.028H435.558V161.726Z" fill="#F2F2F2" />
                <path d="M421.049 159.007H420.759V161.802H421.049V159.007Z" fill="#F2F2F2" />
                <path d="M429.9 159.007H429.61V161.802H429.9V159.007Z" fill="#F2F2F2" />
                <path d="M433.527 231.825H413.215V232.128H433.527V231.825Z" fill="#F2F2F2" />
                <path d="M419.018 229.106H418.728V231.901H419.018V229.106Z" fill="#F2F2F2" />
                <path d="M427.869 229.106H427.578V231.901H427.869V229.106Z" fill="#F2F2F2" />
                <path d="M398.851 183.33H378.538V183.632H398.851V183.33Z" fill="#F2F2F2" />
                <path d="M384.342 180.611H384.052V183.406H384.342V180.611Z" fill="#F2F2F2" />
                <path d="M393.192 180.611H392.902V183.406H393.192V180.611Z" fill="#F2F2F2" />
                <path d="M405.235 219.739H384.922V220.041H405.235V219.739Z" fill="#F2F2F2" />
                <path d="M390.726 217.02H390.436V219.815H390.726V217.02Z" fill="#F2F2F2" />
                <path d="M399.576 217.02H399.286V219.815H399.576V217.02Z" fill="#F2F2F2" />
                <path d="M437.735 208.711H417.422V209.013H437.735V208.711Z" fill="#F2F2F2" />
                <path d="M423.226 205.991H422.936V208.786H423.226V205.991Z" fill="#F2F2F2" />
                <path d="M432.076 205.991H431.786V208.786H432.076V205.991Z" fill="#F2F2F2" />
                <path
                    d="M370.531 241.083H336.176V240.825H370.284V228.343H339.064L337.548 225.053L337.77 224.942L339.22 228.086H370.531V241.083Z"
                    fill="#2F2E41" />
                <path
                    d="M340.748 247.388C342.182 247.388 343.343 246.178 343.343 244.686C343.343 243.193 342.182 241.983 340.748 241.983C339.315 241.983 338.153 243.193 338.153 244.686C338.153 246.178 339.315 247.388 340.748 247.388Z"
                    fill="#3F3D56" />
                <path
                    d="M366.329 247.388C367.763 247.388 368.924 246.178 368.924 244.686C368.924 243.193 367.763 241.983 366.329 241.983C364.896 241.983 363.734 243.193 363.734 244.686C363.734 246.178 364.896 247.388 366.329 247.388Z"
                    fill="#3F3D56" />
                <path
                    d="M396.483 188.968C397.37 188.968 398.089 188.219 398.089 187.295C398.089 186.371 397.37 185.622 396.483 185.622C395.595 185.622 394.876 186.371 394.876 187.295C394.876 188.219 395.595 188.968 396.483 188.968Z"
                    fill="#3F3D56" />
                <path
                    d="M374.205 224.097H335.59L327.235 195.659H382.81L382.76 195.826L374.205 224.097ZM335.773 223.84H374.024L382.473 195.917H327.569L335.773 223.84Z"
                    fill="#2F2E41" />
                <path d="M371.191 222.617H337.274L329.935 197.396H378.749L378.705 197.545L371.191 222.617Z"
                    fill="#F2F2F2" />
                <path d="M383.503 193.119L383.264 193.053L384.895 186.652H394.382V186.909H385.085L383.503 193.119Z"
                    fill="#2F2E41" />
                <path d="M380.033 204.281H329.935V204.538H380.033V204.281Z" fill="#2F2E41" />
                <path d="M377.164 213.762H332.721V214.02H377.164V213.762Z" fill="#2F2E41" />
                <path d="M355.145 195.788H354.898V223.968H355.145V195.788Z" fill="#2F2E41" />
                <path d="M366.211 195.78L364.437 223.96L364.684 223.977L366.458 195.797L366.211 195.78Z" fill="#2F2E41" />
                <path d="M343.837 195.78L343.591 195.796L345.355 223.977L345.601 223.96L343.837 195.78Z" fill="#2F2E41" />
                <path d="M448 247.551H318V247.853H448V247.551Z" fill="#2F2E41" />
                <path
                    d="M404.388 144.348C404.388 144.348 406.509 150.634 405.203 151.601C403.898 152.568 409.609 160.465 409.609 160.465L416.461 158.531L412.708 151.923C412.708 151.923 412.219 145.315 412.219 144.348C412.219 143.381 404.388 144.348 404.388 144.348Z"
                    fill="#A0616A" />
                <path opacity="0.1"
                    d="M404.388 144.348C404.388 144.348 406.509 150.634 405.203 151.601C403.898 152.568 409.609 160.465 409.609 160.465L416.461 158.531L412.708 151.923C412.708 151.923 412.219 145.315 412.219 144.348C412.219 143.381 404.388 144.348 404.388 144.348Z"
                    fill="black" />
                <path
                    d="M400.828 189.154C400.828 189.154 400.209 197.212 400.828 201.403C401.447 205.593 402.376 217.197 402.376 217.197C402.376 217.197 402.376 239.117 405.781 239.439C409.186 239.761 411.663 240.084 411.972 238.794C412.282 237.505 410.424 236.86 411.353 236.216C412.282 235.571 412.591 233.314 411.353 230.736C410.115 228.157 411.353 202.047 411.353 202.047L417.235 218.487C417.235 218.487 417.854 232.025 418.473 233.959C419.092 235.893 417.854 239.439 420.021 239.761C422.188 240.084 424.665 238.15 425.903 237.505C427.141 236.86 424.045 236.86 424.665 236.538C425.284 236.216 427.141 235.248 426.522 234.926C425.903 234.604 425.284 219.131 425.284 219.131C425.284 219.131 423.581 186.091 421.414 184.802C419.247 183.513 417.854 185.733 417.854 185.733L400.828 189.154Z"
                    fill="#2F2E41" />
                <path
                    d="M406.4 238.15V240.728C406.4 240.728 403.614 247.738 406.4 247.738C409.186 247.738 411.353 248.465 411.353 247.498V238.794L406.4 238.15Z"
                    fill="#2F2E41" />
                <path
                    d="M424.665 238.145V240.724C424.665 240.724 427.451 247.734 424.665 247.734C421.878 247.734 419.711 248.46 419.711 247.493V238.79L424.665 238.145Z"
                    fill="#2F2E41" />
                <path
                    d="M408.722 149.022C411.799 149.022 414.294 146.424 414.294 143.22C414.294 140.015 411.799 137.417 408.722 137.417C405.644 137.417 403.149 140.015 403.149 143.22C403.149 146.424 405.644 149.022 408.722 149.022Z"
                    fill="#A0616A" />
                <path
                    d="M407.019 154.018C407.019 154.018 408.567 158.853 411.043 157.886L413.52 156.919L417.854 187.864C417.854 187.864 414.449 193.022 409.496 189.798C404.542 186.575 407.019 154.018 407.019 154.018Z"
                    fill="#00C066" />
                <path
                    d="M411.353 153.051L412.746 149.989C412.746 149.989 420.95 154.018 422.188 155.308C423.426 156.597 423.426 158.531 423.426 158.531L421.259 166.59C421.259 166.59 421.878 184.318 421.878 184.963C421.878 185.608 424.045 189.154 422.498 187.864C420.95 186.575 420.64 185.286 419.402 187.22C418.164 189.154 415.377 191.41 415.377 191.41L411.353 153.051Z"
                    fill="#3F3D56" />
                <path
                    d="M422.188 176.26L421.259 185.285C421.259 185.285 415.687 190.443 416.925 190.765C418.164 191.088 418.783 189.798 418.783 189.798C418.783 189.798 420.95 192.055 422.188 190.765C423.426 189.476 426.522 177.227 426.522 177.227L422.188 176.26Z"
                    fill="#A0616A" />
                <path
                    d="M408.84 135.02C407.605 134.974 406.283 134.951 405.242 135.644C404.762 135.992 404.342 136.42 403.998 136.912C402.984 138.247 402.107 139.927 402.484 141.584L402.921 141.406C402.921 141.848 402.827 142.285 402.645 142.685C402.707 142.498 402.913 142.8 402.858 142.988L402.376 144.635C403.168 144.333 404.154 144.945 404.275 145.815C404.33 143.902 404.52 141.709 406.011 140.589C406.762 140.024 407.713 139.852 408.628 139.699C409.472 139.557 410.357 139.423 411.166 139.712C411.974 140.001 412.663 140.862 412.48 141.732C412.853 141.598 413.27 141.869 413.454 142.232C413.638 142.595 413.648 143.023 413.653 143.434C414.051 143.726 414.503 143.145 414.665 142.668C415.045 141.546 415.383 140.352 415.178 139.182C414.973 138.012 414.058 136.893 412.915 136.889C413.054 136.731 413.128 136.522 413.122 136.308L412.18 136.225C412.419 136.19 412.639 136.069 412.802 135.884C412.424 136.317 409.452 135.042 408.84 135.02Z"
                    fill="#2F2E41" />
                <path
                    d="M408.567 152.084C408.567 152.084 406.047 149.513 405.14 149.67C404.233 149.828 402.995 152.084 402.995 152.084C402.995 152.084 395.565 154.663 395.874 157.242C396.184 159.82 399.589 172.392 399.589 172.392C399.589 172.392 402.375 187.542 399.899 189.154C397.422 190.765 411.662 194.956 411.972 193.022C412.282 191.088 412.901 171.747 411.972 168.846C411.043 165.945 408.567 152.084 408.567 152.084Z"
                    fill="#3F3D56" />
                <path
                    d="M419.402 157.242H423.23C423.23 157.242 425.903 169.491 426.212 170.78C426.522 172.069 427.141 178.194 426.832 178.194C426.522 178.194 420.331 176.905 420.331 177.872L419.402 157.242Z"
                    fill="#3F3D56" />
                <path
                    d="M419.272 187.574H404.618C403.188 180.725 403.069 174.106 404.618 167.783H419.272C416.907 173.993 416.76 180.565 419.272 187.574Z"
                    fill="#F2F2F2" />
                <path
                    d="M398.661 179.161L402.995 181.095C402.995 181.095 411.353 182.384 411.353 178.839C411.353 175.293 402.995 177.227 402.995 177.227L400.208 176.299L398.661 179.161Z"
                    fill="#A0616A" />
                <path
                    d="M399.589 155.308L395.874 156.275L393.088 173.359C393.088 173.359 392.16 177.872 393.707 178.194C395.255 178.516 399.589 181.095 399.589 181.095C399.589 181.095 400.208 176.26 401.447 176.26L398.351 173.681L400.208 162.399L399.589 155.308Z"
                    fill="#3F3D56" />
                <path d="M347.054 188.316H326.741V188.618H347.054V188.316Z" fill="#F2F2F2" />
                <path d="M332.545 185.596H332.255V188.391H332.545V185.596Z" fill="#F2F2F2" />
                <path d="M341.395 185.596H341.105V188.391H341.395V185.596Z" fill="#F2F2F2" />
                <path d="M354.163 143.597H333.851V143.9H354.163V143.597Z" fill="#F2F2F2" />
                <path d="M348.65 143.824H348.36V146.619H348.65V143.824Z" fill="#F2F2F2" />
                <path d="M339.799 143.824H339.509V146.619H339.799V143.824Z" fill="#F2F2F2" />
                <path d="M374.621 173.359H354.308V173.661H374.621V173.359Z" fill="#F2F2F2" />
                <path d="M369.108 173.586H368.817V176.381H369.108V173.586Z" fill="#F2F2F2" />
                <path d="M360.257 173.586H359.967V176.381H360.257V173.586Z" fill="#F2F2F2" />
                <path d="M340.09 173.208H319.777V173.51H340.09V173.208Z" fill="#F2F2F2" />
                <path d="M334.576 173.435H334.286V176.23H334.576V173.435Z" fill="#F2F2F2" />
                <path d="M325.726 173.435H325.436V176.23H325.726V173.435Z" fill="#F2F2F2" />
                <path d="M364.465 158.101H344.152V158.403H364.465V158.101Z" fill="#F2F2F2" />
                <path d="M349.956 155.381H349.666V158.176H349.956V155.381Z" fill="#F2F2F2" />
                <path d="M358.806 155.381H358.516V158.176H358.806V155.381Z" fill="#F2F2F2" />
            </g>
            <g opacity="0.2" clip-path="url(#clip3_28_850)">
                <path
                    d="M478.968 183.002H478.528V170.333C478.528 169.37 478.347 168.416 477.996 167.527C477.645 166.637 477.131 165.829 476.483 165.148C475.834 164.467 475.064 163.927 474.217 163.558C473.37 163.19 472.462 163 471.545 163H445.983C445.066 163 444.158 163.19 443.311 163.558C442.464 163.927 441.694 164.467 441.045 165.148C440.397 165.829 439.882 166.637 439.532 167.527C439.181 168.416 439 169.37 439 170.333V239.837C439 240.8 439.181 241.753 439.532 242.643C439.882 243.533 440.397 244.341 441.045 245.022C441.694 245.703 442.464 246.243 443.311 246.611C444.158 246.98 445.066 247.17 445.983 247.17H471.545C472.462 247.17 473.37 246.98 474.217 246.611C475.064 246.243 475.834 245.703 476.483 245.022C477.131 244.341 477.645 243.533 477.996 242.643C478.347 241.753 478.528 240.8 478.528 239.837V192.02H478.968V183.002Z"
                    fill="#E6E6E6" />
                <path
                    d="M471.827 164.908H468.49C468.643 165.303 468.702 165.731 468.66 166.156C468.619 166.58 468.479 166.987 468.252 167.341C468.026 167.695 467.719 167.986 467.361 168.186C467.002 168.387 466.602 168.492 466.196 168.492H451.552C451.146 168.492 450.746 168.387 450.387 168.186C450.029 167.986 449.722 167.695 449.496 167.341C449.269 166.987 449.129 166.58 449.088 166.156C449.046 165.731 449.105 165.303 449.258 164.908H446.142C445.457 164.908 444.779 165.049 444.146 165.325C443.513 165.6 442.938 166.003 442.454 166.512C441.97 167.02 441.586 167.624 441.324 168.288C441.062 168.952 440.927 169.665 440.927 170.384V239.786C440.927 240.505 441.062 241.217 441.324 241.882C441.586 242.546 441.97 243.15 442.454 243.658C442.938 244.167 443.513 244.57 444.146 244.845C444.779 245.12 445.457 245.262 446.142 245.262H471.827C472.511 245.262 473.19 245.12 473.822 244.845C474.455 244.57 475.03 244.167 475.514 243.658C475.998 243.15 476.382 242.546 476.644 241.882C476.907 241.217 477.041 240.505 477.041 239.786V170.384C477.041 169.665 476.907 168.952 476.644 168.288C476.382 167.624 475.998 167.02 475.514 166.512C475.03 166.003 474.455 165.6 473.822 165.325C473.19 165.049 472.511 164.908 471.827 164.908Z"
                    fill="white" />
                <path
                    d="M451.417 179.016H449.883C449.829 179.016 449.778 179.039 449.739 179.079C449.701 179.119 449.68 179.173 449.68 179.23V179.937C449.68 179.993 449.701 180.048 449.739 180.088C449.778 180.128 449.829 180.15 449.883 180.15H450.137V181.209H451.163V180.15H451.417C451.471 180.15 451.522 180.128 451.561 180.088C451.599 180.048 451.62 179.993 451.62 179.937V179.23C451.62 179.173 451.599 179.119 451.561 179.079C451.522 179.039 451.471 179.016 451.417 179.016Z"
                    fill="#E6E6E6" />
                <path
                    d="M452.953 185.485C452.014 184.042 451.534 182.324 451.581 180.577C451.582 180.537 451.57 180.497 451.546 180.465C451.522 180.434 451.489 180.411 451.452 180.403V180.097H449.832V180.398H449.81C449.765 180.398 449.723 180.417 449.692 180.45C449.661 180.482 449.644 180.527 449.644 180.573C449.644 180.577 449.644 180.582 449.644 180.586C449.772 182.454 449.341 184.128 448.351 185.611C448.294 185.696 448.265 185.798 448.269 185.902L448.446 191.655C448.45 191.783 448.501 191.904 448.589 191.994C448.676 192.084 448.794 192.134 448.916 192.135H452.579C452.703 192.134 452.821 192.082 452.909 191.991C452.997 191.9 453.047 191.776 453.05 191.646L453.118 186.061C453.12 185.856 453.062 185.655 452.953 185.485Z"
                    fill="#E6E6E6" />
                <path
                    d="M452.373 187.396H449.184C449.137 187.396 449.09 187.407 449.048 187.427C449.005 187.448 448.967 187.478 448.936 187.516C448.905 187.554 448.882 187.598 448.87 187.645C448.857 187.693 448.854 187.743 448.861 187.792L449.343 191.081H452.11L452.695 187.803C452.704 187.753 452.702 187.702 452.69 187.653C452.678 187.605 452.656 187.559 452.625 187.52C452.594 187.481 452.556 187.45 452.512 187.429C452.469 187.407 452.421 187.396 452.373 187.396Z"
                    fill="white" />
                <path
                    d="M468.489 196.249H466.955C466.901 196.249 466.849 196.271 466.811 196.311C466.773 196.351 466.752 196.406 466.752 196.462V197.169C466.752 197.226 466.773 197.28 466.811 197.32C466.849 197.36 466.901 197.383 466.955 197.383H467.209V198.442H468.234V197.383H468.489C468.543 197.383 468.594 197.36 468.632 197.32C468.67 197.28 468.692 197.226 468.692 197.169V196.462C468.692 196.406 468.67 196.351 468.632 196.311C468.594 196.271 468.543 196.249 468.489 196.249Z"
                    fill="#E6E6E6" />
                <path
                    d="M470.024 202.718C469.085 201.274 468.605 199.556 468.653 197.809C468.654 197.769 468.641 197.729 468.618 197.698C468.594 197.666 468.561 197.644 468.523 197.635V197.329H466.903V197.631H466.881C466.859 197.631 466.838 197.635 466.818 197.644C466.797 197.653 466.779 197.666 466.764 197.682C466.748 197.698 466.736 197.717 466.728 197.738C466.719 197.76 466.715 197.782 466.715 197.805C466.715 197.809 466.715 197.814 466.716 197.818C466.843 199.686 466.412 201.361 465.423 202.843C465.366 202.928 465.337 203.03 465.34 203.134L465.517 208.887C465.521 209.015 465.573 209.137 465.66 209.226C465.748 209.316 465.865 209.366 465.987 209.367H469.651C469.774 209.366 469.893 209.315 469.981 209.223C470.069 209.132 470.119 209.008 470.121 208.878L470.189 203.293C470.191 203.088 470.134 202.887 470.024 202.718Z"
                    fill="#E6E6E6" />
                <path
                    d="M469.445 204.628H466.256C466.209 204.628 466.162 204.639 466.119 204.66C466.076 204.681 466.038 204.711 466.007 204.748C465.977 204.786 465.954 204.83 465.941 204.878C465.928 204.925 465.925 204.975 465.932 205.024L466.414 208.313H469.181L469.766 205.036C469.775 204.986 469.774 204.935 469.761 204.886C469.749 204.837 469.727 204.792 469.696 204.753C469.666 204.714 469.627 204.682 469.584 204.661C469.54 204.64 469.493 204.628 469.445 204.628H469.445Z"
                    fill="white" />
                <path
                    d="M449.261 220.61H448.533C448.508 220.61 448.483 220.621 448.465 220.64C448.447 220.659 448.437 220.685 448.437 220.711V221.047C448.437 221.074 448.447 221.099 448.465 221.118C448.483 221.137 448.508 221.148 448.533 221.148H448.654V221.65H449.14V221.148H449.261C449.286 221.148 449.311 221.137 449.329 221.118C449.347 221.099 449.357 221.074 449.357 221.047V220.711C449.357 220.685 449.347 220.659 449.329 220.64C449.311 220.621 449.286 220.61 449.261 220.61Z"
                    fill="#E6E6E6" />
                <path
                    d="M449.989 223.678C449.544 222.994 449.316 222.179 449.339 221.35C449.339 221.331 449.333 221.312 449.322 221.297C449.311 221.282 449.295 221.272 449.277 221.267V221.123H448.509V221.265H448.498C448.488 221.265 448.478 221.268 448.468 221.272C448.459 221.276 448.45 221.282 448.443 221.29C448.435 221.297 448.43 221.307 448.426 221.317C448.422 221.327 448.42 221.337 448.42 221.348C448.42 221.35 448.42 221.352 448.42 221.354C448.491 222.2 448.274 223.045 447.807 223.738C447.78 223.778 447.766 223.827 447.767 223.876L447.851 226.605C447.853 226.666 447.878 226.723 447.919 226.766C447.961 226.808 448.016 226.832 448.074 226.833H449.812C449.871 226.832 449.927 226.808 449.969 226.764C450.01 226.721 450.034 226.662 450.035 226.601L450.068 223.951C450.069 223.854 450.041 223.759 449.989 223.678Z"
                    fill="#E6E6E6" />
                <path d="M449.739 224.682H448.081V225.552H449.739V224.682Z" fill="white" />
                <path
                    d="M452.647 220.61H451.92C451.894 220.61 451.87 220.621 451.851 220.64C451.833 220.659 451.823 220.685 451.823 220.711V221.047C451.823 221.074 451.833 221.099 451.851 221.118C451.87 221.137 451.894 221.148 451.92 221.148H452.04V221.65H452.527V221.148H452.647C452.673 221.148 452.697 221.137 452.715 221.118C452.733 221.099 452.744 221.074 452.744 221.047V220.711C452.744 220.685 452.733 220.659 452.715 220.64C452.697 220.621 452.673 220.61 452.647 220.61Z"
                    fill="#E6E6E6" />
                <path
                    d="M453.376 223.678C452.93 222.994 452.702 222.179 452.725 221.35C452.725 221.331 452.72 221.312 452.708 221.297C452.697 221.282 452.681 221.272 452.664 221.267V221.123H451.895V221.265H451.885C451.874 221.265 451.864 221.268 451.854 221.272C451.845 221.276 451.836 221.282 451.829 221.29C451.822 221.297 451.816 221.307 451.812 221.317C451.808 221.327 451.806 221.337 451.806 221.348C451.806 221.35 451.806 221.352 451.806 221.354C451.877 222.2 451.66 223.045 451.193 223.738C451.166 223.778 451.152 223.827 451.154 223.876L451.238 226.605C451.24 226.666 451.264 226.723 451.306 226.766C451.347 226.808 451.403 226.832 451.461 226.833H453.198C453.257 226.832 453.313 226.808 453.355 226.764C453.397 226.721 453.421 226.662 453.422 226.601L453.454 223.951C453.455 223.854 453.428 223.759 453.376 223.678Z"
                    fill="#E6E6E6" />
                <path d="M453.126 224.682H451.468V225.552H453.126V224.682Z" fill="white" />
                <path
                    d="M456.033 220.61H455.306C455.28 220.61 455.256 220.621 455.238 220.64C455.22 220.659 455.209 220.685 455.209 220.711V221.047C455.209 221.074 455.22 221.099 455.238 221.118C455.256 221.137 455.28 221.148 455.306 221.148H455.426V221.65H455.913V221.148H456.033C456.059 221.148 456.083 221.137 456.102 221.118C456.12 221.099 456.13 221.074 456.13 221.047V220.711C456.13 220.685 456.12 220.659 456.102 220.64C456.083 220.621 456.059 220.61 456.033 220.61Z"
                    fill="#E6E6E6" />
                <path
                    d="M456.762 223.678C456.316 222.994 456.089 222.179 456.111 221.35C456.112 221.331 456.106 221.312 456.095 221.297C456.083 221.282 456.068 221.272 456.05 221.267V221.123H455.281V221.265H455.271C455.261 221.265 455.25 221.268 455.241 221.272C455.231 221.276 455.222 221.282 455.215 221.29C455.208 221.297 455.202 221.307 455.198 221.317C455.194 221.327 455.192 221.337 455.192 221.348C455.192 221.35 455.192 221.352 455.192 221.354C455.263 222.2 455.046 223.045 454.579 223.738C454.552 223.778 454.538 223.827 454.54 223.876L454.624 226.605C454.626 226.666 454.65 226.723 454.692 226.766C454.733 226.808 454.789 226.832 454.847 226.833H456.585C456.643 226.832 456.699 226.808 456.741 226.764C456.783 226.721 456.807 226.662 456.808 226.601L456.84 223.951C456.841 223.854 456.814 223.759 456.762 223.678Z"
                    fill="#E6E6E6" />
                <path d="M456.512 224.682H454.854V225.552H456.512V224.682Z" fill="white" />
                <path
                    d="M465.824 213.944H464.291C464.264 213.944 464.238 213.949 464.213 213.96C464.188 213.971 464.166 213.986 464.147 214.006C464.128 214.026 464.113 214.049 464.103 214.075C464.093 214.101 464.087 214.129 464.087 214.157V214.864C464.087 214.921 464.109 214.975 464.147 215.015C464.185 215.055 464.237 215.077 464.291 215.077H464.545V216.136H465.57V215.077H465.824C465.878 215.077 465.93 215.055 465.968 215.015C466.006 214.975 466.028 214.921 466.028 214.864V214.157C466.028 214.129 466.022 214.101 466.012 214.075C466.002 214.049 465.987 214.026 465.968 214.006C465.949 213.986 465.927 213.971 465.902 213.96C465.877 213.949 465.851 213.944 465.824 213.944Z"
                    fill="#E6E6E6" />
                <path
                    d="M467.36 220.412C466.421 218.969 465.941 217.251 465.989 215.504C465.99 215.464 465.977 215.424 465.954 215.392C465.93 215.361 465.896 215.338 465.859 215.33V215.024H464.239V215.325H464.217C464.195 215.325 464.174 215.33 464.153 215.339C464.133 215.348 464.115 215.36 464.1 215.377C464.084 215.393 464.072 215.412 464.064 215.433C464.055 215.454 464.051 215.477 464.051 215.5C464.051 215.504 464.051 215.509 464.052 215.513C464.179 217.381 463.748 219.055 462.759 220.538C462.702 220.623 462.673 220.725 462.676 220.829L462.853 226.582C462.857 226.71 462.909 226.831 462.996 226.921C463.084 227.011 463.201 227.061 463.323 227.062H466.987C467.11 227.061 467.229 227.009 467.317 226.918C467.404 226.827 467.455 226.703 467.457 226.573L467.525 220.988C467.527 220.783 467.47 220.582 467.36 220.412Z"
                    fill="#E6E6E6" />
                <path
                    d="M466.781 222.323H463.592C463.545 222.323 463.498 222.334 463.455 222.355C463.412 222.375 463.374 222.406 463.343 222.443C463.313 222.481 463.29 222.525 463.277 222.573C463.264 222.62 463.261 222.67 463.268 222.719L463.75 226.008H466.517L467.102 222.73C467.111 222.681 467.109 222.63 467.097 222.581C467.085 222.532 467.063 222.486 467.032 222.447C467.002 222.409 466.963 222.377 466.92 222.356C466.876 222.334 466.829 222.323 466.781 222.323Z"
                    fill="white" />
                <path
                    d="M466.662 192.876H457.52C458.159 189.247 458.012 184.866 457.52 180.154H466.662C466.183 184.866 466.039 189.247 466.662 192.876Z"
                    fill="#E6E6E6" />
                <path
                    d="M462.146 188.481C463.362 188.481 464.349 187.445 464.349 186.168C464.349 184.89 463.362 183.855 462.146 183.855C460.929 183.855 459.943 184.89 459.943 186.168C459.943 187.445 460.929 188.481 462.146 188.481Z"
                    fill="white" />
                <path
                    d="M458.291 209.761H449.149C449.789 206.132 449.641 201.751 449.149 197.039H458.291C457.812 201.751 457.669 206.132 458.291 209.761Z"
                    fill="#E6E6E6" />
                <path
                    d="M453.775 205.366C454.992 205.366 455.978 204.331 455.978 203.053C455.978 201.776 454.992 200.74 453.775 200.74C452.559 200.74 451.573 201.776 451.573 203.053C451.573 204.331 452.559 205.366 453.775 205.366Z"
                    fill="white" />
                <path
                    d="M471.838 193.685H462.697C463.336 190.057 463.189 185.675 462.697 180.963H471.838C471.359 185.675 471.216 190.057 471.838 193.685Z"
                    fill="#E6E6E6" />
                <path
                    d="M467.322 189.29C468.539 189.29 469.525 188.255 469.525 186.977C469.525 185.7 468.539 184.664 467.322 184.664C466.106 184.664 465.12 185.7 465.12 186.977C465.12 188.255 466.106 189.29 467.322 189.29Z"
                    fill="white" />
                <path
                    d="M471.838 193.107H462.697C463.336 189.479 463.189 185.097 462.697 180.385H471.838C471.359 185.097 471.216 189.479 471.838 193.107Z"
                    fill="#E6E6E6" />
                <path
                    d="M467.322 188.712C468.539 188.712 469.525 187.676 469.525 186.399C469.525 185.122 468.539 184.086 467.322 184.086C466.106 184.086 465.12 185.122 465.12 186.399C465.12 187.676 466.106 188.712 467.322 188.712Z"
                    fill="white" />
                <path
                    d="M471.838 193.685H462.697C463.336 190.057 463.189 185.675 462.697 180.963H471.838C471.359 185.675 471.216 190.057 471.838 193.685Z"
                    fill="#E6E6E6" />
                <path
                    d="M467.322 189.29C468.539 189.29 469.525 188.255 469.525 186.977C469.525 185.7 468.539 184.664 467.322 184.664C466.106 184.664 465.12 185.7 465.12 186.977C465.12 188.255 466.106 189.29 467.322 189.29Z"
                    fill="white" />
                <path d="M473.931 192.182H443.973V195.651H473.931V192.182Z" fill="#E6E6E6" />
                <path d="M473.931 209.414H443.973V212.884H473.931V209.414Z" fill="#E6E6E6" />
                <path d="M473.931 226.646H443.973V230.116H473.931V226.646Z" fill="#E6E6E6" />
                <path
                    d="M526.044 240.722L518.58 235.179C521.097 232.604 523.387 228.938 525.576 224.793L533.04 230.336C530.057 233.892 527.531 237.383 526.044 240.722Z"
                    fill="#00C066" />
                <path
                    d="M526.046 234.821C527.262 234.821 528.249 233.785 528.249 232.508C528.249 231.23 527.262 230.195 526.046 230.195C524.829 230.195 523.843 231.23 523.843 232.508C523.843 233.785 524.829 234.821 526.046 234.821Z"
                    fill="white" />
                <path
                    d="M490.041 215.428H489.222C489.193 215.428 489.165 215.44 489.145 215.461C489.125 215.483 489.113 215.512 489.113 215.542V215.92C489.113 215.935 489.116 215.949 489.122 215.963C489.127 215.977 489.135 215.99 489.145 216C489.155 216.011 489.167 216.019 489.18 216.025C489.194 216.031 489.208 216.034 489.222 216.034H489.358V216.599H489.905V216.034H490.041C490.07 216.034 490.098 216.022 490.118 216C490.138 215.979 490.15 215.95 490.15 215.92V215.542C490.15 215.512 490.138 215.483 490.118 215.461C490.098 215.44 490.07 215.428 490.041 215.428Z"
                    fill="#E6E6E6" />
                <path
                    d="M490.862 218.884C490.36 218.113 490.104 217.195 490.129 216.262C490.129 216.24 490.123 216.219 490.11 216.202C490.098 216.185 490.08 216.173 490.06 216.169V216.005H489.194V216.166H489.182C489.171 216.166 489.159 216.169 489.149 216.173C489.138 216.178 489.128 216.185 489.12 216.194C489.112 216.202 489.105 216.213 489.101 216.224C489.096 216.235 489.094 216.247 489.094 216.26C489.094 216.262 489.094 216.264 489.094 216.266C489.174 217.219 488.929 218.17 488.404 218.951C488.373 218.996 488.358 219.051 488.359 219.106L488.454 222.179C488.456 222.248 488.484 222.313 488.53 222.361C488.577 222.409 488.64 222.436 488.705 222.436H490.662C490.728 222.436 490.791 222.408 490.838 222.359C490.885 222.31 490.912 222.244 490.913 222.175L490.95 219.191C490.951 219.082 490.92 218.975 490.862 218.884Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M489.871 215.551C489.871 215.616 489.846 215.679 489.802 215.725C489.758 215.772 489.699 215.797 489.636 215.797C489.574 215.797 489.514 215.772 489.47 215.725C489.426 215.679 489.402 215.616 489.402 215.551"
                    fill="black" />
                <path d="M490.48 219.476H488.828V220.632H490.48V219.476Z" fill="white" />
                <path
                    d="M515.967 227.433H514.433C514.379 227.433 514.327 227.456 514.289 227.496C514.251 227.536 514.23 227.59 514.23 227.647V228.353C514.23 228.41 514.251 228.464 514.289 228.504C514.327 228.544 514.379 228.567 514.433 228.567H514.687V229.626H515.712V228.567H515.967C516.021 228.567 516.072 228.544 516.11 228.504C516.149 228.464 516.17 228.41 516.17 228.353V227.647C516.17 227.59 516.149 227.536 516.11 227.496C516.072 227.456 516.021 227.433 515.967 227.433Z"
                    fill="#E6E6E6" />
                <path
                    d="M517.503 233.902C516.564 232.459 516.083 230.741 516.131 228.994C516.132 228.953 516.12 228.914 516.096 228.882C516.072 228.85 516.039 228.828 516.001 228.819V228.514H514.382V228.815H514.359C514.338 228.815 514.316 228.82 514.296 228.828C514.276 228.837 514.257 228.85 514.242 228.866C514.226 228.883 514.214 228.902 514.206 228.923C514.198 228.944 514.193 228.967 514.193 228.99C514.193 228.994 514.194 228.998 514.194 229.003C514.321 230.87 513.891 232.545 512.901 234.027C512.844 234.113 512.815 234.215 512.818 234.319L512.995 240.071C513 240.2 513.051 240.321 513.139 240.411C513.226 240.5 513.343 240.551 513.466 240.552H517.129C517.253 240.551 517.371 240.499 517.459 240.408C517.547 240.316 517.597 240.193 517.6 240.063L517.668 234.478C517.67 234.273 517.612 234.072 517.503 233.902Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M515.647 227.663C515.647 227.785 515.601 227.903 515.519 227.989C515.436 228.075 515.325 228.124 515.208 228.124C515.092 228.124 514.981 228.075 514.898 227.989C514.816 227.903 514.77 227.785 514.77 227.663"
                    fill="black" />
                <path
                    d="M516.923 235.813H513.734C513.687 235.813 513.64 235.823 513.597 235.844C513.554 235.865 513.516 235.895 513.486 235.933C513.455 235.97 513.432 236.014 513.419 236.062C513.406 236.11 513.403 236.16 513.411 236.209L513.892 239.498H516.659L517.245 236.22C517.253 236.17 517.252 236.119 517.24 236.07C517.228 236.021 517.205 235.976 517.175 235.937C517.144 235.898 517.106 235.867 517.062 235.845C517.018 235.824 516.971 235.813 516.923 235.813Z"
                    fill="white" />
                <path
                    d="M511.591 240.713H502.45C503.089 237.085 502.942 232.703 502.45 227.991H511.591C511.112 232.703 510.969 237.085 511.591 240.713Z"
                    fill="#00C066" />
                <path
                    d="M507.076 236.318C508.292 236.318 509.278 235.283 509.278 234.005C509.278 232.728 508.292 231.692 507.076 231.692C505.859 231.692 504.873 232.728 504.873 234.005C504.873 235.283 505.859 236.318 507.076 236.318Z"
                    fill="white" />
                <path d="M474.2 200.676L476.252 200.48L477.558 197.15L475.226 195.778L474.2 200.676Z" fill="#FFB8B8" />
                <path
                    d="M493.034 209.818C493.102 209.64 493.129 209.447 493.112 209.255C493.095 209.063 493.035 208.878 492.937 208.716C492.839 208.553 492.706 208.417 492.548 208.32C492.39 208.222 492.212 208.165 492.029 208.153L488.842 207.954L488.373 209.592L491.653 210.538C491.928 210.617 492.22 210.587 492.474 210.455C492.729 210.322 492.928 210.096 493.034 209.818Z"
                    fill="#FFB8B8" />
                <path
                    d="M489.612 210.566L489.577 207.492L482.5 206.306L477.047 199.739C476.764 199.398 476.372 199.176 475.944 199.114C475.516 199.053 475.082 199.156 474.721 199.405C474.503 199.556 474.319 199.756 474.182 199.989C474.045 200.223 473.959 200.486 473.929 200.758C473.899 201.031 473.927 201.307 474.01 201.567C474.093 201.828 474.23 202.065 474.41 202.264L478.909 208.077L489.612 210.566Z"
                    fill="#575A89" />
                <path
                    d="M472.614 245.146H474.48L479.107 223.177L483.901 229.964L486.7 244.656H488.472L488.099 228.886L481.849 212.038H475.693C474.01 215.236 472.69 218.531 474.2 221.931L472.614 245.146Z"
                    fill="#2F2E41" />
                <path
                    d="M485.556 246.48C485.535 246.55 485.529 246.623 485.538 246.695C485.546 246.767 485.569 246.836 485.605 246.898C485.641 246.96 485.689 247.014 485.746 247.055C485.803 247.096 485.868 247.123 485.936 247.136L490.501 247.987C490.681 248.022 490.868 247.986 491.025 247.886C491.182 247.787 491.298 247.63 491.353 247.446C491.406 247.271 491.399 247.081 491.332 246.91C491.265 246.74 491.144 246.6 490.988 246.514C489.984 245.973 489.12 245.184 488.47 244.216C487.969 244.706 487.408 244.66 486.812 244.299L486.181 244.382L485.556 246.48Z"
                    fill="#2F2E41" />
                <path
                    d="M471.75 246.48C471.73 246.55 471.723 246.623 471.732 246.695C471.74 246.767 471.763 246.836 471.799 246.898C471.835 246.96 471.883 247.014 471.94 247.055C471.997 247.096 472.062 247.123 472.13 247.136L476.695 247.987C476.876 248.022 477.062 247.986 477.219 247.886C477.376 247.787 477.493 247.63 477.547 247.446C477.601 247.271 477.593 247.081 477.526 246.91C477.46 246.74 477.338 246.6 477.182 246.514C476.179 245.973 475.315 245.184 474.665 244.216C474.163 244.706 473.602 244.66 473.007 244.299L472.375 244.382L471.75 246.48Z"
                    fill="#2F2E41" />
                <path
                    d="M477.605 198.374C479.047 198.374 480.217 197.146 480.217 195.631C480.217 194.117 479.047 192.889 477.605 192.889C476.162 192.889 474.993 194.117 474.993 195.631C474.993 197.146 476.162 198.374 477.605 198.374Z"
                    fill="#FFB8B8" />
                <path
                    d="M475.273 212.773L482.082 212.577L480.082 205.968C481.325 203.876 480.074 201.786 478.304 199.696L476.905 198.717L474.666 198.521C473.697 199.61 473.167 201.051 473.186 202.541C473.231 205.733 473.769 209.208 475.273 212.773Z"
                    fill="#575A89" />
                <path
                    d="M490.918 217.222C491.048 217.085 491.145 216.919 491.201 216.736C491.258 216.553 491.272 216.358 491.242 216.168C491.213 215.978 491.141 215.798 491.032 215.643C490.924 215.487 490.782 215.362 490.618 215.276L487.763 213.776L486.718 215.088L489.379 217.313C489.602 217.499 489.881 217.592 490.165 217.575C490.449 217.559 490.717 217.433 490.918 217.222Z"
                    fill="#FFB8B8" />
                <path
                    d="M487.493 216.495L488.612 213.655L482.549 209.641L479.996 201.351C479.864 200.92 479.586 200.554 479.216 200.321C478.846 200.088 478.408 200.003 477.983 200.083C477.726 200.132 477.482 200.239 477.268 200.398C477.055 200.556 476.877 200.762 476.748 201C476.618 201.238 476.54 201.504 476.519 201.777C476.498 202.051 476.535 202.326 476.626 202.583L478.584 209.785L487.493 216.495Z"
                    fill="#575A89" />
                <path
                    d="M473.314 194.554C473.314 195.621 473.974 197.274 474.806 197.982C475.366 198.459 476.107 198.439 476.392 197.786C476.685 197.117 477.694 195.544 479.47 194.554C481.838 193.234 478.631 190.977 476.392 191.321C474.71 191.58 473.314 192.769 473.314 194.554Z"
                    fill="#2F2E41" />
                <path
                    d="M474.9 193.085C475.93 193.085 476.765 192.207 476.765 191.126C476.765 190.044 475.93 189.167 474.9 189.167C473.869 189.167 473.034 190.044 473.034 191.126C473.034 192.207 473.869 193.085 474.9 193.085Z"
                    fill="#2F2E41" />
                <path
                    d="M477.045 190.44C477.045 189.946 476.867 189.471 476.547 189.109C476.227 188.747 475.788 188.525 475.319 188.488C475.366 188.485 475.412 188.481 475.459 188.481C475.954 188.481 476.429 188.687 476.778 189.055C477.128 189.422 477.325 189.92 477.325 190.44C477.325 190.96 477.128 191.458 476.778 191.825C476.429 192.193 475.954 192.399 475.459 192.399C475.412 192.399 475.366 192.395 475.319 192.392C475.788 192.355 476.227 192.133 476.547 191.771C476.867 191.409 477.045 190.934 477.045 190.44Z"
                    fill="#2F2E41" />
                <path
                    d="M477.651 196.611C477.883 196.611 478.071 196.348 478.071 196.023C478.071 195.699 477.883 195.436 477.651 195.436C477.42 195.436 477.232 195.699 477.232 196.023C477.232 196.348 477.42 196.611 477.651 196.611Z"
                    fill="#FFB8B8" />
                <path d="M530.511 241.553H501.469L495.319 211.025H490.07V209.656H496.376L502.526 240.184H530.511V241.553Z"
                    fill="#3F3D56" />
                <path
                    d="M505.725 247.131C507.269 247.131 508.52 245.816 508.52 244.195C508.52 242.574 507.269 241.26 505.725 241.26C504.181 241.26 502.929 242.574 502.929 244.195C502.929 245.816 504.181 247.131 505.725 247.131Z"
                    fill="#3F3D56" />
                <path
                    d="M526.597 247.131C528.141 247.131 529.393 245.816 529.393 244.195C529.393 242.574 528.141 241.26 526.597 241.26C525.054 241.26 523.802 242.574 523.802 244.195C523.802 245.816 525.054 247.131 526.597 247.131Z"
                    fill="#3F3D56" />
                <path
                    d="M529.982 240.908H501.725L496.74 215.037H534.66C534.854 215.037 535.045 215.081 535.221 215.166C535.397 215.251 535.553 215.375 535.678 215.529C535.804 215.684 535.897 215.865 535.949 216.06C536.002 216.256 536.014 216.461 535.984 216.662L531.305 239.72C531.257 240.052 531.096 240.354 530.854 240.572C530.611 240.79 530.301 240.91 529.982 240.908ZM502.032 240.517H529.982C530.212 240.518 530.436 240.432 530.611 240.274C530.786 240.117 530.902 239.899 530.937 239.659L535.615 216.601C535.637 216.456 535.629 216.308 535.591 216.167C535.553 216.026 535.486 215.895 535.395 215.784C535.304 215.672 535.192 215.583 535.065 215.521C534.938 215.46 534.8 215.428 534.66 215.428H497.192L502.032 240.517Z"
                    fill="#3F3D56" />
                <path d="M507.218 240.825L503.953 215.264L504.321 215.201L507.586 240.762L507.218 240.825Z"
                    fill="#3F3D56" />
                <path d="M525.373 240.629L525.005 240.566L528.175 215.201L528.543 215.264L525.373 240.629Z"
                    fill="#3F3D56" />
                <path d="M516.723 215.233H516.35V240.794H516.723V215.233Z" fill="#3F3D56" />
                <path d="M498.643 222.082L498.643 222.473L534.722 222.565L534.723 222.173L498.643 222.082Z"
                    fill="#3F3D56" />
                <path d="M532.177 234.172L500.48 234.4L500.483 234.791L532.179 234.564L532.177 234.172Z" fill="#3F3D56" />
                <path
                    d="M490.629 211.319C491.762 211.319 492.679 210.793 492.679 210.145C492.679 209.496 491.762 208.97 490.629 208.97C489.497 208.97 488.579 209.496 488.579 210.145C488.579 210.793 489.497 211.319 490.629 211.319Z"
                    fill="#3F3D56" />
            </g>
            <g clip-path="url(#clip4_28_850)">
                <path
                    d="M1000.8 198.067L1000.8 198.086L1000.79 198.142L999.978 204.011L995.025 205.848L994.947 205.811L992.174 204.479L990.74 198.917L990.642 198.535L990.672 198.523L996.807 196.193L1000.79 198.065L1000.8 198.067Z"
                    fill="#00C066" />
                <path d="M994.947 205.811L992.174 204.479L990.642 198.535L990.672 198.524L994.669 200.228L994.947 205.811Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M995.017 205.743L992.907 201.656L993.178 200.498L991.902 198.979L991.794 199.072L993.023 200.535L992.105 204.463L992.244 204.496L992.857 201.871L994.89 205.81L995.017 205.743Z"
                    fill="black" />
                <path
                    d="M1000.8 198.139L1000.79 198.142L994.669 200.3L990.74 198.917L990.642 198.535L990.672 198.523L996.807 196.193L1000.79 198.065L1000.8 198.086L1000.8 198.139Z"
                    fill="#3F3D56" />
                <path
                    d="M994.776 200.409L993.528 199.436L993.813 198.355L997.377 197.058L999.8 197.202L1000.76 198.031L1000.83 198.247L994.776 200.409Z"
                    fill="#00C066" />
                <path
                    d="M990.713 198.535L993.528 198.427L995.053 197.904L997.431 197.058L997.876 196.41L996.766 196.209L990.713 198.535Z"
                    fill="#00C066" />
                <path d="M996.322 197.376L994.854 197.896L994.901 198.032L996.369 197.512L996.322 197.376Z"
                    fill="#CCCCCC" />
                <path d="M976.988 188.949L976.3 192.428L979.511 194.863L981.002 190.341L976.988 188.949Z" fill="#9F616A" />
                <path
                    d="M979.568 192.138C981.279 192.138 982.665 190.736 982.665 189.008C982.665 187.279 981.279 185.877 979.568 185.877C977.858 185.877 976.472 187.279 976.472 189.008C976.472 190.736 977.858 192.138 979.568 192.138Z"
                    fill="#9F616A" />
                <path
                    d="M972.859 212.727C972.873 213.737 977.224 224.978 976.62 226.442C975.668 227.426 973.619 232.664 972.744 234.061C972.63 234.061 972.056 235.8 972.056 235.8C972.056 235.8 973.432 238.003 974.923 237.076C976.798 232.618 981.493 230.132 981.576 224.322C981.803 226.157 982.472 237.938 982.472 237.938C982.472 237.938 982.343 237.993 985.232 238.273C985.68 231.436 987.513 219.803 983.41 212.495C982.149 211.915 972.859 212.727 972.859 212.727Z"
                    fill="#2F2E41" />
                <path
                    d="M982.472 237.709C982.337 237.97 981.376 240.376 982.251 240.617C983.26 240.895 984.238 240.505 984.238 240.505C984.238 240.505 986.005 241.064 987.086 240.354C987.59 239.844 987.476 239.38 987.235 239.044C987.113 238.879 986.956 238.742 986.776 238.644C986.596 238.546 986.397 238.489 986.193 238.476C985.644 238.437 985.47 238.334 985.407 238.08C985.315 237.709 982.472 237.709 982.472 237.709Z"
                    fill="#2F2E41" />
                <path
                    d="M973.035 235.608C973.035 235.608 970.57 236.395 971.089 237.313C971.426 237.882 971.918 238.341 972.506 238.634C972.506 238.634 973.02 240.777 974.447 240.777C975.161 240.777 975.404 240.367 975.469 239.957C975.498 239.752 975.483 239.544 975.424 239.346C975.366 239.148 975.265 238.965 975.129 238.811C974.769 238.39 974.718 238.193 974.851 237.969C975.046 237.641 973.035 235.608 973.035 235.608Z"
                    fill="#2F2E41" />
                <path
                    d="M983.984 213.066C983.984 213.066 983.525 213.994 981.69 213.646C979.855 213.299 972.63 213.646 972.63 213.646C972.63 213.646 973.031 205.356 972.113 200.37C971.196 195.384 974.808 192.544 974.808 192.544L975.956 191.384C977.103 191.269 979.525 194.867 979.525 194.867C980.322 195.002 981.066 198.428 981.701 201.669C981.739 201.855 981.774 202.038 981.809 202.221C982.102 203.732 982.509 205.414 982.753 206.924C982.771 207.031 982.788 207.137 982.803 207.243C983.093 209.204 983.487 211.148 983.984 213.066Z"
                    fill="#E6E6E6" />
                <path
                    d="M975.946 187.058C975.946 187.058 975.367 185.771 976.872 185.185C976.872 185.185 978.146 183.078 980.693 184.483C980.693 184.483 982.43 185.185 982.43 187.058C982.43 188.931 983.009 189.282 983.009 189.282C983.009 189.282 982.147 188.388 981.915 187.686C981.684 186.983 979.883 186.824 979.188 187.526C978.493 188.229 976.756 188.112 976.756 188.112L976.872 190.687C976.872 190.687 976.293 189.165 976.061 189.165C975.83 189.165 975.598 187.058 975.946 187.058Z"
                    fill="#2F2E41" />
                <path opacity="0.2"
                    d="M982.753 206.924C980.017 205.421 975.586 202.124 974.156 200.34C972.271 197.991 974.327 196.205 974.327 196.205C976.658 194.718 979.444 199.819 979.444 199.819L981.701 201.669C981.739 201.855 981.774 202.038 981.809 202.221C982.102 203.732 982.509 205.414 982.753 206.924Z"
                    fill="black" />
                <path
                    d="M990.92 205.192C990.92 205.192 994.988 206.861 995.657 204.984C996.327 203.108 992.446 203.14 992.446 203.14L990.922 203.358L990.92 205.192Z"
                    fill="#9F616A" />
                <path
                    d="M973.806 195.441C973.806 195.441 971.751 197.228 973.634 199.577C975.517 201.925 984.173 206.944 984.173 206.944L989.81 205.403L991.406 205.698L991.707 202.67L989.356 202.902L983.39 201.618L979.585 198.497C979.585 198.497 976.136 193.955 973.806 195.441Z"
                    fill="#E6E6E6" />
                <path opacity="0.2" d="M981.291 216.967L981.651 225.459L980.739 216.967H981.291Z" fill="black" />
                <path
                    d="M1020.1 210.893L1016.84 211.657C1016.59 211.716 1016.32 211.674 1016.1 211.538C1015.88 211.403 1015.72 211.185 1015.65 210.932C1015.61 210.785 1015.61 210.631 1015.64 210.482C1015.67 210.333 1015.73 210.192 1015.82 210.071C1015.91 209.95 1016.03 209.851 1016.16 209.781C1016.29 209.712 1016.44 209.674 1016.59 209.671L1019.74 209.596L1020.1 210.893Z"
                    fill="#FFB9B9" />
                <path
                    d="M1019.76 211.377L1019.03 209.179L1023.38 207.678L1022.22 197.411C1024.3 197.793 1025.29 199.443 1025.2 201.575L1025.76 208.581L1019.76 211.377Z"
                    fill="#3F3D56" />
                <path
                    d="M1022.76 195.148H1029.86V191.579C1029.86 190.615 1029.49 189.689 1028.82 189.002C1028.49 188.663 1028.1 188.394 1027.67 188.211C1027.24 188.027 1026.78 187.933 1026.31 187.934C1025.37 187.936 1024.48 188.309 1023.81 188.973C1023.15 189.637 1022.77 190.539 1022.76 191.483C1022.76 191.516 1022.76 191.547 1022.76 191.579L1022.76 195.148Z"
                    fill="#2F2E41" />
                <path
                    d="M1032.83 237.088L1030.56 236.825L1027.84 218.284L1022.22 236.9L1019.77 236.975L1022.56 214.072L1022.15 208.844L1029.11 206.625C1034.03 210.102 1033.93 222.384 1032.83 237.088Z"
                    fill="#2F2E41" />
                <path
                    d="M1025.68 194.44C1027.16 194.44 1028.36 193.228 1028.36 191.732C1028.36 190.237 1027.16 189.024 1025.68 189.024C1024.2 189.024 1023.01 190.237 1023.01 191.732C1023.01 193.228 1024.2 194.44 1025.68 194.44Z"
                    fill="#FFB9B9" />
                <path
                    d="M1028.36 196.621L1023.82 197.825C1024.59 196.338 1024.83 194.95 1024.42 193.688L1027.62 193.161C1027.41 194.369 1027.68 195.609 1028.36 196.621Z"
                    fill="#FFB9B9" />
                <path
                    d="M1029.89 207.641C1027.34 209.277 1024.38 211.157 1022.19 209.333L1021.14 204.218C1020.32 203.473 1020.68 201.172 1021.8 197.894C1021.87 197.685 1021.99 197.496 1022.15 197.341C1022.3 197.185 1022.49 197.067 1022.69 196.995L1024.42 196.396C1025.18 197.046 1026.44 196.658 1027.92 195.794L1029.63 196.245L1030.37 201.887C1029.3 203.513 1029.48 205.679 1029.89 207.641Z"
                    fill="#3F3D56" />
                <path
                    d="M1027.77 209.84L1024.5 210.604C1024.25 210.663 1023.99 210.621 1023.76 210.485C1023.54 210.35 1023.38 210.132 1023.32 209.879C1023.28 209.732 1023.27 209.578 1023.3 209.429C1023.33 209.28 1023.39 209.139 1023.48 209.018C1023.57 208.897 1023.69 208.798 1023.82 208.728C1023.96 208.659 1024.11 208.621 1024.26 208.618L1027.41 208.543L1027.77 209.84Z"
                    fill="#FFB9B9" />
                <path
                    d="M1032.43 240.633C1032.05 240.809 1031.73 239.719 1031.41 240.039C1030.51 240.932 1028.35 240.732 1028.35 240.732C1028.28 240.708 1028.21 240.67 1028.16 240.619C1028.1 240.569 1028.05 240.507 1028.02 240.438C1027.99 240.369 1027.97 240.294 1027.96 240.217C1027.96 240.14 1027.97 240.063 1028 239.991C1028.03 239.905 1028.08 239.828 1028.15 239.767C1028.22 239.705 1028.3 239.662 1028.39 239.639L1029.35 239.398L1030.85 236.728L1032.48 236.519L1032.52 236.587C1032.84 237.102 1033.05 237.68 1033.12 238.282C1033.2 238.883 1033.15 239.494 1032.98 240.075C1032.84 240.516 1032.66 240.53 1032.43 240.633Z"
                    fill="#2F2E41" />
                <path
                    d="M1021.64 240.633C1021.26 240.809 1020.94 239.719 1020.62 240.039C1019.72 240.932 1017.57 240.732 1017.57 240.732C1017.49 240.708 1017.43 240.67 1017.37 240.619C1017.31 240.569 1017.26 240.507 1017.23 240.438C1017.2 240.369 1017.18 240.294 1017.18 240.217C1017.17 240.14 1017.18 240.063 1017.21 239.991C1017.24 239.905 1017.3 239.828 1017.36 239.767C1017.43 239.705 1017.51 239.662 1017.6 239.639L1018.56 239.398L1020.06 236.728L1021.7 236.519L1021.74 236.587C1022.05 237.102 1022.26 237.68 1022.33 238.282C1022.41 238.883 1022.36 239.494 1022.19 240.075C1022.05 240.516 1021.87 240.53 1021.64 240.633Z"
                    fill="#2F2E41" />
                <path
                    d="M1028.82 189.474L1028.15 191.643L1022.32 191.539C1022.34 190.779 1022.59 190.046 1023.04 189.439C1023.5 188.833 1024.12 188.385 1024.84 188.158C1025.56 187.93 1026.33 187.935 1027.04 188.171C1027.75 188.407 1028.38 188.862 1028.82 189.474H1028.82Z"
                    fill="#2F2E41" />
                <path
                    d="M1027.42 210.324L1026.7 208.126L1031.04 206.625L1029.4 196.136C1030.4 196.32 1031.3 196.866 1031.94 197.673C1032.58 198.479 1032.9 199.491 1032.86 200.522L1033.42 207.528L1027.42 210.324Z"
                    fill="#3F3D56" />
                <path
                    d="M1017.04 204.398L1012.52 205.38L1011.6 200.885L1013.3 198.576L1014.83 198.281L1016.53 200.026L1017.04 204.398Z"
                    fill="#CCCCCC" />
                <path
                    d="M1014.95 204.594H1012.23L1011.86 202.742L1011.45 200.713L1012.06 199.829L1013.23 200.197L1014.49 201.966L1014.81 203.769L1014.83 203.897L1014.95 204.594Z"
                    fill="#E6E6E6" />
                <path
                    d="M1019.52 203.513L1016.39 203.882L1016.94 199.854L1018.21 198.699L1019.3 198.969L1020.03 200.664L1019.52 203.513Z"
                    fill="#CCCCCC" />
                <path
                    d="M1019.93 201.13L1019.64 202.752L1018.69 208.278L1015.05 209.458L1014.92 209.389L1012.96 208.303L1011.85 202.74L1011.86 202.742L1014.78 203.931L1014.81 203.769L1014.83 203.652L1015.05 202.212L1016.05 201.13L1019.37 200.32L1019.93 201.13Z"
                    fill="#E6E6E6" />
                <path
                    d="M1017.63 200.959C1018.05 200.959 1018.4 200.607 1018.4 200.173C1018.4 199.739 1018.05 199.387 1017.63 199.387C1017.2 199.387 1016.85 199.739 1016.85 200.173C1016.85 200.607 1017.2 200.959 1017.63 200.959Z"
                    fill="#E6E6E6" />
                <path d="M1015.71 200.578L1013.94 200.898L1013.95 200.946L1015.72 200.627L1015.71 200.578Z"
                    fill="white" />
                <path
                    d="M1014.92 209.389L1012.96 208.303L1011.85 202.74L1011.86 202.742L1011.45 200.713L1012.06 199.829L1013.23 200.197L1014.49 201.966L1014.81 203.769L1014.83 203.652L1014.83 203.897L1014.84 204.594L1014.92 209.389Z"
                    fill="#F2F2F2" />
                <path
                    d="M1012.98 208.31L1012.94 208.297L1013.91 204.624L1012.8 203.145L1012.83 203.116L1013.96 204.613L1012.98 208.31Z"
                    fill="#CCCCCC" />
                <path d="M1013.53 206.213L1013.49 206.234L1015.03 209.468L1015.07 209.447L1013.53 206.213Z"
                    fill="#CCCCCC" />
                <path opacity="0.2"
                    d="M1019.74 202.416L1019.56 203.435L1019.55 203.436L1018.73 208.2L1015.09 209.379L1015.07 209.39L1015.05 209.359L1013 208.225L1012.98 208.218L1012.99 208.17L1011.89 202.661L1011.9 202.663L1011.78 202.058L1011.87 201.926L1012.15 201.519L1013.31 201.887L1014.58 203.656L1014.6 203.761L1014.73 204.515L1014.78 204.819L1014.9 205.459L1015 204.771L1015.04 204.523L1015.14 203.901L1016.13 202.821L1016.58 202.713L1016.88 202.638L1017.31 202.534C1017.18 202.454 1017.07 202.335 1017.01 202.194C1016.94 202.053 1016.92 201.895 1016.94 201.741C1016.97 201.588 1017.04 201.444 1017.14 201.33C1017.25 201.216 1017.38 201.135 1017.53 201.099C1017.68 201.062 1017.84 201.071 1017.98 201.125C1018.13 201.179 1018.25 201.275 1018.34 201.401C1018.43 201.527 1018.48 201.677 1018.49 201.833C1018.5 201.988 1018.46 202.142 1018.37 202.275L1019.46 202.01L1019.73 202.399L1019.74 202.416Z"
                    fill="black" />
                <path
                    d="M1015.04 206.53H1012.32L1011.54 202.648L1012.15 201.764L1013.31 202.133L1014.58 203.901L1015.04 206.53Z"
                    fill="#E6E6E6" />
                <path
                    d="M1018.78 210.214L1015.14 211.393L1013.05 210.239L1011.94 204.675L1014.87 205.866L1015.14 204.147L1016.13 203.066L1019.46 202.256L1020.02 203.066L1019.73 204.687L1018.78 210.214Z"
                    fill="#E6E6E6" />
                <path
                    d="M1017.71 202.894C1018.14 202.894 1018.49 202.542 1018.49 202.108C1018.49 201.674 1018.14 201.322 1017.71 201.322C1017.28 201.322 1016.94 201.674 1016.94 202.108C1016.94 202.542 1017.28 202.894 1017.71 202.894Z"
                    fill="#E6E6E6" />
                <path
                    d="M1015.01 211.286L1013.05 210.2L1011.94 204.637L1011.95 204.64L1011.54 202.61L1012.15 201.726L1013.32 202.095L1014.58 203.864L1014.9 205.666L1014.92 205.549L1014.92 205.795L1014.93 206.491L1015.01 211.286Z"
                    fill="#F2F2F2" />
                <path
                    d="M1013.07 210.245L1013.02 210.233L1013.99 206.56L1012.88 205.081L1012.92 205.051L1014.05 206.549L1013.07 210.245Z"
                    fill="#CCCCCC" />
                <path d="M1013.62 208.148L1013.57 208.17L1015.12 211.404L1015.16 211.383L1013.62 208.148Z"
                    fill="#CCCCCC" />
                <path
                    d="M1045.53 235.912L1041.01 236.895L1040.08 232.4L1041.79 230.091L1043.32 229.796L1045.02 231.54L1045.53 235.912Z"
                    fill="#CCCCCC" />
                <path
                    d="M1043.44 236.108H1040.72L1040.35 234.257L1039.94 232.228L1040.55 231.344L1041.71 231.712L1042.98 233.481L1043.29 235.284L1043.31 235.412L1043.44 236.108Z"
                    fill="#E6E6E6" />
                <path
                    d="M1048.01 235.028L1044.87 235.397L1045.43 231.368L1046.69 230.214L1047.79 230.484L1048.52 232.179L1048.01 235.028Z"
                    fill="#CCCCCC" />
                <path
                    d="M1048.42 232.645L1048.13 234.267L1047.18 239.793L1043.53 240.973L1043.41 240.903L1041.44 239.817L1040.34 234.254L1040.35 234.257L1043.27 235.445L1043.29 235.283L1043.31 235.166L1043.53 233.726L1044.53 232.645L1047.86 231.834L1048.42 232.645Z"
                    fill="#E6E6E6" />
                <path
                    d="M1046.11 232.473C1046.54 232.473 1046.89 232.122 1046.89 231.687C1046.89 231.253 1046.54 230.901 1046.11 230.901C1045.68 230.901 1045.33 231.253 1045.33 231.687C1045.33 232.122 1045.68 232.473 1046.11 232.473Z"
                    fill="#E6E6E6" />
                <path d="M1044.2 232.093L1042.43 232.412L1042.43 232.461L1044.21 232.141L1044.2 232.093Z" fill="white" />
                <path
                    d="M1043.41 240.903L1041.44 239.817L1040.34 234.254L1040.35 234.257L1039.94 232.228L1040.55 231.344L1041.71 231.712L1042.98 233.481L1043.29 235.284L1043.31 235.166L1043.31 235.412L1043.33 236.108L1043.41 240.903Z"
                    fill="#F2F2F2" />
                <path
                    d="M1041.47 239.824L1041.42 239.812L1042.39 236.139L1041.28 234.66L1041.32 234.63L1042.44 236.128L1041.47 239.824Z"
                    fill="#CCCCCC" />
                <path d="M1042.02 237.727L1041.97 237.749L1043.51 240.983L1043.56 240.962L1042.02 237.727Z"
                    fill="#CCCCCC" />
                <path d="M1054.46 240.544H1051.48L1051.03 234.74H1054.9L1054.46 240.544Z" fill="#E6E6E6" />
                <path d="M1054.95 237.084H1050.98V237.977H1054.95V237.084Z" fill="#F2F2F2" />
                <path
                    d="M1055.98 235.157L1055.34 234.967L1055.33 234.732L1052.51 233.891L1052.37 234.084L1051.74 233.895L1051.34 234.474L1056 235.862L1055.98 235.157Z"
                    fill="#CCCCCC" />
                <path
                    d="M962.487 233.218L962.484 233.238L962.476 233.294L961.667 239.163L956.714 241L956.636 240.963L953.863 239.631L952.429 234.069L952.331 233.687L952.36 233.675L958.495 231.345L962.483 233.216L962.487 233.218Z"
                    fill="#00C066" />
                <path d="M956.636 240.963L953.863 239.631L952.331 233.687L952.36 233.675L956.357 235.38L956.636 240.963Z"
                    fill="#00C066" />
                <path opacity="0.2"
                    d="M956.706 240.895L954.596 236.808L954.867 235.649L953.591 234.13L953.482 234.224L954.712 235.687L953.793 239.615L953.932 239.648L954.546 237.022L956.579 240.961L956.706 240.895Z"
                    fill="black" />
                <path
                    d="M962.487 233.291L962.476 233.294L956.357 235.452L952.429 234.069L952.331 233.687L952.36 233.675L958.495 231.345L962.483 233.216L962.484 233.238L962.487 233.291Z"
                    fill="#3F3D56" />
                <path
                    d="M956.464 235.56L955.217 234.587L955.502 233.507L959.066 232.21L961.489 232.354L962.451 233.182L962.522 233.399L956.464 235.56Z"
                    fill="#00C066" />
                <path
                    d="M952.402 233.687L955.217 233.579L956.742 233.055L959.12 232.21L959.565 231.561L958.455 231.361L952.402 233.687Z"
                    fill="#00C066" />
                <path d="M958.011 232.527L956.543 233.048L956.59 233.184L958.058 232.663L958.011 232.527Z"
                    fill="#CCCCCC" />
                <path d="M949.975 240.677H946.994L946.552 234.873H950.416L949.975 240.677Z" fill="#00C066" />
                <path d="M950.471 237.217H946.497V238.11H950.471V237.217Z" fill="#E6E6E6" />
                <path
                    d="M950.637 234.539H949.975L949.901 234.315H946.957L946.883 234.539H946.221L946 235.208H950.858L950.637 234.539Z"
                    fill="#3F3D56" />
                <path d="M1035.25 240.609H968.329V240.832H1035.25V240.609Z" fill="#3F3D56" />
            </g>
            <g clip-path="url(#clip5_28_850)">
                <path d="M270.836 244.257H213.587V244.5H270.836V244.257Z" fill="#3F3D56" />
                <path
                    d="M260.152 202.866C260.263 202.993 260.344 203.142 260.392 203.303C260.44 203.464 260.454 203.633 260.431 203.799C260.409 203.965 260.351 204.125 260.262 204.268C260.174 204.41 260.055 204.533 259.915 204.628L253.99 208.638L251.381 210.353C251.233 210.45 251.053 210.49 250.877 210.464C250.701 210.438 250.541 210.348 250.428 210.212C250.362 210.133 250.315 210.04 250.289 209.941C250.263 209.842 250.259 209.739 250.278 209.638C250.296 209.537 250.337 209.442 250.396 209.358C250.456 209.274 250.533 209.204 250.623 209.153L253.15 207.706L257.56 203.566L254.725 200.564L256.825 199.012L260.152 202.866Z"
                    fill="#A0616A" />
                <path d="M246.22 240.622H244.771L243.91 228.822L247.585 228.719L246.22 240.622Z" fill="#A0616A" />
                <path
                    d="M246.325 244.452C245.939 244.626 245.615 243.217 245.289 243.533C244.377 244.416 242.981 244.609 241.764 244.223L242.19 244.218C242.116 244.195 242.049 244.157 241.99 244.108C241.932 244.058 241.885 243.997 241.851 243.928C241.818 243.86 241.798 243.785 241.795 243.709C241.791 243.633 241.804 243.557 241.831 243.486C241.863 243.401 241.916 243.325 241.985 243.264C242.054 243.204 242.136 243.161 242.226 243.138L243.196 242.899L244.718 240.26L246.273 240.156C246.619 240.592 246.861 241.099 246.98 241.64C247.099 242.181 247.092 242.741 246.959 243.279C246.818 243.847 246.601 244.328 246.325 244.452Z"
                    fill="#2F2E41" />
                <path d="M255.87 240.622H254.42L253.56 228.822L257.34 228.098L255.87 240.622Z" fill="#A0616A" />
                <path
                    d="M255.975 244.452C255.588 244.626 255.265 243.217 254.939 243.533C254.027 244.416 252.631 244.609 251.414 244.223L251.84 244.218C251.766 244.195 251.698 244.157 251.64 244.108C251.582 244.058 251.534 243.997 251.501 243.928C251.467 243.86 251.448 243.785 251.445 243.709C251.441 243.633 251.453 243.557 251.48 243.486C251.513 243.401 251.566 243.325 251.634 243.264C251.703 243.204 251.786 243.161 251.876 243.138L252.845 242.899L254.368 240.26L256.027 240.053L256.069 240.121C256.39 240.63 256.597 241.201 256.676 241.796C256.755 242.391 256.704 242.995 256.528 243.569C256.39 244.005 256.202 244.35 255.975 244.452Z"
                    fill="#2F2E41" />
                <path
                    d="M257.513 199.278C256.18 199.461 255.257 200.181 254.882 201.616L252.432 197.157C252.287 196.874 252.25 196.548 252.328 196.24C252.406 195.932 252.595 195.663 252.859 195.48C253.139 195.287 253.483 195.207 253.821 195.255C254.159 195.304 254.466 195.479 254.678 195.743L257.513 199.278Z"
                    fill="#00C066" />
                <path
                    d="M260.08 227.58C254.124 230.178 248.028 230.498 241.81 228.822C244.08 220.141 246.761 212.291 246.745 205.843L252.835 205.326L253.773 206.791C255.997 210.268 257.533 214.129 258.298 218.17L260.08 227.58Z"
                    fill="#2F2E41" />
                <path
                    d="M250.105 192.491C251.845 192.491 253.255 191.1 253.255 189.385C253.255 187.67 251.845 186.28 250.105 186.28C248.365 186.28 246.955 187.67 246.955 189.385C246.955 191.1 248.365 192.491 250.105 192.491Z"
                    fill="#A0616A" />
                <path d="M253.57 194.871L249.685 195.078L249.055 191.662L252.205 191.145L253.57 194.871Z" fill="#A0616A" />
                <path
                    d="M253.15 205.843L248.894 205.961L246.745 206.257C245.69 202.823 244.802 199.396 246.955 196.527L249.475 194.043L253.255 193.94L253.305 193.968C253.905 194.307 254.37 194.837 254.624 195.472C254.877 196.107 254.904 196.807 254.7 197.459C253.761 200.464 253.159 203.302 253.15 205.843Z"
                    fill="#00C066" />
                <path
                    d="M246.64 215.47L246.376 219.027C246.362 219.217 246.278 219.396 246.141 219.531C246.003 219.665 245.821 219.747 245.628 219.759C245.516 219.767 245.405 219.751 245.3 219.713C245.195 219.676 245.099 219.617 245.018 219.541C244.938 219.465 244.874 219.373 244.831 219.271C244.789 219.169 244.768 219.06 244.771 218.95L244.855 215.47L247.48 205.636L247.585 199.633L250.525 199.529L250.315 206.464L246.64 215.47Z"
                    fill="#A0616A" />
                <path
                    d="M250.84 200.047C249.594 199.547 248.429 199.714 247.375 200.771L247.519 195.702C247.538 195.385 247.671 195.086 247.895 194.858C248.12 194.63 248.42 194.489 248.741 194.462C249.081 194.433 249.42 194.533 249.688 194.742C249.956 194.951 250.133 195.254 250.182 195.587L250.84 200.047Z"
                    fill="#00C066" />
                <path
                    d="M256.773 203.204H247.113C249.366 197.321 250.093 191.849 247.113 187.16C247.164 185.752 248.996 184.531 250.419 184.666C252.1 184.825 254.358 186.042 254.673 187.678L256.773 203.204Z"
                    fill="#2F2E41" />
                <path
                    d="M225.986 184.407H225.545V172.508C225.545 171.604 225.365 170.708 225.014 169.873C224.663 169.037 224.148 168.278 223.499 167.638C222.85 166.999 222.08 166.492 221.233 166.146C220.385 165.799 219.477 165.621 218.559 165.621H192.986C192.069 165.621 191.16 165.799 190.313 166.146C189.465 166.492 188.695 166.999 188.046 167.638C187.397 168.278 186.883 169.037 186.532 169.873C186.181 170.708 186 171.604 186 172.508V237.787C186 238.691 186.181 239.586 186.532 240.422C186.883 241.258 187.397 242.017 188.046 242.656C188.695 243.296 189.465 243.803 190.313 244.149C191.16 244.495 192.069 244.673 192.986 244.673H218.559C219.477 244.673 220.385 244.495 221.233 244.149C222.08 243.803 222.85 243.296 223.499 242.656C224.148 242.017 224.663 241.258 225.014 240.422C225.365 239.586 225.545 238.691 225.545 237.787V192.877H225.986V184.407Z"
                    fill="#3F3D56" />
                <path
                    d="M218.841 167.413H215.503C215.657 167.784 215.715 168.187 215.674 168.585C215.632 168.984 215.492 169.366 215.265 169.699C215.038 170.031 214.732 170.304 214.374 170.492C214.015 170.681 213.615 170.779 213.208 170.779H198.558C198.151 170.779 197.751 170.681 197.392 170.492C197.034 170.304 196.727 170.031 196.501 169.699C196.274 169.366 196.134 168.984 196.092 168.585C196.051 168.187 196.109 167.784 196.263 167.413H193.145C192.46 167.413 191.781 167.546 191.148 167.805C190.515 168.063 189.94 168.442 189.456 168.919C188.971 169.397 188.587 169.964 188.325 170.588C188.063 171.212 187.928 171.881 187.928 172.556V237.739C187.928 238.414 188.063 239.083 188.325 239.707C188.587 240.331 188.971 240.898 189.456 241.375C189.94 241.853 190.515 242.232 191.148 242.49C191.781 242.749 192.46 242.882 193.145 242.882H218.841C219.526 242.882 220.205 242.749 220.838 242.49C221.471 242.232 222.046 241.853 222.53 241.375C223.015 240.898 223.399 240.331 223.661 239.707C223.923 239.083 224.058 238.414 224.058 237.739V172.556C224.058 171.192 223.509 169.884 222.53 168.919C221.552 167.955 220.225 167.413 218.841 167.413Z"
                    fill="white" />
                <path d="M219.546 177.595H192.44V200.514H219.546V177.595Z" fill="#E6E6E6" />
                <path
                    d="M200.484 205.293C201.579 205.293 202.467 204.418 202.467 203.338C202.467 202.258 201.579 201.383 200.484 201.383C199.388 201.383 198.5 202.258 198.5 203.338C198.5 204.418 199.388 205.293 200.484 205.293Z"
                    fill="#00C066" />
                <path
                    d="M201.475 203.175H200.649V202.361H200.318V203.175H199.492V203.501H200.318V204.316H200.649V203.501H201.475V203.175Z"
                    fill="white" />
                <path
                    d="M210.951 205.293C212.047 205.293 212.935 204.418 212.935 203.338C212.935 202.258 212.047 201.383 210.951 201.383C209.856 201.383 208.968 202.258 208.968 203.338C208.968 204.418 209.856 205.293 210.951 205.293Z"
                    fill="#00C066" />
                <path d="M211.943 203.501V203.175H209.96V203.501H211.943Z" fill="white" />
                <path
                    d="M207.004 180.453H204.862C204.787 180.453 204.714 180.483 204.661 180.535C204.608 180.588 204.578 180.659 204.578 180.733V181.66C204.578 181.734 204.608 181.806 204.661 181.858C204.714 181.911 204.787 181.94 204.862 181.94H205.217V183.329H206.649V181.94H207.004C207.079 181.94 207.152 181.911 207.205 181.858C207.258 181.806 207.288 181.734 207.288 181.66V180.733C207.288 180.659 207.258 180.588 207.205 180.535C207.152 180.483 207.079 180.453 207.004 180.453Z"
                    fill="#00C066" />
                <path
                    d="M209.149 188.936C207.838 187.043 207.167 184.79 207.234 182.499C207.235 182.446 207.217 182.395 207.184 182.353C207.151 182.312 207.105 182.282 207.052 182.271V181.87H204.79V182.265H204.759C204.728 182.265 204.698 182.271 204.67 182.283C204.642 182.294 204.616 182.311 204.595 182.333C204.573 182.354 204.556 182.379 204.544 182.407C204.533 182.435 204.527 182.464 204.527 182.494C204.527 182.5 204.527 182.506 204.528 182.511C204.706 184.96 204.104 187.157 202.722 189.1C202.643 189.212 202.602 189.346 202.606 189.482L202.854 197.025C202.86 197.194 202.931 197.353 203.054 197.471C203.176 197.588 203.34 197.654 203.51 197.656H208.627C208.8 197.654 208.965 197.586 209.088 197.467C209.211 197.347 209.281 197.185 209.285 197.014L209.38 189.691C209.383 189.422 209.302 189.158 209.149 188.936Z"
                    fill="#3F3D56" />
                <path opacity="0.2"
                    d="M206.557 180.755C206.557 180.916 206.493 181.069 206.378 181.182C206.263 181.296 206.107 181.359 205.945 181.359C205.782 181.359 205.626 181.296 205.511 181.182C205.397 181.069 205.332 180.916 205.332 180.755"
                    fill="black" />
                <path
                    d="M208.339 191.442H207.72C207.661 191.063 207.466 190.718 207.171 190.469C206.876 190.22 206.501 190.083 206.113 190.083C205.724 190.083 205.349 190.22 205.054 190.469C204.759 190.718 204.564 191.063 204.505 191.442H203.886C203.82 191.442 203.754 191.456 203.695 191.483C203.635 191.51 203.581 191.549 203.538 191.599C203.496 191.648 203.464 191.706 203.446 191.768C203.428 191.831 203.424 191.897 203.434 191.961L204.107 196.274H207.971L208.789 191.975C208.801 191.91 208.799 191.843 208.782 191.779C208.765 191.715 208.734 191.655 208.691 191.604C208.648 191.553 208.595 191.512 208.534 191.484C208.473 191.456 208.407 191.442 208.339 191.442V191.442Z"
                    fill="#00C066" />
                <path d="M219.546 209.855H192.44V232.775H219.546V209.855Z" fill="#E6E6E6" />
                <path
                    d="M200.484 237.554C201.579 237.554 202.467 236.679 202.467 235.599C202.467 234.519 201.579 233.644 200.484 233.644C199.388 233.644 198.5 234.519 198.5 235.599C198.5 236.679 199.388 237.554 200.484 237.554Z"
                    fill="#00C066" />
                <path
                    d="M201.475 235.436H200.649V234.621H200.318V235.436H199.492V235.762H200.318V236.576H200.649V235.762H201.475V235.436Z"
                    fill="white" />
                <path
                    d="M210.951 237.554C212.047 237.554 212.935 236.679 212.935 235.599C212.935 234.519 212.047 233.644 210.951 233.644C209.856 233.644 208.968 234.519 208.968 235.599C208.968 236.679 209.856 237.554 210.951 237.554Z"
                    fill="#00C066" />
                <path d="M211.943 235.762V235.436H209.96V235.762H211.943Z" fill="white" />
                <path
                    d="M211.329 226.138L211.344 226.138C211.855 226.142 212.354 225.994 212.778 225.714C213.202 225.434 213.531 225.035 213.721 224.568C214.321 223.074 214.461 221.438 214.125 219.866C213.789 218.293 212.991 216.853 211.83 215.724C210.669 214.595 209.198 213.828 207.598 213.518C205.998 213.207 204.341 213.368 202.834 213.979C201.326 214.59 200.034 215.625 199.118 216.955C198.202 218.285 197.704 219.851 197.684 221.458C197.665 223.065 198.126 224.642 199.009 225.993C199.892 227.344 201.159 228.409 202.651 229.055C203.115 229.258 203.63 229.317 204.129 229.226C204.628 229.135 205.087 228.897 205.447 228.544C206.218 227.78 207.134 227.174 208.144 226.761C209.154 226.348 210.236 226.136 211.329 226.138Z"
                    fill="white" />
                <path
                    d="M207.06 223.658C208.576 223.658 209.805 222.446 209.805 220.952C209.805 219.458 208.576 218.247 207.06 218.247C205.545 218.247 204.316 219.458 204.316 220.952C204.316 222.446 205.545 223.658 207.06 223.658Z"
                    fill="#00C066" />
            </g>
            <path
                d="M168.619 233.775C168.619 243.799 162.66 247.298 155.309 247.298C147.959 247.298 142 243.799 142 233.775C142 223.751 155.309 211 155.309 211C155.309 211 168.619 223.751 168.619 233.775Z"
                fill="#00C066" />
            <path
                d="M154.825 245.765L154.961 237.376L160.634 226.998L154.982 236.06L155.044 232.288L158.953 224.78L155.06 231.29L155.17 224.506L159.356 218.529L155.187 223.44L155.256 211L154.823 227.468L154.859 226.788L150.602 220.273L154.791 228.092L154.394 235.669L154.382 235.468L149.475 228.611L154.367 236.178L154.318 237.126L154.309 237.14L154.313 237.218L153.307 256.44H154.651L154.812 246.511L159.693 238.963L154.825 245.765Z"
                fill="#3F3D56" />
            <path
                d="M1354 220.228C1354 230.251 1348.04 233.751 1340.69 233.751C1333.34 233.751 1327.38 230.251 1327.38 220.228C1327.38 210.204 1340.69 197.453 1340.69 197.453C1340.69 197.453 1354 210.204 1354 220.228Z"
                fill="#00C066" />
            <path
                d="M1340.21 232.218L1340.34 223.829L1346.01 213.451L1340.36 222.513L1340.42 218.741L1344.33 211.233L1340.44 217.743V217.743L1340.55 210.959L1344.74 204.981L1340.57 209.892L1340.64 197.453L1340.2 213.92L1340.24 213.241L1335.98 206.726L1340.17 214.545L1339.78 222.122L1339.76 221.921L1334.86 215.064L1339.75 222.631L1339.7 223.579L1339.69 223.593L1339.69 223.671L1338.69 242.893H1340.03L1340.19 232.964L1345.07 225.416L1340.21 232.218Z"
                fill="#3F3D56" />
            <path d="M85.0002 256.111H170.333V256.446H85.0002V256.111Z" fill="#3F3D56" />
            <path d="M-5 252H80V253H-5V252Z" fill="#3F3D56" fill-opacity="0.5" />
            <path
                d="M109.375 241.991C109.413 242.533 109.473 243.14 109.566 243.777L107.89 241.918L107.881 241.95C107.984 241.502 108.149 241.072 108.371 240.67L108.361 240.7L109.375 241.991Z"
                fill="#00C066" />
            <path
                d="M109.369 241.896L108.386 240.645C108.595 240.263 108.897 239.941 109.265 239.708C109.283 239.698 109.301 239.687 109.319 239.677C109.314 239.825 109.288 240.692 109.369 241.896Z"
                fill="#00C066" />
            <path
                d="M110.255 246.799C110.298 246.93 110.343 247.059 110.389 247.186L107.921 245.739L107.917 245.775C107.866 245.55 107.823 245.325 107.789 245.1L110.253 246.815L110.255 246.799Z"
                fill="#00C066" />
            <path
                d="M109.912 245.584L107.689 243.751L107.683 243.785C107.675 243.179 107.739 242.574 107.873 241.983L109.581 243.877C109.671 244.474 109.781 245.043 109.912 245.584Z"
                fill="#00C066" />
            <path
                d="M109.619 243.841L112.279 240.873L112.265 240.84C112.515 241.192 112.729 241.568 112.903 241.963L109.868 245.195C109.764 244.723 109.683 244.266 109.619 243.841Z"
                fill="#00C066" />
            <path d="M112.932 242.03L112.932 242.031C112.927 242.019 112.922 242.007 112.918 241.996L112.932 242.03Z"
                fill="#00C066" />
            <path
                d="M109.886 245.273L112.932 242.03C112.983 242.148 113.033 242.269 113.08 242.394L109.966 245.616C109.938 245.501 109.911 245.387 109.886 245.273Z"
                fill="#00C066" />
            <path d="M113.08 242.394L113.094 242.428C113.089 242.417 113.084 242.406 113.08 242.394L113.08 242.394Z"
                fill="#00C066" />
            <path
                d="M107.782 245.057C107.721 244.649 107.688 244.237 107.683 243.825L109.936 245.683C110.025 246.043 110.124 246.39 110.231 246.722L107.787 245.021L107.782 245.057Z"
                fill="#00C066" />
            <path
                d="M113.484 245.288L111.018 248.505C110.815 248.114 110.636 247.71 110.482 247.297L113.491 244.137C113.521 244.532 113.524 244.929 113.501 245.324L113.484 245.288Z"
                fill="#00C066" />
            <path
                d="M109.364 239.675L109.342 239.665C109.882 239.376 110.467 239.407 111.027 239.7L109.412 241.893C109.325 240.592 109.364 239.688 109.364 239.675Z"
                fill="#00C066" />
            <path
                d="M110.469 247.401C110.611 247.773 110.772 248.137 110.953 248.491L108.473 247.207L108.471 247.243C108.284 246.927 108.138 246.589 108.036 246.237C107.996 246.098 107.96 245.959 107.928 245.82L110.425 247.284C110.44 247.323 110.454 247.363 110.469 247.401Z"
                fill="#00C066" />
            <path
                d="M109.419 241.99L111.071 239.747L111.055 239.715C111.528 239.988 111.934 240.363 112.245 240.812L109.607 243.756C109.515 243.126 109.456 242.526 109.419 241.99Z"
                fill="#00C066" />
            <path
                d="M110.455 247.225C110.271 246.723 110.114 246.212 109.985 245.693L113.107 242.463C113.181 242.665 113.249 242.875 113.311 243.093C113.398 243.405 113.455 243.725 113.483 244.048L110.457 247.226L110.455 247.225Z"
                fill="#00C066" />
            <path
                d="M107.249 250.71C107.624 251.103 108.057 251.532 108.535 251.964L106.059 251.601L106.072 251.631C105.866 251.221 105.718 250.784 105.634 250.333L105.644 250.362L107.249 250.71Z"
                fill="#00C066" />
            <path
                d="M105.708 249.022C105.715 249.002 105.723 248.983 105.73 248.964C105.82 249.081 106.354 249.765 107.183 250.641L105.629 250.304C105.546 249.877 105.574 249.436 105.708 249.022Z"
                fill="#00C066" />
            <path
                d="M110.993 253.852C111.11 253.925 111.227 253.996 111.343 254.065L108.519 254.524L108.54 254.554C108.357 254.414 108.18 254.268 108.01 254.117L111.002 253.866L110.993 253.852Z"
                fill="#00C066" />
            <path
                d="M109.954 253.135L107.073 253.141L107.09 253.171C106.697 252.709 106.361 252.203 106.087 251.662L108.611 252.031C109.061 252.434 109.509 252.802 109.954 253.135Z"
                fill="#00C066" />
            <path
                d="M110.926 253.808L107.959 254.057L107.978 254.087C107.671 253.812 107.383 253.516 107.116 253.202L110.036 253.196C110.334 253.416 110.631 253.621 110.926 253.808Z"
                fill="#00C066" />
            <path
                d="M114.559 255.277C114.538 255.255 114.516 255.232 114.494 255.21C113.889 255.113 113.298 254.944 112.734 254.707L112.653 252.568C112.629 252.514 112.606 252.459 112.583 252.404L112.669 254.68C112.263 254.507 111.868 254.311 111.486 254.091L111.761 250.116C111.74 250.105 111.719 250.094 111.697 250.082L111.422 254.052L111.419 254.052C110.957 253.783 110.51 253.49 110.08 253.172L110.38 249.261C110.359 249.245 110.338 249.23 110.317 249.214L110.017 253.125C109.921 253.055 109.828 252.984 109.736 252.913L109.983 248.953C109.962 248.936 109.941 248.918 109.92 248.9L109.672 252.863C109.291 252.566 108.937 252.266 108.617 251.979L108.773 247.997L108.74 247.98C108.851 248.009 108.963 248.043 109.077 248.081C108.864 247.837 108.672 247.576 108.504 247.3L111.008 248.595C111.181 248.924 111.376 249.242 111.591 249.545C111.636 249.588 111.681 249.63 111.725 249.674L111.722 249.722C111.742 249.748 111.762 249.776 111.783 249.802L111.788 249.738C111.819 249.77 111.85 249.805 111.881 249.838C111.564 249.442 111.286 249.017 111.05 248.567L113.498 245.374C113.481 245.659 113.453 245.947 113.417 246.232C113.645 245.862 113.921 245.525 114.238 245.229L114.219 245.254L114.784 246.795C114.653 247.323 114.523 247.918 114.414 248.553L113.409 246.299C113.404 246.334 113.399 246.369 113.395 246.404L114.397 248.653C114.298 249.248 114.227 249.823 114.184 250.378L112.981 248.488C112.974 248.515 112.967 248.542 112.96 248.569L114.177 250.48C114.15 250.85 114.137 251.21 114.136 251.559L112.664 249.618C112.656 249.643 112.649 249.668 112.641 249.693L114.128 251.655L114.135 251.64C114.136 251.778 114.138 251.914 114.143 252.049L112.483 250.181C112.474 250.207 112.466 250.231 112.459 250.252L114.147 252.154C114.149 252.195 114.15 252.237 114.152 252.279C114.172 252.676 114.214 253.072 114.276 253.464L114.116 253.302C114.146 253.365 114.176 253.427 114.205 253.488L114.296 253.581C114.306 253.641 114.318 253.699 114.33 253.758C114.363 253.832 114.396 253.904 114.427 253.974C114.397 253.84 114.369 253.704 114.345 253.567L117.66 251.287C116.795 253.499 115.166 255.604 115.062 255.738C114.977 255.58 114.901 255.417 114.83 255.251C114.809 255.249 114.789 255.247 114.768 255.245C114.777 255.265 114.786 255.285 114.794 255.306C114.805 255.307 114.815 255.308 114.825 255.309C114.817 255.312 114.808 255.314 114.799 255.317C114.849 255.433 114.9 255.547 114.956 255.657C114.883 255.592 114.773 255.489 114.641 255.358C113.862 255.557 111.762 255.983 109.964 255.354L112.719 254.755C113.308 255.005 113.927 255.18 114.559 255.277ZM112.624 251.791L112.558 251.724L112.561 251.824L112.627 251.891L112.624 251.791Z"
                fill="#00C066" />
            <path
                d="M105.763 248.933L105.74 248.94C105.972 248.373 106.442 248.024 107.06 247.892L107.215 250.611C106.318 249.664 105.771 248.944 105.763 248.933Z"
                fill="#00C066" />
            <path
                d="M111.542 254.179C111.888 254.375 112.245 254.552 112.61 254.709L109.881 255.303L109.902 255.332C109.557 255.208 109.229 255.041 108.925 254.834C108.807 254.753 108.69 254.668 108.576 254.582L111.434 254.117C111.47 254.138 111.506 254.159 111.542 254.179Z"
                fill="#00C066" />
            <path
                d="M108.553 251.922C108.081 251.495 107.653 251.071 107.282 250.682L107.123 247.9L107.091 247.885C107.63 247.794 108.182 247.824 108.708 247.972L108.553 251.922Z"
                fill="#00C066" />
            <path
                d="M114.26 245.209C114.577 244.911 114.964 244.698 115.385 244.59C115.406 244.586 115.426 244.582 115.446 244.578C115.396 244.716 115.103 245.533 114.808 246.702L114.26 245.209Z"
                fill="#00C066" />
            <path
                d="M114.445 248.63L117.892 246.63L117.889 246.594C118.018 247.006 118.105 247.43 118.148 247.859L114.263 249.994C114.31 249.514 114.374 249.054 114.445 248.63Z"
                fill="#00C066" />
            <path d="M118.183 248.323L118.186 248.361C118.185 248.348 118.184 248.336 118.183 248.324L118.183 248.323Z"
                fill="#00C066" />
            <path d="M118.155 247.932L118.155 247.932C118.153 247.92 118.153 247.907 118.152 247.895L118.155 247.932Z"
                fill="#00C066" />
            <path
                d="M114.255 250.075L118.155 247.932C118.167 248.06 118.177 248.19 118.183 248.324L114.226 250.426C114.235 250.308 114.244 250.191 114.255 250.075Z"
                fill="#00C066" />
            <path
                d="M114.197 252.184L118.035 250.108C117.942 250.493 117.822 250.871 117.678 251.24L117.673 251.201L114.333 253.498C114.262 253.063 114.216 252.624 114.197 252.184Z"
                fill="#00C066" />
            <path
                d="M115.49 244.589L115.472 244.573C116.075 244.465 116.621 244.676 117.064 245.127L114.85 246.714C115.17 245.449 115.485 244.601 115.49 244.589Z"
                fill="#00C066" />
            <path
                d="M114.826 246.808L117.091 245.185L117.086 245.15C117.451 245.556 117.722 246.038 117.878 246.562L114.459 248.545C114.567 247.918 114.696 247.33 114.826 246.808Z"
                fill="#00C066" />
            <path
                d="M114.194 252.106C114.174 251.572 114.183 251.038 114.22 250.505L118.187 248.397C118.196 248.612 118.196 248.833 118.187 249.059C118.173 249.383 118.129 249.705 118.056 250.021L114.196 252.108L114.194 252.106Z"
                fill="#00C066" />
            <path
                d="M114.441 240.236C114.12 239.676 113.954 239.041 113.96 238.395C113.96 236.732 114.99 235.383 116.261 235.383C117.532 235.383 118.562 236.732 118.562 238.395C118.569 239.041 118.403 239.676 118.082 240.236C118.397 240.799 118.562 241.432 118.562 242.077C118.562 242.722 118.397 243.355 118.082 243.918C118.397 244.48 118.562 245.114 118.562 245.759C118.562 246.403 118.397 247.037 118.082 247.599C118.397 248.162 118.562 248.796 118.562 249.44C118.562 250.085 118.397 250.719 118.082 251.281C118.403 251.841 118.569 252.477 118.562 253.122C118.562 254.786 117.532 256.134 116.261 256.134C114.99 256.134 113.96 254.786 113.96 253.122C113.954 252.477 114.12 251.841 114.441 251.281C114.126 250.719 113.96 250.085 113.96 249.44C113.96 248.796 114.126 248.162 114.441 247.599C114.126 247.037 113.96 246.403 113.96 245.759C113.96 245.114 114.126 244.48 114.441 243.918C114.126 243.355 113.96 242.722 113.96 242.077C113.96 241.432 114.126 240.799 114.441 240.236Z"
                fill="#3F3D56" />
            <path
                d="M116.261 237.726C114.99 237.726 113.96 236.377 113.96 234.713C113.96 233.05 114.99 231.701 116.261 231.701C117.532 231.701 118.562 233.05 118.562 234.713C118.562 236.377 117.532 237.726 116.261 237.726Z"
                fill="#3F3D56" />
            <path
                d="M116.261 234.044C114.99 234.044 113.96 232.695 113.96 231.032C113.96 229.368 114.99 228.02 116.261 228.02C117.532 228.02 118.562 229.368 118.562 231.032C118.562 232.695 117.532 234.044 116.261 234.044Z"
                fill="#3F3D56" />
            <path
                d="M107.647 205.837C107.333 205.437 107.047 205.016 106.79 204.576L112.837 203.583L106.297 203.631C105.67 202.267 105.328 200.788 105.292 199.286C105.256 197.785 105.526 196.292 106.087 194.898L114.86 199.449L106.769 193.502C107.527 192.192 108.547 191.052 109.764 190.154C110.982 189.255 112.372 188.617 113.847 188.279C115.322 187.941 116.851 187.91 118.338 188.188C119.826 188.467 121.24 189.049 122.493 189.898C123.746 190.747 124.81 191.844 125.62 193.123C126.431 194.401 126.969 195.832 127.201 197.328C127.434 198.823 127.356 200.35 126.973 201.814C126.59 203.278 125.909 204.648 124.974 205.837C125.464 206.46 125.885 207.134 126.231 207.847L118.382 211.925L126.751 209.116C127.339 210.853 127.484 212.709 127.173 214.516C126.863 216.324 126.107 218.025 124.974 219.467C126.253 221.092 127.048 223.045 127.269 225.102C127.491 227.158 127.129 229.236 126.225 231.096C125.321 232.957 123.912 234.526 122.159 235.623C120.406 236.721 118.379 237.303 116.311 237.303C114.242 237.303 112.215 236.721 110.462 235.623C108.709 234.526 107.3 232.957 106.396 231.096C105.492 229.236 105.131 227.158 105.352 225.102C105.573 223.045 106.369 221.092 107.647 219.467C106.119 217.524 105.289 215.124 105.289 212.652C105.289 210.18 106.119 207.78 107.647 205.837V205.837Z"
                fill="#F2F2F2" />
            <path
                d="M127.333 212.652C127.336 215.124 126.505 217.526 124.974 219.467C126.253 221.092 127.048 223.045 127.269 225.102C127.491 227.158 127.129 229.236 126.225 231.096C125.321 232.957 123.912 234.526 122.159 235.623C120.406 236.721 118.379 237.303 116.311 237.303C114.242 237.303 112.215 236.721 110.462 235.623C108.709 234.526 107.3 232.957 106.396 231.096C105.492 229.236 105.131 227.158 105.352 225.102C105.573 223.045 106.369 221.092 107.647 219.467C106.17 217.591 127.333 211.415 127.333 212.652Z"
                fill="#F2F2F2" />
            <path
                d="M107.647 205.837C107.333 205.437 107.047 205.016 106.79 204.576L112.837 203.583L106.297 203.631C105.67 202.267 105.328 200.788 105.292 199.286C105.256 197.785 105.526 196.292 106.087 194.898L114.86 199.449L106.769 193.502C107.527 192.192 108.547 191.052 109.764 190.154C110.982 189.255 112.372 188.617 113.847 188.279C115.322 187.941 116.851 187.91 118.338 188.188C119.826 188.467 121.24 189.049 122.493 189.898C123.746 190.747 124.81 191.844 125.62 193.123C126.431 194.401 126.969 195.832 127.201 197.328C127.434 198.823 127.356 200.35 126.973 201.814C126.59 203.278 125.909 204.648 124.974 205.837C125.464 206.46 125.885 207.134 126.231 207.847L118.382 211.925L126.751 209.116C127.339 210.853 127.484 212.709 127.173 214.516C126.863 216.324 126.107 218.025 124.974 219.467C126.253 221.092 127.048 223.045 127.269 225.102C127.491 227.158 127.129 229.236 126.225 231.096C125.321 232.957 123.912 234.526 122.159 235.623C120.406 236.721 118.379 237.303 116.311 237.303C114.242 237.303 112.215 236.721 110.462 235.623C108.709 234.526 107.3 232.957 106.396 231.096C105.492 229.236 105.131 227.158 105.352 225.102C105.573 223.045 106.369 221.092 107.647 219.467C106.119 217.524 105.289 215.124 105.289 212.652C105.289 210.18 106.119 207.78 107.647 205.837V205.837Z"
                fill="#00C066" />
            <path opacity="0.1"
                d="M127.333 212.652C127.336 215.124 126.505 217.526 124.974 219.467C126.253 221.092 127.048 223.045 127.269 225.102C127.491 227.158 127.129 229.236 126.225 231.096C125.321 232.957 123.912 234.526 122.159 235.623C120.406 236.721 118.379 237.303 116.311 237.303C114.242 237.303 112.215 236.721 110.462 235.623C108.709 234.526 107.3 232.957 106.396 231.096C105.492 229.236 105.131 227.158 105.352 225.102C105.573 223.045 106.369 221.092 107.647 219.467C106.17 217.591 127.333 211.415 127.333 212.652Z"
                fill="black" />
            <g opacity="0.2" clip-path="url(#clip6_28_850)">
                <path
                    d="M879.394 237.132C879.066 239.669 877.859 241.991 876.572 244.227C876.53 244.303 876.486 244.378 876.441 244.454H863.063C862.793 244.385 862.525 244.309 862.259 244.227C860.748 243.773 859.322 243.08 858.035 242.176C853.114 238.676 851.22 232.063 852.075 226.138C852.607 222.456 854.244 218.697 857.432 216.715C859.115 215.666 861.277 215.325 863.215 215.715C863.266 215.724 863.316 215.735 863.368 215.745C865.035 216.116 866.52 217.036 867.365 218.519C868.885 221.184 867.98 224.484 867.233 227.45C866.488 230.416 866.084 233.965 868.246 236.153C867.532 234.079 868.237 231.605 869.942 230.203C871.23 229.145 873.024 228.749 874.66 229.077C874.816 229.11 874.971 229.148 875.123 229.193C875.49 229.299 875.844 229.446 876.178 229.629C878.728 231.035 879.761 234.272 879.394 237.132Z"
                    fill="#F2F2F2" />
                <path
                    d="M871.462 244.227C871.832 244.312 872.204 244.387 872.578 244.454H870.556C870.291 244.384 870.027 244.309 869.766 244.227C869.191 244.05 868.626 243.846 868.069 243.617C865.835 242.692 863.778 241.303 862.222 239.456C861.46 238.561 860.839 237.558 860.377 236.482C859.877 235.266 859.559 233.984 859.433 232.677C859.151 229.995 859.439 227.24 859.977 224.606C860.531 221.876 861.427 219.225 862.643 216.712C862.789 216.411 862.94 216.112 863.097 215.815C863.107 215.79 863.124 215.768 863.144 215.751C863.165 215.734 863.189 215.721 863.215 215.715C863.268 215.704 863.323 215.715 863.368 215.745C863.422 215.776 863.462 215.826 863.48 215.884C863.498 215.943 863.492 216.006 863.464 216.061C862.21 218.474 861.26 221.029 860.634 223.67C860.021 226.245 859.674 228.941 859.792 231.589C859.905 234.064 860.56 236.498 862.047 238.522C863.404 240.369 865.278 241.826 867.352 242.818C868.664 243.438 870.043 243.91 871.462 244.227Z"
                    fill="white" />
                <path
                    d="M875.901 244.454H875.305C875.238 244.379 875.173 244.303 875.11 244.227C873.752 242.598 872.831 240.657 872.434 238.584C871.952 235.997 872.327 233.326 873.504 230.966C873.832 230.304 874.219 229.672 874.66 229.077C874.816 229.11 874.971 229.148 875.123 229.193C873.963 230.709 873.183 232.475 872.847 234.345C872.546 236.097 872.646 237.894 873.139 239.604C873.632 241.313 874.505 242.893 875.695 244.227C875.762 244.303 875.831 244.379 875.901 244.454Z"
                    fill="white" />
                <path
                    d="M929.624 242.522C929.711 243.191 930.029 243.804 930.369 244.394C930.38 244.414 930.391 244.434 930.403 244.454H933.934C934.005 244.436 934.076 244.416 934.146 244.394C934.545 244.274 934.921 244.092 935.261 243.853C936.56 242.929 937.06 241.184 936.834 239.62C936.693 238.648 936.261 237.656 935.42 237.133C934.963 236.858 934.418 236.764 933.894 236.869C933.881 236.872 933.867 236.875 933.853 236.877C933.635 236.919 933.428 237.006 933.247 237.132C933.065 237.258 932.912 237.421 932.799 237.609C932.397 238.313 932.636 239.184 932.833 239.966C933.03 240.749 933.137 241.686 932.566 242.263C932.65 242.022 932.667 241.763 932.615 241.513C932.564 241.263 932.446 241.031 932.274 240.84C932.101 240.65 931.881 240.509 931.635 240.431C931.388 240.353 931.126 240.341 930.873 240.396C930.832 240.405 930.791 240.414 930.751 240.426C930.654 240.454 930.561 240.493 930.473 240.542C929.8 240.913 929.527 241.767 929.624 242.522Z"
                    fill="#F2F2F2" />
                <path
                    d="M931.718 244.394C931.62 244.417 931.522 244.436 931.423 244.454H931.957C932.027 244.435 932.096 244.416 932.165 244.394C932.317 244.347 932.466 244.294 932.613 244.233C933.209 243.994 933.738 243.618 934.156 243.135C934.357 242.899 934.521 242.634 934.643 242.35C934.775 242.029 934.859 241.691 934.892 241.346C934.953 240.633 934.904 239.915 934.749 239.216C934.602 238.495 934.366 237.795 934.045 237.132C934.006 237.053 933.967 236.974 933.925 236.896C933.922 236.889 933.918 236.883 933.913 236.879C933.907 236.874 933.901 236.871 933.894 236.869C933.88 236.866 933.865 236.869 933.854 236.877C933.839 236.885 933.829 236.898 933.824 236.914C933.819 236.929 933.821 236.946 933.828 236.961C934.159 237.597 934.41 238.272 934.575 238.969C934.745 239.652 934.82 240.355 934.797 241.059C934.785 241.713 934.578 242.349 934.202 242.888C933.837 243.374 933.356 243.763 932.802 244.022C932.456 244.186 932.092 244.31 931.718 244.394Z"
                    fill="white" />
                <path
                    d="M930.546 244.454H930.703C930.721 244.434 930.738 244.414 930.755 244.394C931.113 243.964 931.356 243.452 931.461 242.905C931.588 242.222 931.489 241.517 931.179 240.894C931.092 240.719 930.99 240.553 930.873 240.396C930.832 240.404 930.791 240.414 930.751 240.426C931.057 240.826 931.263 241.292 931.352 241.786C931.431 242.249 931.405 242.723 931.275 243.174C931.145 243.625 930.914 244.042 930.6 244.394C930.583 244.414 930.564 244.434 930.546 244.454Z"
                    fill="white" />
                <path
                    d="M897.801 227.146H886.751L886.633 223.793C886.628 223.648 886.655 223.503 886.712 223.369C886.769 223.235 886.855 223.115 886.964 223.016C887.072 222.918 887.201 222.844 887.342 222.8C887.482 222.756 887.63 222.742 887.777 222.759L894.207 223.537H894.208C895.161 223.539 896.075 223.914 896.748 224.58C897.422 225.246 897.8 226.149 897.801 227.09V227.146Z"
                    fill="#00C066" />
                <path
                    d="M892.876 215.252H885.169C885.066 215.252 884.965 215.272 884.87 215.311C884.775 215.349 884.689 215.406 884.617 215.478C884.544 215.549 884.487 215.634 884.448 215.728C884.408 215.821 884.388 215.921 884.388 216.022V223.629C884.388 223.73 884.408 223.83 884.448 223.924C884.487 224.017 884.544 224.102 884.617 224.174C884.689 224.245 884.775 224.302 884.87 224.341C884.965 224.379 885.066 224.399 885.169 224.399H892.876C892.978 224.399 893.08 224.379 893.174 224.341C893.269 224.302 893.355 224.245 893.427 224.174C893.5 224.102 893.557 224.017 893.597 223.924C893.636 223.83 893.656 223.73 893.656 223.629V216.022C893.656 215.921 893.636 215.821 893.597 215.728C893.557 215.634 893.5 215.549 893.427 215.478C893.355 215.406 893.269 215.349 893.174 215.311C893.08 215.272 892.978 215.252 892.876 215.252Z"
                    fill="#CCCCCC" />
                <path
                    d="M891.14 220.94L887.501 221.639C887.285 221.681 887.061 221.636 886.879 221.514C886.697 221.393 886.571 221.205 886.528 220.993L886.249 219.575C886.207 219.362 886.253 219.141 886.375 218.961C886.498 218.781 886.688 218.657 886.904 218.615L890.543 217.916C890.759 217.875 890.982 217.92 891.165 218.041C891.347 218.162 891.473 218.35 891.515 218.563L891.795 219.98C891.837 220.193 891.791 220.414 891.668 220.594C891.546 220.774 891.355 220.898 891.14 220.94Z"
                    fill="#3F3D56" />
                <path
                    d="M890.412 219.265L887.635 219.799C887.584 219.809 887.531 219.798 887.488 219.77C887.445 219.741 887.416 219.697 887.406 219.647C887.396 219.597 887.407 219.545 887.436 219.502C887.465 219.46 887.509 219.431 887.56 219.421L890.337 218.887C890.388 218.877 890.441 218.888 890.483 218.916C890.526 218.945 890.556 218.989 890.566 219.039C890.576 219.089 890.565 219.141 890.536 219.184C890.507 219.226 890.462 219.255 890.412 219.265Z"
                    fill="white" />
                <path
                    d="M889.872 220.056L888.436 220.332C888.385 220.341 888.332 220.331 888.289 220.302C888.246 220.274 888.217 220.23 888.207 220.18C888.197 220.129 888.208 220.077 888.236 220.035C888.265 219.993 888.31 219.963 888.361 219.954L889.797 219.678C889.822 219.673 889.848 219.673 889.873 219.678C889.899 219.683 889.922 219.693 889.944 219.707C889.965 219.721 889.983 219.739 889.997 219.76C890.011 219.781 890.021 219.805 890.026 219.83C890.031 219.855 890.031 219.88 890.026 219.905C890.021 219.93 890.011 219.953 889.996 219.974C889.982 219.995 889.964 220.013 889.942 220.027C889.921 220.041 889.897 220.051 889.872 220.056Z"
                    fill="white" />
                <path
                    d="M893.656 216.022V217.033H884.388V216.022C884.388 215.921 884.408 215.821 884.448 215.728C884.487 215.634 884.544 215.549 884.617 215.478C884.689 215.406 884.775 215.349 884.87 215.311C884.965 215.272 885.066 215.252 885.169 215.252H892.876C892.978 215.252 893.08 215.272 893.174 215.311C893.269 215.349 893.355 215.406 893.427 215.478C893.5 215.549 893.557 215.634 893.597 215.728C893.636 215.821 893.656 215.921 893.656 216.022Z"
                    fill="#B3B3B3" />
                <path
                    d="M912.163 217.35C912.109 217.18 912.019 217.023 911.897 216.891C911.775 216.759 911.626 216.654 911.459 216.585C911.292 216.516 911.112 216.484 910.932 216.492C910.751 216.499 910.574 216.545 910.414 216.627L899.811 212.872L899.344 215.487L909.913 218.355C910.07 218.612 910.318 218.804 910.608 218.893C910.899 218.982 911.213 218.963 911.49 218.839C911.767 218.715 911.989 218.495 912.113 218.221C912.237 217.946 912.255 217.636 912.163 217.35Z"
                    fill="#FFB8B8" />
                <path opacity="0.2"
                    d="M912.163 217.35C912.109 217.18 912.019 217.023 911.897 216.891C911.775 216.759 911.626 216.654 911.459 216.585C911.292 216.516 911.112 216.484 910.932 216.492C910.751 216.499 910.574 216.545 910.414 216.627L899.811 212.872L899.344 215.487L909.913 218.355C910.07 218.612 910.318 218.804 910.608 218.893C910.899 218.982 911.213 218.963 911.49 218.839C911.767 218.715 911.989 218.495 912.113 218.221C912.237 217.946 912.255 217.636 912.163 217.35Z"
                    fill="black" />
                <path
                    d="M901.693 213.349L900.692 215.93C900.663 216.004 900.619 216.07 900.562 216.125C900.505 216.18 900.437 216.223 900.362 216.249C900.287 216.276 900.207 216.286 900.128 216.28C900.048 216.273 899.971 216.25 899.902 216.212L897.468 214.86C897.088 214.714 896.783 214.425 896.618 214.057C896.454 213.689 896.444 213.271 896.59 212.896C896.737 212.52 897.029 212.218 897.402 212.054C897.774 211.891 898.197 211.88 898.578 212.024L901.295 212.619C901.373 212.636 901.446 212.669 901.51 212.717C901.573 212.764 901.626 212.824 901.663 212.894C901.701 212.963 901.723 213.039 901.728 213.118C901.733 213.196 901.721 213.275 901.693 213.349Z"
                    fill="#00C066" />
                <path
                    d="M912.997 219.74L909.198 221.445L909.697 223.298C910.66 226.877 910.916 230.606 910.45 234.28L913.228 234.853L915.53 229.058L914.724 222.468L912.997 219.74Z"
                    fill="#00C066" />
                <path
                    d="M920.452 228.319C917.956 228.319 915.921 230.11 915.823 232.353H925.081C924.982 230.11 922.948 228.319 920.452 228.319Z"
                    fill="#3F3D56" />
                <path
                    d="M918.509 228.706C918.379 218.582 912.537 219.513 912.537 219.513C912.537 219.513 912.646 222.664 912.699 222.762C916.421 229.714 910.278 237.864 902.457 236.364C902.309 236.336 902.168 236.308 902.032 236.278C901.041 236.074 900.166 235.505 899.585 234.687C899.004 233.869 898.761 232.863 898.905 231.874C899.675 225.768 895.843 225.876 895.843 225.876H890.241L887.331 223.292C887.228 223.201 887.104 223.136 886.97 223.102C886.836 223.069 886.696 223.069 886.562 223.102C886.428 223.135 886.304 223.199 886.201 223.29C886.098 223.381 886.019 223.496 885.971 223.624L885.597 224.626C885.597 224.626 880.071 225.195 880.531 230.535H882.24C882.236 230.687 882.242 230.839 882.258 230.989L895.009 230.887C895.756 230.881 896.416 231.479 896.419 232.217C896.42 232.396 896.384 232.574 896.313 232.74C896.243 232.905 896.139 233.055 896.009 233.18C895.878 233.305 895.723 233.403 895.554 233.468C895.384 233.533 895.203 233.563 895.021 233.557L892.965 233.489C892.332 236.273 893.886 238.148 895.599 239.327C897.211 240.421 899.124 241.001 901.081 240.989H906.665C913.918 240.989 915.185 234.966 915.185 234.966C918.984 233.376 918.509 228.706 918.509 228.706Z"
                    fill="#3F3D56" />
                <path
                    d="M920.107 244.284C923.683 244.284 926.582 241.422 926.582 237.892C926.582 234.362 923.683 231.501 920.107 231.501C916.53 231.501 913.631 234.362 913.631 237.892C913.631 241.422 916.53 244.284 920.107 244.284Z"
                    fill="#3F3D56" />
                <path
                    d="M920.107 239.459C920.983 239.459 921.694 238.757 921.694 237.892C921.694 237.027 920.983 236.326 920.107 236.326C919.23 236.326 918.519 237.027 918.519 237.892C918.519 238.757 919.23 239.459 920.107 239.459Z"
                    fill="white" />
                <path
                    d="M887.41 244.284C891.527 244.284 894.865 240.99 894.865 236.926C894.865 232.863 891.527 229.569 887.41 229.569C883.293 229.569 879.956 232.863 879.956 236.926C879.956 240.99 883.293 244.284 887.41 244.284Z"
                    fill="#3F3D56" />
                <path
                    d="M887.41 238.73C888.419 238.73 889.237 237.922 889.237 236.926C889.237 235.93 888.419 235.123 887.41 235.123C886.401 235.123 885.583 235.93 885.583 236.926C885.583 237.922 886.401 238.73 887.41 238.73Z"
                    fill="white" />
                <path
                    d="M909.209 221.948L907.842 218.284C907.771 218.093 907.738 217.89 907.747 217.687C907.755 217.483 907.804 217.284 907.89 217.099C907.976 216.914 908.099 216.748 908.25 216.61C908.402 216.472 908.58 216.365 908.773 216.294L912.692 214.87C913.032 214.747 913.394 214.69 913.757 214.705C914.119 214.719 914.476 214.803 914.805 214.954C915.134 215.104 915.431 215.316 915.677 215.579C915.923 215.843 916.114 216.151 916.239 216.487C916.352 216.789 916.41 217.108 916.41 217.429C916.408 217.837 916.315 218.24 916.136 218.609C915.957 218.977 915.697 219.301 915.375 219.557C915.143 219.741 914.881 219.887 914.601 219.988L909.209 221.948Z"
                    fill="#3F3D56" />
                <path
                    d="M916.352 217.429C916.352 217.829 916.261 218.224 916.085 218.585C915.91 218.945 915.655 219.263 915.339 219.513C914.854 219.387 914.403 219.158 914.017 218.843C913.631 218.527 913.319 218.132 913.103 217.685C912.888 217.239 912.773 216.751 912.767 216.257C912.762 215.762 912.865 215.272 913.071 214.821C913.466 214.736 913.875 214.739 914.268 214.831C914.662 214.923 915.029 215.1 915.344 215.35C915.658 215.601 915.912 215.917 916.087 216.277C916.261 216.637 916.352 217.031 916.352 217.429Z"
                    fill="#00C066" />
                <path
                    d="M881.51 231.273C882.4 231.273 883.122 230.409 883.122 229.342C883.122 228.275 882.4 227.41 881.51 227.41C880.62 227.41 879.898 228.275 879.898 229.342C879.898 230.409 880.62 231.273 881.51 231.273Z"
                    fill="#00C066" />
                <path d="M902.816 236.179H904.227L904.899 232.566L902.815 232.567L902.816 236.179Z" fill="#FFB8B8" />
                <path
                    d="M902.456 235.724L905.235 235.724H905.235C905.468 235.724 905.698 235.77 905.913 235.857C906.128 235.945 906.323 236.074 906.488 236.236C906.652 236.399 906.783 236.591 906.872 236.804C906.961 237.016 907.007 237.243 907.007 237.473V237.529L902.456 237.53L902.456 235.724Z"
                    fill="#2F2E41" />
                <path
                    d="M904.454 234.697C904.438 234.697 904.421 234.696 904.404 234.694L902.451 234.554C902.372 234.547 902.296 234.522 902.228 234.481C902.161 234.44 902.103 234.384 902.061 234.318C902.019 234.252 901.992 234.177 901.984 234.099C901.975 234.021 901.985 233.942 902.013 233.869L904.627 228.072C904.645 228.02 904.653 227.966 904.649 227.911C904.645 227.856 904.63 227.803 904.604 227.754C904.578 227.705 904.542 227.662 904.499 227.627C904.455 227.593 904.404 227.568 904.35 227.554C903.12 227.237 899.966 226.393 897.236 225.405C896.067 224.981 895.33 224.37 895.047 223.586C894.673 222.554 895.226 221.612 895.249 221.573L895.268 221.542L897.837 221.772L900.622 222.006L906.725 225.236C907.237 225.509 907.625 225.962 907.813 226.505C908.001 227.048 907.975 227.641 907.741 228.166L904.927 234.393C904.886 234.484 904.82 234.56 904.736 234.614C904.652 234.668 904.554 234.696 904.454 234.697Z"
                    fill="#2F2E41" />
                <path
                    d="M898.283 210.304C899.845 210.304 901.111 209.054 901.111 207.513C901.111 205.972 899.845 204.722 898.283 204.722C896.722 204.722 895.456 205.972 895.456 207.513C895.456 209.054 896.722 210.304 898.283 210.304Z"
                    fill="#FFB8B8" />
                <path d="M902.01 236.52H903.421L904.093 232.907L902.01 232.907L902.01 236.52Z" fill="#FFB8B8" />
                <path
                    d="M901.65 236.066L904.429 236.065H904.429C904.662 236.065 904.892 236.111 905.107 236.199C905.322 236.286 905.517 236.415 905.682 236.577C905.846 236.74 905.977 236.933 906.066 237.145C906.155 237.357 906.201 237.584 906.201 237.814V237.871L901.65 237.871L901.65 236.066Z"
                    fill="#2F2E41" />
                <path
                    d="M903.648 235.037C903.632 235.037 903.615 235.037 903.599 235.035L901.645 234.895C901.566 234.887 901.49 234.862 901.422 234.821C901.355 234.781 901.298 234.725 901.255 234.659C901.213 234.592 901.186 234.518 901.178 234.44C901.17 234.362 901.179 234.283 901.207 234.21L903.821 228.413C903.84 228.361 903.847 228.306 903.843 228.252C903.839 228.197 903.824 228.144 903.798 228.095C903.773 228.046 903.737 228.003 903.693 227.968C903.649 227.934 903.598 227.909 903.544 227.895C902.314 227.578 899.161 226.733 896.43 225.745C895.261 225.322 894.524 224.71 894.241 223.927C893.867 222.895 894.42 221.953 894.443 221.914L894.462 221.883L897.031 222.113L899.816 222.347L905.919 225.577C906.431 225.85 906.819 226.303 907.007 226.846C907.196 227.389 907.17 227.982 906.935 228.507L904.121 234.734C904.08 234.824 904.014 234.901 903.93 234.955C903.846 235.009 903.748 235.037 903.648 235.037Z"
                    fill="#2F2E41" />
                <path
                    d="M899.156 211.886L896.162 210.864C896.162 210.864 894.283 212.289 895.186 215.823C895.657 217.647 895.52 219.573 894.794 221.314C894.707 221.529 894.606 221.739 894.493 221.942C894.493 221.942 897.832 225.919 900.94 222.965L899.731 217.227C899.731 217.227 901.631 213.42 899.156 211.886Z"
                    fill="#00C066" />
                <path
                    d="M898.635 210.399C898.232 209.804 897.915 208.98 898.358 208.414C898.795 207.856 899.658 207.938 900.328 207.691C901.261 207.347 901.802 206.265 901.633 205.296C901.464 204.328 900.676 203.524 899.737 203.196C898.799 202.867 897.74 202.974 896.821 203.353C895.689 203.818 894.718 204.72 894.311 205.861C893.904 207.002 894.122 208.373 894.966 209.25C895.872 210.191 897.293 210.442 898.607 210.427"
                    fill="#2F2E41" />
                <path
                    d="M912.022 217.236C911.948 217.074 911.838 216.929 911.701 216.813C911.564 216.696 911.403 216.611 911.228 216.563C911.054 216.515 910.872 216.505 910.693 216.534C910.515 216.563 910.345 216.631 910.196 216.732L899.205 214.297L899.068 216.948L909.915 218.508C910.103 218.744 910.373 218.903 910.672 218.956C910.972 219.01 911.281 218.952 911.541 218.796C911.8 218.639 911.993 218.394 912.082 218.106C912.17 217.819 912.149 217.509 912.022 217.236Z"
                    fill="#FFB8B8" />
                <path
                    d="M901.132 214.541L900.461 217.224C900.442 217.301 900.406 217.372 900.357 217.434C900.307 217.495 900.245 217.546 900.174 217.581C900.103 217.617 900.025 217.637 899.945 217.64C899.865 217.643 899.786 217.63 899.712 217.6L897.129 216.555C896.733 216.456 896.393 216.207 896.184 215.862C895.974 215.516 895.912 215.103 896.011 214.712C896.11 214.322 896.361 213.986 896.711 213.778C897.06 213.571 897.479 213.509 897.875 213.605L900.646 213.865C900.725 213.872 900.802 213.896 900.871 213.936C900.94 213.975 901 214.029 901.046 214.093C901.092 214.157 901.123 214.23 901.138 214.307C901.153 214.385 901.151 214.464 901.132 214.541V214.541Z"
                    fill="#00C066" />
                <path
                    d="M910.752 219.343C911.198 219.343 911.558 218.987 911.558 218.547C911.558 218.108 911.198 217.752 910.752 217.752C910.307 217.752 909.947 218.108 909.947 218.547C909.947 218.987 910.307 219.343 910.752 219.343Z"
                    fill="#00C066" />
                <path
                    d="M946.441 244.34C946.441 244.371 946.429 244.399 946.407 244.421C946.385 244.442 946.356 244.454 946.326 244.454H851.115C851.085 244.454 851.055 244.442 851.034 244.421C851.012 244.399 851 244.371 851 244.34C851 244.31 851.012 244.281 851.034 244.26C851.055 244.239 851.085 244.227 851.115 244.227H946.326C946.356 244.227 946.385 244.239 946.407 244.26C946.429 244.281 946.441 244.31 946.441 244.34Z"
                    fill="#3F3D56" />
            </g>
            <g clip-path="url(#clip7_28_850)">
                <path
                    d="M1334.56 243.896L1334.87 243.89C1334.75 240.421 1334.39 236.966 1333.78 233.55C1332.46 226.238 1330.26 221.435 1327.24 219.276L1327.07 219.531C1334.11 224.575 1334.56 243.703 1334.56 243.896Z"
                    fill="#2F2E41" />
                <path
                    d="M1330.74 243.821L1331.04 243.815C1331.04 243.47 1330.85 235.328 1327.7 233.077L1327.53 233.332C1330.54 235.492 1330.74 243.738 1330.74 243.821Z"
                    fill="#2F2E41" />
                <path
                    d="M1325.33 219.56C1326.17 219.56 1326.86 218.861 1326.86 218C1326.86 217.138 1326.17 216.44 1325.33 216.44C1324.48 216.44 1323.8 217.138 1323.8 218C1323.8 218.861 1324.48 219.56 1325.33 219.56Z"
                    fill="#00C066" />
                <path
                    d="M1326.09 232.974C1326.93 232.974 1327.62 232.276 1327.62 231.414C1327.62 230.553 1326.93 229.854 1326.09 229.854C1325.24 229.854 1324.56 230.553 1324.56 231.414C1324.56 232.276 1325.24 232.974 1326.09 232.974Z"
                    fill="#00C066" />
                <path
                    d="M1331.45 220.494C1331.16 222.367 1331.91 224.042 1331.91 224.042C1331.91 224.042 1333.13 222.681 1333.41 220.808C1333.7 218.936 1332.95 217.261 1332.95 217.261C1332.95 217.261 1331.74 218.622 1331.45 220.494Z"
                    fill="#2F2E41" />
                <path
                    d="M1326.45 225.042C1328.21 225.657 1329.96 225.196 1329.96 225.196C1329.96 225.196 1328.85 223.739 1327.1 223.124C1325.34 222.509 1323.59 222.97 1323.59 222.97C1323.59 222.97 1324.69 224.427 1326.45 225.042Z"
                    fill="#2F2E41" />
                <path
                    d="M1326.4 236.922C1327.19 237.177 1328.04 237.214 1328.85 237.03C1328.34 236.359 1327.64 235.854 1326.85 235.578C1326.06 235.301 1325.2 235.263 1324.39 235.469C1324.92 236.124 1325.61 236.625 1326.4 236.922Z"
                    fill="#2F2E41" />
                <path
                    d="M1290.71 195.208L1280.85 189.979C1280.85 189.979 1277.54 186.26 1275.46 184.58C1273.38 182.9 1272.74 184.134 1272.74 184.134L1271.87 185.62L1273.98 188.617L1279.69 193.545L1289.88 197.618C1290.04 197.885 1290.27 198.099 1290.54 198.237C1290.82 198.376 1291.13 198.432 1291.43 198.399C1291.73 198.366 1292.02 198.246 1292.26 198.052C1292.5 197.858 1292.68 197.599 1292.79 197.305C1292.89 197.011 1292.9 196.693 1292.84 196.389C1292.77 196.085 1292.62 195.807 1292.4 195.587C1292.18 195.368 1291.91 195.215 1291.61 195.148C1291.31 195.081 1291 195.102 1290.71 195.208Z"
                    fill="#9F616A" />
                <path
                    d="M1265.07 190.685L1264.48 187.043L1262.84 186.622C1262.84 186.622 1261.53 186.211 1261.22 188.899C1260.92 191.587 1261.15 196.604 1261.15 196.604L1257.81 207.413C1257.53 207.545 1257.29 207.755 1257.13 208.019C1256.96 208.282 1256.87 208.588 1256.87 208.902C1256.87 209.215 1256.95 209.522 1257.12 209.788C1257.28 210.053 1257.51 210.266 1257.79 210.402C1258.07 210.537 1258.37 210.59 1258.68 210.553C1258.98 210.517 1259.27 210.393 1259.51 210.196C1259.75 209.998 1259.93 209.736 1260.03 209.439C1260.12 209.142 1260.14 208.823 1260.06 208.519L1264.45 198.286L1265.07 190.685Z"
                    fill="#9F616A" />
                <path d="M1278.7 241.803L1280.86 241.803L1281.88 233.317L1278.7 233.318L1278.7 241.803Z" fill="#9F616A" />
                <path
                    d="M1278.15 241.085L1282.4 241.084H1282.4C1283.11 241.085 1283.8 241.375 1284.31 241.893C1284.82 242.411 1285.1 243.113 1285.1 243.845V243.935L1278.15 243.935L1278.15 241.085Z"
                    fill="#2F2E41" />
                <path d="M1255.18 241.803L1257.33 241.803L1258.36 233.317L1255.18 233.318L1255.18 241.803Z"
                    fill="#9F616A" />
                <path
                    d="M1254.63 241.085L1258.87 241.084H1258.87C1259.59 241.085 1260.28 241.375 1260.79 241.893C1261.3 242.411 1261.58 243.113 1261.58 243.845V243.935L1254.63 243.935L1254.63 241.085Z"
                    fill="#2F2E41" />
                <path
                    d="M1265.82 183.409L1262.25 186.524L1265.18 196L1265.84 198.116C1265.84 198.116 1261.8 201.92 1259.3 212.547C1256.8 223.173 1252.7 237.293 1252.7 237.293L1261.34 239.816L1268.37 215.778L1276.64 234.637L1277.6 240.215L1284.96 238.001L1283.22 224.012L1274.54 199.797L1275.44 193.378C1275.44 193.378 1276.8 190.174 1274.44 186.782L1273.71 183.595L1271.06 182.931L1265.82 183.409Z"
                    fill="#2F2E41" />
                <path
                    d="M1271.77 181.716H1262.1C1261.9 181.715 1261.71 181.635 1261.56 181.491C1261.42 181.348 1261.35 181.153 1261.34 180.95V176.698C1261.34 175.187 1261.93 173.737 1262.98 172.669C1264.03 171.6 1265.45 171 1266.93 171C1268.41 171 1269.83 171.6 1270.88 172.669C1271.93 173.737 1272.52 175.187 1272.52 176.698V180.95C1272.52 181.153 1272.44 181.348 1272.3 181.491C1272.16 181.635 1271.97 181.715 1271.77 181.716Z"
                    fill="#2F2E41" />
                <path
                    d="M1271.67 179.443C1272.76 177.418 1272.03 174.88 1270.04 173.773C1268.06 172.667 1265.57 173.411 1264.49 175.435C1263.4 177.46 1264.13 179.998 1266.11 181.105C1268.1 182.211 1270.59 181.467 1271.67 179.443Z"
                    fill="#9F616A" />
                <path
                    d="M1273.84 177.123H1267.92L1267.86 176.257L1267.56 177.123H1266.65L1266.53 175.407L1265.93 177.123H1264.17V177.038C1264.17 175.843 1264.63 174.697 1265.46 173.852C1266.29 173.007 1267.41 172.532 1268.59 172.531H1269.42C1270.59 172.532 1271.71 173.007 1272.54 173.852C1273.37 174.697 1273.84 175.843 1273.84 177.038V177.123Z"
                    fill="#2F2E41" />
                <path
                    d="M1267.88 182.51C1267.83 182.509 1267.79 182.505 1267.74 182.498L1263.41 181.718V174.418H1268.18L1268.06 174.558C1266.42 176.512 1267.66 179.679 1268.54 181.393C1268.61 181.519 1268.63 181.661 1268.62 181.802C1268.61 181.944 1268.56 182.08 1268.48 182.194C1268.41 182.292 1268.32 182.371 1268.22 182.426C1268.11 182.481 1267.99 182.51 1267.88 182.51Z"
                    fill="#2F2E41" />
                <path
                    d="M1303.69 220.781L1265.74 234.468C1264.8 234.805 1263.77 234.749 1262.87 234.312C1261.97 233.875 1261.28 233.092 1260.95 232.135L1254.43 213.326C1254.1 212.369 1254.15 211.317 1254.58 210.402C1255.01 209.486 1255.78 208.781 1256.72 208.442L1294.67 194.755C1295.6 194.417 1296.63 194.474 1297.53 194.911C1298.43 195.348 1299.12 196.131 1299.45 197.087L1305.97 215.897C1306.3 216.854 1306.25 217.906 1305.82 218.821C1305.39 219.737 1304.62 220.442 1303.69 220.781Z"
                    fill="white" />
                <path
                    d="M1305.97 215.897L1306.01 215.996C1306.32 216.91 1306.27 217.915 1305.86 218.79C1305.45 219.665 1304.72 220.338 1303.82 220.661L1265.68 234.416C1264.79 234.739 1263.8 234.686 1262.95 234.268C1262.09 233.851 1261.43 233.102 1261.11 232.189L1261.08 232.089L1305.97 215.897Z"
                    fill="#F2F2F2" />
                <path
                    d="M1263.37 212.809C1260.85 214.497 1257.63 213.226 1256.5 211.375L1256.68 211.271C1258.82 209.91 1262 210.668 1263.37 212.809Z"
                    fill="#00C066" />
                <path
                    d="M1294.89 217.599C1294.27 217.821 1293.72 217.811 1293.24 217.569C1292.16 217.021 1291.66 215.398 1291.25 214.094C1291.13 213.715 1291.02 213.356 1290.9 213.064L1290.9 213.059C1290.7 212.478 1290.74 211.841 1291 211.285C1291.26 210.73 1291.72 210.302 1292.29 210.094L1297.39 208.253C1298.01 208.031 1298.56 208.041 1299.04 208.283C1300.12 208.829 1300.63 210.452 1301.04 211.756C1301.15 212.136 1301.27 212.495 1301.38 212.788C1301.58 213.37 1301.55 214.008 1301.29 214.564C1301.03 215.121 1300.56 215.55 1299.99 215.759L1294.89 217.599ZM1291.12 212.98C1291.23 213.28 1291.35 213.641 1291.47 214.024C1291.86 215.286 1292.35 216.857 1293.34 217.361C1293.77 217.577 1294.25 217.584 1294.81 217.38L1299.92 215.54C1300.43 215.352 1300.85 214.967 1301.08 214.467C1301.32 213.967 1301.35 213.393 1301.17 212.869C1301.05 212.573 1300.94 212.21 1300.82 211.826C1300.42 210.564 1299.93 208.993 1298.94 208.49C1298.51 208.275 1298.03 208.268 1297.47 208.471L1292.37 210.312C1291.86 210.5 1291.44 210.885 1291.2 211.384C1290.97 211.884 1290.94 212.457 1291.12 212.98Z"
                    fill="#3F3D56" />
                <path
                    d="M1262.31 213.417C1261.41 213.734 1260.45 213.788 1259.52 213.573C1258.17 213.27 1256.94 212.447 1256.32 211.424L1256.26 211.322L1256.54 211.159C1258.71 209.778 1261.97 210.527 1263.38 212.732L1263.44 212.829L1263.35 212.892C1263.02 213.109 1262.67 213.285 1262.31 213.417ZM1256.58 211.403C1257.19 212.327 1258.32 213.067 1259.57 213.346C1260.78 213.636 1262.06 213.426 1263.12 212.761C1261.75 210.731 1258.7 210.057 1256.66 211.357L1256.58 211.403Z"
                    fill="#3F3D56" />
                <path
                    d="M1263.64 226.917C1263.32 227.045 1262.98 227.083 1262.64 227.026C1262.3 226.969 1261.99 226.819 1261.72 226.592C1261.42 226.32 1261.19 225.972 1261.05 225.582C1260.92 225.192 1260.88 224.773 1260.95 224.366C1261.02 224.015 1261.18 223.69 1261.41 223.425C1261.64 223.161 1261.95 222.968 1262.28 222.868L1269.08 220.415C1269.41 220.278 1269.76 220.235 1270.1 220.291C1270.45 220.346 1270.77 220.498 1271.04 220.729C1271.34 221.001 1271.58 221.349 1271.71 221.739C1271.85 222.129 1271.88 222.547 1271.81 222.955C1271.68 223.671 1271.2 224.198 1270.48 224.451L1263.68 226.904C1263.67 226.908 1263.66 226.912 1263.64 226.917ZM1262.32 223.098C1262.03 223.19 1261.77 223.36 1261.57 223.591C1261.37 223.822 1261.23 224.105 1261.18 224.409C1261.11 224.776 1261.14 225.154 1261.27 225.505C1261.39 225.856 1261.6 226.169 1261.87 226.415C1262.11 226.618 1262.39 226.752 1262.7 226.799C1263 226.847 1263.32 226.808 1263.6 226.686L1270.41 224.231C1270.7 224.144 1270.97 223.974 1271.18 223.741C1271.39 223.508 1271.53 223.221 1271.59 222.911C1271.65 222.544 1271.62 222.167 1271.5 221.816C1271.38 221.464 1271.17 221.151 1270.89 220.906C1270.66 220.702 1270.37 220.569 1270.06 220.521C1269.76 220.473 1269.45 220.512 1269.16 220.633L1262.36 223.087C1262.35 223.091 1262.33 223.095 1262.32 223.098L1262.32 223.098Z"
                    fill="#3F3D56" />
                <path
                    d="M1294.94 212.065L1292.79 212.838C1292.65 212.89 1292.49 212.881 1292.36 212.815C1292.22 212.749 1292.12 212.63 1292.07 212.485C1292.02 212.34 1292.02 212.18 1292.09 212.042C1292.15 211.903 1292.27 211.796 1292.41 211.745L1294.56 210.971C1294.7 210.92 1294.86 210.929 1294.99 210.995C1295.13 211.061 1295.23 211.18 1295.28 211.325C1295.33 211.47 1295.32 211.629 1295.26 211.768C1295.19 211.907 1295.08 212.014 1294.94 212.065Z"
                    fill="#00C066" />
                <path
                    d="M1295.54 213.815L1293.4 214.588C1293.26 214.639 1293.1 214.631 1292.96 214.565C1292.83 214.498 1292.72 214.38 1292.67 214.235C1292.62 214.09 1292.63 213.93 1292.7 213.791C1292.76 213.652 1292.88 213.546 1293.02 213.494L1295.16 212.721C1295.31 212.67 1295.46 212.678 1295.6 212.745C1295.73 212.811 1295.84 212.93 1295.89 213.075C1295.94 213.22 1295.93 213.379 1295.87 213.518C1295.8 213.657 1295.68 213.763 1295.54 213.815Z"
                    fill="#00C066" />
                <path
                    d="M1296.15 215.564L1294.01 216.338C1293.93 216.363 1293.86 216.374 1293.79 216.37C1293.71 216.366 1293.64 216.347 1293.57 216.314C1293.5 216.281 1293.44 216.235 1293.39 216.179C1293.34 216.122 1293.3 216.056 1293.28 215.984C1293.25 215.912 1293.24 215.836 1293.25 215.76C1293.25 215.684 1293.27 215.61 1293.3 215.541C1293.33 215.472 1293.38 215.41 1293.44 215.36C1293.49 215.309 1293.56 215.269 1293.63 215.244L1295.77 214.471C1295.84 214.445 1295.92 214.434 1295.99 214.438C1296.06 214.442 1296.14 214.461 1296.2 214.494C1296.27 214.527 1296.33 214.573 1296.38 214.63C1296.43 214.686 1296.47 214.752 1296.5 214.824C1296.52 214.896 1296.53 214.972 1296.53 215.048C1296.52 215.124 1296.5 215.199 1296.47 215.267C1296.44 215.336 1296.4 215.398 1296.34 215.449C1296.28 215.5 1296.22 215.539 1296.15 215.564Z"
                    fill="#00C066" />
                <path
                    d="M1298.69 210.712L1296.54 211.485C1296.47 211.51 1296.4 211.521 1296.32 211.517C1296.25 211.513 1296.18 211.494 1296.11 211.462C1296.04 211.429 1295.98 211.383 1295.93 211.326C1295.88 211.269 1295.84 211.203 1295.82 211.132C1295.79 211.06 1295.78 210.984 1295.79 210.908C1295.79 210.831 1295.81 210.757 1295.84 210.688C1295.87 210.62 1295.92 210.558 1295.97 210.507C1296.03 210.456 1296.09 210.417 1296.17 210.391L1298.31 209.618C1298.45 209.567 1298.61 209.575 1298.74 209.642C1298.88 209.708 1298.98 209.827 1299.03 209.972C1299.08 210.117 1299.08 210.276 1299.01 210.415C1298.95 210.554 1298.83 210.66 1298.69 210.712Z"
                    fill="#00C066" />
                <path
                    d="M1299.29 212.461L1297.15 213.235C1297.08 213.26 1297.01 213.271 1296.93 213.267C1296.86 213.263 1296.78 213.244 1296.72 213.211C1296.65 213.178 1296.59 213.132 1296.54 213.076C1296.49 213.019 1296.45 212.953 1296.43 212.881C1296.4 212.809 1296.39 212.733 1296.39 212.657C1296.4 212.581 1296.42 212.507 1296.45 212.438C1296.48 212.369 1296.53 212.308 1296.58 212.257C1296.64 212.206 1296.7 212.167 1296.77 212.141L1298.92 211.368C1298.99 211.342 1299.06 211.332 1299.14 211.336C1299.21 211.34 1299.28 211.359 1299.35 211.391C1299.42 211.424 1299.48 211.47 1299.53 211.527C1299.58 211.583 1299.62 211.65 1299.64 211.721C1299.67 211.793 1299.68 211.869 1299.67 211.945C1299.67 212.021 1299.65 212.096 1299.62 212.165C1299.59 212.233 1299.54 212.295 1299.49 212.346C1299.43 212.397 1299.37 212.436 1299.29 212.461Z"
                    fill="#00C066" />
                <path
                    d="M1299.9 214.211L1297.76 214.984C1297.61 215.036 1297.46 215.027 1297.32 214.961C1297.19 214.895 1297.08 214.776 1297.03 214.631C1296.98 214.486 1296.99 214.327 1297.05 214.188C1297.12 214.049 1297.24 213.942 1297.38 213.891L1299.52 213.118C1299.59 213.092 1299.67 213.081 1299.74 213.085C1299.82 213.089 1299.89 213.108 1299.96 213.141C1300.02 213.174 1300.08 213.22 1300.13 213.277C1300.18 213.333 1300.22 213.399 1300.25 213.471C1300.27 213.543 1300.28 213.619 1300.28 213.695C1300.28 213.771 1300.26 213.846 1300.22 213.914C1300.19 213.983 1300.15 214.045 1300.09 214.096C1300.04 214.147 1299.97 214.186 1299.9 214.211Z"
                    fill="#00C066" />
                <path d="M1300.87 201.182L1255.98 217.374L1256.05 217.593L1300.95 201.401L1300.87 201.182Z"
                    fill="#3F3D56" />
                <path
                    d="M1303.69 220.781L1265.74 234.468C1264.8 234.805 1263.77 234.749 1262.87 234.312C1261.97 233.875 1261.28 233.092 1260.95 232.135L1254.43 213.326C1254.1 212.369 1254.15 211.317 1254.58 210.402C1255.01 209.486 1255.78 208.781 1256.72 208.442L1294.67 194.755C1295.6 194.417 1296.63 194.474 1297.53 194.911C1298.43 195.348 1299.12 196.131 1299.45 197.087L1305.97 215.897C1306.3 216.854 1306.25 217.906 1305.82 218.821C1305.39 219.737 1304.62 220.442 1303.69 220.781ZM1256.79 208.66C1255.91 208.979 1255.19 209.641 1254.79 210.501C1254.38 211.362 1254.33 212.35 1254.64 213.249L1261.16 232.058C1261.48 232.957 1262.12 233.692 1262.97 234.103C1263.81 234.513 1264.78 234.566 1265.66 234.25L1303.61 220.563C1304.49 220.244 1305.21 219.582 1305.61 218.721C1306.02 217.861 1306.07 216.873 1305.76 215.974L1299.24 197.165C1298.93 196.266 1298.28 195.531 1297.43 195.12C1296.59 194.709 1295.62 194.657 1294.74 194.973L1256.79 208.66Z"
                    fill="#3F3D56" />
                <path
                    d="M1353.85 244H1241.15C1241.11 244 1241.07 243.984 1241.04 243.954C1241.02 243.925 1241 243.885 1241 243.844C1241 243.803 1241.02 243.763 1241.04 243.734C1241.07 243.704 1241.11 243.688 1241.15 243.688H1297.5H1353.85C1353.89 243.688 1353.93 243.704 1353.96 243.734C1353.98 243.763 1354 243.803 1354 243.844C1354 243.885 1353.98 243.925 1353.96 243.954C1353.93 243.984 1353.89 244 1353.85 244Z"
                    fill="#CBCBCB" />
            </g>
            <g opacity="0.1">
                <path
                    d="M81.5 59C95.031 59 106 48.2548 106 35C106 21.7452 95.031 11 81.5 11C67.969 11 57 21.7452 57 35C57 48.2548 67.969 59 81.5 59Z"
                    fill="#EE4B6C" />
                <path d="M223.474 42.5751H194.304V17.574L223.474 42.5751Z" fill="#3F3D56" />
                <path d="M226.882 41.7566H80.1389V232.895H226.882V41.7566Z" fill="#E6E6E6" />
                <path d="M112.043 55.1582H94.7793V89.4551H112.043V55.1582Z" fill="white" />
                <path d="M138.747 55.1582H121.483V89.4551H138.747V55.1582Z" fill="white" />
                <path d="M109.768 103.77H92.5039V138.066H109.768V103.77Z" fill="white" />
                <path d="M138.747 103.77H121.483V138.066H138.747V103.77Z" fill="white" />
                <path d="M109.768 148.748H92.5039V183.045H109.768V148.748Z" fill="white" />
                <path d="M138.097 148.135H120.833V182.432H138.097V148.135Z" fill="white" />
                <path d="M163.188 198.675H145.924V232.972H163.188V198.675Z" fill="#CCCCCC" />
                <path d="M189.272 148.135H172.008V182.432H189.272V148.135Z" fill="white" />
                <path d="M218.25 148.135H200.986V182.432H218.25V148.135Z" fill="white" />
                <path d="M189.921 103.406H172.657V137.703H189.921V103.406Z" fill="white" />
                <path d="M218.901 103.406H201.637V137.703H218.901V103.406Z" fill="white" />
                <path d="M189.921 55.1582H172.657V89.4551H189.921V55.1582Z" fill="white" />
                <path d="M218.901 55.1582H201.637V89.4551H218.901V55.1582Z" fill="white" />
                <path d="M226.882 85.9358H80.1389V91.1675H226.882V85.9358Z" fill="#3F3D56" />
                <path d="M226.882 126.627H80.1389V129.533H226.882V126.627Z" fill="#3F3D56" />
                <path d="M226.882 117.326H80.1389V120.233H226.882V117.326Z" fill="#3F3D56" />
                <path d="M94.6284 185.339V162.086H91.5456V185.339H94.6284Z" fill="#3F3D56" />
                <path d="M111.892 185.339V162.086H108.809V185.339H111.892Z" fill="#3F3D56" />
                <path d="M129.156 185.339V162.086H126.074V185.339H129.156Z" fill="#3F3D56" />
                <path d="M146.42 185.339V162.086H143.337V185.339H146.42Z" fill="#3F3D56" />
                <path d="M163.684 185.339V162.086H160.601V185.339H163.684Z" fill="#3F3D56" />
                <path d="M180.948 185.339V162.086H177.865V185.339H180.948Z" fill="#3F3D56" />
                <path d="M198.213 185.339V162.086H195.13V185.339H198.213Z" fill="#3F3D56" />
                <path d="M215.476 185.339V162.086H212.393V185.339H215.476Z" fill="#3F3D56" />
                <path d="M94.9363 141.16V117.907H91.8534V141.16H94.9363Z" fill="#3F3D56" />
                <path d="M112.201 141.16V117.907H109.118V141.16H112.201Z" fill="#3F3D56" />
                <path d="M129.465 141.16V117.907H126.382V141.16H129.465Z" fill="#3F3D56" />
                <path d="M146.729 141.16V117.907H143.646V141.16H146.729Z" fill="#3F3D56" />
                <path d="M163.992 141.16V117.907H160.91V141.16H163.992Z" fill="#3F3D56" />
                <path d="M181.256 141.16V117.907H178.173V141.16H181.256Z" fill="#3F3D56" />
                <path d="M198.521 141.16V117.907H195.438V141.16H198.521Z" fill="#3F3D56" />
                <path d="M215.784 141.16V117.907H212.701V141.16H215.784Z" fill="#3F3D56" />
                <path d="M94.9363 89.4235V66.1714H91.8534V89.4235H94.9363Z" fill="#3F3D56" />
                <path d="M112.201 89.4235V66.1714H109.118V89.4235H112.201Z" fill="#3F3D56" />
                <path d="M129.465 89.4235V66.1714H126.382V89.4235H129.465Z" fill="#3F3D56" />
                <path d="M146.729 89.4235V66.1714H143.646V89.4235H146.729Z" fill="#3F3D56" />
                <path d="M163.992 89.4235V66.1714H160.91V89.4235H163.992Z" fill="#3F3D56" />
                <path d="M181.256 89.4235V66.1714H178.173V89.4235H181.256Z" fill="#3F3D56" />
                <path d="M198.52 89.4235V66.1714H195.437V89.4235H198.52Z" fill="#3F3D56" />
                <path d="M215.784 89.4235V66.1714H212.701V89.4235H215.784Z" fill="#3F3D56" />
                <path d="M226.882 74.3096H80.1389V77.2161H226.882V74.3096Z" fill="#3F3D56" />
                <path d="M226.882 65.0088H80.1389V67.9153H226.882V65.0088Z" fill="#3F3D56" />
                <path d="M226.882 136.509H80.1389V141.741H226.882V136.509Z" fill="#3F3D56" />
                <path d="M233.635 39.606H73.3865V47.4021H233.635V39.606Z" fill="#3F3D56" />
                <path d="M112.076 206.092V198.676H102.636V206.092H111.289H112.076Z" fill="white" />
                <path d="M111.289 212.024H102.636V219.44H112.076V212.024H111.289Z" fill="white" />
                <path d="M127.808 198.675H118.369V206.091H127.808V198.675Z" fill="white" />
                <path d="M127.808 212.024H118.369V219.441H127.808V212.024Z" fill="white" />
                <path d="M189.063 206.092V198.676H179.624V206.092H188.276H189.063Z" fill="white" />
                <path d="M188.276 212.024H179.624V219.44H189.063V212.024H188.276Z" fill="white" />
                <path d="M204.796 198.675H195.356V206.091H204.796V198.675Z" fill="white" />
                <path d="M204.796 212.024H195.356V219.441H204.796V212.024Z" fill="white" />
                <path d="M226.882 180.688H80.1389V185.92H226.882V180.688Z" fill="#3F3D56" />
                <path d="M226.882 171.387H80.1389V174.294H226.882V171.387Z" fill="#3F3D56" />
                <path d="M226.882 162.086H80.1389V164.993H226.882V162.086Z" fill="#3F3D56" />
                <path
                    d="M124.564 230.404C124.564 230.242 124.562 230.081 124.557 229.921C124.425 225.636 119.917 224.474 117.499 226.502C116.737 225.878 115.76 225.534 114.75 225.534C113.74 225.534 112.764 225.878 112.001 226.502C109.574 224.506 105.155 225.585 105.009 229.822C105.003 229.982 105 230.143 105 230.305C105.007 231.196 105.065 232.086 105.173 232.971H124.393C124.497 232.119 124.555 231.262 124.564 230.404Z"
                    fill="#00C066" />
                <path
                    d="M200.951 230.404C200.951 230.242 200.949 230.081 200.944 229.921C200.812 225.636 196.303 224.474 193.886 226.502C193.123 225.878 192.147 225.534 191.137 225.534C190.126 225.534 189.15 225.878 188.387 226.502C185.96 224.506 181.541 225.585 181.395 229.822C181.39 229.982 181.387 230.143 181.386 230.305C181.394 231.196 181.452 232.086 181.56 232.971H200.779C200.884 232.119 200.941 231.262 200.951 230.404Z"
                    fill="#00C066" />
                <path d="M215.701 250.708H159.441V252.804H215.701V250.708Z" fill="#E6E6E6" />
                <path d="M318.293 250.708H261.729V252.804H318.293V250.708Z" fill="#E6E6E6" />
                <path d="M113.485 250.708H57.1523V252.804H113.485V250.708Z" fill="#E6E6E6" />
                <path d="M318.061 232.925H-11V233.509H318.061V232.925Z" fill="#3F3D56" />
                <path
                    d="M213.977 225.456L229.494 225.463H231.388L234.586 225.465V225.244L234.588 222.593L234.591 219.616H232.463L230.569 219.614L227.214 219.612H225.319L221.446 219.61L213.977 225.456Z"
                    fill="white" />
                <path
                    d="M237.11 225.467L245.311 225.471L245.313 223.954V221.302L245.316 219.622H244.115L242.221 219.62L237.113 219.618L237.11 225.467Z"
                    fill="white" />
                <path d="M233.53 231.712L234.582 231.713L234.583 229.829L233.531 229.829L233.53 231.712Z" fill="#3F3D56" />
                <path d="M218.181 228.135L218.182 227.144L216.184 227.143L216.183 228.134L218.181 228.135Z"
                    fill="#3F3D56" />
                <path
                    d="M217.444 227.579L217.329 227.579C216.746 227.578 216.187 227.36 215.775 226.971C215.363 226.582 215.132 226.055 215.132 225.505C215.132 224.956 215.364 224.429 215.777 224.041C216.189 223.652 216.748 223.434 217.331 223.434L217.447 223.434L217.444 227.579Z"
                    fill="#3F3D56" />
                <path
                    d="M199.609 235.764C200.404 235.845 201.205 235.66 201.869 235.24C202.533 234.819 203.019 234.192 203.241 233.467C203.462 232.742 203.405 231.967 203.08 231.278C202.755 230.589 202.183 230.03 201.463 229.7C200.435 230.944 199.828 232.45 199.722 234.024L199.609 235.764Z"
                    fill="#3F3D56" />
                <path d="M230.568 219.614L234.585 225.244L234.587 222.593L232.462 219.616L230.568 219.614Z"
                    fill="#F2F2F2" />
                <path d="M242.221 219.62L245.313 223.954V221.302L244.115 219.622L242.221 219.62Z" fill="#F2F2F2" />
                <path d="M225.319 219.612L229.493 225.462H231.387L227.213 219.612H225.319Z" fill="#F2F2F2" />
                <path
                    d="M141.097 0.366165L141.054 0.388179C140.591 0.626897 140.072 0.752841 139.545 0.754586C139.017 0.756331 138.497 0.63382 138.032 0.39817C138.006 0.38455 137.979 0.371101 137.952 0.357823C137.488 0.123962 136.969 0.00244704 136.442 0.00416181C135.915 0.00587659 135.397 0.130768 134.934 0.36765L134.894 0.388179C134.431 0.626897 133.912 0.752841 133.385 0.754586C132.857 0.756331 132.337 0.63382 131.872 0.39817C131.845 0.384031 131.817 0.370075 131.789 0.356301C131.33 0.123512 130.817 0.00125154 130.296 0.000381703C129.774 -0.000488131 129.261 0.12006 128.801 0.351316C127.395 1.06493 125.495 2.28505 125.503 3.66298C125.504 3.71747 125.507 3.7719 125.513 3.82608C125.677 5.25706 130.627 5.62168 133.347 4.9473C135.374 5.3834 137.479 5.3834 139.507 4.9473C142.215 5.63247 147.266 5.23992 147.413 3.79253C147.419 3.73829 147.422 3.68383 147.421 3.62935C147.413 2.25068 145.496 1.04335 144.082 0.339779C143.62 0.112196 143.106 -0.00447211 142.586 0.000131118C142.065 0.00473434 141.554 0.130465 141.097 0.366165Z"
                    fill="#E6E6E6" />
                <path
                    d="M277.482 47.6123L277.439 47.6343C276.976 47.873 276.457 47.9989 275.93 48.0007C275.402 48.0024 274.882 47.8799 274.417 47.6443C274.391 47.6306 274.364 47.6172 274.337 47.6039C273.873 47.3701 273.354 47.2485 272.827 47.2503C272.3 47.252 271.782 47.3769 271.319 47.6137L271.279 47.6343C270.816 47.873 270.297 47.9989 269.77 48.0007C269.242 48.0024 268.722 47.8799 268.257 47.6443C268.23 47.6301 268.202 47.6162 268.174 47.6024C267.715 47.3696 267.202 47.2473 266.681 47.2465C266.159 47.2456 265.646 47.3662 265.186 47.5974C263.78 48.311 261.88 49.5311 261.888 50.9091C261.889 50.9636 261.892 51.018 261.898 51.0722C262.062 52.5032 267.012 52.8678 269.732 52.1934C271.759 52.6295 273.864 52.6295 275.892 52.1934C278.6 52.8786 283.651 52.486 283.798 51.0386C283.804 50.9844 283.807 50.9299 283.806 50.8754C283.798 49.4968 281.881 48.2894 280.467 47.5859C280.005 47.3583 279.492 47.2416 278.971 47.2462C278.45 47.2508 277.939 47.3766 277.482 47.6123Z"
                    fill="#E6E6E6" />
                <path
                    d="M38.6499 50.2497L38.607 50.2717C38.144 50.5104 37.6252 50.6364 37.0975 50.6381C36.5698 50.6399 36.05 50.5174 35.5853 50.2817C35.5585 50.2681 35.5319 50.2546 35.5054 50.2414C35.0407 50.0075 34.5217 49.886 33.9949 49.8877C33.4682 49.8894 32.9501 50.0143 32.4871 50.2512L32.4471 50.2717C31.9841 50.5104 31.4653 50.6364 30.9376 50.6381C30.4099 50.6399 29.8901 50.5174 29.4254 50.2817C29.3976 50.2676 29.3699 50.2536 29.3425 50.2398C28.8832 50.0071 28.3701 49.8848 27.8487 49.8839C27.3273 49.8831 26.8137 50.0036 26.3536 50.2349C24.9481 50.9485 23.0481 52.1686 23.0564 53.5465C23.0568 53.601 23.06 53.6554 23.0662 53.7096C23.2297 55.1406 28.1802 55.5052 30.8997 54.8308C32.927 55.2669 35.0324 55.2669 37.0596 54.8308C39.7676 55.516 44.8188 55.1235 44.9664 53.6761C44.972 53.6218 44.9746 53.5674 44.9743 53.5129C44.9659 52.1342 43.0491 50.9269 41.6347 50.2233C41.1733 49.9957 40.6595 49.8791 40.1388 49.8837C39.6181 49.8883 39.1066 50.014 38.6499 50.2497Z"
                    fill="#E6E6E6" />
                <path d="M46.346 231.494L42.3286 237.125L42.3264 234.473L44.4519 231.496L46.346 231.494Z" fill="#F2F2F2" />
                <path d="M34.6936 231.5L31.6008 235.834V233.183L32.7994 231.503L34.6936 231.5Z" fill="#F2F2F2" />
            </g>
            <g clip-path="url(#clip8_28_850)">
                <path
                    d="M1228.11 249.851H1095V249.553H1228.11C1228.2 249.553 1228.26 249.62 1228.26 249.702C1228.26 249.784 1228.2 249.851 1228.11 249.851Z"
                    fill="#3F3D56" />
                <path
                    d="M1127.86 249.553H1119.52C1118.27 249.553 1117.26 248.547 1117.26 247.31V223.017C1117.26 221.78 1118.27 220.773 1119.52 220.773H1127.86C1129.11 220.773 1130.12 221.78 1130.12 223.017V247.31C1130.12 248.547 1129.11 249.553 1127.86 249.553Z"
                    fill="#3F3D56" />
                <path
                    d="M1209.56 249.601H1201.22C1199.98 249.601 1198.96 248.594 1198.96 247.357V223.065C1198.96 221.827 1199.98 220.821 1201.22 220.821H1209.56C1210.81 220.821 1211.82 221.827 1211.82 223.065V247.357C1211.82 248.594 1210.81 249.601 1209.56 249.601Z"
                    fill="#3F3D56" />
                <path
                    d="M1129.84 189.191L1117.56 206.501C1116.07 208.589 1115.49 211.176 1115.92 213.693L1119.65 235.274C1120.46 239.909 1124.51 243.297 1129.25 243.297H1201.41C1206.55 243.297 1210.81 239.325 1211.12 234.23L1212.56 210.882C1212.73 208.103 1211.69 205.385 1209.69 203.427L1192.47 186.516C1190.58 184.66 1188 183.653 1185.34 183.729L1137.51 185.097C1134.45 185.185 1131.6 186.702 1129.84 189.191H1129.84Z"
                    fill="#00C066" />
                <path
                    d="M1131.71 192.264L1129.36 196.621C1127.86 199.397 1130.05 202.676 1133.36 202.64L1192.15 201.992C1195.76 201.952 1197.8 198.089 1195.64 195.372L1191.93 190.716C1191.08 189.642 1189.73 189.02 1188.3 189.045L1135.56 189.993C1133.93 190.022 1132.44 190.896 1131.71 192.264H1131.71Z"
                    fill="white" />
                <path
                    d="M1205.3 201.356C1204.92 201.356 1204.55 201.216 1204.26 200.961C1203.94 200.672 1203.75 200.259 1203.75 199.828L1203.76 198.87L1203.95 194.456C1203.98 193.637 1204.66 192.995 1205.49 192.995H1211.61C1212.18 192.995 1212.7 193.305 1212.97 193.804L1213.69 195.16C1213.93 195.59 1213.94 196.088 1213.73 196.528C1213.52 196.969 1213.13 197.278 1212.65 197.376L1208.03 198.323C1207.56 198.421 1207.18 198.772 1207.05 199.239L1206.78 200.23C1206.61 200.836 1206.08 201.286 1205.45 201.348C1205.4 201.354 1205.35 201.356 1205.3 201.356Z"
                    fill="#00C066" />
                <path
                    d="M1122.63 201.348C1122 201.286 1121.46 200.836 1121.3 200.23L1121.02 199.239C1120.89 198.772 1120.52 198.421 1120.04 198.323L1115.43 197.376C1114.95 197.278 1114.55 196.969 1114.35 196.528C1114.14 196.088 1114.15 195.59 1114.38 195.16L1115.11 193.804C1115.38 193.305 1115.9 192.995 1116.47 192.995H1122.59C1123.42 192.995 1124.09 193.637 1124.13 194.456L1124.32 198.87L1124.32 199.828C1124.32 200.259 1124.14 200.672 1123.81 200.961C1123.53 201.216 1123.16 201.356 1122.78 201.356C1122.73 201.356 1122.68 201.354 1122.63 201.348L1122.63 201.348Z"
                    fill="#00C066" />
                <path
                    d="M1131.13 220.273C1134.47 220.273 1137.18 217.584 1137.18 214.267C1137.18 210.95 1134.47 208.26 1131.13 208.26C1127.79 208.26 1125.08 210.95 1125.08 214.267C1125.08 217.584 1127.79 220.273 1131.13 220.273Z"
                    fill="white" />
                <path
                    d="M1200.86 220.398C1204.2 220.398 1206.91 217.709 1206.91 214.392C1206.91 211.075 1204.2 208.386 1200.86 208.386C1197.51 208.386 1194.8 211.075 1194.8 214.392C1194.8 217.709 1197.51 220.398 1200.86 220.398Z"
                    fill="white" />
                <path
                    d="M1123.07 182.179C1123.63 182.489 1124.11 182.926 1124.46 183.455L1128.43 185.8L1135.18 188.939C1135.18 188.939 1136.78 183.321 1138.68 182.962C1140.58 182.603 1143.72 186.767 1143.72 186.767C1143.72 186.767 1138.25 195.559 1135.86 194.657C1133.48 193.756 1128.16 189.378 1128.16 189.378L1127.46 188.817L1123.04 185.896C1122.4 185.857 1121.78 185.668 1121.23 185.343C1119.85 184.55 1119.14 183.198 1119.65 182.324C1120.16 181.45 1121.69 181.385 1123.07 182.179V182.179Z"
                    fill="#A0616A" />
                <path
                    d="M1136.23 184.617L1139.69 180.583L1141.77 180.882C1144.33 181.247 1145.76 184.017 1144.55 186.287L1143.35 188.55L1136.23 184.617Z"
                    fill="#E6E6E6" />
                <path
                    d="M1125.01 189.899L1118.93 181.584C1118.84 181.462 1118.86 181.29 1118.98 181.193L1120.44 179.998C1120.5 179.946 1120.58 179.923 1120.66 179.935C1120.74 179.947 1120.82 179.993 1120.86 180.061L1126.9 189.054C1126.95 189.128 1126.96 189.219 1126.94 189.304C1126.91 189.388 1126.84 189.454 1126.76 189.485L1125.34 190C1125.24 190.038 1125.12 190.013 1125.04 189.939C1125.03 189.927 1125.02 189.914 1125.01 189.899Z"
                    fill="#3F3D56" />
                <path
                    d="M1125.49 189.391L1119.2 181.299C1119.11 181.18 1119.11 181.024 1119.21 180.945L1120.46 179.968C1120.52 179.926 1120.59 179.912 1120.67 179.929C1120.75 179.946 1120.82 179.994 1120.86 180.06L1127.17 188.769C1127.23 188.84 1127.24 188.925 1127.23 189C1127.21 189.075 1127.15 189.13 1127.08 189.152L1125.81 189.51C1125.71 189.537 1125.6 189.504 1125.53 189.43C1125.51 189.418 1125.5 189.405 1125.49 189.391H1125.49Z"
                    fill="#E6E6E6" />
                <path d="M1122.98 239.984L1120.24 245.84L1115.78 243.84L1119.24 239.412L1122.98 239.984Z" fill="#A0616A" />
                <path
                    d="M1118.37 243.983L1121.68 243.555C1121.68 243.555 1123.99 248.983 1122.26 249.269C1120.53 249.554 1107 250.84 1107 249.126C1107 247.412 1112.62 245.269 1112.62 245.269L1116.5 242.555L1118.37 243.983Z"
                    fill="#2F2E41" />
                <path
                    d="M1144.43 202.271C1144.43 202.271 1148.46 208.271 1139.82 211.985L1130.61 225.127L1122.98 241.555L1118.37 239.841L1126.43 214.985L1131.04 203.843L1133.2 200.414L1144.43 202.271Z"
                    fill="#2F2E41" />
                <path d="M1112.4 224.38L1110.57 230.573L1105.86 229.249L1108.62 224.363L1112.4 224.38Z" fill="#A0616A" />
                <path
                    d="M1108.44 229.011L1111.65 228.102C1111.65 228.102 1114.74 233.133 1113.07 233.669C1111.41 234.204 1098.22 237.459 1097.96 235.764C1097.71 234.068 1102.94 231.126 1102.94 231.126L1106.38 227.872L1108.44 229.011H1108.44Z"
                    fill="#2F2E41" />
                <path
                    d="M1135.65 201.072L1113.52 205.836C1111.82 206.203 1110.49 207.543 1110.16 209.244L1107.06 224.869L1113.84 227.052L1116.88 213.101L1136.52 212.346L1135.65 201.072H1135.65Z"
                    fill="#2F2E41" />
                <path d="M1141.21 174.672L1138.47 179.99L1145.75 181.113L1145.67 173.963L1141.21 174.672Z"
                    fill="#A0616A" />
                <path
                    d="M1142.73 176.854C1145.52 176.854 1147.79 174.603 1147.79 171.827C1147.79 169.05 1145.52 166.8 1142.73 166.8C1139.93 166.8 1137.66 169.05 1137.66 171.827C1137.66 174.603 1139.93 176.854 1142.73 176.854Z"
                    fill="#A0616A" />
                <path
                    d="M1146.01 203.985L1146.85 190.556C1147.57 187.342 1147.33 183.988 1146.15 180.908L1145.87 177.701L1139.25 178.13L1136.44 182.629L1133.78 193.272L1133.2 200.414L1146.01 203.985V203.985Z"
                    fill="#E6E6E6" />
                <path
                    d="M1126.63 193.595C1127.27 193.506 1127.91 193.57 1128.51 193.779L1133.11 193.258L1140.4 191.7C1140.4 191.7 1138.24 186.272 1139.53 184.844C1140.83 183.415 1145.87 184.844 1145.87 184.844C1145.87 184.844 1146.87 195.129 1144.43 195.843C1141.98 196.557 1135.07 196.272 1135.07 196.272L1134.18 196.243L1128.87 196.576C1128.34 196.928 1127.73 197.149 1127.1 197.22C1125.51 197.42 1124.12 196.77 1123.99 195.769C1123.87 194.768 1125.05 193.794 1126.63 193.595V193.595Z"
                    fill="#A0616A" />
                <path
                    d="M1138.6 187.629L1138.89 182.344L1140.73 181.328C1142.99 180.082 1145.81 181.432 1146.23 183.963L1146.66 186.486L1138.6 187.629V187.629Z"
                    fill="#E6E6E6" />
                <path
                    d="M1146.68 174.916C1146.68 174.916 1147.15 172.573 1145.73 172.416C1144.31 172.26 1142.9 169.448 1142.9 169.448C1142.9 169.448 1138.01 168.601 1137.85 170.632C1137.69 172.664 1137.75 172.212 1137.75 172.212C1137.75 172.212 1136.59 171.726 1137.06 169.695C1137.2 169.114 1137.53 168.585 1137.93 168.125C1139.21 166.646 1141.18 165.948 1143.13 166.171C1143.96 166.266 1146.43 167.045 1146.9 167.577C1148.16 168.983 1148.72 173.354 1146.68 174.916V174.916Z"
                    fill="#3F3D56" />
                <path
                    d="M1129.98 234.51C1129.09 234.51 1128.3 234.049 1127.88 233.274C1127.45 232.495 1127.48 231.586 1127.97 230.841L1128.04 230.888L1127.97 230.841L1129.55 228.429C1129.99 227.753 1130.74 227.349 1131.56 227.349H1200.27C1200.97 227.349 1201.63 227.652 1202.09 228.18L1203.82 230.193C1204.44 230.903 1204.57 231.873 1204.18 232.723C1203.79 233.574 1202.96 234.105 1202.02 234.111L1129.99 234.51H1129.98Z"
                    fill="#3F3D56" />
                <path
                    d="M1212.19 205.39C1213.45 206.211 1214.9 206.229 1215.43 205.43C1215.96 204.632 1215.36 203.32 1214.09 202.499C1213.59 202.164 1213.02 201.953 1212.42 201.884L1207.02 198.475L1205.46 201.024L1210.95 204.114C1211.25 204.632 1211.68 205.069 1212.19 205.39L1212.19 205.39Z"
                    fill="#FFB6B6" />
                <path
                    d="M1196.83 196.989L1210.08 203.784L1211.23 200.639L1202.24 193.653L1201.65 183.462C1201.57 182.217 1200.94 181.089 1199.92 180.367C1198.9 179.644 1197.62 179.425 1196.41 179.765C1194.26 180.369 1192.97 182.607 1193.55 184.751L1196.83 196.989Z"
                    fill="#E6E6E6" />
                <path d="M1200.03 178.752L1200.65 174.91L1196.47 173.22L1195.85 179.06L1200.03 178.752Z" fill="#FFB6B6" />
                <path
                    d="M1186.86 200.614C1186.86 200.614 1185.66 208.059 1190.46 208.952C1195.26 209.845 1206.22 210.441 1206.22 210.441L1220.32 227.415L1223.17 224.289L1211.02 205.676L1201.27 199.571L1186.86 200.614Z"
                    fill="#2F2E41" />
                <path
                    d="M1188.01 199.408C1188.01 199.408 1185.21 206.418 1189.7 208.323C1194.19 210.229 1204.75 213.169 1204.75 213.169L1214.81 232.776L1218.28 230.337L1210.48 209.551L1202.3 201.492L1188.01 199.408V199.408Z"
                    fill="#2F2E41" />
                <path
                    d="M1200.82 178.13L1195.42 177.237L1191.75 179.259C1189.62 182.334 1189.45 192.09 1188.94 195.789L1185.96 202.698L1195.42 201.358L1203.07 200.614L1200.52 184.086L1200.82 178.13L1200.82 178.13Z"
                    fill="#E6E6E6" />
                <path
                    d="M1198.97 176.145C1201.33 176.145 1203.24 174.251 1203.24 171.914C1203.24 169.577 1201.33 167.683 1198.97 167.683C1196.62 167.683 1194.71 169.577 1194.71 171.914C1194.71 174.251 1196.62 176.145 1198.97 176.145Z"
                    fill="#FFB6B6" />
                <path
                    d="M1198.63 166.225C1198.76 166.297 1198.92 166.189 1198.96 166.052C1199 165.916 1198.95 165.772 1198.91 165.637C1198.83 165.412 1198.76 165.186 1198.68 164.961C1198.52 164.481 1198.34 163.985 1197.99 163.62C1197.46 163.069 1196.61 162.929 1195.84 163.031C1194.86 163.161 1193.9 163.688 1193.44 164.558C1192.99 165.429 1193.18 166.644 1194 167.187C1192.83 168.522 1192.42 170.009 1192.49 171.779C1192.55 173.549 1194.49 175.178 1195.76 176.425C1196.05 176.255 1196.3 175.457 1196.15 175.167C1195.99 174.877 1196.21 174.541 1196.02 174.274C1195.83 174.007 1195.67 174.432 1195.86 174.166C1195.99 173.999 1195.51 173.614 1195.69 173.513C1196.57 173.028 1196.87 171.935 1197.42 171.097C1198.09 170.087 1199.24 169.403 1200.45 169.289C1201.12 169.227 1201.83 169.34 1202.37 169.725C1202.92 170.11 1203.28 170.798 1203.15 171.452C1203.48 171.121 1203.64 170.635 1203.58 170.174C1203.52 169.712 1203.23 169.286 1202.83 169.051C1203.07 168.243 1202.86 167.314 1202.29 166.689C1201.72 166.064 1199.4 166.171 1198.57 166.335"
                    fill="#2F2E41" />
                <path
                    d="M1198.5 169.314C1197.4 169.432 1196.6 170.382 1195.93 171.259C1195.54 171.764 1195.13 172.322 1195.14 172.958C1195.15 173.6 1195.58 174.151 1195.79 174.76C1196.13 175.755 1195.8 176.939 1195 177.621C1195.79 177.771 1196.65 177.179 1196.79 176.387C1196.95 175.466 1196.24 174.576 1196.33 173.645C1196.4 172.824 1197.05 172.192 1197.61 171.579C1198.16 170.965 1198.68 170.151 1198.43 169.367"
                    fill="#2F2E41" />
                <path
                    d="M1208.8 206.186C1210.06 207.007 1211.52 207.024 1212.04 206.226C1212.57 205.428 1211.97 204.115 1210.7 203.295C1210.2 202.96 1209.63 202.749 1209.03 202.68L1203.63 199.271L1202.07 201.82L1207.56 204.91C1207.87 205.428 1208.29 205.865 1208.8 206.186V206.186Z"
                    fill="#FFB6B6" />
                <path
                    d="M1193.44 197.785L1206.69 204.58L1207.84 201.435L1198.86 194.449L1198.26 184.258C1198.18 183.013 1197.56 181.885 1196.53 181.163C1195.51 180.44 1194.23 180.221 1193.02 180.56C1190.87 181.165 1189.58 183.402 1190.16 185.547L1193.44 197.785Z"
                    fill="#E6E6E6" />
                <path
                    d="M1215.29 230.145L1215.6 230.319C1215.6 230.319 1217.7 229.128 1218.75 230.319C1219.8 231.51 1220.55 234.488 1220.55 234.488C1220.55 234.488 1224.9 238.062 1222.35 238.062C1220.43 238.062 1215.87 235.953 1213.74 234.91C1213.05 234.577 1212.74 233.786 1213 233.079C1213.22 232.49 1213.51 231.872 1213.79 231.659C1214.09 231.436 1214.28 230.952 1214.39 230.524C1214.5 230.136 1214.94 229.946 1215.29 230.145Z"
                    fill="#2F2E41" />
                <path
                    d="M1221.14 224.487L1221.45 224.661C1221.45 224.661 1223.55 223.47 1224.6 224.661C1225.65 225.852 1226.4 228.83 1226.4 228.83C1226.4 228.83 1230.75 232.404 1228.2 232.404C1226.28 232.404 1221.72 230.294 1219.59 229.251C1218.91 228.918 1218.59 228.127 1218.85 227.421C1219.07 226.832 1219.36 226.214 1219.65 226.001C1219.95 225.778 1220.13 225.294 1220.25 224.866C1220.35 224.478 1220.79 224.288 1221.14 224.487Z"
                    fill="#2F2E41" />
            </g>
            <defs>
                <clipPath id="clip0_28_850">
                    <rect width="109.902" height="75.1958" fill="white" transform="translate(742 178)" />
                </clipPath>
                <clipPath id="clip1_28_850">
                    <rect width="185" height="129" fill="white" transform="translate(534 117)" />
                </clipPath>
                <clipPath id="clip2_28_850">
                    <rect width="130" height="113" fill="white" transform="translate(318 135)" />
                </clipPath>
                <clipPath id="clip3_28_850">
                    <rect width="97" height="85" fill="white" transform="translate(439 163)" />
                </clipPath>
                <clipPath id="clip4_28_850">
                    <rect width="110" height="57" fill="white" transform="translate(946 184)" />
                </clipPath>
                <clipPath id="clip5_28_850">
                    <rect width="84.8363" height="79.052" fill="white" transform="translate(186 165.621)" />
                </clipPath>
                <clipPath id="clip6_28_850">
                    <rect width="95.4408" height="41.4541" fill="white" transform="translate(851 203)" />
                </clipPath>
                <clipPath id="clip7_28_850">
                    <rect width="113" height="73" fill="white" transform="translate(1241 171)" />
                </clipPath>
                <clipPath id="clip8_28_850">
                    <rect width="134" height="87" fill="white" transform="translate(1095 163)" />
                </clipPath>
            </defs>
        </svg>
        <!-- Banner Cloud -->

        <div class="cloud-img">
            <svg class="cloud cloud-1" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-2" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-3" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-4" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-5" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-6" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
            <svg class="cloud cloud-7" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300"
                style="enable-background:new 0 0 300 300;" xml:space="preserve">
                <path class="st0" fill="#8cefb9" d="M259.83,140.14l-30.51,19.41l18.51-33.65c-5.24-4.19-11.73-6.51-18.44-6.59h-0.48
                                                        c-2.12,0.03-4.24-0.13-6.34-0.48l-10.34,6.55l4.43-8.05c-7.32-2.56-13.65-7.37-18.08-13.73l-18.49,11.73l11.69-21.26
                                                        c-10.82-13-25.38-20.97-41.4-20.97c-19.24,0-36.38,11.45-47.44,29.27c-3.27,5.34-7.89,9.72-13.4,12.69
                                                        c-5.51,2.97-11.71,4.43-17.96,4.23h-1.03c-21.23,0-38.46,24.09-38.46,53.81c0,29.72,17.23,53.81,38.46,53.81
                                                        c4.67-0.02,9.26-1.17,13.39-3.37c13.87-7.12,32.04-7.34,46.55-0.91c6.22,2.8,12.96,4.26,19.78,4.27c6.82,0.02,13.57-1.41,19.8-4.18
                                                        c14.38-6.3,32.38-6.16,46.14,0.89c4.08,2.15,8.63,3.28,13.24,3.29c21.24,0,38.46-24.09,38.46-53.81
                                                        C268.03,161.6,265.25,150.27,259.83,140.14z" />
            </svg>
        </div>

    </section>
    <!-- ==== Banner Section Ends Here ==== -->

    <!-- ==== Ecommerce Venture Section Starts Here ==== -->
    <section class="ecommerce-venture-section">
        <div class="container max-w1060">
            <div class="section-header mb-30 wow fadeInUp">
                <h2 class="title"><?php echo e($landing_data['fixed_module_title']); ?>

                    <span class="primary-color text-nowrap">color text</span>
                </h2>
                <p>
                    <?php echo e($landing_data['fixed_module_sub_title']); ?>

                </p>
            </div>
            <div class="nav--tabs-wrapper">
                <?php ($modules = \App\Models\Module::Active()->get()); ?>
                <div class="nav--tabs">
                    <div class="owl-theme owl-carousel" id="sync2">
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="item">
                                <img class="__img-50 onerror-image"
                                    data-onerror-image="<?php echo e(asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    src="<?php echo e($item['icon_full_url'] ?? asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    alt="image">
                                <div class="txt d-block"><?php echo e(translate("messages.{$item->module_name}")); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="owl-theme owl-carousel" id="sync1">
                <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row flex-wrap-reverse justify-content-center align-items-center">
                        <div class="col-lg-6 col-md-8">
                            <div class="venture-content mt-4 mt-lg-0">
                                <div class="venture-content-box">
                                    <?php echo $item->description ?? ''; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-8">
                            <div class="venture-img mx-1">
                                <img src="<?php echo e($item['thumbnail_full_url'] ?? asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    class="img-fluid onerror-image w-100 mw-450"
                                    data-onerror-image="<?php echo e(asset('public/assets/admin/img/100x100/2.png')); ?>"
                                    alt="image">
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- ==== Ecommerce Venture Section Ends Here ==== -->

    <!-- ==== Main Category Section Starts Here ==== -->
    <?php ($promotion_banner = $landing_data['promotional_banners']); ?>
    <?php if($promotion_banner && count($promotion_banner) > 0): ?>
        <section class="main-category overflow-hidden pt-80 pb-80">
            <div class="container">
                <div class="overflow-hidden">
                    <div class="main-category-slider owl-theme owl-carousel">
                        <?php $__currentLoopData = $promotion_banner; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="category-slide-item"
                                style="background: url(<?php echo e($item['image_full_url']); ?>) no-repeat center center / cover">
                                <div>
                                    <h2 class="title"><?php echo e($item['title'] ?? ''); ?></h2>
                                    <div class="text"><?php echo e($item['sub_title'] ?? ''); ?></div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Main Category Section Ends Here ==== -->

    <!-- ==== Learn Feature Section Starts Here ==== -->
    <section class="learn-feature-section"
        style="background: url(<?php echo e(asset('public/assets/landing/img/learn-feature-bg.svg')); ?>) no-repeat center center / cover">
        <div class="container position-relative">
            <div class="row gy-5 gx-0 gx-xl-4 align-items-center">
                <div class=" col-lg-6 pe-lg-5">
                    <div class="learn-feature-content wow fadeInUp">
                        <div class="section-header text-start mb-0">
                            <h2 class="title">
                                <?php echo e($landing_data['feature_title']); ?>

                                <span class="primary-color text-nowrap">color text</span>
                            </h2>
                            <div class="text">
                                <?php echo e($landing_data['feature_short_description']); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php ($feature = $landing_data['features']); ?>
                <?php
                $array1 = array_slice($feature, 0, ceil(count($feature) / 2));
                $array2 = array_slice($feature, ceil(count($feature) / 2));
                ?>
                <?php if(isset($feature) && ($x = count($feature) > 0)): ?>

                    <div class="col-lg-6">
                        <div class="learn-feature-wrapper py-5">
                            <div class="row g-4 learn-feature-item-group">
                                <div class="col-6">
                                    <div class="row gy-4 gy-sm-5">
                                        <!-- Item -->
                                        <?php $__currentLoopData = $array1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12">
                                                <div class="learn-feature-item">
                                                    <div class="learn-feature-icon">
                                                        <img src="<?php echo e($item['image_full_url']); ?>"
                                                            alt="<?php echo e($item['title'] ?? ''); ?>">
                                                    </div>
                                                    <div class="learn-feature-item-content">
                                                        <h5 class="subttle"><?php echo e($item['title'] ?? ''); ?></h5>
                                                        <div class="text">
                                                            <?php echo e($item['sub_title'] ?? ''); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Item End-->
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="row gy-4 gy-sm-5 mt-5 pt-5">
                                        <?php $__currentLoopData = $array2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12">
                                                <div class="learn-feature-item">
                                                    <div class="learn-feature-icon">
                                                        <img src="<?php echo e($item['image_full_url']); ?>"
                                                            alt="<?php echo e($item['title'] ?? ''); ?>">
                                                    </div>
                                                    <div class="learn-feature-item-content">
                                                        <h5 class="subttle"><?php echo e($item['title'] ?? ''); ?></h5>
                                                        <div class="text">
                                                            <?php echo e($item['sub_title'] ?? ''); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- ==== Learn Feature Section Ends Here ==== -->

    <!-- ==== Delivery Area Section Starts Here ==== -->
    <?php if($landing_data['available_zone_status'] && $landing_data['available_zone_list']): ?>
        <section class="delivery-area-section">
            <div class="container">
                <div class="row text-center gy-4 flex-wrap-reverse align-items-center">
                    <div class="col-lg-5 col-xl-6 text-lg-start">
                        <div class="section-header text-lg-start wow fadeInUp">
                            <h2 class="title">
                                
                                <span><?php echo e($landing_data['available_zone_title']); ?></span>
                                <span class="primary-color text-nowrap">color text</span>
                            </h2>
                        </div>
                        <div class="text">
                            <?php echo e($landing_data['available_zone_short_description']); ?>

                        </div>
                        <div class="zone-list-container">
                            <div class="zone-list-wrapper mt-4">
                                <div class="zone-list">
                                    <?php $__currentLoopData = $landing_data['available_zone_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($zone['modules']->toArray()) > 0): ?>
                                            <span class="item" data-bs-trigger="hover" data-bs-toggle="popover"
                                                data-bs-placement="top" title="<?php echo e($zone['display_name']); ?>"
                                                data-bs-content="<?php echo e(count($zone['modules']->toArray()) > 0 ? implode(', ', $zone['modules']->toArray()) . ' ' . translate('are_available.') : translate('right_now_no_module_available.')); ?>">
                                                <?php echo e($zone['display_name']); ?>

                                            </span>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-7 col-xl-6 text-lg-end">
                        <img src="<?php echo e($landing_data['available_zone_image_full_url']); ?>" alt=""
                            class="img-fluid w-100 mw-450">
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Delivery Area Section Ends Here ==== -->

    <!-- ==== Refer Section Starts Here ==== -->
    <section class="refer-section pb-80">
        <div class="container">
            <div class="row align-items-center text-center gy-4 flex-wrap-reverse">
                <div class="col-lg-5 col-xl-6 text-lg-start">
                    <div class="section-header text-lg-start mb-3 wow fadeInUp">
                        <h2 class="title">
                            <div>
                                <?php echo e($landing_data['fixed_referal_title']); ?>

                                <span class="primary-color text-nowrap">color text</span>
                            </div>
                            
                        </h2>
                    </div>
                    <div class="text">
                        <?php echo e($landing_data['fixed_referal_sub_title']); ?>

                    </div>
                </div>
                <div class="col-lg-7 col-xl-6 text-lg-end">
                    <div class="refer-img">
                        <!-- Main Image -->
                        <svg class="main-img" viewBox="0 0 518 382" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M237.219 159.432C236.893 159.812 236.872 160.312 236.885 160.799C236.897 161.452 236.932 162.105 236.962 162.759C236.992 163.412 237.018 164.061 237.013 164.715C237.013 164.745 237.013 164.779 237.013 164.809C236.885 164.578 236.769 164.335 236.653 164.1C236.216 163.194 235.74 162.31 235.208 161.456C235.079 161.251 234.946 161.046 234.813 160.841C234.702 160.671 234.599 160.47 234.419 160.363C234.341 160.316 234.247 160.32 234.166 160.337C233.861 160.389 233.557 160.495 233.265 160.602C233.072 160.675 232.849 160.743 232.682 160.876C232.605 160.935 232.57 161.051 232.545 161.145C232.3 162.02 232.24 162.951 232.189 163.861C232.159 164.429 232.133 165.001 232.086 165.569C232.073 165.718 232.06 165.868 232.043 166.021C231.781 165.701 231.584 165.33 231.391 164.962C231.172 164.557 230.949 164.151 230.628 163.818C230.499 163.685 230.323 163.583 230.139 163.587C229.929 163.587 229.71 163.673 229.513 163.737C229.32 163.801 229.122 163.865 228.934 163.942C228.814 163.989 228.668 164.04 228.565 164.121C228.419 164.236 228.398 164.403 228.385 164.582C228.368 164.838 228.363 165.095 228.368 165.351C228.372 165.671 228.41 165.983 228.453 166.299C228.243 166.115 228.037 165.919 227.819 165.744C227.446 165.453 226.987 165.231 226.515 165.266C226.193 165.291 225.867 165.419 225.571 165.53C225.426 165.586 225.271 165.641 225.134 165.714C225.125 165.718 224.975 165.804 225.074 165.795C225.692 165.744 226.206 166.145 226.656 166.542C226.905 166.76 227.145 166.991 227.424 167.174C227.699 167.354 227.969 167.397 228.269 167.341C228.29 167.345 228.346 167.332 228.428 167.307C228.814 167.209 229.208 167.085 229.568 166.914C229.714 166.846 229.869 166.773 229.954 166.632C230.122 166.363 229.98 165.97 229.941 165.676C229.937 165.633 229.933 165.586 229.929 165.543C230.04 165.752 230.156 165.966 230.28 166.167C230.499 166.513 230.769 166.833 231.116 167.051C231.271 167.149 231.451 167.23 231.635 167.23C231.85 167.23 232.069 167.14 232.266 167.08C232.579 166.987 232.939 166.884 233.218 166.7C233.368 166.602 233.428 166.427 233.462 166.256C233.509 166.026 233.535 165.791 233.561 165.56C233.612 165.103 233.642 164.646 233.668 164.185C233.707 163.502 233.733 162.819 233.805 162.144C234.003 162.468 234.196 162.801 234.384 163.135C234.633 163.579 234.865 164.031 235.083 164.488C235.268 164.873 235.448 165.257 235.679 165.616C235.898 165.957 236.181 166.29 236.537 166.487C236.627 166.534 236.726 166.534 236.82 166.521C237.125 166.47 237.429 166.363 237.721 166.256C238.008 166.15 238.334 166.068 238.446 165.748C238.514 165.552 238.501 165.317 238.51 165.112C238.523 164.856 238.527 164.599 238.531 164.343C238.536 163.848 238.523 163.357 238.506 162.861C238.48 162.148 238.437 161.435 238.416 160.726C238.398 160.167 238.313 159.453 238.699 159.001C238.754 158.937 238.63 158.967 238.604 158.971C238.446 158.997 238.295 159.043 238.141 159.09C237.944 159.15 237.751 159.219 237.562 159.295C237.476 159.33 237.296 159.377 237.228 159.453L237.219 159.432Z"
                                fill="url(#paint0_linear_28_1911)" />
                            <path
                                d="M229.564 166.897L229.616 166.871C228.977 166.901 228.458 166.282 228.458 166.282C228.248 166.098 228.042 165.902 227.823 165.727C227.45 165.436 226.991 165.214 226.519 165.248C226.198 165.274 225.872 165.402 225.576 165.513C225.43 165.569 225.276 165.624 225.138 165.697C225.13 165.701 224.98 165.787 225.078 165.778C225.696 165.727 226.211 166.128 226.661 166.525C226.91 166.743 227.15 166.974 227.428 167.157C227.703 167.337 227.973 167.379 228.273 167.324C228.295 167.328 228.351 167.315 228.432 167.29C228.818 167.192 229.213 167.068 229.573 166.897H229.564Z"
                                fill="url(#paint1_linear_28_1911)" />
                            <path
                                d="M232.094 165.56C232.081 165.71 232.069 165.859 232.051 166.013C231.79 165.693 231.593 165.321 231.4 164.954C231.181 164.548 230.958 164.142 230.636 163.809C230.508 163.677 230.332 163.574 230.147 163.579C229.937 163.579 229.718 163.664 229.521 163.728C229.328 163.792 229.131 163.856 228.942 163.933C228.852 163.972 228.745 164.006 228.651 164.061C229.217 164.194 229.847 165.389 229.847 165.389L229.929 165.59C229.929 165.59 229.924 165.552 229.924 165.53C230.036 165.74 230.152 165.953 230.276 166.154C230.495 166.5 230.765 166.82 231.112 167.038C231.267 167.136 231.447 167.217 231.631 167.217C231.631 167.217 232 167.196 232.094 165.56Z"
                                fill="url(#paint2_linear_28_1911)" />
                            <path
                                d="M237 164.787C236.876 164.561 236.764 164.326 236.653 164.095C236.216 163.19 235.739 162.306 235.208 161.452C235.079 161.247 234.946 161.042 234.813 160.837C234.702 160.666 234.599 160.466 234.419 160.359C234.341 160.312 234.247 160.316 234.166 160.333C233.861 160.384 233.557 160.491 233.265 160.598C233.072 160.67 232.849 160.739 232.682 160.871H232.677L232.802 160.854C232.802 160.854 233.248 160.922 233.797 162.127C233.994 162.451 234.187 162.784 234.376 163.117C234.624 163.562 234.856 164.014 235.075 164.471C235.259 164.856 235.439 165.24 235.671 165.599C235.89 165.94 236.173 166.273 236.529 166.47C236.576 166.495 236.627 166.508 236.679 166.512C236.73 166.508 236.949 166.389 237 164.791V164.787Z"
                                fill="url(#paint3_linear_28_1911)" />
                            <path d="M466.096 355.875H431.784V356.133H466.096V355.875Z" fill="#EBEBEB" />
                            <path d="M343.144 358.692H334.141V358.951H343.144V358.692Z" fill="#EBEBEB" />
                            <path d="M430.748 346.261H410.867V346.52H430.748V346.261Z" fill="#EBEBEB" />
                            <path d="M99.0935 348.002H54.3486V348.261H99.0935V348.002Z" fill="#EBEBEB" />
                            <path d="M114.882 348.002H108.324V348.261H114.882V348.002Z" fill="#EBEBEB" />
                            <path d="M233.255 352.373H136.203V352.632H233.255V352.373Z" fill="#EBEBEB" />
                            <path
                                d="M246.982 293.005H46.9307C43.6673 293.005 41.0151 290.354 41.0151 287.09V5.91501C41.0151 2.65191 43.6673 0 46.9307 0H246.982C250.246 0 252.898 2.65191 252.898 5.91501V287.09C252.898 290.354 250.246 293.005 246.982 293.005ZM46.9307 0.258976C43.8123 0.258976 41.2741 2.79694 41.2741 5.91501V287.09C41.2741 290.209 43.8123 292.746 46.9307 292.746H246.982C250.101 292.746 252.639 290.209 252.639 287.09V5.91501C252.639 2.79694 250.101 0.258976 246.982 0.258976H46.9307Z"
                                fill="#EBEBEB" />
                            <path
                                d="M471.069 293.005H271.018C267.754 293.005 265.102 290.354 265.102 287.09V5.91501C265.102 2.65191 267.754 0 271.018 0H471.069C474.333 0 476.985 2.65191 476.985 5.91501V287.09C476.985 290.354 474.333 293.005 471.069 293.005ZM271.018 0.258976C267.899 0.258976 265.361 2.79694 265.361 5.91501V287.09C265.361 290.209 267.899 292.746 271.018 292.746H471.069C474.188 292.746 476.726 290.209 476.726 287.09V5.91501C476.726 2.79694 474.188 0.258976 471.069 0.258976H271.018Z"
                                fill="#EBEBEB" />
                            <path d="M518 339.207H0V339.466H518V339.207Z" fill="#EBEBEB" />
                            <path
                                d="M421.424 113.804H380.471C376.576 113.804 373.416 116.964 373.416 120.859V147.233C373.416 151.128 376.576 154.288 380.471 154.288H392.25L397.513 161.166C399.244 163.435 402.662 163.435 404.392 161.166L409.655 154.288H421.435C425.33 154.288 428.49 151.128 428.49 147.233V120.859C428.49 116.964 425.33 113.804 421.435 113.804H421.424Z"
                                fill="#E0E0E0" />
                            <path
                                d="M392.136 136.864C390.085 134.854 389.204 132.658 389.204 130.69C389.204 127.333 391.442 125.096 394.84 125.096C398.01 125.096 399.088 126.567 400.942 128.69C402.797 126.567 403.874 125.096 407.044 125.096C410.442 125.096 412.68 127.333 412.68 130.69C412.68 132.658 411.789 134.854 409.748 136.864L400.942 145.627L392.136 136.864Z"
                                fill="white" />
                            <path
                                d="M104.491 321.192C102.077 318.831 101.031 316.23 101.031 313.91C101.031 309.953 103.673 307.311 107.672 307.311C111.401 307.311 112.675 309.041 114.861 311.538C117.047 309.041 118.322 307.311 122.051 307.311C126.05 307.311 128.692 309.953 128.692 313.91C128.692 316.23 127.646 318.82 125.232 321.192L114.861 331.52L104.491 321.192Z"
                                fill="#E0E0E0" />
                            <path
                                d="M127.915 332.846C126.444 331.396 125.801 329.811 125.801 328.402C125.801 325.978 127.417 324.373 129.862 324.373C132.142 324.373 132.919 325.429 134.255 326.962C135.591 325.429 136.368 324.373 138.648 324.373C141.093 324.373 142.709 325.989 142.709 328.402C142.709 329.821 142.066 331.406 140.595 332.846L134.255 339.155L127.915 332.846Z"
                                fill="#EBEBEB" />
                            <path
                                d="M393.908 38.6703H346.925C342.46 38.6703 338.834 42.2959 338.834 46.7607V77.0195C338.834 81.4842 342.46 85.1099 346.925 85.1099H360.435L366.464 93.0035C368.453 95.6036 372.369 95.6036 374.358 93.0035L380.388 85.1099H393.897C398.363 85.1099 401.989 81.4842 401.989 77.0195V46.7607C401.989 42.2959 398.363 38.6703 393.897 38.6703H393.908Z"
                                fill="#F5F5F5" />
                            <path d="M355.659 74.0568H360.984V55.1308H354.768L355.659 74.0568Z" fill="#E0E0E0" />
                            <path
                                d="M385.671 58.0935C385.402 57.2544 384.552 55.4934 383.744 55.1412C381.413 54.0949 376.306 54.4264 371.779 55.0272C371.965 54.6646 372.131 54.3435 372.214 54.1053C372.607 53.0797 373.229 50.925 373.156 49.8373C373.094 48.8325 372.628 46.6053 371.779 46.077C371.323 45.787 370.017 45.6937 369.644 46.077C368.753 47.0093 369.375 49.972 369.012 51.2254C368.681 52.3649 367.199 54.385 365.925 55.9699C364.35 56.2599 363.335 56.4775 363.335 56.4775V73.1866C363.335 73.1866 376.979 76.8952 381.372 75.7039C383.061 75.2377 383.858 72.3165 384.48 70.6797C385.588 67.7378 386.625 61.108 385.661 58.1142L385.671 58.0935Z"
                                fill="#E0E0E0" />
                            <path
                                d="M275.058 64.9512C274.561 58.7979 269.422 54.0638 263.258 54.0638H254.742C248.567 54.0638 243.439 58.7979 242.942 64.9512L242.227 72.1714H275.773L275.058 64.9512Z"
                                fill="#EBEBEB" />
                            <path
                                d="M259 54.0639C263.411 54.0639 266.987 50.488 266.987 46.077C266.987 41.666 263.411 38.0902 259 38.0902C254.588 38.0902 251.012 41.666 251.012 46.077C251.012 50.488 254.588 54.0639 259 54.0639Z"
                                fill="#EBEBEB" />
                            <path
                                d="M100.513 176.3C99.2385 176.3 98.0678 176.746 97.1458 177.502L90.7329 172.333C91.0955 171.608 91.3131 170.789 91.3131 169.919C91.3131 166.967 88.9199 164.574 85.9673 164.574C83.0147 164.574 80.6216 166.967 80.6216 169.919C80.6216 172.872 83.0147 175.265 85.9673 175.265C87.2416 175.265 88.4123 174.819 89.3343 174.063L95.7472 179.232C95.3846 179.957 95.167 180.776 95.167 181.646C95.167 182.516 95.3742 183.334 95.7472 184.059L89.3343 189.228C88.4123 188.483 87.2416 188.027 85.9673 188.027C83.0147 188.027 80.6216 190.42 80.6216 193.372C80.6216 196.324 83.0147 198.717 85.9673 198.717C88.9199 198.717 91.3131 196.324 91.3131 193.372C91.3131 192.502 91.1059 191.684 90.7329 190.958L97.1458 185.789C98.0678 186.535 99.2385 186.991 100.513 186.991C103.465 186.991 105.859 184.598 105.859 181.646C105.859 178.693 103.465 176.3 100.513 176.3Z"
                                fill="#E0E0E0" />
                            <path
                                d="M259 382C369.937 382 459.87 376.75 459.87 370.274C459.87 363.797 369.937 358.547 259 358.547C148.062 358.547 58.1299 363.797 58.1299 370.274C58.1299 376.75 148.062 382 259 382Z"
                                fill="#F5F5F5" />
                            <path
                                d="M327.055 92.2679H302.844L278.425 371.32H302.636C313.856 371.32 323.75 362.225 324.734 351.006L345.599 112.592C346.583 101.374 338.275 92.2783 327.055 92.2783V92.2679Z"
                                fill="#263238" />
                            <path
                                d="M342.056 120.248C342.149 119.17 343.102 118.3 344.17 118.3C345.237 118.3 346.045 119.17 345.951 120.248L344.315 138.946C344.221 140.023 343.268 140.893 342.201 140.893C341.134 140.893 340.326 140.023 340.419 138.946L342.056 120.248Z"
                                fill="#039D55" />
                            <path opacity="0.3"
                                d="M342.056 120.248C342.149 119.17 343.102 118.3 344.17 118.3C345.237 118.3 346.045 119.17 345.951 120.248L344.315 138.946C344.221 140.023 343.268 140.893 342.201 140.893C341.134 140.893 340.326 140.023 340.419 138.946L342.056 120.248Z"
                                fill="white" />
                            <path
                                d="M297.684 371.309H197.928C186.708 371.309 178.399 362.214 179.383 350.995L200.248 112.582C201.233 101.363 211.126 92.2679 222.346 92.2679H322.103C333.323 92.2679 341.631 101.363 340.647 112.582L319.782 350.995C318.798 362.214 308.904 371.309 297.684 371.309Z"
                                fill="#039D55" />
                            <path
                                d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.106 104.792 287.335 107.879 283.18 107.879H258.534C254.39 107.879 251.157 104.792 250.992 100.679L250.961 99.8715C250.888 98.183 249.572 96.9295 247.873 96.9295H221.942C213.292 96.9295 205.667 103.943 204.91 112.582L184.045 350.995C183.289 359.645 189.681 366.648 198.332 366.648H298.088C306.739 366.648 314.364 359.635 315.12 350.995L335.985 112.582C336.741 103.932 330.349 96.9295 321.699 96.9295Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.106 104.792 287.335 107.879 283.18 107.879H258.534C254.39 107.879 251.157 104.792 250.992 100.679L250.961 99.8715C250.888 98.183 249.572 96.9295 247.873 96.9295H221.942C213.292 96.9295 205.667 103.943 204.91 112.582L184.045 350.995C183.289 359.645 189.681 366.648 198.332 366.648H298.088C306.739 366.648 314.364 359.635 315.12 350.995L335.985 112.582C336.741 103.932 330.349 96.9295 321.699 96.9295Z"
                                fill="white" />
                            <g opacity="0.2">
                                <path
                                    d="M264.875 100.926C265.701 100.134 265.784 98.8799 265.06 98.1237C264.336 97.3674 263.079 97.3957 262.253 98.1869C261.426 98.9782 261.343 100.233 262.067 100.989C262.791 101.745 264.048 101.717 264.875 100.926Z"
                                    fill="black" />
                                <path
                                    d="M279.772 97.5822H272.976C271.878 97.5822 270.914 98.473 270.821 99.5607C270.728 100.659 271.536 101.539 272.634 101.539H279.43C280.528 101.539 281.492 100.648 281.585 99.5607C281.678 98.4627 280.87 97.5822 279.772 97.5822Z"
                                    fill="black" />
                            </g>
                            <path d="M216.182 107.838H218.275L218.461 105.745H216.369L216.182 107.838Z" fill="#039D55" />
                            <path
                                d="M220.564 105.745L220.378 107.838H222.471L222.657 105.745L222.844 103.642H220.741L220.564 105.745Z"
                                fill="#039D55" />
                            <path
                                d="M225.123 101.55L224.936 103.642L224.76 105.745L224.574 107.838H226.666L226.853 105.745L227.039 103.642L227.216 101.55H225.123Z"
                                fill="#039D55" />
                            <path
                                d="M315.327 101.684L315.192 103.228H314.167L313.897 106.304H314.923L314.788 107.838H324.019L324.558 101.684H315.327ZM319.026 106.304H315.949L316.218 103.228H319.295L319.026 106.304Z"
                                fill="#039D55" />
                            <g opacity="0.4">
                                <path
                                    d="M258.606 107.879L189.743 363.913C192.105 365.633 195.058 366.648 198.342 366.648H203.729L273.328 107.879H258.617H258.606Z"
                                    fill="white" />
                                <path
                                    d="M321.699 96.9295H295.768C294.069 96.9295 292.525 98.1933 292.162 99.8715L291.986 100.679C291.126 104.688 287.521 107.703 283.501 107.858L213.903 366.648H266.987L335.985 110.106C335.446 102.637 329.5 96.9191 321.699 96.9191V96.9295Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M218.865 164.647L215.813 163.755C214.989 163.51 214.566 162.597 214.933 161.813L220.054 150.815L224.928 152.241L220.566 163.802C220.31 164.49 219.556 164.862 218.854 164.656L218.865 164.647Z"
                                fill="#039D55" />
                            <path
                                d="M284.444 141.018C284.444 141.018 287.459 142.354 290.495 140.365C293.675 138.283 299.653 140.904 297.84 149.377C294.732 163.963 288.247 174.436 292.453 178.849C292.453 178.849 278.446 179.491 280.518 167.122C282.072 157.851 292.608 147.316 290.07 145.223C289.22 144.529 287.988 144.881 284.009 144.881L284.434 141.007L284.444 141.018Z"
                                fill="#263238" />
                            <path
                                d="M284.02 144.892C286.485 144.892 288.34 145.13 289.707 145.576C290.598 143.017 290.547 140.779 290.453 139.723C287.211 140.075 284.455 141.018 284.455 141.018L284.03 144.892H284.02Z"
                                fill="#039D55" />
                            <path
                                d="M270.831 130.389C270.831 130.389 265.009 128.721 268.853 124.971C273.867 120.072 281.005 129.239 281.005 129.239C281.005 129.239 297.705 136.542 283.916 153.479C283.916 153.479 278.943 162.388 277.897 158.928C276.861 155.468 283.781 145.627 283.781 145.627L283.367 136.822L281.45 133.383L275.431 129.954L270.831 130.389Z"
                                fill="#263238" />
                            <path
                                d="M247.739 179.988C246.082 177.274 242.528 176.425 239.814 178.082L239.721 178.134C237.918 179.242 235.981 180.486 234.074 181.615L228.325 185.064C225.631 186.649 222.927 188.182 220.202 189.674C220.037 187.758 220.026 185.613 220.109 183.459C220.182 181.035 220.347 178.559 220.544 176.083C220.71 173.597 220.969 171.08 221.186 168.614V168.552C221.3 167.288 220.565 166.066 219.322 165.61C217.83 165.061 216.183 165.827 215.634 167.319C214.711 169.816 213.986 172.281 213.271 174.809C212.588 177.336 211.987 179.895 211.5 182.516C211.044 185.157 210.63 187.82 210.63 190.824C210.661 192.347 210.681 193.9 211.303 196.024C211.686 197.081 212.132 198.438 213.789 199.898C214.608 200.603 215.768 201.193 216.939 201.421C218.099 201.649 219.114 201.566 219.964 201.4C220.192 201.359 220.441 201.286 220.668 201.193L221.01 201.048C223.217 200.137 225.413 199.225 227.548 198.189C229.702 197.184 231.816 196.138 233.898 195.019C235.991 193.921 238.042 192.761 240.073 191.559C242.103 190.316 244.072 189.135 246.113 187.726C248.589 185.997 249.335 182.599 247.739 179.988Z"
                                fill="#CE7A63" />
                            <path
                                d="M252.815 172.437C256.307 179.47 251.282 185.572 242.072 195.351C233.867 188.493 232.531 180.019 232.531 180.019C232.531 180.019 243.15 171.235 252.815 172.447V172.437Z"
                                fill="#039D55" />
                            <path opacity="0.2"
                                d="M253.147 180.786C249.738 178.704 245.916 177.782 243.222 181.169C240.228 184.95 237.773 187.188 236.063 188.493C237.472 190.72 239.399 193.113 242.072 195.351C247.573 189.508 251.562 184.981 253.147 180.786Z"
                                fill="black" />
                            <path
                                d="M218.555 155.396L220.927 156.96C221.818 157.551 222.367 158.524 222.409 159.591L222.585 164.574C222.657 166.563 221.756 168.469 220.181 169.681L219.197 170.427C215.095 168.106 212.37 162.575 212.37 162.575L211.417 161.083C210.567 159.757 210.899 158.089 212.173 157.25L215.105 155.323C216.12 154.66 217.488 154.681 218.555 155.386V155.396Z"
                                fill="#CE7A63" />
                            <path
                                d="M244.693 366.648C250.07 350.032 253.727 331.665 250.08 318.23C272.251 253.113 262.253 234.156 262.253 234.156L235.866 224.532C235.866 224.532 232.095 283.175 230.956 311.527C230.324 327.397 227.61 348.012 224.491 366.637H244.683L244.693 366.648Z"
                                fill="#263238" />
                            <path opacity="0.5"
                                d="M258.379 258.251L253.023 249.622L249.738 256.355C249.738 256.355 246.651 282.211 252.152 311.983C257.291 296.113 260.42 283.206 262.243 272.785L258.379 258.251Z"
                                fill="black" />
                            <path
                                d="M260.907 366.648H280.902C282.942 349.431 282.963 330.899 276.861 318.499C286.154 250.347 272.707 233.648 272.707 233.648L244.963 229.256C244.963 229.256 252.494 287.536 256.814 315.588C259.052 330.111 260.316 348.955 260.907 366.637V366.648Z"
                                fill="#263238" />
                            <path
                                d="M240.435 185.53C239.741 189.208 238.83 191.943 237.949 200.841C237.058 208.351 236.405 215.768 235.545 228.168L273.1 234.114C274.022 223.413 277.162 211.552 287.677 188.814C290.112 183.541 287.47 177.689 281.989 176.249C280.529 175.865 278.964 175.482 277.358 175.151C271.111 173.845 265.973 172.83 260.306 172.447C258.42 172.323 256.473 172.25 254.587 172.219C247.812 172.095 241.679 178.942 240.435 185.53Z"
                                fill="#039D55" />
                            <path
                                d="M279.202 155.758C276.851 161.011 273.432 170.779 276.426 175.006C276.426 175.006 271.349 173.4 259.239 178.476C256.773 173.39 259.373 172.302 259.373 172.302C265.838 171.825 266.729 167.319 266.656 162.937L279.202 155.758Z"
                                fill="#CE7A63" />
                            <path
                                d="M261.777 177.471C263.186 177.906 264.077 179.056 264.647 180.299C265.548 182.267 267.91 183.065 269.785 181.988C272.852 180.237 276.809 177.74 278.767 175.524C277.576 174.643 275.898 172.996 275.898 172.996C275.898 172.996 264.232 175.71 261.777 177.471Z"
                                fill="white" />
                            <path
                                d="M258.41 176.342C258.41 176.342 257.27 176.466 255.965 177.43C255.053 178.103 253.789 177.191 254.162 176.124C255.457 172.457 257.685 172.022 257.685 172.022C257.685 172.022 258.949 171.39 261.041 172.064C257.923 173.131 258.399 176.342 258.399 176.342H258.41Z"
                                fill="white" />
                            <path opacity="0.2"
                                d="M274.084 158.69L266.656 162.937C266.677 163.973 266.636 165.019 266.48 166.014C268.894 166.045 272.707 164.025 273.525 161.642C273.929 160.451 274.157 159.291 274.084 158.69Z"
                                fill="black" />
                            <path
                                d="M285.636 145.493C282.569 154.091 281.45 157.778 275.721 161.228C267.102 166.418 257.187 161.383 257.622 152.195C258.006 143.918 262.958 131.259 272.551 129.778C282 128.317 288.692 136.905 285.626 145.503L285.636 145.493Z"
                                fill="#CE7A63" />
                            <path
                                d="M274.084 145.172C273.856 145.907 273.287 146.404 272.82 146.301C272.344 146.187 272.147 145.503 272.375 144.768C272.603 144.032 273.173 143.535 273.639 143.638C274.115 143.752 274.312 144.436 274.084 145.172Z"
                                fill="#263238" />
                            <path
                                d="M264.916 142.716C264.688 143.452 264.118 143.949 263.652 143.846C263.175 143.732 262.979 143.048 263.207 142.312C263.434 141.577 264.004 141.08 264.47 141.183C264.937 141.287 265.144 141.981 264.916 142.716Z"
                                fill="#263238" />
                            <path d="M264.667 141.287L263.082 140.375C263.082 140.375 263.548 141.96 264.667 141.287Z"
                                fill="#263238" />
                            <path
                                d="M267.578 144.229C267.578 144.229 265.372 147.098 263.548 148.3C264.232 149.429 265.983 149.398 265.983 149.398L267.578 144.229Z"
                                fill="#BA4D3C" />
                            <path
                                d="M276.871 140.904C276.757 140.883 276.654 140.821 276.581 140.728C275.545 139.122 273.908 139.174 273.888 139.174C273.649 139.174 273.453 138.998 273.453 138.749C273.453 138.5 273.67 138.303 273.908 138.293C273.991 138.293 276.053 138.231 277.338 140.22C277.462 140.417 277.4 140.696 277.182 140.841C277.079 140.914 276.965 140.935 276.851 140.914L276.871 140.904Z"
                                fill="#263238" />
                            <path
                                d="M262.947 136.574C262.844 136.532 262.761 136.449 262.72 136.346C262.637 136.128 262.761 135.869 262.999 135.786C265.382 134.885 267.081 135.993 267.143 136.035C267.34 136.17 267.382 136.439 267.236 136.636C267.081 136.832 266.801 136.884 266.594 136.75C266.532 136.708 265.196 135.859 263.31 136.584C263.186 136.625 263.061 136.625 262.947 136.584V136.574Z"
                                fill="#263238" />
                            <path d="M273.836 143.732L272.251 142.82C272.251 142.82 272.717 144.405 273.836 143.732Z"
                                fill="#263238" />
                            <path
                                d="M239.669 213.769H230.707C229.858 213.769 229.029 213.085 228.853 212.236L224.698 192.844C224.522 191.994 225.061 191.311 225.9 191.311H234.862C235.711 191.311 236.54 191.994 236.716 192.844L240.87 212.236C241.046 213.085 240.508 213.769 239.669 213.769Z"
                                fill="#263238" />
                            <path
                                d="M238.633 213.769H229.671C228.822 213.769 227.993 213.085 227.817 212.236L223.663 192.844C223.486 191.994 224.025 191.311 224.864 191.311H233.826C234.675 191.311 235.504 191.994 235.68 192.844L239.834 212.236C240.011 213.085 239.472 213.769 238.633 213.769Z"
                                fill="#263238" />
                            <path opacity="0.2"
                                d="M238.633 213.769H229.671C228.822 213.769 227.993 213.085 227.817 212.236L223.663 192.844C223.486 191.994 224.025 191.311 224.864 191.311H233.826C234.675 191.311 235.504 191.994 235.68 192.844L239.834 212.236C240.011 213.085 239.472 213.769 238.633 213.769Z"
                                fill="white" />
                            <path
                                d="M235.421 202.343L238.187 201.732C239.233 201.504 240.321 201.784 241.109 202.498L244.818 205.834C246.299 207.17 247.045 209.139 246.817 211.117L246.672 212.34C242.145 213.676 236.271 211.78 236.271 211.78L234.54 211.428C232.997 211.117 232.023 209.719 232.313 208.217L232.966 204.777C233.194 203.586 234.167 202.623 235.411 202.343H235.421Z"
                                fill="#CE7A63" />
                            <path
                                d="M283.17 182.164C280 181.863 277.192 184.194 276.892 187.354L276.871 187.53C276.778 188.566 276.633 189.829 276.498 191C276.364 192.191 276.198 193.382 276.011 194.574C275.659 196.956 275.234 199.329 274.768 201.67C274.281 204.011 273.701 206.3 273.059 208.558C272.51 210.361 271.878 212.101 271.204 213.8C270.531 213.842 269.64 213.79 268.708 213.645C266.491 213.303 263.217 212.661 260.793 211.884C258.358 211.128 255.903 210.237 253.447 209.304C250.992 208.403 248.516 207.367 246.102 206.393L246.03 206.362C244.849 205.886 243.44 206.248 242.642 207.315C241.699 208.59 241.968 210.392 243.243 211.335C245.522 213.013 247.812 214.473 250.194 215.944C252.577 217.374 255.022 218.71 257.591 219.943C260.171 221.145 263.652 222.284 266.708 223.082C268.241 223.465 269.868 223.807 271.878 223.828C272.883 223.828 274.012 223.734 275.338 223.32C276.623 222.937 278.218 222.067 279.399 220.647C279.575 220.43 279.762 220.171 279.896 219.912L280 219.726C281.357 217.219 282.528 214.66 283.481 212.07C284.424 209.48 285.242 206.87 285.895 204.239C286.558 201.618 287.086 198.976 287.501 196.314C287.698 194.988 287.884 193.652 288.029 192.315C288.195 190.958 288.298 189.684 288.371 188.172C288.516 185.116 286.237 182.443 283.16 182.153L283.17 182.164Z"
                                fill="#CE7A63" />
                            <path
                                d="M284.9 177.585C291.313 182.112 291.614 188.887 288.153 201.867C283.522 204.187 272.271 201.245 272.271 201.245C272.271 201.245 275.815 181.107 284.9 177.585Z"
                                fill="#039D55" />
                            <path
                                d="M261.86 151.687C261.86 151.687 265.337 151.338 275.001 151.486C273.787 152.926 271.607 154.072 266.657 153.995C264.17 154.078 262.037 153.133 261.872 151.893C261.872 151.822 261.872 151.758 261.872 151.687H261.86Z"
                                fill="#263238" />
                            <path
                                d="M269.002 152.867C267.104 152.785 265.195 153.009 263.569 153.499C264.464 153.812 265.537 153.983 266.645 153.977C268.542 154.06 270.439 153.842 272.078 153.346C271.182 153.027 270.109 152.856 269.013 152.862L269.002 152.867Z"
                                fill="#BA4D3C" />
                            <path
                                d="M262.296 151.651C262.473 152.017 263.039 152.307 263.769 152.395C266.633 152.431 269.509 152.348 272.349 152.153C273.268 152.124 274.093 151.864 274.553 151.468C270.463 151.374 266.362 151.433 262.284 151.657L262.296 151.651Z"
                                fill="white" />
                            <path
                                d="M272.634 129.198C272.085 129.281 271.546 129.405 271.028 129.56V130.047C272.23 130.037 273.567 130.182 275.048 130.638C282.217 132.824 283.367 136.812 280.933 142.81C279.783 145.648 279.161 151.667 280.487 152.796C280.829 153.086 281.865 153.044 283.212 152.827C284.103 150.786 284.952 148.341 286.04 145.296C289.179 136.491 282.321 127.696 272.634 129.188V129.198Z"
                                fill="#263238" />
                            <path
                                d="M286.454 153.345C284.952 154.888 282.974 155.582 281.316 155.572C278.84 155.562 278.436 153.003 279.834 150.869C281.088 148.953 283.896 146.653 286.04 147.689C288.154 148.714 288.164 151.584 286.444 153.345H286.454Z"
                                fill="#CE7A63" />
                            <g opacity="0.9">
                                <path
                                    d="M271.173 197.36C253.737 196.283 245.854 193.061 242.714 191.238C242.611 191.176 242.528 191.114 242.445 191.041C241.544 190.254 242.683 188.804 243.719 189.405C246.465 190.99 254.028 194.211 271.298 195.278C271.867 195.309 272.313 195.796 272.282 196.366C272.251 196.936 271.754 197.381 271.173 197.34V197.36Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.9">
                                <path
                                    d="M270.262 207.222C270.241 207.802 269.744 208.248 269.174 208.227C253.966 207.512 243.481 203.027 240.342 201.514C239.803 201.255 239.607 200.603 239.886 200.085C240.156 199.598 240.746 199.411 241.243 199.65C244.227 201.069 254.587 205.472 269.267 206.155C269.837 206.186 270.283 206.652 270.262 207.222Z"
                                    fill="white" />
                            </g>
                            <g opacity="0.9">
                                <path
                                    d="M252.712 224.501C244.641 222.916 240.477 221.849 238.736 221.352C238.166 221.186 237.856 220.585 238.042 220.026C238.218 219.508 238.767 219.208 239.296 219.363C240.984 219.839 245.118 220.917 253.106 222.481C253.665 222.595 254.038 223.134 253.924 223.693C253.82 224.252 253.271 224.625 252.702 224.511L252.712 224.501Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M271.153 132.689C270.49 133.041 269.588 132.637 269.267 131.953C268.946 131.27 269.122 130.431 269.557 129.809C269.992 129.188 270.645 128.763 271.319 128.421C270.904 129.043 270.106 130.089 270.127 130.845C270.148 131.591 270.428 132.906 271.142 132.689H271.153Z"
                                fill="#263238" />
                            <path
                                d="M279.803 153.79C279.845 154.174 279.42 154.495 279.037 154.432C278.653 154.37 278.363 154.039 278.249 153.666C278.135 153.293 278.166 152.899 278.208 152.516C278.301 151.636 278.456 150.755 278.84 149.957C279.223 149.16 279.845 148.445 280.663 148.124C280.984 148.414 280.995 148.994 280.819 149.388C280.642 149.781 280.342 150.092 280.093 150.444C279.461 151.366 279.296 152.578 279.648 153.635C279.783 153.635 279.669 153.79 279.803 153.801V153.79Z"
                                fill="#263238" />
                            <defs>
                                <linearGradient id="paint0_linear_28_1911" x1="233.665" y1="167.502"
                                    x2="231.627" y2="161.077" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#F8A629" />
                                </linearGradient>
                                <linearGradient id="paint1_linear_28_1911" x1="229.666" y1="167.018"
                                    x2="225.584" y2="165.53" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                                <linearGradient id="paint2_linear_28_1911" x1="231.994" y1="167.315"
                                    x2="229.889" y2="163.655" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                                <linearGradient id="paint3_linear_28_1911" x1="237.106" y1="166.146"
                                    x2="233.757" y2="160.525" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F71873" />
                                    <stop offset="1" stop-color="#C6211B" />
                                </linearGradient>
                            </defs>
                        </svg>

                        <!-- Shape 1 -->
                        <svg class="shape-1" width="128" height="133" viewBox="0 0 128 133" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M97.2488 36.8319L24.3196 25.7714C18.7167 24.9217 13.491 28.7707 12.6414 34.373L4.23492 89.8023C3.38527 95.4046 7.23475 100.63 12.8376 101.48L67.9033 109.831C67.6336 118.864 74.1419 126.871 83.299 128.259C83.7088 128.322 84.1027 128.35 84.5068 128.38C82.2278 124.199 80.729 118.398 80.186 111.683L85.7684 112.53C91.3713 113.38 96.597 109.531 97.4466 103.928L105.853 48.4991C106.703 42.8967 102.853 37.6714 97.2504 36.8217L97.2488 36.8319Z"
                                fill="#039D55" />
                            <path opacity="0.4"
                                d="M97.2488 36.8319L24.3196 25.7714C18.7167 24.9217 13.491 28.7707 12.6414 34.373L4.23492 89.8023C3.38527 95.4046 7.23475 100.63 12.8376 101.48L67.9033 109.831C67.6336 118.864 74.1419 126.871 83.299 128.259C83.7088 128.322 84.1027 128.35 84.5068 128.38C82.2278 124.199 80.729 118.398 80.186 111.683L85.7684 112.53C91.3713 113.38 96.597 109.531 97.4466 103.928L105.853 48.4991C106.703 42.8967 102.853 37.6714 97.2504 36.8217L97.2488 36.8319Z"
                                fill="white" />
                            <path
                                d="M108.284 62.5933L114.754 58.21L118.238 67.9167C118.238 67.9167 111.972 71.367 109.034 68.2182L108.274 62.5917L108.284 62.5933Z"
                                fill="#FF8B7B" />
                            <path d="M108.284 62.5934L103.177 70.2218L107.818 75.41L113.576 68.6033L108.284 62.5934Z"
                                fill="#FF8B7B" />
                            <path
                                d="M119.969 60.2374L120.387 63.7688C120.596 65.4979 119.691 67.2467 118.238 67.9169L115.952 68.9637L111.697 57.9142L116.854 57.4181C118.422 57.2368 119.757 58.4555 119.967 60.2476L119.969 60.2374Z"
                                fill="#FF8B7B" />
                            <path
                                d="M108.284 62.5934C108.284 62.5934 111.262 56.5699 111.258 54.5891C111.26 53.4054 112.408 53.7786 113.34 54.2657C114.058 54.647 114.475 55.4227 114.383 56.2364C114.151 58.3177 113.497 62.2838 111.86 62.2975C109.636 62.3164 108.284 62.5934 108.284 62.5934Z"
                                fill="#FF8B7B" />
                            <path
                                d="M113.912 70.1839C112.637 68.2303 110.748 66.6552 108.387 65.7836L106.71 65.1626C105.758 64.8086 105.486 65.0085 105.323 65.2561L104.715 65.9497L103.478 67.3337C102.638 68.2436 101.817 69.1668 100.96 70.0531C99.2913 71.8641 97.5724 73.5942 95.8557 75.2407C94.1508 76.8786 92.3795 78.4016 90.68 79.5897C90.5164 79.7011 90.3528 79.8125 90.1907 79.9137C89.7569 79.2507 89.3246 78.5774 88.9174 77.8766C87.7323 75.8109 86.6304 73.6111 85.6243 71.3316C84.6199 69.0419 81.2734 62.2269 80.4428 59.8273C80.0267 58.6326 79.624 57.419 79.252 56.2101L78.7196 54.4005C78.5545 53.8307 78.3758 53.1435 78.2741 52.709C78.2542 52.6326 78.2201 52.5122 78.2018 52.4256C77.0579 48.2916 72.7741 45.8608 68.6383 47.0147C64.5039 48.1584 62.073 52.4417 63.2271 56.5772C63.4701 57.4627 63.677 58.1018 63.8992 58.848L64.5945 60.9651C65.0732 62.3684 65.5771 63.744 66.1015 65.1227C67.1621 67.8715 70.8236 75.0277 72.1573 77.7026C73.4911 80.3776 74.9964 83.0262 76.7325 85.605C78.4787 88.1854 80.4525 90.7164 82.8379 93.0899L83.13 93.3751C84.4971 94.7245 86.4513 95.4505 88.5151 95.1767C91.2082 94.8308 93.084 93.9313 94.6944 93.0545C96.2977 92.1556 97.6071 91.1911 98.8141 90.2112C101.228 88.2513 103.216 86.1954 105.095 84.102C106.953 82.0054 108.635 79.8297 110.245 77.6431C111.033 76.5262 111.809 75.418 112.546 74.2831L113.646 72.5638L114.186 71.6924C114.397 71.41 114.508 71.0915 113.93 70.2075L113.912 70.1839Z"
                                fill="#263238" />
                            <path opacity="0.4"
                                d="M76.446 61.1699L70.2097 64.2894L67.9546 67.8974C68.1534 68.4514 68.3421 69.0039 68.5528 69.5493C69.6134 72.2981 70.8282 74.9969 72.1604 77.6821C73.4942 80.3571 74.9995 83.0057 76.7356 85.5845C77.5486 86.787 78.416 87.9768 79.3496 89.1451C77.6082 82.2488 76.446 61.1699 76.446 61.1699Z"
                                fill="black" />
                            <path
                                d="M21.3702 84.6686C20.262 94.9466 18.7104 94.2608 17.4687 102.172L67.3822 109.741C73.7639 85.972 73.0576 82.0615 75.5429 66.0202C76.9436 56.9915 76.928 47.5594 68.0777 45.2532C58.2391 42.6924 45.7375 40.9012 36.2938 40.6424C29.5219 40.4536 23.8813 45.8636 23.8494 52.6377C23.7967 66.5963 21.5264 74.1729 21.3702 84.6686Z"
                                fill="#263238" />
                            <path opacity="0.9"
                                d="M63.5771 44.183C57.1689 42.771 50.0824 41.6858 43.6128 41.0923C43.4471 43.1522 44.2197 48.5605 54.8921 54.6739C54.8921 54.6739 58.2547 49.568 60.0093 52.3696C60.0093 52.3696 62.1983 49.4745 64.9861 55.8276C64.9861 55.8276 71.3443 50.7988 63.5771 44.183Z"
                                fill="white" />
                            <path opacity="0.4"
                                d="M34.405 54.6158C34.061 64.2763 25.5896 79.2317 21.1572 86.4176C21.2395 85.8747 21.2973 85.2863 21.37 84.6686C21.4631 78.1134 22.3872 72.7109 23.0734 66.1827L34.405 54.6158Z"
                                fill="black" />
                            <path
                                d="M51.2597 23.6965C49.9714 32.2603 47.6044 36.9514 44.9868 41.2903C44.7357 41.7027 44.7589 42.2406 45.0677 42.6227C47.8878 46.0679 52.5213 49.2329 59.2984 50.355C65.9935 51.4646 65.9227 49.306 64.6923 46.7096C64.5182 46.3374 64.2528 46.0143 63.9357 45.7566C59.76 42.3364 60.1491 38.6654 61.7619 36.6678L51.2582 23.7067L51.2597 23.6965Z"
                                fill="#FF8B7B" />
                            <path opacity="0.2"
                                d="M51.2699 23.698L61.7736 36.6591C60.86 37.7778 60.3461 39.4392 60.8108 41.2803C58.3913 40.9972 56.0495 39.8562 54.1766 37.6967C51.4374 34.5467 50.8506 31.2306 50.7462 26.6675C50.9404 25.733 51.11 24.7529 51.2699 23.698Z"
                                fill="black" />
                            <path
                                d="M48.5037 17.4111C47.8054 25.6767 46.4389 26.8106 49.9787 31.5908C55.2911 38.7773 65.3011 41.5213 68.005 33.4341C70.4398 26.1548 73.2087 12.7339 65.6346 8.36866C58.1773 4.06299 49.2121 9.14699 48.5139 17.4126L48.5037 17.4111Z"
                                fill="#FF8B7B" />
                            <path
                                d="M67.0595 29.2359C67.0595 29.2359 64.3195 27.8878 56.2087 26.3015C56.6336 29.373 57.9745 32.07 62.1349 32.8267C66.2938 33.5936 67.0611 29.2256 67.0611 29.2256L67.0595 29.2359Z"
                                fill="#263238" />
                            <path
                                d="M60.6265 30.1986C62.635 30.5661 63.9876 31.3894 64.8926 32.4696C64.2153 32.8593 63.3067 33.0463 62.1453 32.8283C60.1367 32.4608 58.7928 31.6493 57.8894 30.5588C58.5667 30.1691 59.465 29.9805 60.6265 30.1986Z"
                                fill="#FF5652" />
                            <path
                                d="M66.7046 29.0878C66.3672 29.6548 66.0179 30.2305 65.1736 30.2701C63.464 30.0736 59.2446 28.6689 58.1282 28.1538C57.4069 27.8663 56.8318 27.4438 56.5522 26.3851C62.7876 27.6241 65.7468 28.7015 66.6928 29.0965L66.7046 29.0878Z"
                                fill="white" />
                            <path
                                d="M65.0076 21.1399C65.0076 21.1399 66.2084 24.2767 67.5625 25.7812C66.5877 26.6811 64.9635 26.2672 64.9635 26.2672L65.0076 21.1399Z"
                                fill="#FF5652" />
                            <path
                                d="M57.4618 16.3808C57.3917 16.3596 57.3349 16.3196 57.2915 16.2606C57.1509 16.0821 57.1692 15.823 57.3493 15.6722C59.1333 14.2035 60.9776 14.7556 61.0477 14.7767C61.2684 14.8416 61.3895 15.08 61.3143 15.2991C61.2494 15.5198 61.011 15.6408 60.7903 15.5759C60.7289 15.5666 59.2937 15.1498 57.8697 16.3169C57.7502 16.414 57.5903 16.4317 57.4501 16.3894L57.4618 16.3808Z"
                                fill="#263238" />
                            <path
                                d="M70.8437 19.8981C70.7074 19.8984 70.5805 19.8372 70.4936 19.7192C69.4648 18.2116 67.9659 18.2148 67.9029 18.2157C67.6714 18.2225 67.4898 18.0378 67.483 17.8063C67.4762 17.5747 67.6609 17.3932 67.8925 17.3864C67.976 17.3886 69.8883 17.3538 71.1834 19.2476C71.3121 19.4348 71.2615 19.6995 71.0743 19.8283C71.0036 19.8804 70.9272 19.9003 70.8437 19.8981Z"
                                fill="#263238" />
                            <path
                                d="M5.91807 84.0226C5.87085 84.4031 5.87328 84.8016 5.91823 85.1961C6.3495 89.0543 7.19183 92.1367 8.06737 95.2766C8.56812 97.0184 9.09557 98.7224 9.64662 100.409C10.6283 100.914 11.6933 101.285 12.8405 101.459L23.8823 103.134C23.6378 102.259 23.4036 101.385 23.1575 100.52C22.3543 97.6634 21.6243 94.8075 21.0125 92.0011C20.4852 89.6056 20.0404 87.1493 19.8619 85.0791C20.0401 84.4565 20.3587 83.5304 20.7592 82.6168C21.2749 81.4272 21.8968 80.1594 22.592 78.8923C23.9838 76.3478 25.5724 73.7493 27.221 71.1704C28.8797 68.5931 30.6512 66.0328 32.4298 63.4946C34.2068 60.9666 36.0767 58.3794 37.8949 55.9938L37.9601 55.9094C37.9601 55.9094 38.0269 55.8148 38.0654 55.7682C40.5745 52.2825 39.7811 47.4264 36.295 44.9174C32.809 42.4085 27.9524 43.2017 25.4434 46.6874C23.44 49.4639 21.6208 52.1322 19.786 54.9029C17.9732 57.6664 16.2259 60.4818 14.519 63.3767C12.8223 66.2731 11.1896 69.2315 9.69119 72.4095C8.93765 73.9926 8.21421 75.6536 7.55408 77.4499C6.91133 79.2698 6.26949 81.1527 5.93331 83.7839L5.89913 84.0093L5.91807 84.0226Z"
                                fill="#263238" />
                            <path
                                d="M43.9545 22.3266C44.4655 24.4158 45.7702 26.0386 47.1299 26.8839C49.179 28.1586 50.7138 26.1911 50.5627 23.6641C50.427 21.3804 49.2051 17.968 46.9448 17.7404C44.7168 17.5073 43.3626 19.9423 43.9443 22.325L43.9545 22.3266Z"
                                fill="#FF8B7B" />
                            <path
                                d="M58.9752 19.4602C58.8255 20.1709 59.0837 20.8178 59.5502 20.92C60.0167 21.0222 60.5103 20.5312 60.6513 19.8087C60.8026 19.0877 60.5428 18.4511 60.0866 18.3505C59.6303 18.2499 59.1265 18.7393 58.9752 19.4602Z"
                                fill="#2E353A" />
                            <path
                                d="M67.006 21.1601C66.8563 21.8708 67.1144 22.5177 67.5707 22.6183C68.027 22.7189 68.5308 22.2296 68.6821 21.5086C68.8318 20.7979 68.5736 20.151 68.1173 20.0504C67.6611 19.9498 67.147 20.4376 67.006 21.1601Z"
                                fill="#2E353A" />
                        </svg>
                        <!-- Shape 2 -->
                        <svg class="shape-2" width="110" height="114" viewBox="0 0 110 114" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M98.6725 21.1219L25.9842 8.51457C20.4006 7.54614 15.0944 11.2834 14.1261 16.8664L4.54537 72.1049C3.57703 77.6879 7.31476 82.9937 12.8983 83.9622L67.7744 93.48C67.3131 102.505 73.6501 110.648 82.7757 112.231C83.184 112.302 83.5772 112.338 83.9806 112.377C81.7908 108.149 80.4154 102.317 80.0133 95.6028L85.5765 96.5677C91.16 97.5361 96.4662 93.7989 97.4346 88.2158L107.015 32.9774C107.984 27.3944 104.246 22.0885 98.6623 21.1201L98.6725 21.1219Z"
                                fill="#039D55" />
                            <path opacity="0.4"
                                d="M98.6725 21.1219L25.9842 8.51457C20.4006 7.54614 15.0944 11.2834 14.1261 16.8664L4.54537 72.1049C3.57703 77.6879 7.31476 82.9937 12.8983 83.9622L67.7744 93.48C67.3131 102.505 73.6501 110.648 82.7757 112.231C83.184 112.302 83.5772 112.338 83.9806 112.377C81.7908 108.149 80.4154 102.317 80.0133 95.6028L85.5765 96.5677C91.16 97.5361 96.4662 93.7989 97.4346 88.2158L107.015 32.9774C107.984 27.3944 104.246 22.0885 98.6623 21.1201L98.6725 21.1219Z"
                                fill="white" />
                            <path
                                d="M67.7846 93.4818C68.4177 85.5276 70.9163 75.6681 70.9163 75.6681C73.3619 65.3262 72.1981 53.4857 70.1747 51.1477C67.2607 47.7615 64.5548 44.5692 62.8212 47.8957C61.8276 49.8051 61.0358 53.1583 60.4234 56.9316C58.9428 66.0741 58.8574 77.782 58.9154 83.2066C58.9385 85.1347 58.6266 91.904 58.6266 91.904L67.7828 93.4921L67.7846 93.4818Z"
                                fill="#039D55" />
                            <path
                                d="M68.5572 51.3192C68.588 49.7475 67.6913 48.3093 66.2718 47.6426C63.8283 46.5143 59.6218 44.6388 55.7239 43.2267C51.1408 41.6433 46.4602 40.3794 41.7007 39.4488C38.7005 38.8022 35.7142 38.3789 33.3332 38.1026C33.054 38.0752 32.7594 38.0767 32.4816 38.1021C30.2864 38.3311 28.6928 40.3047 28.9237 42.4895C31.2292 65.1469 30.6896 75.7142 29.0977 86.7719L58.6385 91.8955C61.7479 82.1524 65.8744 74.4256 67.1373 68.5993C68.9732 60.0757 68.5469 53.9248 68.5554 51.3294L68.5572 51.3192Z"
                                fill="#039D55" />
                            <path opacity="0.8"
                                d="M68.5572 51.3192C68.588 49.7475 67.6913 48.3093 66.2718 47.6426C63.8283 46.5143 59.6218 44.6388 55.7239 43.2267C51.1408 41.6433 46.4602 40.3794 41.7007 39.4488C38.7005 38.8022 35.7142 38.3789 33.3332 38.1026C33.054 38.0752 32.7594 38.0767 32.4816 38.1021C30.2864 38.3311 28.6928 40.3047 28.9237 42.4895C31.2292 65.1469 30.6896 75.7142 29.0977 86.7719L58.6385 91.8955C61.7479 82.1524 65.8744 74.4256 67.1373 68.5993C68.9732 60.0757 68.5469 53.9248 68.5554 51.3294L68.5572 51.3192Z"
                                fill="white" />
                            <path
                                d="M58.2741 38.5278C55.8797 40.8145 53.9125 43.6695 56.3627 47.6691C56.8783 48.5155 57.1477 49.5085 56.9999 50.4816C56.7597 52.0486 55.5994 53.4034 51.0347 49.5311C44.4172 43.915 45.8896 39.1238 45.8896 39.1238C49.9721 38.6228 53.6899 30.8883 55.3954 26.3898L58.2759 38.5176L58.2741 38.5278Z"
                                fill="#FFB573" />
                            <path opacity="0.2"
                                d="M54.5912 33.4522C53.6761 35.3332 55.2301 38.8619 56.6065 40.3833C57.1015 39.7122 57.6625 39.0841 58.2658 38.5158L56.5552 31.3432C55.7647 31.9 55.094 32.6142 54.581 33.4505L54.5912 33.4522Z"
                                fill="black" />
                            <path
                                d="M77.4834 16.6477C79.5061 20.3839 71.952 29.2615 71.6767 27.09C71.2419 23.5345 70.9341 16.458 71.4449 13.6343C72.2438 9.20991 75.4709 12.9132 77.4834 16.6477Z"
                                fill="#263238" />
                            <path
                                d="M55.8075 13.95C59.5513 9.52125 66.1753 8.97742 70.6045 12.721C76.8584 17.9481 74.3733 29.1242 70.6919 35.1934C66.6381 41.9551 57.0368 41.236 53.279 33.8029C50.7533 28.844 51.7259 25.7219 53.6195 18.2597C54.0013 16.6647 54.7519 15.1863 55.8093 13.9398L55.8075 13.95Z"
                                fill="#FFB573" />
                            <path
                                d="M63.59 23.9421C63.4327 24.5457 63.6163 25.1242 64.0055 25.2443C64.3966 25.3542 64.8659 24.9519 65.0333 24.3502C65.2008 23.7484 65.007 23.1681 64.6178 23.048C64.2268 22.9381 63.7828 23.3763 63.59 23.9421Z"
                                fill="#263238" />
                            <path d="M64.4014 23.0841L65.9719 23.0621C65.9719 23.0621 64.9339 23.9544 64.4014 23.0841Z"
                                fill="#263238" />
                            <path
                                d="M71.0282 27.0091C70.871 27.6126 71.0545 28.1912 71.4438 28.3112C71.8348 28.4211 72.3041 28.0189 72.4716 27.4171C72.639 26.8153 72.4453 26.235 72.056 26.1149C71.665 26.0051 71.221 26.4432 71.0282 27.0091Z"
                                fill="#263238" />
                            <path d="M71.8396 26.151L73.4101 26.129C73.4101 26.129 72.3721 27.0214 71.8396 26.151Z"
                                fill="#263238" />
                            <path
                                d="M67.2898 31.1654C67.9632 31.5871 68.7869 31.6879 69.543 31.451C69.0364 30.0069 68.7312 28.4926 68.6391 26.9626L67.2898 31.1654Z"
                                fill="#ED893E" />
                            <path
                                d="M61.5379 29.8944C61.513 29.7955 61.5733 29.6903 61.662 29.6636C61.761 29.6387 61.8662 29.699 61.8929 29.7878C62.423 31.278 63.6332 32.4237 65.1445 32.8645C65.2328 32.9009 65.2901 32.9949 65.2622 33.0952C65.2343 33.1955 65.1318 33.2408 65.0417 33.2147C64.751 33.1327 64.4758 33.0219 64.2042 32.8907C62.9529 32.2846 61.9841 31.2019 61.5397 29.8842L61.5379 29.8944Z"
                                fill="#263238" />
                            <path
                                d="M64.0459 19.9209C63.9517 19.7363 64.0315 19.5188 64.2041 19.4331C66.0635 18.4729 68.2873 19.5946 68.3721 19.6514C68.5554 19.7463 68.6221 19.9681 68.529 20.1412C68.4341 20.3245 68.2122 20.3911 68.0391 20.298C68.0187 20.2945 66.1042 19.2685 64.5559 20.0724C64.4174 20.143 64.2421 20.1231 64.1356 20.01L64.0459 19.9209Z"
                                fill="#263238" />
                            <path
                                d="M74.7428 24.2048C74.3771 23.3423 73.6149 22.7055 72.7015 22.5155C72.4973 22.4801 72.3606 22.2987 72.396 22.0946C72.4314 21.8904 72.6128 21.7537 72.817 21.7891C73.9736 22.0317 74.9511 22.8216 75.426 23.9028C75.5082 24.0958 75.4182 24.3114 75.2372 24.3852C75.1227 24.4389 74.9781 24.4244 74.8746 24.3538C74.8187 24.3126 74.7747 24.2629 74.7428 24.2048Z"
                                fill="#263238" />
                            <path
                                d="M66.8894 14.3161C64.5423 14.3296 62.2321 15.4639 60.7756 17.314C60.0868 18.1934 56.3723 19.7254 55.6396 20.5551C53.3159 23.2221 53.8078 32.0863 52.849 32.5824C51.8903 33.0785 52.6338 30.6105 51.9021 29.979C51.1789 29.3594 50.2894 28.9107 49.6931 28.166C48.8601 27.1489 46.8913 17.282 52.22 12.4447C54.9529 9.96436 58.4677 8.25044 62.1603 8.23905C65.853 8.22766 69.5303 9.75914 72.1223 12.3955C72.9632 13.2458 74.2911 15.4107 71.4938 15.7771C70.7505 15.8795 70.8088 15.3008 70.0955 14.9879C69.0901 14.5401 67.9948 14.3081 66.8911 14.3059L66.8894 14.3161Z"
                                fill="#263238" />
                            <path
                                d="M48.137 19.2538C51.0831 17.2415 54.2271 17.7868 57.0035 18.2683C58.5551 18.5375 59.9025 18.7712 60.9892 18.5075C63.9985 17.7678 66.414 14.0864 66.9486 12.8229C67.4779 11.59 69.112 10.9587 69.6685 11.0237C70.0719 11.0621 71.3537 11.4316 71.8272 12.46C72.2017 13.2714 71.9701 14.3036 71.136 15.5363L71.4938 15.7771C72.4139 14.4122 72.6601 13.2353 72.2168 12.2752C71.6593 11.0641 70.2261 10.6578 69.7122 10.5897C68.96 10.5013 67.1497 11.2387 66.5478 12.6482C66.0531 13.8031 63.6961 17.3895 60.8847 18.0794C59.885 18.3265 58.5784 18.0999 57.0779 17.8397C54.3525 17.367 50.9839 16.7827 47.8941 18.8962L48.137 19.2538Z"
                                fill="#263238" />
                            <path opacity="0.1"
                                d="M48.137 19.2538C51.0831 17.2415 54.2271 17.7868 57.0035 18.2683C58.5551 18.5375 59.9025 18.7712 60.9892 18.5075C63.9985 17.7678 66.414 14.0864 66.9486 12.8229C67.4779 11.59 69.112 10.9587 69.6685 11.0237C70.0719 11.0621 71.3537 11.4316 71.8272 12.46C72.2017 13.2714 71.9701 14.3036 71.136 15.5363L71.4938 15.7771C72.4139 14.4122 72.6601 13.2353 72.2168 12.2752C71.6593 11.0641 70.2261 10.6578 69.7122 10.5897C68.96 10.5013 67.1497 11.2387 66.5478 12.6482C66.0531 13.8031 63.6961 17.3895 60.8847 18.0794C59.885 18.3265 58.5784 18.0999 57.0779 17.8397C54.3525 17.367 50.9839 16.7827 47.8941 18.8962L48.137 19.2538Z"
                                fill="white" />
                            <path
                                d="M49.8053 22.487C50.2245 21.1614 51.6362 20.418 52.974 20.8287C54.8026 21.4402 55.221 24.1202 54.9342 25.7737C54.5969 27.5972 53.0141 28.7209 51.5494 27.405C50.4506 26.4049 49.7905 24.9972 49.7117 23.5116C49.6765 23.1691 49.7061 22.8167 49.8071 22.4768L49.8053 22.487Z"
                                fill="#FFB573" />
                            <path
                                d="M48.4697 50.0115C47.1568 55.1563 38.9049 74.0586 28.3567 72.7968C26.7093 72.5952 25.1637 71.6858 24.0736 70.3928C24.0634 70.391 24.0465 70.367 24.0381 70.3551C16.4864 63.82 27.3828 40.3403 29.3251 39.2053C32.5616 37.338 37.4255 38.6967 38.1716 43.6099C38.5307 42.8731 38.8423 42.1071 39.1131 41.334C40.0158 38.736 42.5398 32.7919 45.2921 32.8067C46.9527 32.8109 50.2968 33.2331 51.0261 34.7264C51.7675 36.2113 50.6291 41.502 48.4679 50.0217L48.4697 50.0115Z"
                                fill="#039D55" />
                            <g opacity="0.2">
                                <path
                                    d="M52.9622 20.8372L52.9318 21.3155L52.6273 25.9203L51.6147 31.7585L53.0128 28.4263C53.3745 27.5533 53.5866 26.6334 53.6235 25.6935L53.8144 21.2583L52.9604 20.8474L52.9622 20.8372Z"
                                    fill="black" />
                            </g>
                            <path
                                d="M45.2902 33.9102L45.6119 24.5983L53.1966 25.8508C53.1966 25.8508 51.3896 32.571 49.0874 34.5688L45.28 33.9085L45.2902 33.9102Z"
                                fill="#FFB573" />
                            <path d="M48.0271 18.6144L53.4696 20.5782L53.1796 25.8268L45.6136 24.5882L48.0271 18.6144Z"
                                fill="#FFB573" />
                            <path opacity="0.2"
                                d="M34.468 51.5047C34.468 51.5047 28.104 61.2195 28.6935 57.0321C29.3229 52.4942 34.468 51.5047 34.468 51.5047Z"
                                fill="black" />
                        </svg>
                        <!-- Shape 3 -->
                        <svg class="shape-3" width="116" height="132" viewBox="0 0 116 132" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M16.3869 31.8622L94.3148 23.2301C100.297 22.5674 105.684 26.8796 106.347 32.8616L112.908 92.0949C113.571 98.0769 109.258 103.464 103.276 104.126L44.4283 110.645C44.3243 120.245 37.0749 128.479 27.2928 129.563C26.8603 129.611 26.4335 129.616 25.9988 129.644C28.6019 125.29 30.4403 119.209 31.2996 112.099L25.3376 112.76C19.3551 113.422 13.968 109.11 13.3053 103.128L6.744 43.8948C6.08137 37.9127 10.3941 32.5261 16.3767 31.8634L16.3869 31.8622Z"
                                fill="#039D55" />
                            <path opacity="0.4"
                                d="M16.3869 31.8622L94.3148 23.2301C100.297 22.5674 105.684 26.8796 106.347 32.8616L112.908 92.0949C113.571 98.0769 109.258 103.464 103.276 104.126L44.4283 110.645C44.3243 120.245 37.0749 128.479 27.2928 129.563C26.8603 129.611 26.4335 129.616 25.9988 129.644C28.6019 125.29 30.4403 119.209 31.2996 112.099L25.3376 112.76C19.3551 113.422 13.968 109.11 13.3053 103.128L6.744 43.8948C6.08137 37.9127 10.3941 32.5261 16.3767 31.8634L16.3869 31.8622Z"
                                fill="white" />
                            <path
                                d="M15.2507 55.2926L10.6788 49.2121L12.6276 44.7855C12.8863 44.2045 12.866 43.5501 12.5744 42.9884L12.3469 42.5341C11.9616 41.7847 11.1506 41.3326 10.304 41.4055L6.51358 41.7212C5.72872 41.7873 5.05471 42.2892 4.74899 43.011L4.1421 44.4957C3.84668 45.2163 3.90705 46.0434 4.31525 46.7173L6.33108 50.048L10.2423 57.7859L15.2599 55.2812L15.2507 55.2926Z"
                                fill="#7F3E3B" />
                            <path
                                d="M45.7989 50.7518L25.578 69.1985L13.099 51.018L7.51144 54.2113C7.51144 54.2113 19.8084 82.5113 24.9287 80.7455C30.0593 78.9786 44.0945 69.9928 48.3764 64.4219C50.535 61.6084 51.873 56.7493 48.8237 51.2401C48.212 50.1406 46.7271 49.909 45.8001 50.7621L45.7989 50.7518Z"
                                fill="#039D55" />
                            <path
                                d="M49.7939 11.7256C49.7939 11.7256 42.2455 14.6254 46.8873 23.5956C46.8873 23.5956 50.6358 22.1485 50.997 19.5759C51.348 17.0044 51.5563 13.4272 51.5563 13.4272L49.8042 11.7244L49.7939 11.7256Z"
                                fill="#263238" />
                            <path opacity="0.3"
                                d="M49.7939 11.7256C49.7939 11.7256 42.2455 14.6254 46.8873 23.5956C46.8873 23.5956 50.6358 22.1485 50.997 19.5759C51.348 17.0044 51.5563 13.4272 51.5563 13.4272L49.8042 11.7244L49.7939 11.7256Z"
                                fill="black" />
                            <path
                                d="M72.2743 46.8915L58.0326 47.9896L52.2579 49.4944L52.6398 60.2809L64.5006 62.813L76.4334 59.0315L75.9302 48.6544L74.8268 46.6921L72.2743 46.8915Z"
                                fill="#7F3E3B" />
                            <path
                                d="M59.5956 108.965L79.6748 106.741C79.0972 99.6443 76.069 62.803 75.8779 63.0535C75.6581 63.328 77.1323 54.9935 77.1323 54.9935L76.7707 51.7297L74.2618 48.464C74.2618 48.464 70.4701 55.9191 62.9454 56.3983C55.8039 56.8558 53.7939 49.9079 53.7939 49.9079L54.099 60.8489L56.1103 87.1928L58.4862 98.1962L59.6071 108.974L59.5956 108.965Z"
                                fill="#039D55" />
                            <path opacity="0.6"
                                d="M59.5956 108.965L79.6748 106.741C79.0972 99.6443 76.069 62.803 75.8779 63.0535C75.6581 63.328 77.1323 54.9935 77.1323 54.9935L76.7707 51.7297L74.2618 48.464C74.2618 48.464 70.4701 55.9191 62.9454 56.3983C55.8039 56.8558 53.7939 49.9079 53.7939 49.9079L54.099 60.8489L56.1103 87.1928L58.4862 98.1962L59.6071 108.974L59.5956 108.965Z"
                                fill="white" />
                            <path
                                d="M51.6053 109.85L62.4893 108.644C63.0617 94.2396 60.4702 68.3039 60.4702 68.3039C60.4702 68.3039 57.0697 59.4359 55.764 53.5772C54.4584 47.7185 63.0196 47.5623 70.5521 47.7181C78.0846 47.8738 66.9709 68.0841 66.9709 68.0841C66.9709 68.0841 68.851 93.5253 72.5907 107.525L99.4144 104.554C97.6572 100.924 92.4178 89.7579 90.5592 81.6363C88.3145 71.8169 93.5551 56.5512 91.7933 49.5862C90.0316 42.6212 66.7346 46.6609 66.7346 46.6609C66.7346 46.6609 51.6999 48.2221 48.3705 48.7473C44.4667 49.3569 44.0535 59.8355 43.1022 68.185C42.1509 76.5345 46.4522 84.2187 49.4404 94.258C51.3991 100.836 51.6556 106.634 51.6053 109.85Z"
                                fill="#263238" />
                            <path
                                d="M56.8139 47.7182C61.705 47.1764 66.7334 46.6507 66.7334 46.6507C66.7334 46.6507 69.7196 46.1323 73.6221 45.7938C75.2945 46.682 77.6162 48.9158 76.556 54.307L73.3028 55.991L74.2913 59.2688C74.2913 59.2688 71.0651 65.9004 67.0118 68.7362C66.9765 68.3232 66.9605 68.0852 66.9605 68.0852C66.9605 68.0852 78.0741 47.875 70.5416 47.7192C63.0091 47.5635 54.448 47.7197 55.7537 53.5784C57.0593 59.4371 60.4598 68.305 60.4598 68.305C60.4598 68.305 60.4712 68.408 60.4906 68.583C58.1939 66.951 56.0464 63.8433 54.3259 60.0734L55.2894 56.0686L52.0339 54.72C52.0339 54.72 52.016 50.1361 56.8151 47.7285L56.8139 47.7182Z"
                                fill="#039D55" />
                            <path
                                d="M57.272 53.358C56.2613 51.3855 57.2046 49.9261 57.2046 49.9261C62.5757 47.4134 61.5978 43.2903 59.8795 39.5409L67.8527 29.3714C67.8578 34.311 68.9065 45.5657 72.532 49.1246L72.6312 50.0204C68.9545 55.5033 63.9364 56.0279 61.1404 55.8165C59.5216 55.6936 58.0152 54.7974 57.272 53.358Z"
                                fill="#7F3E3B" />
                            <path opacity="0.1"
                                d="M59.8794 39.541L66.2089 31.4712L67.9226 31.8859C67.968 32.7667 68.0432 33.7277 68.1344 34.739C67.4336 36.6926 65.5494 39.5382 60.6178 41.4081C60.403 40.7858 60.1458 40.1576 59.86 39.5535L59.8794 39.541Z"
                                fill="black" />
                            <path
                                d="M71.5391 20.7814C70.2868 29.331 69.9401 32.9756 65.2285 37.0203C58.1378 43.1107 47.9098 39.6995 46.5868 30.9558C45.3906 23.0734 47.6374 10.4219 56.3321 7.70783C62.5348 5.7388 69.1577 9.16369 71.1383 15.3749C71.6971 17.1265 71.8292 18.9775 71.5494 20.7803L71.5391 20.7814Z"
                                fill="#7F3E3B" />
                            <path
                                d="M52.027 25.1107C51.2702 26.6537 50.3041 28.0948 49.163 29.3676C49.8424 29.949 50.7347 30.1941 51.6157 30.0548L52.0373 25.1096L52.027 25.1107Z"
                                fill="#630F0F" />
                            <path
                                d="M60.5529 21.0604C60.6147 21.0536 60.6639 21.0273 60.7223 20.9895C60.8767 20.8786 60.9043 20.6567 60.7842 20.5137C60.0203 19.4518 58.785 18.8382 57.4842 18.8573C57.2988 18.8778 57.1603 19.0391 57.1705 19.2255C57.1911 19.4109 57.3421 19.5505 57.5285 19.5402C58.6028 19.5463 59.6186 20.0591 60.2475 20.9379C60.3207 21.034 60.4408 21.0832 60.5541 21.0707L60.5529 21.0604Z"
                                fill="#263238" />
                            <path
                                d="M46.5074 20.0732C46.5692 20.0663 46.6184 20.04 46.6767 20.0023C47.5327 19.3551 48.6471 19.1587 49.6721 19.4725C49.8471 19.5469 50.0462 19.4623 50.1206 19.2873C50.1836 19.1031 50.099 18.9041 49.9149 18.8411C48.6725 18.4472 47.311 18.6709 46.2719 19.4531C46.1163 19.5537 46.067 19.7676 46.178 19.9221C46.2523 20.0285 46.385 20.0972 46.5177 20.072L46.5074 20.0732Z"
                                fill="#263238" />
                            <path
                                d="M55.3393 31.9562C54.9377 32.0006 54.5327 32.0142 54.1334 31.9855C54.0179 31.9775 53.9344 31.8825 53.9322 31.7681C53.9402 31.6525 54.0341 31.5588 54.1496 31.5668C55.948 31.7115 57.7147 31.0051 58.9096 29.6534C58.9829 29.5619 59.1156 29.5368 59.2071 29.61C59.2986 29.6832 59.3237 29.816 59.2504 29.9075C58.265 31.0797 56.8552 31.8091 55.3301 31.9676L55.3393 31.9562Z"
                                fill="#263238" />
                            <path
                                d="M69.4584 27.5884C69.4584 27.5884 66.0282 24.9459 66.0004 19.4251C66.0004 19.4251 62.2752 16.3775 62.0328 12.6836C62.0328 12.6836 61.3682 15.7172 62.5871 17.6875C62.5871 17.6875 53.8371 18.021 53.5583 13.6223C53.5583 13.6223 53.2361 15.8884 54.6601 16.8875C54.6601 16.8875 46.9841 18.0713 47.5919 13.9601C48.1894 9.85006 54.017 7.22427 54.017 7.22427C54.017 7.22427 59.2313 1.69603 68.1478 9.45274C68.1478 9.45274 78.1659 14.2629 72.6055 24.7593L69.4687 27.5873L69.4584 27.5884Z"
                                fill="#263238" />
                            <path
                                d="M72.9991 27.7487C72.39 29.3066 71.1837 30.5554 69.6527 31.2252C67.6125 32.0974 66.3135 30.3444 66.6357 28.266C66.9303 26.4094 68.3396 23.6998 70.5088 23.7097C72.0887 23.764 73.3193 25.0868 73.2638 26.6563C73.2534 27.0326 73.1594 27.4078 73.0094 27.7475L72.9991 27.7487Z"
                                fill="#7F3E3B" />
                            <path
                                d="M58.1461 23.2343C58.1527 23.9527 57.7704 24.5474 57.2911 24.5484C56.8128 24.5597 56.4344 23.9659 56.4369 23.236C56.4394 22.5062 56.8126 21.9229 57.2817 21.923C57.7507 21.9232 58.1384 22.5056 58.1461 23.2343Z"
                                fill="#2E353A" />
                            <path
                                d="M49.9272 23.2797C49.9338 23.9981 49.5515 24.5928 49.0824 24.5927C48.6134 24.5925 48.2257 24.0101 48.218 23.2814C48.2102 22.5527 48.5937 21.9682 49.0627 21.9684C49.5318 21.9686 49.9298 22.5498 49.9272 23.2797Z"
                                fill="#2E353A" />
                            <path d="M49.2652 22.0085L47.5229 21.524C47.5229 21.524 48.4332 22.8719 49.2652 22.0085Z"
                                fill="#2E353A" />
                            <path d="M57.4841 21.9631L55.7407 21.4684C55.7407 21.4684 56.6509 22.8163 57.4841 21.9631Z"
                                fill="#2E353A" />
                            <path
                                d="M69.5679 35.1639C71.1021 34.9939 72.2101 33.6101 72.0401 32.076C71.9626 31.3758 71.631 30.7351 71.1003 30.2728L70.7764 30.6422C71.2145 31.021 71.4923 31.553 71.5562 32.1296C71.6965 33.396 70.7808 34.5397 69.5143 34.68C68.2477 34.8203 67.104 33.9047 66.9637 32.6383C66.8234 31.3719 67.7391 30.2282 69.0056 30.0879C69.3351 30.0514 69.652 30.0893 69.9643 30.1797L70.1109 29.7153C69.7323 29.5905 69.3421 29.5504 68.9509 29.5937C67.4166 29.7637 66.3087 31.1475 66.4786 32.6816C66.6485 34.2157 68.0325 35.3235 69.5667 35.1536L69.5679 35.1639Z"
                                fill="#039D55" />
                            <g opacity="0.6">
                                <path
                                    d="M69.5679 35.1639C71.1021 34.9939 72.2101 33.6101 72.0401 32.076C71.9626 31.3758 71.631 30.7351 71.1003 30.2728L70.7764 30.6422C71.2145 31.021 71.4923 31.553 71.5562 32.1296C71.6965 33.396 70.7808 34.5397 69.5143 34.68C68.2477 34.8203 67.104 33.9047 66.9637 32.6383C66.8234 31.3719 67.7391 30.2282 69.0056 30.0879C69.3351 30.0514 69.652 30.0893 69.9643 30.1797L70.1109 29.7153C69.7323 29.5905 69.3421 29.5504 68.9509 29.5937C67.4166 29.7637 66.3087 31.1475 66.4786 32.6816C66.6485 34.2157 68.0325 35.3235 69.5667 35.1536L69.5679 35.1639Z"
                                    fill="white" />
                            </g>
                            <path
                                d="M72.3104 77.4251L64.7889 78.5918L61.8042 74.7952C61.4154 74.2963 60.8206 74.0078 60.1936 73.9939L59.6925 73.9868C58.8471 73.9763 58.0678 74.4691 57.738 75.256L56.2381 78.7469C55.9324 79.4686 56.0453 80.3003 56.5508 80.9114L57.5743 82.1529C58.0684 82.7548 58.8245 83.0879 59.6116 83.0424L63.5072 82.8298L72.1815 83.0363L72.3425 77.432L72.3104 77.4251Z"
                                fill="#7F3E3B" />
                            <path
                                d="M82.6928 48.3535L89.4359 74.882L67.5135 77.3104L67.6944 83.7418C67.6944 83.7418 98.4484 86.2342 99.3151 80.8853C100.17 75.5272 98.8617 58.913 95.9637 52.5116C94.5015 49.2863 90.844 45.8143 84.5482 45.9072C83.2897 45.9319 82.39 47.1259 82.7019 48.3421L82.6928 48.3535Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 4 -->
                        <svg class="shape-4" width="25" height="23" viewBox="0 0 25 23" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M3.15953 0.268188H21.4744C23.219 0.268188 24.6252 1.6829 24.6252 3.41874V15.2138C24.6252 16.9583 23.2104 18.3643 21.4744 18.3643H16.2056L13.8533 21.4368C13.0808 22.4523 11.5531 22.4523 10.7719 21.4368L8.41961 18.3643H3.15085C1.40617 18.3643 0 16.9496 0 15.2138V3.41874C0 1.67422 1.41484 0.268188 3.15953 0.268188Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M3.15953 0.268188H21.4744C23.219 0.268188 24.6252 1.6829 24.6252 3.41874V15.2138C24.6252 16.9583 23.2104 18.3643 21.4744 18.3643H16.2056L13.8533 21.4368C13.0808 22.4523 11.5531 22.4523 10.7719 21.4368L8.41961 18.3643H3.15085C1.40617 18.3643 0 16.9496 0 15.2138V3.41874C0 1.67422 1.41484 0.268188 3.15953 0.268188Z"
                                fill="white" />
                            <path
                                d="M4.21875 8.37461L10.0778 4.79877V6.94253H12.7599C16.3447 6.94253 19.2525 9.85007 19.2525 13.4346C19.2525 13.9293 19.1918 14.4067 19.0876 14.8667C18.4366 11.9678 15.85 9.80668 12.7599 9.80668H10.0778V11.9504L4.21875 8.37461Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 5 -->
                        <svg class="shape-5" width="34" height="30" viewBox="0 0 34 30" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M29.0932 0H4.44089C2.0939 0 0.194824 1.89892 0.194824 4.24569V20.1267C0.194824 22.4735 2.0939 24.3724 4.44089 24.3724H11.5266L14.6888 28.5106C15.7369 29.8721 17.7883 29.8721 18.8364 28.5106L21.9985 24.3724H29.0843C31.4313 24.3724 33.3303 22.4735 33.3303 20.1267V4.24569C33.3303 1.89892 31.4313 0 29.0843 0H29.0932Z"
                                fill="#039D55" />
                            <path opacity="0.7"
                                d="M29.0932 0H4.44089C2.0939 0 0.194824 1.89892 0.194824 4.24569V20.1267C0.194824 22.4735 2.0939 24.3724 4.44089 24.3724H11.5266L14.6888 28.5106C15.7369 29.8721 17.7883 29.8721 18.8364 28.5106L21.9985 24.3724H29.0843C31.4313 24.3724 33.3303 22.4735 33.3303 20.1267V4.24569C33.3303 1.89892 31.4313 0 29.0843 0H29.0932Z"
                                fill="white" />
                            <path
                                d="M27.66 10.9098L19.768 6.09088V8.97508H16.149C11.3206 8.97508 7.40601 12.8893 7.40601 17.7172C7.40601 18.3801 7.48663 19.025 7.62996 19.643C8.50784 15.7467 11.9835 12.8267 16.149 12.8267H19.768V15.7109L27.66 10.8919V10.9098Z"
                                fill="#039D55" />
                        </svg>
                        <!-- Shape 6 -->
                        <svg class="shape-6" width="57" height="49" viewBox="0 0 57 49" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M51.8997 34.0325C51.0552 33.7856 50.5676 32.8995 50.8145 32.055L51.3753 30.1528C51.6221 29.3083 52.5084 28.8208 53.3529 29.0677C54.1974 29.3145 54.685 30.2007 54.4382 31.0451L53.8774 32.9473C53.6305 33.7918 52.7443 34.2793 51.8997 34.0325Z"
                                fill="#039D55" />
                            <path
                                d="M49.5243 24.185C49.5243 24.185 37.8388 22.0059 33.8659 19.595C24.5156 13.926 16.0994 1.38599 14.166 0.823022C11.0116 -0.0965931 6.11327 7.16812 3.20909 17.0667C0.315249 26.9661 0.513582 35.7348 3.66801 36.6544C5.60141 37.2174 19.4567 31.2113 30.3847 31.4778C35.0297 31.5893 46.0431 36.0678 46.0431 36.0678L49.5243 24.185V24.185Z"
                                fill="#039D55" />
                            <path opacity="0.3"
                                d="M49.5243 24.185C49.5243 24.185 37.8388 22.0059 33.8659 19.595C24.5156 13.926 16.0994 1.38599 14.166 0.823022C11.0116 -0.0965931 6.11327 7.16812 3.20909 17.0667C0.315249 26.9661 0.513582 35.7348 3.66801 36.6544C5.60141 37.2174 19.4567 31.2113 30.3847 31.4778C35.0297 31.5893 46.0431 36.0678 46.0431 36.0678L49.5243 24.185V24.185Z"
                                fill="white" />
                            <path
                                d="M14.6249 20.4107C11.731 30.3101 6.82233 37.5741 3.6679 36.6544C0.513477 35.7348 0.304809 26.9654 3.20898 17.0668C6.10283 7.16741 11.0115 -0.0965766 14.1659 0.823039C17.3204 1.74265 17.529 10.5121 14.6249 20.4107V20.4107Z"
                                fill="#039D55" />
                            <path opacity="0.4"
                                d="M14.6249 20.4107C11.731 30.3101 6.82233 37.5741 3.6679 36.6544C0.513477 35.7348 0.304809 26.9654 3.20898 17.0668C6.10283 7.16741 11.0115 -0.0965766 14.1659 0.823039C17.3204 1.74265 17.529 10.5121 14.6249 20.4107V20.4107Z"
                                fill="black" />
                            <path
                                d="M47.7092 22.6854L42.3268 21.1092C40.8615 20.6833 39.3237 21.5712 39.0099 23.0651C38.7264 24.4262 38.3676 25.8235 37.955 27.2482C37.5423 28.6728 37.0816 30.0421 36.5848 31.3361C36.0474 32.7623 36.8593 34.3465 38.3247 34.7724L44.7044 36.6375C48.5299 37.7605 51.5143 35.2202 52.5872 31.3707C53.6202 27.6431 51.4232 23.7693 47.6996 22.6743L47.7092 22.6854Z"
                                fill="#263238" />
                            <path
                                d="M9.14837 17.9659L8.6959 19.5123C8.43504 20.4077 8.85475 21.3721 9.68682 21.7946L13.5481 23.7302C13.9351 22.6673 14.294 21.5607 14.6352 20.4114C14.9661 19.2614 15.2638 18.1402 15.5083 17.0359L11.2196 16.5862C10.2814 16.4885 9.41956 17.0712 9.14837 17.9659Z"
                                fill="#263238" />
                            <path opacity="0.8"
                                d="M9.14837 17.9659L8.6959 19.5123C8.43504 20.4077 8.85475 21.3721 9.68682 21.7946L13.5481 23.7302C13.9351 22.6673 14.294 21.5607 14.6352 20.4114C14.9661 19.2614 15.2638 18.1402 15.5083 17.0359L11.2196 16.5862C10.2814 16.4885 9.41956 17.0712 9.14837 17.9659Z"
                                fill="white" />
                            <path opacity="0.2"
                                d="M12.0403 19.6562C11.7522 20.6431 11.436 21.5865 11.1102 22.5188L13.5377 23.7295C13.9247 22.6665 14.2836 21.56 14.6248 20.4107C14.9557 19.2607 15.2534 18.1395 15.4979 17.0352L12.797 16.7501C12.5738 17.7001 12.3181 18.6685 12.03 19.6554L12.0403 19.6562Z"
                                fill="black" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==== Refer Section Ends Here ==== -->


    <!-- ==== Earn Money Section Starts Here ==== -->
    <section class="earn-money-section">
        <div class="container">
            <div class="section-header wow fadeInUp">
                <h2 class="title">
                    <?php echo e($landing_data['earning_title']); ?>

                    <span class="primary-color text-nowrap">color text</span>
                </h2>
                <div class="text"><?php echo e($landing_data['earning_sub_title']); ?></div>
            </div>
        </div>
        <div class="container">
            <!-- Earn Money Item -->
            <?php ($join_as_seller = $landing_data['seller_app_earning_links']); ?>
            <div class="earn-item wow fadeInUp">
                <div class="earn-item-img"
                    style="background: url(<?php echo e(\App\CentralLogics\Helpers::get_full_url('earning', isset($landing_data['earning_seller_image']) ? $landing_data['earning_seller_image'] : null, isset($landing_data['earning_seller_image_storage']) ? $landing_data['earning_seller_image_storage'] : 'public')); ?>) no-repeat center center / cover;">
                    <div class="position-relative dropdown text-capitalize">




                        <?php if(isset($join_as_seller['playstore_url_status']) &&
                                $join_as_seller['playstore_url_status'] == '1' &&
                                isset($join_as_seller['apple_store_url_status']) &&
                                $join_as_seller['apple_store_url_status'] == '1'): ?>
                            <button type="button" class="cmn--btn border-0" data-bs-toggle="dropdown">
                                <?php echo e(translate('Seller App')); ?>

                                <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                        fill="#ffffff"></path>
                                </svg>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end p-0">
                                <a href="<?php echo e(isset($join_as_seller['playstore_url']) ? $join_as_seller['playstore_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('google_play')); ?>

                                </a>
                                <a href="<?php echo e(isset($join_as_seller['apple_store_url']) ? $join_as_seller['apple_store_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('apple_store')); ?>

                                </a>
                            </div>
                        <?php elseif(isset($join_as_seller['playstore_url_status']) && $join_as_seller['playstore_url_status'] == '1'): ?>
                            <a type="button" class="cmn--btn border-0"
                                href="<?php echo e(isset($join_as_seller['playstore_url']) ? $join_as_seller['playstore_url'] : ''); ?>">
                                <?php echo e(translate('Seller App')); ?>

                            </a>
                        <?php elseif(isset($join_as_seller['apple_store_url_status']) && $join_as_seller['apple_store_url_status'] == '1'): ?>
                            <a type="button" class="cmn--btn border-0"
                                href="<?php echo e(isset($join_as_seller['apple_store_url']) ? $join_as_seller['apple_store_url'] : ''); ?>">
                                <?php echo e(translate('Seller App')); ?>

                            </a>
                        <?php endif; ?>












                    </div>
                </div>
                <div class="earn-item-cont">
                    <div>
                        <h4 class="subtitle"><?php echo e(translate('messages.Become a best')); ?> </h4>
                        <h3 class="title"><?php echo e(translate('messages.Seller')); ?></h3>
                    </div>
                </div>
            </div>
            <!-- Earn Money Item -->
            <?php ($join_as_dm = $landing_data['dm_app_earning_links']); ?>
            <div class="earn-item wow fadeInUp">
                <div class="earn-item-img"
                    style="background: url(<?php echo e(\App\CentralLogics\Helpers::get_full_url('earning', isset($landing_data['earning_delivery_image']) ? $landing_data['earning_delivery_image'] : null, isset($landing_data['earning_delivery_image_storage']) ? $landing_data['earning_delivery_image_storage'] : 'public')); ?>) no-repeat center center / cover;">
                    <div class="position-relative dropdown text-capitalize">

                        <?php if(isset($join_as_dm['playstore_url_status']) &&
                                $join_as_dm['playstore_url_status'] == '1' &&
                                isset($join_as_dm['apple_store_url_status']) &&
                                $join_as_dm['apple_store_url_status'] == '1'): ?>
                            <button type="button" class="cmn--btn border-0" data-bs-toggle="dropdown">
                                <?php echo e(translate('Deliveryman App')); ?>

                                <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                        fill="#ffffff"></path>
                                </svg>
                            </button>

                            <div class="dropdown-menu p-0">
                                <a href="<?php echo e(isset($join_as_dm['playstore_url']) ? $join_as_dm['playstore_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('google_play')); ?>

                                </a>

                                <a href="<?php echo e(isset($join_as_dm['apple_store_url']) ? $join_as_dm['apple_store_url'] : ''); ?>"
                                    class="dropdown-item">
                                    <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                        alt="">
                                    <?php echo e(translate('apple_store')); ?>

                                </a>
                            </div>
                        <?php elseif(isset($join_as_dm['playstore_url_status']) && $join_as_dm['playstore_url_status'] == '1'): ?>
                            <a type="button"
                                href="<?php echo e(isset($join_as_dm['playstore_url']) ? $join_as_dm['playstore_url'] : ''); ?>"
                                class="cmn--btn border-0">
                                <?php echo e(translate('Deliveryman App')); ?>

                            </a>
                        <?php elseif(isset($join_as_dm['apple_store_url_status']) && $join_as_dm['apple_store_url_status'] == '1'): ?>
                            <a type="button"
                                href="<?php echo e(isset($join_as_dm['apple_store_url']) ? $join_as_dm['apple_store_url'] : ''); ?>"
                                class="cmn--btn border-0">
                                <?php echo e(translate('Deliveryman App')); ?>

                            </a>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="earn-item-cont">
                    <div>
                        <h4 class="subtitle"><?php echo e(translate('messages.Become a smart')); ?></h4>
                        <h3 class="title"><?php echo e(translate('messages.Deliveryman')); ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <!-- Shape 1 -->
        <svg class="e-shape-1" width="321" height="1198" viewBox="0 0 321 1198" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g opacity="0.19">
                <g opacity="0.3">
                    <path
                        d="M378.224 594.481C373.917 598.162 367.986 599.453 362.327 599.161C356.683 598.857 351.211 597.12 345.856 595.316C334.069 591.363 323.268 587.609 312.023 582.401C307.382 580.253 301.984 577.016 297.605 574.374C296.199 573.531 294.788 572.62 293.816 571.304C292.843 569.989 292.39 568.17 293.08 566.691C293.845 565.033 295.841 564.224 297.676 564.297C299.498 564.369 301.224 565.129 302.9 565.856C317.001 571.934 332.524 576.055 347.691 573.63C351.932 572.956 356.073 571.773 360.292 571.057C364.525 570.342 368.93 570.092 373.054 571.277C377.179 572.461 381.002 575.252 382.622 579.231C384.749 584.469 382.529 590.826 378.221 594.508L378.224 594.481Z"
                        fill="url(#paint0_linear_28_738)" />
                    <path
                        d="M219.315 746.746C219.537 742.343 221.978 738.289 225.173 735.24C228.366 732.205 232.275 730.038 236.174 727.963C244.72 723.406 252.633 719.298 261.599 715.721C265.304 714.242 270.026 712.927 273.858 711.854C275.083 711.517 276.36 711.2 277.62 711.352C278.881 711.504 280.154 712.223 280.629 713.412C281.156 714.741 280.537 716.296 279.529 717.292C278.507 718.286 277.16 718.85 275.853 719.42C264.862 724.153 254.215 730.732 247.475 740.624C245.594 743.386 244.037 746.363 242.18 749.141C240.324 751.92 238.096 754.546 235.225 756.247C232.354 757.947 228.72 758.613 225.609 757.402C221.494 755.802 219.095 751.136 219.317 746.733L219.315 746.746Z"
                        fill="url(#paint1_linear_28_738)" />
                    <path
                        d="M143.17 601.174C147.418 604.46 151.352 580.886 150.402 568.451C149.454 556.003 133.85 557.917 136.356 575.415C138.863 592.912 141.903 600.186 143.183 601.175L143.17 601.174Z"
                        fill="url(#paint2_linear_28_738)" />
                    <path
                        d="M128.09 732.092C141.591 745.934 162.259 752.709 181.156 748.606C196.029 745.391 208.759 736.169 221.92 728.506C241.322 717.207 262.495 708.962 284.436 704.176C304.83 699.716 333.913 707.479 351.856 696.785C363.632 689.776 373.236 678.789 377.345 665.712C382.497 649.341 376.572 628.712 367.992 618.036C350.588 596.371 308.532 594.489 287.486 576.344C270.44 561.644 268.668 540.627 253.119 524.344C240.139 510.754 219.523 505.223 201.347 509.938C183.17 514.653 168.003 529.237 162.031 547.044C157.823 559.611 157.965 573.161 156.007 586.268L155.98 586.494C154.128 598.604 148.985 609.995 141.233 619.468C139.021 622.177 136.848 624.904 134.725 627.664C123.155 642.776 113.113 659.85 110.741 678.725C108.332 697.918 114.605 718.226 128.106 732.067L128.09 732.092Z"
                        fill="url(#paint3_linear_28_738)" />
                </g>
                <path
                    d="M142.919 1178.36C142.996 1177.82 143.323 1177.54 143.834 1177.37C145.127 1176.95 146.408 1176.48 147.694 1176.04C148.451 1175.78 148.839 1175.98 149.102 1176.74C151.127 1182.6 153.155 1188.47 155.192 1194.33C155.368 1194.83 155.339 1195.25 155.014 1195.66L149.556 1197.54L142.923 1178.35L142.919 1178.36Z"
                    fill="url(#paint4_linear_28_738)" />
                <path
                    d="M186.73 1152.99C186.385 1153.67 186.025 1154.36 185.684 1155.06C182.156 1162.31 178.629 1169.57 175.107 1176.81C174.961 1177.12 174.823 1177.38 174.43 1177.35C173.946 1174.24 171.577 1172.43 168.496 1172.83C167.945 1172.9 167.401 1173.1 166.866 1173.28C165.621 1173.69 164.387 1174.14 163.146 1174.55C162.935 1174.62 162.643 1174.62 162.451 1174.52C157.519 1172.14 152.599 1169.74 147.676 1167.35C147.601 1167.31 147.536 1167.26 147.434 1167.21C147.513 1167.03 147.579 1166.87 147.656 1166.71C148.974 1164.01 150.297 1161.31 151.6 1158.61C152.432 1156.88 151.974 1155.03 150.5 1154.02C149.762 1153.51 148.99 1153.37 148.154 1153.78C147.052 1154.33 145.917 1154.5 144.736 1154.07C143.221 1153.53 142.281 1152.44 142.009 1150.86C141.699 1149.1 142.285 1147.6 143.696 1146.51C146.507 1144.31 150.016 1146.21 150.408 1149.05C150.51 1149.79 150.962 1150.31 151.646 1150.62C153.256 1151.37 155.147 1150.81 156.083 1149.3C156.338 1148.89 156.532 1148.45 156.745 1148.02C157.941 1145.58 159.13 1143.13 160.319 1140.69C160.393 1140.54 160.418 1140.37 160.476 1140.15C162.155 1140.97 163.712 1141.74 165.28 1142.51C166.49 1143.09 167.705 1143.67 168.904 1144.27C169.735 1144.69 170.083 1145.46 169.873 1146.29C169.785 1146.64 169.615 1146.85 169.232 1146.95C166.143 1147.75 164.668 1150.3 164.487 1152.51C164.132 1156.84 168.137 1160.1 172.294 1158.83C175.678 1157.79 177.455 1154.01 176.19 1150.55C176.051 1150.17 175.811 1149.82 176.153 1149.4C176.515 1148.96 176.953 1148.7 177.511 1148.69C177.78 1148.68 178.08 1148.75 178.322 1148.86C181.071 1150.19 183.817 1151.53 186.563 1152.86C186.604 1152.88 186.638 1152.92 186.732 1152.99L186.73 1152.99Z"
                    fill="url(#paint5_linear_28_738)" />
                <path
                    d="M157.011 1194.02L151.077 1176.85C153.072 1175.95 155.1 1175.49 157.246 1176.22C158.943 1176.79 160.666 1177.01 162.426 1176.62C163.283 1176.43 164.107 1176.12 164.943 1175.85C166.173 1175.45 167.382 1174.97 168.632 1174.65C170.35 1174.22 172.24 1175.37 172.55 1176.93C172.589 1177.12 172.581 1177.32 172.587 1177.52C172.6 1177.9 172.434 1178.1 172.056 1178.23C170.189 1178.88 168.315 1179.5 166.483 1180.23C164.766 1180.9 163.505 1182.18 162.474 1183.67C162.21 1184.06 162.307 1184.56 162.642 1184.84C162.996 1185.14 163.519 1185.13 163.857 1184.78C164.024 1184.62 164.15 1184.43 164.287 1184.24C165.25 1182.93 166.513 1182.04 168.045 1181.51C170.619 1180.62 173.186 1179.74 175.747 1178.81C176.266 1178.62 176.738 1178.28 177.182 1177.94C181.691 1174.49 186.188 1171.03 190.689 1167.58C191.769 1166.75 193.045 1167.1 193.378 1168.33C193.538 1168.93 193.322 1169.43 192.945 1169.89C190.489 1172.85 188.041 1175.81 185.592 1178.77C183.931 1180.77 182.265 1182.76 180.623 1184.78C179.796 1185.8 178.782 1186.51 177.534 1186.93C170.878 1189.21 164.234 1191.52 157.585 1193.82L157.008 1194.02L157.011 1194.02Z"
                    fill="url(#paint6_linear_28_738)" />
                <path
                    d="M62.4251 233.406C58.6274 229.168 56.8408 224.464 57.8922 218.932C58.676 214.764 60.8325 211.432 64.2902 208.951C66.7879 207.162 69.5678 206.202 72.619 206.039C75.7092 205.874 78.5871 206.584 81.2875 208.09C83.9662 209.585 85.8582 211.858 87.6107 214.451C88.1494 214.048 88.6446 213.677 89.1398 213.306C93.2755 210.209 98.3434 210.929 101.593 214.942C105.671 219.971 109.851 224.937 113.972 229.934C117.224 233.878 120.476 237.822 123.728 241.767C125.347 243.73 126.976 245.687 128.58 247.648C131.959 251.781 131.296 257.197 127.004 260.412C116.439 268.323 105.874 276.235 95.3092 284.146C91.7643 286.801 87.3347 286.698 84.1152 283.703C82.9684 282.642 82.1348 281.239 81.2401 279.936C78.9775 276.643 76.7735 273.319 74.537 270.007C71.555 265.59 68.5729 261.173 65.5757 256.754C63.3392 253.442 61.1179 250.131 58.8379 246.851C56.2683 243.166 56.5127 238.766 59.6253 235.516C60.3839 234.718 61.4021 234.159 62.4273 233.391L62.4251 233.406ZM83.3513 217.6C80.7569 213.393 77.2807 210.779 72.1729 211.401C67.7743 211.938 64.7675 214.46 63.4047 218.67C61.9589 223.132 63.5635 226.85 66.5828 230.157L83.36 217.594L83.3513 217.6ZM69.7241 241.632C70.5823 242.76 72.2839 242.986 73.3939 242.114C74.5213 241.229 74.7334 239.557 73.8665 238.435C72.9844 237.312 71.298 237.088 70.188 237.96C69.0606 238.844 68.8529 240.487 69.7241 241.632ZM93.4369 223.807C92.5809 222.664 90.9119 222.427 89.7737 223.28C88.6355 224.132 88.4148 225.811 89.2708 226.954C90.1074 228.071 91.8284 228.323 92.9362 227.467C94.0766 226.599 94.3016 224.944 93.4369 223.807Z"
                    fill="url(#paint7_linear_28_738)" />
                <path
                    d="M207.574 591.012C214.605 591.012 221.637 591.012 228.657 591.012C230.435 591.012 232.143 591.377 233.674 592.355C235.394 593.462 236.572 594.981 237.208 596.913C239.292 603.167 241.448 609.386 243.45 615.663C246.077 623.943 241.236 631.988 232.708 633.495C228.786 634.19 225.159 633.213 221.931 630.834C221.649 630.622 221.378 630.386 221.095 630.162C219.682 629.032 218.351 629.008 216.973 630.139C213.993 632.588 210.566 633.755 206.726 633.543C203.64 633.378 200.884 632.282 198.458 630.351C196.691 628.949 195.596 628.949 193.841 630.351C188.717 634.402 181.533 634.709 176.562 631.093C171.686 627.536 169.79 621.376 171.78 615.322C173.771 609.256 175.797 603.202 177.846 597.16C179.189 593.191 182.275 591.012 186.503 591C193.534 591 200.566 591 207.586 591L207.574 591.012Z"
                    fill="url(#paint8_linear_28_738)" />
                <path
                    d="M176.197 637.971C177.94 638.43 179.53 638.949 181.144 639.255C186.185 640.221 190.896 639.231 195.266 636.616C195.925 636.216 196.385 636.228 197.021 636.616C200.213 638.572 203.722 639.537 207.444 639.561C211.319 639.584 214.971 638.572 218.292 636.534C218.775 636.239 219.128 636.181 219.658 636.499C225.524 640.115 231.684 640.621 238.103 638.148C238.327 638.065 238.539 637.983 238.88 637.853C238.904 638.159 238.951 638.407 238.951 638.654C238.951 646.451 238.974 654.26 238.951 662.057C238.939 666.356 236.312 669.725 232.296 670.655C231.578 670.82 230.824 670.902 230.094 670.914C227.679 670.95 225.265 670.903 222.862 670.938C222.143 670.938 221.943 670.726 221.955 670.019C221.99 666.474 221.979 662.929 221.955 659.384C221.943 654.755 218.115 650.915 213.487 650.903C209.553 650.903 205.631 650.903 201.697 650.903C197.068 650.915 193.228 654.755 193.216 659.372C193.216 662.917 193.193 666.462 193.216 670.007C193.216 670.691 193.051 670.961 192.321 670.938C189.412 670.855 186.491 670.938 183.582 670.738C179.978 670.502 176.692 667.157 176.362 663.577C176.268 662.516 176.209 661.445 176.209 660.373C176.197 653.224 176.209 646.074 176.209 638.937V637.971H176.197Z"
                    fill="url(#paint9_linear_28_738)" />
                <path
                    d="M199.011 670.914C199.011 667.039 198.988 663.223 199.011 659.407C199.023 657.935 200.236 656.733 201.708 656.722C205.607 656.686 209.517 656.686 213.416 656.722C214.876 656.722 216.101 657.947 216.113 659.407C216.148 663.223 216.113 667.027 216.113 670.914H198.988H199.011Z"
                    fill="url(#paint10_linear_28_738)" />
                <path
                    d="M123.324 447.264H201.685C201.144 449.169 200.616 451.035 200.089 452.889C196.729 464.55 193.357 476.212 190.023 487.873C189.779 488.722 189.47 489.044 188.53 489.031C171.154 488.993 153.777 489.006 136.388 489.031C135.577 489.031 135.217 488.838 134.985 488.015C131.188 474.731 127.352 461.448 123.53 448.165C123.452 447.895 123.401 447.598 123.324 447.264ZM190.191 455.926C189.959 455.604 189.714 454.961 189.29 454.781C188.852 454.588 188.157 454.729 187.681 454.961C187.385 455.102 187.204 455.63 187.101 456.029C185.647 461.783 184.218 467.549 182.777 473.303C182.236 475.478 181.683 477.64 181.181 479.828C180.975 480.755 181.425 481.437 182.223 481.618C183.073 481.811 183.716 481.437 184.025 480.549C184.089 480.369 184.128 480.176 184.167 479.983C185.647 474.101 187.127 468.218 188.594 462.336C189.109 460.29 189.598 458.243 190.165 455.939L190.191 455.926ZM136.607 454.588C135.127 454.613 134.638 455.514 134.998 456.956C136.556 463.186 138.1 469.428 139.67 475.658C140.082 477.293 140.481 478.94 140.932 480.562C141.189 481.463 141.897 481.836 142.721 481.63C143.506 481.437 143.905 480.807 143.789 479.918C143.751 479.661 143.686 479.404 143.635 479.159C142.76 475.632 141.884 472.106 140.996 468.579C139.954 464.396 138.911 460.2 137.868 456.016C137.662 455.18 137.251 454.588 136.607 454.588ZM157.806 480.227C157.446 475.735 157.124 471.694 156.789 467.652C156.48 463.829 156.159 460.019 155.824 456.197C155.734 455.102 155.103 454.523 154.138 454.613C153.237 454.691 152.761 455.334 152.838 456.428C152.902 457.329 152.992 458.243 153.069 459.144C153.649 466.107 154.241 473.058 154.833 480.021C154.923 481.154 155.515 481.746 156.442 481.682C157.356 481.618 157.845 480.948 157.819 480.24L157.806 480.227ZM172.042 457.471C172.132 455.463 171.9 454.897 171.154 454.652C170.047 454.292 169.223 455.038 169.107 456.428C168.747 460.869 168.361 465.297 168 469.737C167.717 473.135 167.421 476.533 167.177 479.944C167.099 481 167.678 481.669 168.567 481.708C169.455 481.746 170.047 481.141 170.137 480.099C170.356 477.602 170.549 475.105 170.768 472.62C171.218 467.369 171.656 462.13 172.055 457.484L172.042 457.471Z"
                    fill="url(#paint11_linear_28_738)" />
                <path
                    d="M162.517 435.306C177.126 435.306 191.735 435.306 206.344 435.306C209.626 435.306 211.84 438.357 210.694 441.317C209.986 443.132 208.583 444.059 206.666 444.239C206.472 444.252 206.279 444.239 206.086 444.239C177.036 444.239 147.972 444.239 118.921 444.239C117.712 444.239 116.605 443.981 115.652 443.209C114.185 442.012 113.631 440.03 114.249 438.279C114.893 436.452 116.527 435.293 118.497 435.293C130.338 435.293 142.18 435.293 154.022 435.293C156.853 435.293 159.685 435.293 162.517 435.293V435.306Z"
                    fill="url(#paint12_linear_28_738)" />
                <path
                    d="M146.029 432.32H144.935C140.25 432.32 135.564 432.307 130.879 432.333C130.21 432.333 129.837 432.127 129.489 431.548C126.747 426.94 124.431 422.152 123.555 416.823C123.246 414.957 123.195 412.987 123.452 411.121C123.89 407.877 126.027 406.629 129.232 407.465C132.295 408.263 134.805 410.065 137.173 412.073C140.468 414.866 143.21 418.162 145.656 421.714C145.836 421.972 146.016 422.293 146.016 422.589C146.042 425.769 146.029 428.961 146.029 432.307V432.32ZM133.183 428.51C133.634 428.394 133.878 428.381 134.058 428.266C136.208 426.875 138.37 425.498 140.468 424.044C141.138 423.58 141.189 422.821 140.687 422.139C140.211 421.482 139.516 421.225 138.808 421.663C136.671 423.001 134.535 424.366 132.488 425.846C132.128 426.103 131.96 426.978 132.089 427.48C132.205 427.918 132.849 428.227 133.17 428.523L133.183 428.51ZM131.651 423.259C132.038 423.194 132.192 423.207 132.282 423.143C133.801 422.165 135.358 421.225 136.813 420.144C137.366 419.732 137.315 418.96 136.89 418.367C136.478 417.788 135.835 417.467 135.191 417.853C133.724 418.728 132.269 419.655 130.905 420.697C130.57 420.955 130.442 421.791 130.596 422.242C130.75 422.692 131.355 422.988 131.639 423.259H131.651Z"
                    fill="url(#paint13_linear_28_738)" />
                <path d="M191.993 414.442V432.256H172.004V414.442H191.993Z" fill="url(#paint14_linear_28_738)" />
                <path
                    d="M168.926 432.268H149.066C149.04 431.934 149.014 431.651 149.014 431.368C149.014 426.451 149.014 421.534 149.014 416.63C149.014 414.969 149.632 414.352 151.318 414.352C156.428 414.352 161.538 414.352 166.648 414.352C168.334 414.352 168.926 414.956 168.926 416.655C168.926 421.534 168.926 426.425 168.926 431.303V432.281V432.268ZM152.979 423.632C152.979 426.901 155.682 429.604 158.938 429.617C162.22 429.643 165.001 426.863 164.975 423.593C164.962 420.272 162.233 417.595 158.9 417.634C155.605 417.672 152.953 420.35 152.966 423.632H152.979Z"
                    fill="url(#paint15_linear_28_738)" />
                <path
                    d="M202.096 432.256H195.068V431.252C195.068 425.563 195.055 419.861 195.094 414.171C195.094 413.631 195.287 413.026 195.57 412.563C196.51 411.057 197.539 409.602 198.608 408.032C199.805 409.808 200.937 411.456 202.044 413.129C202.173 413.322 202.16 413.631 202.16 413.888C202.16 419.783 202.16 425.666 202.16 431.561C202.16 431.78 202.109 431.998 202.083 432.269L202.096 432.256Z"
                    fill="url(#paint16_linear_28_738)" />
                <path
                    d="M195.738 406.925C194.773 408.341 193.872 409.705 192.932 411.056C192.829 411.211 192.546 411.314 192.353 411.314C186.084 411.327 179.803 411.314 173.303 411.314C174.333 409.782 175.26 408.392 176.212 407.028C176.328 406.873 176.676 406.809 176.907 406.809C183.06 406.809 189.199 406.809 195.352 406.809C195.442 406.809 195.519 406.86 195.738 406.925Z"
                    fill="url(#paint17_linear_28_738)" />
                <path d="M192.494 400V403.784H181.682V400H192.494Z" fill="url(#paint18_linear_28_738)" />
                <path d="M154.897 411.262V408.173H163.032V411.262H154.897Z" fill="url(#paint19_linear_28_738)" />
                <path
                    d="M156.004 423.632C155.992 421.959 157.266 420.659 158.926 420.646C160.6 420.646 161.912 421.894 161.964 423.542C162.003 425.202 160.638 426.618 158.978 426.631C157.382 426.631 156.017 425.266 156.004 423.632Z"
                    fill="url(#paint20_linear_28_738)" />
                <path
                    d="M292 262.524C291.495 261.388 290.63 260.983 289.386 261.001C285.402 261.055 281.41 261.019 277.417 261.019C273.992 261.019 271.423 263.587 271.189 266.994C271.009 269.644 270.621 272.285 270.333 274.935C270.242 275.746 270.152 276.557 270.053 277.422H269.134C254.253 277.422 239.364 277.44 224.484 277.395C222.663 277.395 221.771 278.675 222.05 280.288C223.141 286.426 224.114 292.582 225.142 298.72C225.295 299.639 225.421 300.568 225.646 301.469C226.349 304.29 228.72 306.128 231.622 306.128C243.997 306.128 256.372 306.128 268.755 306.128C269.747 306.128 270.558 306.408 271.009 307.345C271.621 308.625 270.738 310.085 269.278 310.229C269.026 310.256 268.773 310.238 268.53 310.238C257.814 310.238 247.106 310.238 236.39 310.238C232.866 310.238 230.171 312.978 230.198 316.502C230.216 319.549 232.622 322.208 235.66 322.523C238.778 322.857 241.771 320.766 242.329 317.719C242.528 316.656 242.356 315.52 242.356 314.375H255.11C254.425 316.809 254.857 318.981 256.66 320.784C257.976 322.09 259.598 322.631 261.446 322.532C264.33 322.37 268.178 319.378 266.827 314.33C267.593 314.33 268.332 314.33 269.08 314.33C272 314.321 274.488 312.402 275.146 309.662C275.812 306.886 274.569 304.101 272 302.749C271.558 302.514 271.423 302.271 271.477 301.802C271.829 298.747 272.171 295.701 272.514 292.645C272.856 289.59 273.19 286.534 273.532 283.488C273.875 280.387 274.226 277.287 274.569 274.196C274.821 271.915 275.091 269.626 275.308 267.337C275.443 265.904 276.245 265.101 277.696 265.101C281.59 265.101 285.492 265.065 289.386 265.12C290.63 265.138 291.495 264.732 292 263.596V262.506V262.524ZM263.005 291.807C263.005 293.078 263.005 294.358 263.005 295.628C263.005 296.989 262.131 297.954 260.941 297.945C259.769 297.936 258.904 296.98 258.904 295.673C258.904 293.078 258.895 290.482 258.904 287.886C258.904 286.579 259.796 285.633 260.968 285.642C262.14 285.651 262.996 286.606 263.005 287.913C263.005 289.211 263.005 290.509 263.005 291.807ZM246.592 291.825C246.592 290.527 246.592 289.229 246.592 287.931C246.592 286.579 247.494 285.615 248.683 285.642C249.855 285.669 250.693 286.615 250.702 287.94C250.702 290.509 250.702 293.087 250.702 295.655C250.702 296.98 249.855 297.927 248.683 297.954C247.494 297.981 246.601 297.007 246.601 295.655C246.601 294.385 246.601 293.105 246.601 291.834L246.592 291.825ZM238.391 291.726C238.391 293.042 238.391 294.367 238.391 295.682C238.382 296.989 237.507 297.945 236.336 297.945C235.164 297.945 234.29 296.989 234.29 295.682C234.29 293.087 234.281 290.491 234.29 287.895C234.29 286.588 235.173 285.633 236.345 285.633C237.516 285.633 238.382 286.588 238.391 287.895C238.391 289.166 238.391 290.446 238.391 291.717V291.726Z"
                    fill="url(#paint21_linear_28_738)" />
                <path
                    d="M246.593 273.267C246.593 269.779 246.611 266.336 246.584 262.902C246.584 261.812 245.646 261.019 244.475 261.019C240.302 261.019 236.138 261.019 231.965 261.019C230.667 261.019 229.369 261.001 228.071 261.019C227.008 261.037 226.106 261.866 226.106 262.902C226.079 266.336 226.097 269.779 226.097 273.267H246.602H246.593Z"
                    fill="url(#paint22_linear_28_738)" />
                <path
                    d="M263.005 273.267C263.005 271.14 263.023 269.067 263.005 267.003C262.996 266.048 262.176 265.156 261.23 265.147C257.751 265.111 254.263 265.129 250.748 265.129V273.267H263.014H263.005Z"
                    fill="url(#paint23_linear_28_738)" />
                <path
                    d="M13.0455 561.155C15.8171 549.48 25.9828 544.5 34.8062 546.091C36.1148 546.332 37.4124 546.71 38.6784 547.14C41.6749 548.168 44.6428 549.276 47.6229 550.349C49.504 551.027 49.7757 552.085 48.427 553.519C47.1675 554.883 45.8709 556.208 44.6527 557.6C41.7312 560.913 42.291 566.005 46.2655 567.872C50.338 569.787 54.6802 571.415 59.0746 572.294C64.4658 573.391 69.2404 569.375 70.4993 563.748C71.4809 559.352 72.6253 555.002 73.7017 550.628C74.0056 549.393 74.3095 548.158 74.6275 546.814C75.636 547.177 76.5743 547.451 77.4368 547.864C77.6552 547.968 77.768 548.508 77.7598 548.851C77.5095 554.521 77.2212 560.191 76.9441 565.865C76.8632 567.653 76.7708 569.438 76.688 571.303C76.402 571.315 76.1427 571.324 75.8834 571.333C71.5931 571.516 68.0241 573.072 65.5739 576.747C64.5937 578.224 64.2031 579.735 65.492 581.275C65.5994 581.403 65.5839 581.73 65.5073 581.908C65.3345 582.281 65.0825 582.625 64.8091 583.064L63.9592 582.758C55.1094 579.57 46.2482 576.379 37.3984 573.191C36.8771 573.003 36.5771 572.806 36.4897 572.16C36.2185 570.283 35.0901 569.044 33.2997 568.399C26.8861 566.089 20.4612 563.775 14.0477 561.465L13.0505 561.106L13.0455 561.155ZM28.3454 560.047C26.4531 559.366 24.5607 558.684 22.6797 558.007C21.6032 557.619 20.7265 557.956 20.4154 558.855C20.1247 559.698 20.5656 560.535 21.5968 560.907C25.3434 562.269 29.0941 563.62 32.8488 564.96C33.88 565.331 34.7381 564.974 35.0483 564.113C35.3748 563.207 34.9403 562.423 33.8411 562.027C32.0054 561.366 30.1811 560.709 28.3454 560.047ZM30.7858 557.573C32.2136 558.087 33.6332 558.624 35.0804 559.119C36.0631 559.448 36.88 559.063 37.1707 558.221C37.4768 557.371 37.069 556.584 36.0945 556.233C33.2616 555.213 30.441 554.158 27.5991 553.199C27.1345 553.031 26.4124 553.117 25.9985 553.377C24.9613 554.054 25.2539 555.516 26.5139 556.034C27.9212 556.605 29.3653 557.074 30.7931 557.588L30.7858 557.573Z"
                    fill="url(#paint24_linear_28_738)" />
                <path
                    d="M40.4522 544.489C40.1308 544.386 39.8126 544.31 39.5067 544.199C31.7447 541.404 23.9827 538.608 16.2207 535.812C14.453 535.175 14.2033 534.624 14.84 532.857C16.9256 527.066 19.0072 521.287 21.0928 515.497L21.4438 514.522L25.8858 516.122C25.7103 516.61 25.5162 517.077 25.3674 517.562C25.1157 518.367 25.4628 519.145 26.1789 519.467C26.8724 519.781 27.7287 519.5 28.1236 518.759C28.3866 518.278 28.559 517.764 28.8052 517.187L40.5105 521.403C40.3881 521.743 40.2452 522.14 40.1064 522.525C39.7536 523.575 40.1084 524.51 40.9777 524.797C41.8244 525.077 42.6472 524.605 43.0218 523.6C43.1524 523.238 43.2871 522.864 43.4381 522.445L47.812 524.02L40.4408 544.485L40.4522 544.489Z"
                    fill="url(#paint25_linear_28_738)" />
                <path
                    d="M84.7288 592.197C82.6583 596.88 77.7715 599.216 73.0757 597.716C67.2232 595.839 64.7282 588.834 68.0639 583.66C68.4674 583.037 68.8228 582.833 69.6006 583.126C74.5361 584.954 79.4879 586.738 84.4561 588.476C85.1926 588.742 85.3934 589.108 85.2319 589.806C85.0491 590.597 84.9003 591.401 84.7247 592.209L84.7288 592.197Z"
                    fill="url(#paint26_linear_28_738)" />
                <path
                    d="M16.4303 565.69L17.3255 566.012C22.2207 567.775 27.1159 569.538 32.011 571.302C33.4388 571.816 33.8085 572.602 33.2158 573.963C31.1027 578.835 25.5958 580.973 20.7347 578.902C16.3939 577.057 14.0591 571.633 15.7842 567.057C15.9474 566.604 16.1973 566.195 16.4417 565.694L16.4303 565.69Z"
                    fill="url(#paint27_linear_28_738)" />
                <path
                    d="M88.322 586.592L67.8008 579.2C68.4012 577.675 69.4888 576.646 70.8139 575.882C73.3367 574.422 76.0098 574.002 78.795 574.942C80.5977 575.552 82.4927 576.12 84.0918 577.118C87.2105 579.086 88.84 581.99 88.5007 585.811C88.4798 586.047 88.3982 586.274 88.322 586.592Z"
                    fill="url(#paint28_linear_28_738)" />
                <path
                    d="M22.5463 511.463C22.9055 510.466 23.2216 509.518 23.583 508.585C23.8996 507.777 24.6589 507.411 25.4961 507.61C25.7308 507.669 25.9493 507.773 26.1873 507.859C33.598 510.528 41.0201 513.202 48.4308 515.871C50.0965 516.471 50.3825 517.099 49.7856 518.791C49.5285 519.505 49.2714 520.219 48.9857 521.012L22.5382 511.486L22.5463 511.463Z"
                    fill="url(#paint29_linear_28_738)" />
                <path
                    d="M84.967 540.642L82.8773 546.444C82.6085 546.372 82.3697 546.325 82.1544 546.247C79.5255 545.3 76.8812 544.361 74.2564 543.402C72.432 542.745 71.5625 541.037 72.1552 539.356C72.7561 537.652 74.5535 536.891 76.4118 537.56C79.2447 538.581 82.0662 539.597 84.967 540.642Z"
                    fill="url(#paint30_linear_28_738)" />
                <path
                    d="M43.4206 545.596C43.8247 544.474 44.1376 543.499 44.5226 542.537C44.8659 541.726 45.5482 541.396 46.3794 541.682C48.1934 542.297 49.9951 542.946 51.7804 543.64C52.8447 544.062 53.3567 545.271 53.0564 546.353C52.7357 547.492 51.6391 548.262 50.4756 548.009C49.5015 547.799 48.5619 547.422 47.6173 547.095C46.2421 546.612 44.8751 546.107 43.4134 545.581L43.4206 545.596Z"
                    fill="url(#paint31_linear_28_738)" />
                <path
                    d="M256.215 1071.04C250.678 1071.57 245.854 1069.42 241.198 1066.85C234.933 1063.38 229.449 1058.95 224.899 1053.38C215.57 1041.94 218.908 1025.19 230.932 1017.67C242.182 1010.63 257.268 1013.98 264.342 1025.2C264.453 1025.38 264.619 1025.54 264.754 1025.71L267.302 1031.82C267.483 1032.96 267.71 1034.09 267.841 1035.24C268.754 1043 267.841 1050.59 265.521 1058.02C264.077 1062.63 262.256 1067.08 258.249 1070.2L256.211 1071.05L256.215 1071.04ZM235.217 1041.85C237.192 1046.59 242.674 1048.88 247.417 1046.92C252.141 1044.96 254.435 1039.44 252.481 1034.7C250.531 1029.98 245.004 1027.69 240.269 1029.65C235.533 1031.6 233.255 1037.12 235.228 1041.85L235.217 1041.85Z"
                    fill="url(#paint32_linear_28_738)" />
                <path
                    d="M184.236 1006.79C184.401 1007.18 184.53 1007.49 184.656 1007.8C186.942 1013.28 189.228 1018.77 191.521 1024.26C192.154 1025.78 193.157 1026.46 194.52 1026.13C195.122 1025.98 195.733 1025.52 196.161 1025.05C198.039 1022.94 199.87 1020.78 201.688 1018.61C202.016 1018.22 202.326 1018.09 202.835 1018.14C205.624 1018.37 208.411 1018.57 211.202 1018.76C213.712 1018.94 214.951 1017.24 213.987 1014.9C211.727 1009.43 209.438 1003.98 207.162 998.514C207.023 998.181 206.884 997.847 206.723 997.46C207.019 997.318 207.234 997.201 207.466 997.104C212.459 995.025 217.451 992.946 222.444 990.867C223.979 990.227 225.36 990.771 225.993 992.29C228.476 998.252 230.956 1004.21 233.438 1010.17C233.493 1010.3 233.529 1010.43 233.609 1010.64C223.779 1014.74 217.31 1021.83 215.11 1032.32C212.905 1042.82 216.132 1051.83 223.612 1059.57L222.659 1059.97C212.883 1064.04 203.108 1068.11 193.332 1072.18C191.433 1072.97 190.192 1072.46 189.404 1070.57C181.982 1052.75 174.556 1034.92 167.133 1017.1C166.365 1015.25 166.884 1014.01 168.736 1013.23C173.597 1011.21 178.458 1009.19 183.318 1007.16C183.597 1007.05 183.876 1006.93 184.233 1006.78L184.236 1006.79Z"
                    fill="url(#paint33_linear_28_738)" />
                <path
                    d="M207.815 1013.41C207.485 1013.4 207.213 1013.4 206.951 1013.38C205.149 1013.25 203.346 1013.14 201.546 1012.99C200.472 1012.9 199.624 1013.24 198.934 1014.08C197.773 1015.46 196.594 1016.82 195.416 1018.19C195.239 1018.4 195.045 1018.59 194.798 1018.85L188.98 1004.88L202.011 999.449L207.823 1013.4L207.815 1013.41Z"
                    fill="url(#paint34_linear_28_738)" />
                <path
                    d="M239.903 1039.89C238.994 1037.68 240.008 1035.27 242.228 1034.35C244.414 1033.44 246.873 1034.47 247.778 1036.67C248.678 1038.85 247.65 1041.3 245.438 1042.21C243.244 1043.13 240.808 1042.1 239.903 1039.89Z"
                    fill="url(#paint35_linear_28_738)" />
                <path
                    d="M262.225 870.569C261.71 867.189 262.741 864.329 265.184 861.984C268.428 858.873 273.708 858.591 277.355 861.307C277.665 861.537 277.891 861.433 278.149 861.292C279.732 860.408 281.312 859.52 282.896 858.628C284.105 857.95 285.298 857.247 286.519 856.597C287.492 856.082 288.536 856.083 289.597 856.276C296.858 857.591 304.122 858.891 311.384 860.198C311.766 860.269 312.155 860.328 312.541 860.404C313.483 860.584 313.767 860.998 313.589 861.932C312.546 867.361 311.503 872.781 310.456 878.205C310.238 879.333 310.022 880.467 309.796 881.594C309.628 882.405 309.178 882.722 308.367 882.575C300.626 881.183 292.881 879.786 285.14 878.394C283.884 878.169 282.912 877.545 282.147 876.526C281.507 875.668 280.798 874.857 280.119 874.025C280.035 873.924 279.926 873.839 279.793 873.72C278.876 875.14 277.747 876.284 276.216 877.168C276.092 876.47 275.95 875.872 275.895 875.265C275.883 875.099 276.097 874.894 276.234 874.734C276.884 873.97 277.548 873.216 278.199 872.443C278.426 872.172 278.398 871.93 278.135 871.632C277.263 870.636 276.428 869.599 275.592 868.571C274.388 867.092 274.356 864.743 275.505 863.164C275.605 863.024 275.707 862.888 275.81 862.752C274.053 861.175 270.579 860.993 267.992 862.326C265.421 863.649 263.744 866.772 264.077 869.675C264.264 869.641 264.449 869.615 264.631 869.563C268.808 868.53 273.078 870.326 275.168 874.089C275.887 875.379 275.927 875.068 274.618 875.728C273.561 876.258 272.394 876.428 271.207 876.387C270.643 876.369 270.242 876.672 270.125 877.188C270.058 877.481 270.155 877.907 270.347 878.123C270.532 878.33 270.928 878.42 271.238 878.439C272.849 878.515 274.327 878.146 276.124 877.267C276.166 877.413 276.226 877.553 276.243 877.694C276.574 880.88 275.875 883.738 273.555 886.071C273.254 886.371 273.282 886.656 273.403 887.023C275.46 893.23 277.494 899.446 279.556 905.65C279.743 906.217 279.722 906.674 279.453 907.199C278.942 908.188 278.495 909.205 278.025 910.21C277.707 910.877 277.547 910.929 276.893 910.61C275.883 910.121 274.867 909.644 273.852 909.159C273.764 909.031 273.677 908.902 273.589 908.774C273.84 908.211 274.064 907.629 274.355 907.081C274.613 906.592 274.507 906.288 274.029 906.036C273.563 905.791 273.128 905.495 272.662 905.249C272.195 905.012 272.131 904.686 272.33 904.237C272.564 903.722 272.757 903.19 272.987 902.67C273.164 902.273 273.064 902.001 272.69 901.794C272.18 901.505 271.684 901.194 271.173 900.914C270.79 900.705 270.705 900.423 270.862 900.04C271.076 899.516 271.258 898.978 271.511 898.471C271.779 897.932 271.609 897.599 271.122 897.324C270.578 897.016 270.069 896.655 269.523 896.356C269.085 896.12 268.834 895.785 268.668 895.311C267.925 893.183 267.132 891.066 266.388 888.938C266.245 888.529 266.029 888.351 265.614 888.295C261.634 887.757 258.999 885.513 257.804 881.745C256.615 877.994 257.571 874.656 260.348 871.879C260.891 871.34 261.608 870.979 262.245 870.534C262.447 871.178 262.63 871.835 262.86 872.475C262.984 872.825 263.009 873.083 262.773 873.426C261.829 874.807 262.021 876.502 263.199 877.701C264.272 878.799 266.078 879.023 267.405 878.221C268.925 877.309 269.555 875.702 269.016 874.114C268.51 872.627 266.983 871.66 265.392 871.824C265.187 871.842 264.979 871.876 264.732 871.908L264.171 870.024L262.235 870.562L262.225 870.569ZM301.063 873.974C301.232 873.67 301.42 873.468 301.471 873.237C301.922 870.999 302.352 868.754 302.764 866.513C302.857 866.015 302.636 865.63 302.135 865.459C301.654 865.297 301.238 865.43 300.953 865.85C300.84 866.022 300.798 866.247 300.759 866.454C300.364 868.487 299.974 870.517 299.587 872.551C299.554 872.726 299.469 872.929 299.534 873.066C299.668 873.366 299.818 873.733 300.074 873.884C300.33 874.035 300.723 873.953 301.063 873.974ZM293.389 864.018C293.228 864.418 293.063 864.705 292.998 865.011C292.588 867.076 292.198 869.148 291.805 871.216C291.666 871.964 291.933 872.469 292.522 872.587C293.127 872.708 293.586 872.321 293.736 871.558C293.941 870.526 294.138 869.492 294.334 868.458C294.538 867.383 294.746 866.312 294.945 865.24C295.032 864.775 294.936 864.34 294.486 864.149C294.179 864.019 293.802 864.06 293.387 864.026L293.389 864.018Z"
                    fill="url(#paint36_linear_28_738)" />
                <path
                    d="M264.743 874.068C265.413 873.608 266.394 873.79 266.871 874.463C267.317 875.092 267.128 876.085 266.474 876.548C265.812 877.009 264.792 876.832 264.326 876.174C263.842 875.491 264.024 874.562 264.738 874.071L264.743 874.068Z"
                    fill="url(#paint37_linear_28_738)" />
                <g opacity="0.3">
                    <path
                        d="M248.281 100.98C252.645 100.88 256.815 102.997 260.051 105.927C263.272 108.857 265.693 112.559 268.012 116.244C273.123 124.343 277.744 131.844 281.922 140.428C283.646 143.971 285.293 148.532 286.621 152.242C287.05 153.43 287.449 154.661 287.388 155.92C287.328 157.178 286.713 158.485 285.581 159.032C284.317 159.649 282.731 159.161 281.671 158.223C280.618 157.293 279.958 155.999 279.312 154.749C273.852 144.254 266.592 134.235 256.356 128.297C253.496 126.634 250.448 125.324 247.58 123.697C244.705 122.063 241.954 120.067 240.068 117.351C238.182 114.636 237.259 111.108 238.229 107.944C239.51 103.78 243.931 101.066 248.296 100.966L248.281 100.98Z"
                        fill="url(#paint38_linear_28_738)" />
                    <path
                        d="M464.624 140.626C463.303 125.788 454.264 111.679 440.984 104.927C430.539 99.6039 418.448 98.9112 406.86 97.0772C389.774 94.3755 373.119 88.9872 357.689 81.1603C343.342 73.8925 329.759 55.0958 313.84 52.7437C303.396 51.1933 292.312 53.0758 283.492 58.8824C272.444 66.1476 265.936 81.3487 265.859 91.9002C265.7 113.309 289.892 134.912 293.621 155.993C296.64 173.069 287.463 186.48 288.817 203.773C289.949 218.207 299.564 231.547 312.711 237.583C325.859 243.62 342.016 242.298 354.252 234.575C362.884 229.122 369.397 220.963 376.948 214.091L377.074 213.97C384.077 207.641 392.694 203.345 401.935 201.465C404.575 200.924 407.2 200.355 409.812 199.741C424.078 196.352 438.387 191.049 448.994 180.935C459.779 170.65 465.922 155.471 464.602 140.633L464.624 140.626Z"
                        fill="url(#paint39_linear_28_738)" />
                </g>
            </g>
            <defs>
                <linearGradient id="paint0_linear_28_738" x1="335.695" y1="596.025" x2="339.204"
                    y2="566.937" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_738" x1="246.492" y1="760.202" x2="252.747"
                    y2="708.351" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint2_linear_28_738" x1="140.076" y1="601.021" x2="144.957"
                    y2="560.561" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint3_linear_28_738" x1="234.044" y1="757.929" x2="263.495"
                    y2="513.798" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint4_linear_28_738" x1="145.729" y1="1176.71" x2="152.567"
                    y2="1196.5" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint5_linear_28_738" x1="160.221" y1="1140.24" x2="173.208"
                    y2="1177.83" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint6_linear_28_738" x1="171.269" y1="1169.81" x2="177.223"
                    y2="1187.04" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint7_linear_28_738" x1="63.96" y1="209.194" x2="111.185"
                    y2="272.258" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint8_linear_28_738" x1="207.582" y1="591" x2="207.582"
                    y2="633.714" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint9_linear_28_738" x1="207.579" y1="636.285" x2="207.579"
                    y2="670.939" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint10_linear_28_738" x1="207.558" y1="656.695" x2="207.558"
                    y2="670.914" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint11_linear_28_738" x1="162.504" y1="447.264" x2="162.504"
                    y2="489.032" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint12_linear_28_738" x1="162.5" y1="435.293" x2="162.5"
                    y2="444.245" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint13_linear_28_738" x1="134.66" y1="407.213" x2="134.66"
                    y2="432.333" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint14_linear_28_738" x1="181.998" y1="414.442" x2="181.998"
                    y2="432.256" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint15_linear_28_738" x1="158.97" y1="414.352" x2="158.97"
                    y2="432.281" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint16_linear_28_738" x1="198.613" y1="408.032" x2="198.613"
                    y2="432.269" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint17_linear_28_738" x1="184.521" y1="406.809" x2="184.521"
                    y2="411.32" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint18_linear_28_738" x1="187.088" y1="400" x2="187.088"
                    y2="403.784" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint19_linear_28_738" x1="158.964" y1="408.173" x2="158.964"
                    y2="411.262" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint20_linear_28_738" x1="158.985" y1="420.646" x2="158.985"
                    y2="426.631" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint21_linear_28_738" x1="257" y1="261" x2="257"
                    y2="322.558" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint22_linear_28_738" x1="236.347" y1="261.011" x2="236.347"
                    y2="273.267" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint23_linear_28_738" x1="256.881" y1="265.124" x2="256.881"
                    y2="273.267" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint24_linear_28_738" x1="54.4097" y1="539.512" x2="41.7181"
                    y2="574.747" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint25_linear_28_738" x1="34.6336" y1="519.273" x2="27.2461"
                    y2="539.783" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint26_linear_28_738" x1="77.0332" y1="585.802" x2="72.7781"
                    y2="597.616" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint27_linear_28_738" x1="25.1143" y1="568.818" x2="21.3905"
                    y2="579.156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint28_linear_28_738" x1="80.6957" y1="575.583" x2="78.0614"
                    y2="582.896" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint29_linear_28_738" x1="37.336" y1="511.863" x2="35.7569"
                    y2="516.247" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint30_linear_28_738" x1="79.0917" y1="538.526" x2="76.9797"
                    y2="544.389" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint31_linear_28_738" x1="49.3977" y1="542.742" x2="47.8013"
                    y2="547.174" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint32_linear_28_738" x1="234.42" y1="1015.86" x2="257.227"
                    y2="1070.62" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint33_linear_28_738" x1="195.481" y1="1002.1" x2="220.039"
                    y2="1061.06" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint34_linear_28_738" x1="195.496" y1="1002.16" x2="201.314"
                    y2="1016.13" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint35_linear_28_738" x1="242.209" y1="1034.36" x2="245.473"
                    y2="1042.2" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint36_linear_28_738" x1="273.731" y1="855.976" x2="300.543"
                    y2="895.036" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint37_linear_28_738" x1="264.741" y1="874.07" x2="266.452"
                    y2="876.563" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint38_linear_28_738" x1="274.423" y1="120.768" x2="258.164"
                    y2="136.425" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint39_linear_28_738" x1="413.949" y1="73.6075" x2="277.487"
                    y2="205.016" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 2 -->
        <svg class="e-shape-2" width="428" height="1099" viewBox="0 0 428 1099" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g opacity="0.19">
                <path
                    d="M107.949 872.983C133.798 879.164 142.061 835.876 129.39 812.949C116.72 789.998 30.0039 793.046 54.4198 825.342C78.8357 857.637 100.233 871.125 108.025 872.986L107.949 872.983Z"
                    fill="url(#paint0_linear_28_690)" />
                <path
                    d="M151.662 852.461L151.354 853.568C147.766 866.472 144.174 879.388 140.611 892.298C140.399 893.061 140.059 893.377 139.29 893.521C124.559 896.409 109.834 899.324 95.1122 902.227C94.7759 902.293 94.4308 902.343 93.9421 902.432L94.2191 901.436C97.8244 888.471 101.433 875.493 105.038 862.528C105.209 861.913 105.414 861.559 106.114 861.423C120.969 858.517 135.835 855.574 150.685 852.64C150.965 852.585 151.238 852.555 151.655 852.486L151.662 852.461Z"
                    fill="url(#paint1_linear_28_690)" />
                <path
                    d="M91.6613 901.771C90.95 901.136 90.3146 900.562 89.6791 899.988C78.8993 890.192 68.1318 880.399 57.3486 870.616C56.9372 870.236 56.7159 869.936 56.8869 869.321C60.5681 856.178 64.2157 843.013 67.8723 829.864C67.9202 829.691 67.9961 829.514 68.087 829.234C68.387 829.49 68.6391 829.679 68.8598 829.886C72.6478 833.325 76.4324 836.776 80.2396 840.194C80.739 840.637 80.8715 841.019 80.6779 841.667C79.413 846.073 78.2097 850.496 76.9817 854.912L76.6568 856.08C77.9114 856.429 79.0896 856.863 80.3046 857.068C82.0131 857.358 83.075 858.21 83.814 859.793C84.6883 861.653 85.8073 863.396 86.9118 865.333L91.1054 850.252C91.3555 850.401 91.5209 850.473 91.6357 850.585C95.2665 853.874 98.8885 857.147 102.497 860.47C102.751 860.699 102.937 861.268 102.848 861.588C99.2117 874.809 95.5223 888.029 91.8487 901.24C91.8076 901.388 91.742 901.529 91.649 901.768L91.6613 901.771Z"
                    fill="url(#paint2_linear_28_690)" />
                <path
                    d="M150.947 850.221C145.227 851.347 139.675 852.441 134.107 853.543C124.657 855.407 115.207 857.272 105.762 859.164C104.974 859.33 104.476 859.165 103.899 858.62C100.515 855.492 97.0925 852.407 93.6891 849.301C93.4773 849.109 93.2812 848.909 92.9546 848.606C94.7214 848.209 96.3638 847.831 98.0028 847.465C111.087 844.544 124.183 841.626 137.261 838.676C137.896 838.535 138.327 838.655 138.786 839.1C142.61 842.602 146.452 846.082 150.292 849.575C150.482 849.747 150.641 849.937 150.943 850.233L150.947 850.221Z"
                    fill="url(#paint3_linear_28_690)" />
                <path
                    d="M69.8291 827.638C71.3177 827.337 72.6976 827.044 74.0864 826.768C87.7715 824.067 101.457 821.366 115.148 818.64C115.809 818.505 116.262 818.591 116.779 819.067C120.396 822.405 124.052 825.701 127.797 829.101C127.488 829.214 127.266 829.298 127.038 829.354C112.511 832.603 97.9937 835.868 83.4617 839.089C83.1063 839.175 82.5555 839.155 82.3259 838.932C78.1799 835.208 74.0687 831.454 69.8359 827.614L69.8291 827.638Z"
                    fill="url(#paint4_linear_28_690)" />
                <path
                    d="M57.4236 103.09C46.5997 103.09 35.7757 103.059 24.9517 103.12C23.2825 103.12 21.9308 102.014 22.0025 100.14C22.1151 97.3754 22.0332 94.6003 22.0332 91.8252C22.0332 87.9339 23.3337 84.5239 25.9041 81.6156C28.1262 79.0965 30.42 76.6184 32.6831 74.13C33.9939 72.6963 35.6118 72 37.5677 72C51.1873 72.0102 64.8069 72.0102 78.4367 72C80.5154 72 82.2153 72.7578 83.5158 74.3655C85.6151 76.9665 87.7348 79.5471 89.7727 82.1891C91.8617 84.8925 92.8755 87.9953 92.8755 91.4258C92.8755 94.4262 92.8755 97.4368 92.8755 100.437C92.8755 102.086 91.8719 103.079 90.2027 103.079C79.2764 103.079 68.35 103.079 57.4134 103.079L57.4236 103.09ZM48.1357 100.591C48.1357 100.243 48.1357 99.9662 48.1357 99.6897C48.1357 96.6381 48.1357 93.5865 48.1357 90.5349C48.1357 90.0434 48.1664 89.5519 48.2278 89.0706C48.617 85.7834 49.6513 82.6806 50.8596 79.629C51.5355 77.9291 52.2727 76.26 53.0203 74.4986C51.4433 74.4986 49.9175 74.4884 48.4019 74.5191C48.2278 74.5191 48.0128 74.7444 47.9104 74.9185C45.2991 79.2296 43.6402 83.8787 43.333 88.9169C43.1077 92.6854 43.1999 96.464 43.1589 100.243C43.1589 100.366 43.2101 100.478 43.2408 100.601H48.1357V100.591ZM63.1684 74.4986C64.1105 76.8129 65.0629 79.0146 65.9128 81.2572C67.3567 85.0564 68.2476 88.9477 68.0428 93.0643C67.9301 95.3069 68.0223 97.5597 68.0223 99.8126C68.0223 100.058 68.0428 100.314 68.053 100.56H72.9991C72.9991 98.9012 72.9991 97.3037 72.9991 95.7062C72.9991 92.6342 73.0913 89.5518 72.5588 86.5002C71.8419 82.3836 70.439 78.5333 68.2681 74.9595C68.1452 74.7546 67.8585 74.5294 67.6434 74.5294C66.1688 74.4884 64.6942 74.5089 63.1787 74.5089L63.1684 74.4986Z"
                    fill="url(#paint5_linear_28_690)" />
                <path
                    d="M28.249 106.848H87.9089V107.667C87.9089 115.613 87.9089 123.56 87.9089 131.517C87.9089 135.93 84.6832 139.146 80.2594 139.146C75.8049 139.146 71.3606 139.146 66.7832 139.146C66.7832 138.849 66.7832 138.572 66.7832 138.306C66.7832 134.087 66.8037 129.868 66.7832 125.649C66.7525 121.512 64.1207 118.061 60.3113 117.088C54.6894 115.654 49.4362 119.751 49.385 125.639C49.3543 129.837 49.385 134.026 49.385 138.224C49.385 138.501 49.385 138.787 49.385 139.115C49.0778 139.125 48.8217 139.156 48.576 139.156C44.3263 139.156 40.0868 139.156 35.8371 139.156C31.5259 139.156 28.2593 135.91 28.2593 131.609C28.2593 123.611 28.2593 115.613 28.2593 107.606V106.858L28.249 106.848Z"
                    fill="url(#paint6_linear_28_690)" />
                <path
                    d="M117.649 307.678C110.337 304.947 103.021 302.228 95.7141 299.486C90.7932 297.635 88.0863 293.155 88.7256 288.036C88.9464 286.297 89.6566 284.754 90.6445 283.328C91.3686 282.286 92.0574 281.23 92.7889 280.204C94.0466 278.45 94.6564 276.495 94.7372 274.342C95.2236 260.486 95.7217 246.635 96.2199 232.784C96.2835 230.999 95.6728 230.088 93.9963 229.449C91.9157 228.672 89.8351 227.895 87.7544 227.118C85.568 226.301 84.4797 224.086 85.2097 221.988C85.988 219.761 88.2555 218.639 90.4977 219.449C94.2842 220.823 98.0575 222.232 101.818 223.677C103.659 224.378 104.586 225.876 104.529 227.93C104.419 231.667 104.274 235.39 104.153 239.122C104.078 241.331 104.557 242.059 106.625 242.831C126.538 250.268 146.451 257.704 166.376 265.145C167.057 265.4 167.763 265.663 168.323 266.1C170.225 267.534 170.421 270.058 168.813 272.069C165.331 276.408 161.821 280.749 158.327 285.084C154.842 289.394 151.361 293.693 147.888 298.008C146.227 300.054 144.791 300.455 142.287 299.52C129.145 294.612 116.015 289.708 102.873 284.801C100.745 284.006 99.9055 284.282 98.6156 286.157C98.0924 286.913 97.55 287.648 97.0458 288.424C96.3189 289.546 96.6644 290.88 97.8328 291.518C98.2458 291.739 98.7042 291.91 99.1392 292.072C113.762 297.533 128.385 302.994 143.008 308.456C143.631 308.688 144.266 308.925 144.813 309.29C146.406 310.367 146.922 312.502 146.096 314.283C145.266 316.076 143.367 317.001 141.451 316.5C141.022 316.393 140.599 316.235 140.187 316.081C132.664 313.272 125.153 310.467 117.63 307.657L117.649 307.678Z"
                    fill="url(#paint7_linear_28_690)" />
                <path
                    d="M90.2811 301.77C94.5086 303.469 96.5549 308.212 94.8349 312.351C93.0534 316.655 88.4636 318.544 84.0598 316.779C79.9807 315.148 78.1149 310.353 79.8728 306.04C81.458 302.118 86.2651 300.15 90.2811 301.77Z"
                    fill="url(#paint8_linear_28_690)" />
                <path
                    d="M140.585 329.182C139.067 333.357 134.418 335.545 130.291 334.044C125.976 332.473 123.758 327.867 125.301 323.662C126.893 319.327 131.533 317.162 135.8 318.756C139.996 320.323 142.114 324.945 140.578 329.166L140.585 329.182Z"
                    fill="url(#paint9_linear_28_690)" />
                <path
                    d="M285.822 57.9025C289.578 61.3222 293.233 64.6505 296.888 67.9788C299.833 70.6597 300.525 74.6211 298.463 77.9771C297.813 79.0276 296.839 79.9965 295.793 80.6572C287.646 85.7575 279.446 90.7804 271.255 95.8108C268.039 97.7804 264.331 97.4164 261.546 94.8802C250.003 84.3698 238.452 73.8518 226.909 63.3415C224.157 60.8357 223.423 57.1555 225.055 53.8345C229.319 45.1524 233.583 36.4703 237.897 27.818C240.279 23.0348 246.368 21.9928 250.34 25.5946C253.853 28.7934 257.358 31.9846 260.871 35.1834L261.465 35.7241C261.7 35.4663 261.897 35.2501 262.101 35.0256C264.38 32.5223 266.66 30.019 268.939 27.5158C274.393 21.5597 283.575 20.5655 290.267 25.2134C298.555 30.9647 299.906 42.4179 293.184 49.8348C290.965 52.2716 288.738 54.7166 286.52 57.1534L285.838 57.9018L285.822 57.9025ZM281.788 54.1837C283.689 52.0963 285.537 50.083 287.362 48.0628C288.292 47.0239 289.24 46.0003 290.054 44.8707C293.289 40.3934 292.232 33.5738 287.823 30.1988C283.083 26.5669 276.776 27.0916 272.769 31.4591C270.519 33.9132 268.286 36.3825 266.052 38.8359C265.885 39.0188 265.751 39.2163 265.585 39.4152L281.796 54.1754L281.788 54.1837ZM277.861 69.9725C278.905 68.793 278.927 67.3229 278.126 66.3043C277.24 65.1936 275.835 64.8721 274.61 65.6125C269.944 68.4682 265.287 71.3314 260.647 74.2258C259.083 75.2047 259.051 77.4575 260.513 78.5908C261.526 79.3766 262.653 79.383 263.923 78.5927C268.045 76.0483 272.159 73.4964 276.281 70.9521C276.877 70.5826 277.481 70.2047 277.845 69.9732L277.861 69.9725ZM254.174 44.5552C252.867 43.3352 250.759 43.6674 249.908 45.3414C247.473 50.1668 245.079 55.0303 242.709 59.8848C242.057 61.2228 242.685 62.768 244.019 63.4359C245.305 64.074 246.892 63.5571 247.586 62.2413C248.191 61.089 248.756 59.9145 249.329 58.7476C251.1 55.1729 252.886 51.5976 254.649 48.0153C255.295 46.7174 255.095 45.4249 254.174 44.5552Z"
                    fill="url(#paint10_linear_28_690)" />
                <path
                    d="M122.816 638.694L124.553 637.261C125.572 638.119 126.621 638.939 127.585 639.851C127.852 640.101 127.882 640.609 128.048 640.98C129.333 643.899 130.642 646.812 131.902 649.748C132.327 650.738 132.657 651.765 132.998 652.793C133.102 653.097 133.102 653.425 133.165 653.82C129.069 653.888 125.554 655.262 122.638 658.066C119.721 660.879 118.204 664.332 118.09 668.523L117.113 668.328C110.342 666.98 103.578 665.59 96.8043 664.307C94.5743 663.885 92.9695 662.845 92.0187 660.768C91.4318 659.494 90.6414 658.365 89.2679 657.808C88.8751 657.643 88.4509 657.525 88.031 657.442C83.1804 656.422 78.3403 655.404 73.4877 654.394C72.1354 654.114 71.7654 653.56 72.0224 652.214C73.4056 644.882 78.8996 639.928 86.0415 639.636C87.1646 639.587 88.3152 639.674 89.4302 639.885C94.3731 640.826 99.3139 641.831 104.248 642.813C105.435 643.049 105.744 643.58 105.596 644.762C105.458 645.892 104.93 646.518 103.83 646.889C102.18 647.444 100.699 648.361 99.4489 649.597C98.0918 650.931 97.3774 652.546 97.2321 654.427C97.0558 656.793 98.4095 658.656 100.778 659.15C105.389 660.111 110.013 661.01 114.637 661.909C115.571 662.095 116.398 661.833 117.09 661.153C119.066 659.232 121.053 657.313 123.029 655.393C123.597 654.84 123.85 654.17 123.848 653.362C123.825 649.636 123.845 645.917 123.835 642.183C123.837 641.845 123.757 641.479 123.658 641.154C123.397 640.327 123.111 639.517 122.827 638.696L122.816 638.694Z"
                    fill="url(#paint11_linear_28_690)" />
                <path
                    d="M112.312 654.122L106.989 653.062L110.504 635.403L109.528 635.209C105.633 634.433 101.744 633.572 97.8257 632.912C94.9322 632.423 93.1352 630.155 94.4232 626.646C94.6667 626.684 94.9355 626.704 95.1875 626.754C100.762 627.864 106.327 628.972 111.902 630.082C114.884 630.675 116.523 633.076 115.932 636.047C114.786 641.855 113.618 647.669 112.462 653.475C112.421 653.685 112.36 653.88 112.301 654.12L112.312 654.122Z"
                    fill="url(#paint12_linear_28_690)" />
                <path
                    d="M121.602 630.757L120.604 630.559C117.182 629.877 113.769 629.144 110.332 628.536C107.991 628.124 106.184 627.055 105.11 624.887C105.061 624.801 104.99 624.722 104.851 624.541L104.487 625.986L94.9121 624.08C94.9329 623.866 94.9306 623.658 94.9703 623.458C95.4928 620.834 96.0153 618.209 96.5399 615.574C96.774 614.398 97.3505 613.476 98.4648 612.923C98.8404 612.735 99.1175 612.714 99.4495 613.075C100.944 614.671 102.79 615.377 104.981 615.224C105.225 615.207 105.607 615.48 105.746 615.715C107.008 617.985 108.244 620.272 109.435 622.572C109.758 623.193 110.181 623.485 110.855 623.608C113.192 624.04 115.533 624.507 117.857 625.002C120.497 625.56 122.214 628.172 121.57 630.751L121.602 630.757Z"
                    fill="url(#paint13_linear_28_690)" />
                <path
                    d="M123.708 670.514C120.758 669.927 120.253 669.171 120.843 666.211C121.837 661.213 126.133 657.179 131.232 656.458C136.287 655.74 141.311 658.301 143.721 662.808C144.022 663.381 144.165 663.922 143.697 664.462C143.284 664.948 142.766 665.03 142.161 664.833C136.323 662.907 129.997 664.911 126.388 669.934C125.816 670.726 125.312 671.008 124.43 670.669C124.208 670.581 123.958 670.575 123.716 670.527L123.708 670.514Z"
                    fill="url(#paint14_linear_28_690)" />
                <path
                    d="M137.378 666.49C138.543 666.667 139.746 666.71 140.867 667.054C142.052 667.409 143.171 667.599 144.388 667.078C144.805 668.492 144.785 669.853 144.495 671.203C143.725 674.848 140.74 677.725 137.09 678.406C133.362 679.094 129.601 677.483 127.532 674.332C127.162 673.778 127.113 673.364 127.487 672.751C128.543 671.007 129.833 669.518 131.566 668.433C131.803 668.284 132.068 668.162 132.351 668C132.162 670.374 132.732 671.623 134.21 672.146C135.657 672.664 137.122 672.213 137.951 671.014C138.856 669.699 138.656 668.294 137.384 666.513L137.378 666.49Z"
                    fill="url(#paint15_linear_28_690)" />
                <path
                    d="M72.8369 656.786L78.8003 657.973C79.1133 660.458 79.8804 661.43 81.619 661.688C83.114 661.909 84.3057 661.132 85.0789 659.386C86.0658 659.583 87.0904 659.699 88.0564 660.001C89.3605 660.413 89.6913 661.713 90.2423 662.783C90.3138 662.917 90.1209 663.228 90.0035 663.434C87.8884 666.931 83.7625 668.74 79.7118 667.65C75.3691 666.491 72.6177 662.767 72.7125 658.453C72.7267 657.943 72.7829 657.441 72.8348 656.796L72.8369 656.786Z"
                    fill="url(#paint16_linear_28_690)" />
                <path
                    d="M111.539 607.284L104.914 605.966L103.604 612.548C101.593 612.563 99.1702 610.476 98.3766 608.102C97.4524 605.342 98.4175 602.249 100.744 600.486C103.161 598.653 106.381 598.595 108.844 600.319C111.093 601.902 112.257 604.829 111.529 607.282L111.539 607.284Z"
                    fill="url(#paint17_linear_28_690)" />
                <path
                    d="M89.106 629.397C88.6755 631.559 88.2742 633.63 87.852 635.696C87.7036 636.441 87.1078 636.858 86.3498 636.718C82.7129 636.016 79.0698 635.29 75.4413 634.546C74.7904 634.417 74.305 633.949 74.4283 633.275C74.8063 631.102 75.2704 628.935 75.7093 626.73L89.1165 629.399L89.106 629.397Z"
                    fill="url(#paint18_linear_28_690)" />
                <path
                    d="M133.094 633.776C132.856 634.973 132.618 636.17 132.382 637.357C132.215 638.196 131.841 638.428 130.993 638.303C128.99 638.002 127.383 637.136 126.571 635.185C125.862 633.483 126.06 631.83 127.192 630.364C128.385 628.811 129.997 628.226 131.922 628.479C133.921 628.745 134.056 628.947 133.665 630.91C133.475 631.866 133.285 632.821 133.094 633.776Z"
                    fill="url(#paint19_linear_28_690)" />
                <path
                    d="M99.2495 635.684C101.286 636.089 103.334 636.497 105.37 636.902C106.62 637.151 107.263 637.977 107.052 639.038C106.841 640.098 105.92 640.613 104.67 640.365C100.565 639.548 96.4495 638.728 92.3444 637.911C91.095 637.662 90.454 636.825 90.6651 635.765C90.8741 634.715 91.7952 634.2 93.0446 634.449C95.1129 634.86 97.1812 635.272 99.2495 635.684Z"
                    fill="url(#paint20_linear_28_690)" />
                <path
                    d="M89.6033 626.898L76.1961 624.229C76.3592 623.41 76.4655 622.601 76.6937 621.839C76.8904 621.18 77.4843 620.938 78.1248 621.065C81.7616 621.767 85.3942 622.491 89.0227 623.235C89.8311 623.396 90.1676 624.008 90.0171 624.819C89.896 625.482 89.7538 626.142 89.6033 626.898Z"
                    fill="url(#paint21_linear_28_690)" />
                <path
                    d="M105.231 657.449L105.896 654.11C106.662 654.263 107.397 654.409 108.132 654.556C109.434 654.815 110.74 655.053 112.027 655.331C113.959 655.77 114.964 657.466 114.357 659.255L105.233 657.439L105.231 657.449Z"
                    fill="url(#paint22_linear_28_690)" />
                <path
                    d="M70.5095 648.354C69.722 648.088 69.499 647.564 69.616 646.921C69.9105 645.277 70.2281 643.627 70.5962 641.997C70.7781 641.193 71.3174 640.896 72.109 641.032C73.0265 641.193 73.9358 641.396 75.0172 641.611C72.9552 643.58 71.4834 645.765 70.499 648.352L70.5095 648.354Z"
                    fill="url(#paint23_linear_28_690)" />
                <path
                    d="M121.005 622.572L122.355 615.79C123.367 615.915 124.039 616.485 124.359 617.346C124.944 618.903 124.561 620.388 123.653 621.713C123.068 622.568 122.055 622.836 121.003 622.583L121.005 622.572Z"
                    fill="url(#paint24_linear_28_690)" />
                <path
                    d="M121.286 632.452C122.41 632.675 123.158 633.741 122.949 634.846C122.73 635.948 121.647 636.671 120.524 636.448C119.39 636.222 118.686 635.154 118.92 634.033C119.16 632.934 120.18 632.253 121.284 632.462L121.286 632.452Z"
                    fill="url(#paint25_linear_28_690)" />
                <path d="M110.712 609.685C110.21 611.768 108.259 613.071 106.176 612.733L106.933 608.932L110.712 609.685Z"
                    fill="url(#paint26_linear_28_690)" />
                <path
                    d="M125.011 623.937L126.251 622.427C126.97 623.585 127.664 624.705 128.334 625.832C128.532 626.155 128.492 626.409 128.083 626.601C127.493 626.876 126.954 627.227 126.266 627.614C126.859 626.008 125.439 625.19 125.011 623.937Z"
                    fill="url(#paint27_linear_28_690)" />
                <path
                    d="M134.941 637.331L136.183 631.095C137.107 631.824 137.398 632.723 137.233 633.77C137.005 635.242 136.794 636.739 134.941 637.331Z"
                    fill="url(#paint28_linear_28_690)" />
                <path
                    d="M39.6917 449.595C40.2996 447.964 41.4723 447.321 43.2019 447.24C48.6167 446.974 54.0243 446.594 59.4331 446.233C61.4064 446.109 62.5614 444.737 62.3193 442.856C62.1324 441.399 61.1647 440.636 59.4711 440.686C58.033 440.729 56.6091 440.848 55.174 440.938C51.8317 441.15 48.4894 441.361 45.1471 441.572C43.306 441.688 41.9745 440.569 41.8853 438.859C41.7998 437.205 42.9827 435.974 44.776 435.851C45.824 435.785 46.8626 435.719 48.0144 435.646C47.8831 433.569 47.7572 431.577 47.6313 429.585C47.509 427.649 48.5874 426.415 50.504 426.294C67.4705 425.222 84.4369 424.149 101.403 423.077L102.253 423.023L102.323 424.128C102.651 429.321 102.979 434.504 103.307 439.697C103.45 441.963 104.654 443.015 106.93 442.871C114.001 442.424 121.064 441.978 128.135 441.531C132.261 441.27 136.2 443.751 137.415 447.371C137.661 448.114 137.816 448.919 137.875 449.702C138.266 455.432 138.618 461.163 138.971 466.895C139.093 468.821 138.005 470.046 136.078 470.168C134.521 470.266 132.963 470.365 131.631 470.449C130.919 472.068 130.46 473.661 129.577 474.987C127.084 478.737 123.465 480.425 118.992 479.846C114.606 479.279 111.63 476.747 110.033 472.62C109.851 472.138 109.745 471.813 109.084 471.855C99.7575 472.473 90.4287 473.053 81.1004 473.643C81.006 473.649 80.9128 473.674 80.8007 473.7C79.4574 479.292 76.1275 482.849 70.2087 483.09C64.5738 483.323 60.9949 480.241 59.0727 475.026C57.2505 475.141 55.4378 475.255 53.625 475.37C51.7083 475.491 50.4831 474.403 50.3607 472.467C50.1877 469.729 50.0146 466.991 49.832 464.102L47.5566 464.246C46.4708 464.314 45.3809 464.317 44.3099 464.47C42.5816 464.721 41.3307 464.127 40.5223 462.586L40.4257 461.057C41.0335 459.426 42.2056 458.773 43.9358 458.702C47.5384 458.559 51.1226 458.276 54.7198 458.049C59.3934 457.753 64.077 457.467 68.75 457.162C70.5155 457.05 71.7302 455.722 71.6282 454.108C71.5267 452.503 70.1563 451.366 68.3877 451.431C68.1328 451.447 67.8779 451.463 67.6229 451.479C59.6071 451.986 51.5888 452.455 43.5772 453.027C41.85 453.146 40.6062 452.665 39.7984 451.133L39.7018 449.604L39.6917 449.595ZM69.4691 466.889C66.5623 467.092 64.3175 469.67 64.5361 472.529C64.7535 475.368 67.2902 477.559 70.1516 477.387C72.9652 477.209 75.22 474.64 75.0309 471.799C74.8513 468.957 72.2815 466.693 69.4596 466.89L69.4691 466.889ZM120.796 474.186C123.619 474.008 125.854 471.421 125.665 468.58C125.466 465.729 122.896 463.475 120.085 463.69C117.217 463.9 114.996 466.41 115.166 469.253C115.338 472.123 117.907 474.378 120.805 474.186L120.796 474.186Z"
                    fill="url(#paint29_linear_28_690)" />
                <path d="M108.933 436.915L108.071 423.281C116.031 424.295 120.588 429.656 124.596 435.925L108.933 436.915Z"
                    fill="url(#paint30_linear_28_690)" />
                <path
                    d="M392.451 1041.91C392.982 1042.18 393.521 1042.44 394.049 1042.73C397.556 1044.62 399.744 1048.94 399.357 1052.92C399.127 1055.32 397.967 1057.22 396.448 1058.96C393.725 1062.07 390.491 1064.61 387.141 1067.01C386.717 1067.32 386.298 1067.63 385.86 1067.91C385.03 1068.46 384.042 1068.22 383.596 1067.34C381.536 1063.21 379.657 1059.01 378.652 1054.48C378.299 1052.9 378.066 1051.31 378.38 1049.69C378.772 1047.69 379.694 1045.96 381.128 1044.54C383.611 1042.07 386.607 1041 390.104 1041.4C390.18 1041.41 390.255 1041.38 390.33 1041.37C391.035 1041.55 391.74 1041.73 392.445 1041.91L392.451 1041.91ZM393.138 1053.09C393.758 1050.65 392.367 1048.21 389.864 1047.55C387.452 1046.91 384.975 1048.41 384.361 1050.82C383.741 1053.24 385.109 1055.7 387.641 1056.36C390.058 1057 392.517 1055.5 393.144 1053.09L393.138 1053.09Z"
                    fill="url(#paint31_linear_28_690)" />
                <path
                    d="M379.226 1065.29C379.487 1065.83 379.737 1066.36 380 1066.9C380.298 1067.51 380.594 1068.12 380.912 1068.73C382.225 1071.23 385.276 1071.98 387.608 1070.38C391.111 1067.98 394.475 1065.41 397.434 1062.34C397.632 1062.13 397.81 1062.12 398.06 1062.19C402.351 1063.3 406.651 1064.4 410.943 1065.5C411.762 1065.71 412.219 1066.2 412.272 1066.91C412.33 1067.63 411.927 1068.21 411.116 1068.51C409.085 1069.26 407.05 1070.01 405.014 1070.76C394.613 1074.61 384.207 1078.45 373.805 1082.3C372.833 1082.66 372.183 1082.58 371.717 1082.01C371.259 1081.45 371.242 1080.84 371.55 1080.23C374.06 1075.27 376.582 1070.32 379.103 1065.37C379.109 1065.34 379.154 1065.33 379.227 1065.28L379.226 1065.29Z"
                    fill="url(#paint32_linear_28_690)" />
                <path
                    d="M391.958 1092.02C386.574 1090.63 381.196 1089.25 375.811 1087.87C374.737 1087.59 374.244 1086.7 374.628 1085.75C374.832 1085.24 375.271 1084.99 375.759 1084.82C379.617 1083.39 383.475 1081.96 387.332 1080.54C388.832 1079.98 390.339 1079.45 391.823 1078.86C392.652 1078.54 393.322 1078.67 393.99 1079.28C399.158 1084 404.343 1088.71 409.514 1093.42C410.487 1094.3 410.453 1095.5 409.438 1096.07C408.991 1096.33 408.537 1096.28 408.06 1096.15C402.693 1094.77 397.325 1093.4 391.958 1092.02Z"
                    fill="url(#paint33_linear_28_690)" />
                <path
                    d="M416.633 1092.6C416.391 1093.74 415.179 1094.23 414.3 1093.64C414.145 1093.54 414.001 1093.41 413.858 1093.29C408.691 1088.58 403.529 1083.88 398.367 1079.18C398.3 1079.11 398.225 1079.05 398.157 1078.98C397.241 1078.09 397.485 1076.81 398.677 1076.35C400.124 1075.79 401.585 1075.26 403.038 1074.73C407.043 1073.25 411.049 1071.76 415.058 1070.29C415.962 1069.96 416.751 1070.17 417.125 1070.88C417.271 1071.16 417.344 1071.51 417.335 1071.83C417.187 1076.77 417.027 1081.71 416.862 1086.65C416.801 1088.46 416.741 1090.27 416.681 1092.09C416.677 1092.29 416.648 1092.5 416.64 1092.6L416.633 1092.6Z"
                    fill="url(#paint34_linear_28_690)" />
                <path
                    d="M100.699 1043.71C101.184 1042.33 101.56 1040.92 102.157 1039.59C105.493 1032.14 108.909 1024.74 112.23 1017.3C113.182 1015.18 114.667 1014 116.948 1013.61C131.844 1011 146.72 1008.35 161.605 1005.68C163.53 1005.34 165.161 1005.72 166.73 1006.91C174.284 1012.62 181.875 1018.29 189.478 1023.94C189.998 1024.32 190.67 1024.56 191.305 1024.69C197.955 1025.96 204.611 1027.18 211.273 1028.43C218.477 1029.78 222.672 1034.25 224.184 1041.45C225.309 1046.8 222.737 1048.84 218.681 1049.27C216.632 1049.49 214.614 1049.96 212.873 1050.27C212.131 1052.59 211.681 1054.83 210.723 1056.83C206.486 1065.78 194.101 1067.97 187.072 1061.03C185.69 1059.66 184.662 1057.91 183.568 1056.27C183.229 1055.76 182.974 1055.55 182.365 1055.66C169.629 1057.94 156.887 1060.18 144.151 1062.46C144.038 1062.48 143.932 1062.54 144.151 1062.46C143.386 1064.81 142.922 1067.05 141.978 1069.05C137.808 1077.88 125.504 1080.13 118.491 1073.36C117.116 1072.03 116.071 1070.34 115.01 1068.72C114.551 1068.02 114.232 1067.63 113.36 1067.9C112.682 1068.11 111.954 1068.12 111.256 1068.3C108.376 1069.02 106.098 1068.28 104.576 1065.63L100.682 1043.7L100.699 1043.71ZM143.636 1031.93L176.12 1026.16C175.988 1026 175.942 1025.9 175.856 1025.83C171.428 1022.52 167.027 1019.19 162.562 1015.92C162.192 1015.65 161.516 1015.62 161.034 1015.7C154.858 1016.77 148.701 1017.87 142.532 1018.98C142.15 1019.04 141.79 1019.15 141.382 1019.24L143.633 1031.92L143.636 1031.93ZM133.954 1033.65L131.69 1020.9C127.982 1021.56 124.356 1022.19 120.74 1022.88C120.414 1022.93 120.088 1023.4 119.934 1023.77C118.015 1027.92 116.141 1032.09 114.253 1036.25C114.126 1036.53 114.032 1036.82 113.883 1037.22L133.954 1033.65ZM198.157 1055.38C201.158 1054.85 203.168 1052.02 202.689 1049C202.21 1045.97 199.288 1043.91 196.228 1044.43C193.213 1044.97 191.206 1047.81 191.711 1050.81C192.209 1053.87 195.114 1055.92 198.171 1055.38L198.157 1055.38ZM129.537 1067.56C132.566 1067.03 134.579 1064.22 134.074 1061.21C133.551 1058.1 130.741 1056.09 127.667 1056.62C124.579 1057.16 122.602 1060 123.165 1063.09C123.72 1066.13 126.522 1068.1 129.551 1067.56L129.537 1067.56Z"
                    fill="url(#paint35_linear_28_690)" />
                <g opacity="0.3">
                    <path
                        d="M272.321 815.467C266.54 820.407 258.582 822.139 250.988 821.747C243.414 821.339 236.072 819.008 228.886 816.587C213.07 811.282 198.576 806.245 183.486 799.257C177.259 796.374 170.015 792.031 164.138 788.485C162.252 787.354 160.358 786.132 159.054 784.366C157.749 782.601 157.14 780.16 158.066 778.176C159.093 775.951 161.771 774.865 164.234 774.963C166.679 775.059 168.995 776.08 171.244 777.056C190.166 785.211 210.995 790.741 231.349 787.487C237.04 786.583 242.596 784.995 248.258 784.034C253.937 783.075 259.849 782.74 265.383 784.329C270.918 785.918 276.048 789.663 278.222 795.002C281.077 802.032 278.097 810.562 272.316 815.502L272.321 815.467Z"
                        fill="url(#paint36_linear_28_690)" />
                    <path
                        d="M59.0824 1019.79C59.3797 1013.88 62.6554 1008.44 66.9423 1004.35C71.227 1000.28 76.4733 997.369 81.7045 994.585C93.1722 988.47 103.791 982.958 115.822 978.157C120.794 976.173 127.131 974.408 132.272 972.969C133.917 972.517 135.63 972.091 137.321 972.295C139.013 972.499 140.721 973.464 141.359 975.059C142.065 976.842 141.236 978.928 139.882 980.265C138.511 981.599 136.704 982.357 134.949 983.121C120.202 989.473 105.914 998.301 96.87 1011.57C94.3455 1015.28 92.2559 1019.27 89.7649 1023C87.2738 1026.73 84.2836 1030.26 80.4316 1032.54C76.5797 1034.82 71.703 1035.71 67.5274 1034.09C62.006 1031.94 58.7872 1025.68 59.0845 1019.77L59.0824 1019.79Z"
                        fill="url(#paint37_linear_28_690)" />
                    <path
                        d="M-63.3317 1000.13C-45.2142 1018.7 -17.4807 1027.79 7.87705 1022.29C27.8344 1017.97 44.9167 1005.6 62.5774 995.313C88.6125 980.151 117.025 969.088 146.468 962.666C173.834 956.68 212.86 967.098 236.937 952.747C252.739 943.342 265.627 928.599 271.14 911.051C278.054 889.083 270.103 861.4 258.59 847.074C235.236 818.003 178.802 815.478 150.561 791.129C127.687 771.403 125.308 743.201 104.443 721.35C87.0255 703.114 59.3615 695.693 34.9704 702.02C10.5794 708.346 -9.77335 727.917 -17.7863 751.812C-23.4334 768.675 -23.2424 786.857 -25.8701 804.446L-25.9066 804.749C-28.3909 821 -35.2928 836.284 -45.6958 848.996C-48.6633 852.631 -51.5795 856.291 -54.4289 859.994C-69.9537 880.274 -83.4297 903.185 -86.6116 928.512C-89.8451 954.268 -81.4271 981.519 -63.3096 1000.09L-63.3317 1000.13Z"
                        fill="url(#paint38_linear_28_690)" />
                </g>
            </g>
            <defs>
                <linearGradient id="paint0_linear_28_690" x1="133.527" y1="874.518" x2="37.4054"
                    y2="822.459" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#CFFFE9" />
                    <stop offset="0.328125" stop-color="#A3F0CC" stop-opacity="0.67" />
                    <stop offset="0.796875" stop-color="#AEFCD8" stop-opacity="0.15" />
                    <stop offset="1" stop-color="white" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_690" x1="131.335" y1="846.809" x2="114.294"
                    y2="908.091" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint2_linear_28_690" x1="88.3844" y1="834.878" x2="71.3536"
                    y2="896.124" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint3_linear_28_690" x1="125.883" y1="835.274" x2="118.201"
                    y2="862.899" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint4_linear_28_690" x1="102.564" y1="814.883" x2="94.8852"
                    y2="842.495" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint5_linear_28_690" x1="57.4376" y1="72" x2="57.4376"
                    y2="103.12" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint6_linear_28_690" x1="58.079" y1="106.848" x2="58.079"
                    y2="139.156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint7_linear_28_690" x1="131.715" y1="234.812" x2="106.11"
                    y2="303.374" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint8_linear_28_690" x1="90.1474" y1="301.717" x2="84.465"
                    y2="316.933" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint9_linear_28_690" x1="135.806" y1="318.758" x2="130.121"
                    y2="333.981" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint10_linear_28_690" x1="292.008" y1="26.5939" x2="244.206"
                    y2="79.0915" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint11_linear_28_690" x1="106.447" y1="633.657" x2="100.211"
                    y2="664.986" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint12_linear_28_690" x1="105.633" y1="628.834" x2="101.045"
                    y2="651.879" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint13_linear_28_690" x1="110.672" y1="615.12" x2="108.09"
                    y2="628.092" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint14_linear_28_690" x1="134.147" y1="656.344" x2="131.026"
                    y2="672.019" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint15_linear_28_690" x1="137.189" y1="665.645" x2="134.611"
                    y2="678.595" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint16_linear_28_690" x1="81.7989" y1="658.57" x2="79.9766"
                    y2="667.724" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint17_linear_28_690" x1="106.202" y1="599.192" x2="103.533"
                    y2="612.6" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint18_linear_28_690" x1="82.4082" y1="628.063" x2="80.8982"
                    y2="635.649" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint19_linear_28_690" x1="130.641" y1="628.19" x2="128.716"
                    y2="637.86" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint20_linear_28_690" x1="99.2023" y1="635.674" x2="98.5126"
                    y2="639.139" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint21_linear_28_690" x1="83.5754" y1="622.134" x2="82.893"
                    y2="625.562" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint22_linear_28_690" x1="110.474" y1="655.012" x2="109.807"
                    y2="658.36" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint23_linear_28_690" x1="72.9159" y1="641.183" x2="71.451"
                    y2="648.542" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint24_linear_28_690" x1="123.786" y1="616.066" x2="122.432"
                    y2="622.87" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint25_linear_28_690" x1="121.328" y1="632.46" x2="120.534"
                    y2="636.45" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint26_linear_28_690" x1="108.823" y1="609.308" x2="108.066"
                    y2="613.109" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint27_linear_28_690" x1="127.219" y1="622.619" x2="126.226"
                    y2="627.606" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint28_linear_28_690" x1="136.957" y1="631.249" x2="135.715"
                    y2="637.485" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint29_linear_28_690" x1="87.1702" y1="423.977" x2="90.8294"
                    y2="481.867" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint30_linear_28_690" x1="115.903" y1="422.786" x2="116.764"
                    y2="436.42" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint31_linear_28_690" x1="391.397" y1="1041.64" x2="384.582"
                    y2="1068.16" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint32_linear_28_690" x1="395.053" y1="1061.42" x2="388.574"
                    y2="1086.63" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint33_linear_28_690" x1="395.26" y1="1079.31" x2="391.992"
                    y2="1092.02" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint34_linear_28_690" x1="411.281" y1="1068.91" x2="405.484"
                    y2="1091.46" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint35_linear_28_690" x1="156.06" y1="1006.67" x2="167.425"
                    y2="1070.66" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint36_linear_28_690" x1="215.251" y1="817.538" x2="219.96"
                    y2="778.506" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint37_linear_28_690" x1="95.5501" y1="1037.85" x2="103.944"
                    y2="968.268" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint38_linear_28_690" x1="78.8463" y1="1034.8" x2="118.367"
                    y2="707.199" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 3 -->
        <svg class="e-shape-3" viewBox="0 0 567 122" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
                d="M0.771484 56.7829C2.51171 39.3589 24.7719 26.9408 54.061 19.8095C83.3362 12.7292 119.288 10.3136 155.143 8.25515C233.743 3.70573 306.53 -0.0574563 389.079 0.0314772C423.192 0.0674218 466.707 2.41053 502.013 4.2893C513.305 4.91499 525.072 5.70358 536.723 8.36127C548.374 11.019 560.178 15.9867 564.655 21.558C569.606 27.7792 564.004 33.0555 554.76 35.4425C545.392 37.8016 532.993 37.8981 520.962 38.0786C419.801 39.3776 321.934 48.6861 260.387 77.7089C243.206 85.8148 229.033 95.3111 212.083 103.524C195.134 111.737 174.739 118.73 148.349 120.944C121.96 123.157 88.4465 119.954 59.6276 110.022C21.5201 96.887 -0.954816 74.1559 0.785346 56.7319L0.771484 56.7829Z"
                fill="url(#paint1_linear_28_12)" />
            <defs>
                <linearGradient id="paint0_linear_28_12" x1="775.34" y1="173.511" x2="99.211"
                    y2="-856.565" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#CFFFE9" />
                    <stop offset="0.328125" stop-color="#A3F0CC" stop-opacity="0.67" />
                    <stop offset="0.796875" stop-color="#AEFCD8" stop-opacity="0.15" />
                    <stop offset="1" stop-color="white" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_12" x1="542.96" y1="113.435" x2="6.2657"
                    y2="-32.4356" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" />
                    <stop offset="1" stop-color="#D6FFEC" />
                </linearGradient>
            </defs>
        </svg>
        <!-- Shape 4 -->
        <svg class="e-shape-4" width="567" height="122" viewBox="0 0 567 122" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M0.771494 56.7829C2.51169 39.3589 24.7719 26.9408 54.061 19.8095C83.3362 12.7292 119.288 10.3136 155.143 8.25516C233.743 3.70574 306.53 -0.0574518 389.079 0.0314811C423.192 0.0674279 466.707 2.41053 502.013 4.2893C513.305 4.91499 525.072 5.70357 536.723 8.36126C548.374 11.0189 560.178 15.9867 564.655 21.558C569.606 27.7792 564.004 33.0555 554.76 35.4425C545.392 37.8015 532.993 37.8981 520.962 38.0786C419.802 39.3776 321.934 48.6861 260.387 77.7089C243.206 85.8148 229.033 95.3111 212.083 103.524C195.134 111.737 174.739 118.73 148.349 120.944C121.96 123.157 88.4465 119.954 59.6276 110.022C21.5201 96.887 -0.954838 74.1559 0.785356 56.7319L0.771494 56.7829Z"
                fill="url(#paint0_linear_28_689)" />
            <defs>
                <linearGradient id="paint0_linear_28_689" x1="542.96" y1="113.435" x2="6.2657"
                    y2="-32.4356" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" />
                    <stop offset="1" stop-color="#D6FFEC" />
                </linearGradient>
            </defs>
        </svg>


    </section>
    <!-- ==== Earn Money Section Ends Here ==== -->

    <!-- ==== Special Feature Section Starts Here ==== -->
    <?php ($special = $landing_data['criterias']); ?>
    <?php if($special && count($special) > 0): ?>
        <section class="special-feature-section pt-80 pb-80 overflow-hidden position-relative">
            <div class="container">
                <div class="section-header wow fadeInUp">
                    <h2 class="title">
                        <?php echo e($landing_data['why_choose_title']); ?>

                        <span class="primary-color text-nowrap">color text</span>
                    </h2>
                </div>
                <div class="special-feature-wrapper wow fadeInUp">
                    <?php $__currentLoopData = $special; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->status == '1'): ?>
                            <div class="feature-card">
                                <div class="feature-card-icon">
                                    <img src="<?php echo e($item['image_full_url']); ?>" alt="<?php echo e($item['title']); ?>"
                                        class="onerror-image"
                                        data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>">
                                </div>
                                <div class="feature-card-cont">
                                    <h4 class="subtitle">
                                        <?php ($arr = explode(' ', trim($item['title']))); ?>
                                        <?php if(isset($arr[0])): ?>
                                            <?php echo e($arr[0]); ?>

                                        <?php endif; ?>
                                        <br>
                                        <?php if(count($arr) > 1): ?>
                                            <?php (array_shift($arr)); ?>
                                            <?php echo e(implode(' ', $arr)); ?>

                                        <?php endif; ?>
                                    </h4>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <!-- Shape 1 -->
            <svg class="s-shape-1" width="152" height="537" viewBox="0 0 152 537" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M83.2873 13.7046C81.6228 5.40203 89.5703 -1.589 97.5928 1.12076L143.54 16.6403C151.563 19.3501 153.643 29.7283 147.285 35.3212L110.871 67.3528C104.513 72.9456 94.4851 69.5584 92.8206 61.2558L83.2873 13.7046Z"
                    fill="url(#paint0_linear_28_12)" />
                <path
                    d="M12.2376 276.382C3.78116 276.82 -1.97923 267.94 1.86888 260.398L23.9081 217.197C27.7562 209.654 38.3267 209.106 42.935 216.21L69.3281 256.896C73.9364 264 69.1262 273.429 60.6698 273.868L12.2376 276.382Z"
                    fill="url(#paint1_linear_28_12)" />
                <path
                    d="M123.58 527.141C122.616 535.553 112.907 539.768 106.103 534.727L43.806 488.572C37.0021 483.531 38.2067 473.015 45.9742 469.643L117.095 438.77C124.862 435.398 133.367 441.699 132.403 450.112L123.58 527.141Z"
                    fill="url(#paint2_linear_28_12)" />
                <defs>
                    <linearGradient id="paint0_linear_28_12" x1="79.5421" y1="-4.97621" x2="145.59"
                        y2="70.108" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint1_linear_28_12" x1="-6.78937" y1="277.369" x2="77.1052"
                        y2="222.948" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint2_linear_28_12" x1="121.412" y1="546.069" x2="68.2419"
                        y2="423.585" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                </defs>
            </svg>
            <!-- Shape 2 -->
            <svg class="s-shape-2" width="151" height="537" viewBox="0 0 151 537" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M67.845 13.7046C69.5095 5.40203 61.562 -1.589 53.5395 1.12076L7.59235 16.6403C-0.430176 19.3501 -2.51085 29.7283 3.84714 35.3212L40.2611 67.3528C46.6191 72.9456 56.6472 69.5584 58.3117 61.2558L67.845 13.7046Z"
                    fill="url(#paint0_linear_28_12)" />
                <path
                    d="M138.895 276.382C147.351 276.82 153.112 267.94 149.263 260.398L127.224 217.197C123.376 209.654 112.806 209.106 108.197 216.21L81.8043 256.896C77.1959 264 82.0061 273.429 90.4625 273.868L138.895 276.382Z"
                    fill="url(#paint1_linear_28_12)" />
                <path
                    d="M27.5523 527.141C28.5159 535.553 38.2253 539.768 45.0292 534.727L107.326 488.572C114.13 483.531 112.926 473.015 105.158 469.643L34.0377 438.77C26.2702 435.398 17.7654 441.699 18.729 450.112L27.5523 527.141Z"
                    fill="url(#paint2_linear_28_12)" />
                <defs>
                    <linearGradient id="paint0_linear_28_12" x1="71.5902" y1="-4.97621" x2="5.54207"
                        y2="70.108" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint1_linear_28_12" x1="157.922" y1="277.369" x2="74.0271"
                        y2="222.948" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                    <linearGradient id="paint2_linear_28_12" x1="29.7205" y1="546.069" x2="82.8904"
                        y2="423.585" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white" />
                        <stop offset="1" stop-color="#D1FFEA" />
                    </linearGradient>
                </defs>
            </svg>
        </section>
    <?php endif; ?>
    <!-- ==== Special Feature Section Ends Here ==== -->

    <!-- ==== Counter Section Starts Here ==== -->
    <?php ($counter = $landing_data['counter_section']); ?>
    <?php if(isset($counter) && $counter['status'] == '1'): ?>
        <section class="counter-section  mb--186px">
            <div class="container">
                <div class="counter-wrapper">
                    <div class="contact-wrapper-inner">
                        <div class="left-side">
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="35" viewBox="0 0 32 35" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M1.72825 34.2238C1.23767 34.0386 0.764414 33.8361 0.441208 33.3906C0.175717 33.0319 0.00256513 32.6384 0.00256513 32.1871C-0.00320641 29.3462 0.00256513 26.5053 0.00256513 23.6643C0.00256513 23.6354 0.0141075 23.6007 0.0198791 23.5486H4.25619V29.919H27.7291V23.5428H32V23.9305C32 26.5689 32 29.2131 32 31.8515C32 33.0955 31.521 33.7667 30.3493 34.1659C30.3205 34.1775 30.2974 34.2006 30.2685 34.2238H1.72825Z"
                                            fill="#6DEBB0" />
                                        <path
                                            d="M12.7978 14.9741V14.5286C12.7978 10.1081 12.7978 5.68184 12.7978 1.26134C12.7978 0.387657 13.1845 0 14.056 0C15.3777 0 16.6994 0 18.0211 0C18.7771 0 19.1927 0.422373 19.1927 1.18034C19.1927 5.63555 19.1927 10.0908 19.1927 14.546V14.9741H19.5794C20.826 14.9741 22.0669 14.9857 23.3136 14.9741C23.8215 14.9741 24.2139 15.1419 24.4275 15.6048C24.6468 16.0735 24.5025 16.4901 24.1735 16.8604C22.696 18.5499 21.2185 20.2452 19.741 21.9405C18.8176 22.9993 17.8999 24.0523 16.9764 25.1112C16.3069 25.8749 15.6894 25.8807 15.0256 25.1228C12.6478 22.4033 10.2641 19.6781 7.89778 16.9472C7.70732 16.7273 7.53417 16.4496 7.48223 16.1718C7.36102 15.5354 7.88046 14.9857 8.5615 14.9799C9.83701 14.9741 11.1183 14.9799 12.3938 14.9799C12.515 14.9799 12.6362 14.9799 12.7978 14.9799V14.9741Z"
                                            fill="#6DEBB0" />
                                    </svg>
                                </div>
                                <h4 class="title text-right"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['app_download_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Download')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="36" viewBox="0 0 32 36" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M15.9963 0.00515352C19.0717 0.00515352 22.147 0.00515352 25.2172 0.00515352C25.9951 0.00515352 26.742 0.165252 27.4117 0.593884C28.1638 1.07932 28.6789 1.74551 28.9571 2.59244C29.8689 5.33465 30.8116 8.06136 31.6873 10.8139C32.8361 14.4444 30.7189 17.9715 26.9893 18.6326C25.2739 18.9373 23.6873 18.5086 22.2758 17.4654C22.1522 17.3725 22.0337 17.2692 21.91 17.1711C21.2919 16.6753 20.7098 16.665 20.1071 17.1608C18.8038 18.2349 17.3047 18.7462 15.6254 18.6532C14.2758 18.5809 13.0703 18.1006 12.0092 17.2537C11.2365 16.6392 10.7574 16.6392 9.98983 17.2537C7.749 19.0302 4.60667 19.1645 2.4328 17.5791C0.300147 16.0195 -0.52922 13.3186 0.341358 10.6641C1.21194 8.00457 2.09797 5.35014 2.9943 2.70089C3.58156 0.960538 4.93121 0.00516424 6.78054 0C9.8559 0 12.9313 0 16.0015 0L15.9963 0.00515352Z"
                                            fill="#7FBDF4" />
                                        <path
                                            d="M2.2771 20.5944C3.0395 20.7958 3.73493 21.0231 4.44067 21.1573C6.64544 21.5808 8.70598 21.147 10.6171 20.0005C10.9056 19.825 11.1065 19.8301 11.3847 20.0005C12.7807 20.8578 14.3158 21.2813 15.9436 21.2916C17.6384 21.3019 19.2353 20.8578 20.688 19.9644C20.8992 19.8353 21.0538 19.8095 21.2856 19.9489C23.851 21.5343 26.5451 21.7564 29.3526 20.6719C29.4505 20.6358 29.5432 20.5996 29.6926 20.5428C29.7029 20.6771 29.7235 20.7855 29.7235 20.894C29.7235 24.3127 29.7338 27.7366 29.7235 31.1553C29.7183 33.0402 28.5696 34.5172 26.813 34.9252C26.4987 34.9975 26.1691 35.0336 25.8497 35.0388C24.7937 35.0543 23.7376 35.0336 22.6867 35.0491C22.3725 35.0491 22.2849 34.9562 22.2901 34.6463C22.3055 33.0919 22.3004 31.5375 22.2901 29.983C22.2849 27.9535 20.6108 26.2699 18.5863 26.2648C16.8657 26.2648 15.1503 26.2648 13.4298 26.2648C11.4053 26.2699 9.72595 27.9535 9.7208 29.9779C9.7208 31.5323 9.7105 33.0867 9.7208 34.6412C9.7208 34.9407 9.64868 35.0595 9.3293 35.0491C8.05691 35.013 6.77938 35.0491 5.507 34.9613C3.93068 34.8581 2.49346 33.3914 2.34922 31.8215C2.30801 31.3567 2.28225 30.8868 2.28225 30.4168C2.2771 27.2821 2.28225 24.1474 2.28225 21.0179V20.5944H2.2771Z"
                                            fill="#7FBDF4" />
                                        <path
                                            d="M12.2562 35.043C12.2562 33.344 12.2458 31.6707 12.2562 29.9975C12.2613 29.352 12.7919 28.8253 13.4358 28.8201C15.1409 28.8046 16.8512 28.8046 18.5563 28.8201C19.195 28.8201 19.7308 29.3572 19.7359 29.9975C19.7514 31.6707 19.7359 33.3388 19.7359 35.043H12.2458H12.2562Z"
                                            fill="#7FBDF4" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['seller_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Seller')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="26" viewBox="0 0 32 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M2.89821 20.0516C2.40405 15.6726 5.28959 12.687 8.5281 12.1385C9.00902 12.0589 9.50318 12.0279 9.99293 12.0191C11.1533 12.0014 12.3137 12.0147 13.4741 12.0147C14.2065 12.0147 14.4315 12.3464 14.1448 13.0099C13.88 13.638 13.5976 14.2572 13.3506 14.8897C12.7549 16.398 13.58 18.0877 15.1816 18.2381C16.8229 18.3929 18.5216 18.415 20.1453 18.1717C22.1395 17.8798 23.2867 15.8982 23.022 13.7972C22.8146 12.1562 22.669 10.5108 22.4969 8.86535C22.4484 8.40092 22.3999 7.93648 22.3425 7.43224C22.7352 7.43224 23.0926 7.41013 23.4411 7.44551C23.5294 7.45436 23.6353 7.62686 23.675 7.74629C24.2927 9.73672 24.8971 11.7316 25.506 13.7264C25.7001 14.3545 25.8899 14.9826 26.0928 15.6372C25.9958 15.677 25.9075 15.7124 25.8193 15.7478C24.3633 16.3449 23.3264 17.3269 22.9381 18.9015C22.7837 19.5341 22.8367 20.1047 23.472 20.4762C23.525 20.5072 23.5603 20.6222 23.5558 20.6929C23.5426 20.8433 23.4985 20.9937 23.4588 21.1795H23.1279C19.682 21.1795 16.2317 21.1795 12.7858 21.1795C12.5829 21.1795 12.4549 21.1485 12.3446 20.9362C12.0181 20.3214 11.4754 20.0339 10.7783 20.0339C8.28102 20.0339 5.77934 20.0339 3.28206 20.0339H2.8938L2.89821 20.0516ZM8.03394 17.7648C7.29711 17.7648 6.56028 17.7648 5.82787 17.7648C5.40872 17.7648 5.1484 17.9904 5.15281 18.3398C5.15722 18.6671 5.41313 18.9015 5.81463 18.9015C7.27505 18.906 8.73547 18.906 10.1959 18.9015C10.5974 18.9015 10.8489 18.6715 10.8489 18.3354C10.8489 17.9815 10.6018 17.7648 10.1738 17.7648C9.45906 17.7648 8.7487 17.7648 8.03394 17.7648ZM8.56781 16.6059C9.12374 16.6059 9.67967 16.6148 10.24 16.6059C10.6195 16.5971 10.8533 16.3626 10.8489 16.0353C10.8489 15.7036 10.6106 15.4824 10.2312 15.4824C9.12815 15.4824 8.02511 15.4692 6.92649 15.4913C6.74559 15.4913 6.50734 15.6107 6.39703 15.7522C6.12348 16.1149 6.40586 16.5838 6.90443 16.6059C7.46036 16.628 8.01629 16.6103 8.57222 16.6103L8.56781 16.6059Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M10.2756 10.8829C10.1521 10.8873 10.0329 10.9006 9.91381 10.9006C6.8915 10.9006 3.86918 10.9006 0.846869 10.9006C0.158575 10.9006 0.00415039 10.7414 0.00415039 10.0514C0.00415039 7.79112 0.00415039 5.53529 0.00415039 3.27505V2.89465H1.73371C1.73371 3.08485 1.72488 3.27062 1.73371 3.4564C1.74694 3.76602 1.96314 3.9916 2.24993 4.01372C2.52789 4.03583 2.78821 3.83237 2.83233 3.52717C2.86322 3.32813 2.8588 3.12908 2.87204 2.89908H7.42978C7.42978 3.03177 7.42978 3.18658 7.42978 3.33697C7.4386 3.7439 7.67686 4.02256 8.01218 4.01372C8.33868 4.00487 8.5637 3.73948 8.56811 3.34582C8.56811 3.20428 8.56811 3.05831 8.56811 2.89465H10.2712V10.8829H10.2756Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.4645 21.8582C31.3322 23.7336 29.9379 25.1491 28.1334 25.2154C25.8832 25.295 24.1536 23.1852 24.661 20.9824C24.7228 20.717 24.8199 20.602 25.1243 20.6064C27.0524 20.6241 28.9805 20.6241 30.9086 20.6064C31.1954 20.6064 31.3101 20.7082 31.341 20.9691C31.3763 21.2655 31.4248 21.5619 31.4645 21.8626V21.8582Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M4.62678 21.1986H4.97534C6.88138 21.1986 8.78743 21.1986 10.6935 21.1986C11.2494 21.1986 11.4744 21.4242 11.4391 21.9682C11.3156 23.9144 9.68309 25.3387 7.75058 25.2281C6.02543 25.1308 4.54736 23.5473 4.57384 21.7515C4.57384 21.5746 4.60913 21.4021 4.63119 21.1986H4.62678Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.9999 19.4743H24.0095C24.0272 18.8727 24.2743 18.3817 24.636 17.9527C25.3243 17.1344 26.1935 16.6567 27.2701 16.6346C27.9672 16.6213 28.6908 16.5815 29.3659 16.7275C30.6851 17.0194 31.6072 17.82 31.9646 19.1823C31.9867 19.2664 31.9867 19.3548 31.9999 19.4743Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M0.0039219 1.70243C0.0039219 1.31319 -0.00490238 0.946069 0.0039219 0.578945C0.0127462 0.260476 0.228941 0.0393172 0.542203 0.00393172C0.630445 -0.00491465 0.718688 0.00393172 0.811343 0.00393172C3.69688 0.00393172 6.58683 0.00393172 9.47237 0.00393172C10.121 0.00393172 10.2974 0.185282 10.3019 0.844336C10.3019 1.123 10.3019 1.40166 10.3019 1.71128H0.0039219V1.70243Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M25.1394 4.01562V6.28029C25.0379 6.28914 24.9497 6.30241 24.8658 6.30241C23.8422 6.30241 22.8142 6.30683 21.7906 6.30241C21.0802 6.30241 20.5684 5.82028 20.564 5.16565C20.5596 4.50217 21.0846 4.01562 21.8082 4.01562C22.9113 4.01562 24.0099 4.01562 25.1394 4.01562Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M11.4383 10.8974C11.4383 10.4595 11.425 10.0836 11.4383 9.70318C11.4559 9.38028 11.65 9.18124 11.9721 9.17682C12.6737 9.16355 13.3752 9.16355 14.0767 9.18124C14.4959 9.19451 14.8224 9.54836 14.8533 9.95972C14.8841 10.3932 14.6018 10.7957 14.1694 10.8532C13.8076 10.9019 13.437 10.8886 13.0707 10.893C12.5369 10.8974 12.003 10.893 11.4338 10.893L11.4383 10.8974Z"
                                            fill="#F9AD76" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['deliveryman_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.Deliveryman')); ?></div>
                            </div>
                            <div class="counter-item wow fadeInUp">
                                <div class="icon">
                                    <svg width="32" height="26" viewBox="0 0 32 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M2.89821 20.0516C2.40405 15.6726 5.28959 12.687 8.5281 12.1385C9.00902 12.0589 9.50318 12.0279 9.99293 12.0191C11.1533 12.0014 12.3137 12.0147 13.4741 12.0147C14.2065 12.0147 14.4315 12.3464 14.1448 13.0099C13.88 13.638 13.5976 14.2572 13.3506 14.8897C12.7549 16.398 13.58 18.0877 15.1816 18.2381C16.8229 18.3929 18.5216 18.415 20.1453 18.1717C22.1395 17.8798 23.2867 15.8982 23.022 13.7972C22.8146 12.1562 22.669 10.5108 22.4969 8.86535C22.4484 8.40092 22.3999 7.93648 22.3425 7.43224C22.7352 7.43224 23.0926 7.41013 23.4411 7.44551C23.5294 7.45436 23.6353 7.62686 23.675 7.74629C24.2927 9.73672 24.8971 11.7316 25.506 13.7264C25.7001 14.3545 25.8899 14.9826 26.0928 15.6372C25.9958 15.677 25.9075 15.7124 25.8193 15.7478C24.3633 16.3449 23.3264 17.3269 22.9381 18.9015C22.7837 19.5341 22.8367 20.1047 23.472 20.4762C23.525 20.5072 23.5603 20.6222 23.5558 20.6929C23.5426 20.8433 23.4985 20.9937 23.4588 21.1795H23.1279C19.682 21.1795 16.2317 21.1795 12.7858 21.1795C12.5829 21.1795 12.4549 21.1485 12.3446 20.9362C12.0181 20.3214 11.4754 20.0339 10.7783 20.0339C8.28102 20.0339 5.77934 20.0339 3.28206 20.0339H2.8938L2.89821 20.0516ZM8.03394 17.7648C7.29711 17.7648 6.56028 17.7648 5.82787 17.7648C5.40872 17.7648 5.1484 17.9904 5.15281 18.3398C5.15722 18.6671 5.41313 18.9015 5.81463 18.9015C7.27505 18.906 8.73547 18.906 10.1959 18.9015C10.5974 18.9015 10.8489 18.6715 10.8489 18.3354C10.8489 17.9815 10.6018 17.7648 10.1738 17.7648C9.45906 17.7648 8.7487 17.7648 8.03394 17.7648ZM8.56781 16.6059C9.12374 16.6059 9.67967 16.6148 10.24 16.6059C10.6195 16.5971 10.8533 16.3626 10.8489 16.0353C10.8489 15.7036 10.6106 15.4824 10.2312 15.4824C9.12815 15.4824 8.02511 15.4692 6.92649 15.4913C6.74559 15.4913 6.50734 15.6107 6.39703 15.7522C6.12348 16.1149 6.40586 16.5838 6.90443 16.6059C7.46036 16.628 8.01629 16.6103 8.57222 16.6103L8.56781 16.6059Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M10.2756 10.8829C10.1521 10.8873 10.0329 10.9006 9.91381 10.9006C6.8915 10.9006 3.86918 10.9006 0.846869 10.9006C0.158575 10.9006 0.00415039 10.7414 0.00415039 10.0514C0.00415039 7.79112 0.00415039 5.53529 0.00415039 3.27505V2.89465H1.73371C1.73371 3.08485 1.72488 3.27062 1.73371 3.4564C1.74694 3.76602 1.96314 3.9916 2.24993 4.01372C2.52789 4.03583 2.78821 3.83237 2.83233 3.52717C2.86322 3.32813 2.8588 3.12908 2.87204 2.89908H7.42978C7.42978 3.03177 7.42978 3.18658 7.42978 3.33697C7.4386 3.7439 7.67686 4.02256 8.01218 4.01372C8.33868 4.00487 8.5637 3.73948 8.56811 3.34582C8.56811 3.20428 8.56811 3.05831 8.56811 2.89465H10.2712V10.8829H10.2756Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.4645 21.8582C31.3322 23.7336 29.9379 25.1491 28.1334 25.2154C25.8832 25.295 24.1536 23.1852 24.661 20.9824C24.7228 20.717 24.8199 20.602 25.1243 20.6064C27.0524 20.6241 28.9805 20.6241 30.9086 20.6064C31.1954 20.6064 31.3101 20.7082 31.341 20.9691C31.3763 21.2655 31.4248 21.5619 31.4645 21.8626V21.8582Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M4.62678 21.1986H4.97534C6.88138 21.1986 8.78743 21.1986 10.6935 21.1986C11.2494 21.1986 11.4744 21.4242 11.4391 21.9682C11.3156 23.9144 9.68309 25.3387 7.75058 25.2281C6.02543 25.1308 4.54736 23.5473 4.57384 21.7515C4.57384 21.5746 4.60913 21.4021 4.63119 21.1986H4.62678Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M31.9999 19.4743H24.0095C24.0272 18.8727 24.2743 18.3817 24.636 17.9527C25.3243 17.1344 26.1935 16.6567 27.2701 16.6346C27.9672 16.6213 28.6908 16.5815 29.3659 16.7275C30.6851 17.0194 31.6072 17.82 31.9646 19.1823C31.9867 19.2664 31.9867 19.3548 31.9999 19.4743Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M0.0039219 1.70243C0.0039219 1.31319 -0.00490238 0.946069 0.0039219 0.578945C0.0127462 0.260476 0.228941 0.0393172 0.542203 0.00393172C0.630445 -0.00491465 0.718688 0.00393172 0.811343 0.00393172C3.69688 0.00393172 6.58683 0.00393172 9.47237 0.00393172C10.121 0.00393172 10.2974 0.185282 10.3019 0.844336C10.3019 1.123 10.3019 1.40166 10.3019 1.71128H0.0039219V1.70243Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M25.1394 4.01562V6.28029C25.0379 6.28914 24.9497 6.30241 24.8658 6.30241C23.8422 6.30241 22.8142 6.30683 21.7906 6.30241C21.0802 6.30241 20.5684 5.82028 20.564 5.16565C20.5596 4.50217 21.0846 4.01562 21.8082 4.01562C22.9113 4.01562 24.0099 4.01562 25.1394 4.01562Z"
                                            fill="#F9AD76" />
                                        <path
                                            d="M11.4383 10.8974C11.4383 10.4595 11.425 10.0836 11.4383 9.70318C11.4559 9.38028 11.65 9.18124 11.9721 9.17682C12.6737 9.16355 13.3752 9.16355 14.0767 9.18124C14.4959 9.19451 14.8224 9.54836 14.8533 9.95972C14.8841 10.3932 14.6018 10.7957 14.1694 10.8532C13.8076 10.9019 13.437 10.8886 13.0707 10.893C12.5369 10.8974 12.003 10.893 11.4338 10.893L11.4383 10.8974Z"
                                            fill="#F9AD76" />
                                    </svg>

                                </div>
                                <h4 class="title"> <span class=" odometer"
                                        data-odometer-final="<?php echo e($counter['customer_count_numbers'] ?? 0); ?>"></span>
                                    <span>+</span>
                                </h4>
                                <div class="text"><?php echo e(translate('messages.customer')); ?></div>
                            </div>
                        </div>
                        <?php ($fav = \App\Models\BusinessSetting::where(['key' => 'icon'])->first()); ?>
                        <div class="right-side d-flex word-nowrap align-items-center">
                            <img class="onerror-image"
                                data-onerror-image="<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>"
                                
                                src="<?php echo e(\App\CentralLogics\Helpers::get_full_url('business', $fav?->value ?? '', $fav?->storage[0]?->value ?? 'public', 'favicon')); ?>"
                                alt="image">
                            <?php echo e(translate('messages.Still increasing')); ?>

                        </div>
                    </div>
                    <div class="counter-bg"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Counter Section Ends Here ==== -->

    <!-- ==== Download App Starts Here ==== -->
    <?php ($landing_page_links = $landing_data['download_user_app_links']); ?>
    <?php if(
        (isset($landing_page_links['playstore_url_status']) && $landing_page_links['playstore_url_status'] == '1') ||
            (isset($landing_page_links['apple_store_url_status']) && $landing_page_links['apple_store_url_status'] == '1')): ?>
        <section class="download-app-section">
            <div class="container">
                <div class="row justify-content-center align-items-center g-4">
                    <div class="col-lg-6 col-md-9">
                        <div class="download-app-content wow fadeInUp">
                            <h2 class="title">
                                
                                <div class="primary-color">
                                    <?php echo e(translate('Lets')); ?>

                                </div>
                                <?php echo e(translate('Manage_your_business')); ?>

                                <div class="primary-color">
                                    <?php echo e(translate('Smartly_or_Earn')); ?>

                                </div>
                            </h2>
                            
                            <div class="btn-grp">
                            </div>
                            <div class="position-relative dropdown text-capitalize">
                                <button type="button" class="cmn--btn border-0 w-75 w-sm-50 d-flex justify-content-between align-items-center"
                                    data-bs-toggle="dropdown">
                                    <?php echo e(translate('User App')); ?>

                                    <svg class="ms-2" width="12" height="7" viewBox="0 0 12 7"
                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.00224 5.46105L1.33333 0.415128C1.21002 0.290383 1 0.0787335 1 0.0787335C1 0.0787335 0.708488 -0.0458817 0.584976 0.0788632L0.191805 0.475841C0.0680976 0.600389 7.43292e-08 0.766881 7.22135e-08 0.9443C7.00978e-08 1.12172 0.0680976 1.28801 0.191805 1.41266L5.53678 6.80682C5.66068 6.93196 5.82624 7.00049 6.00224 7C6.17902 7.00049 6.34439 6.93206 6.46839 6.80682L11.8082 1.41768C11.9319 1.29303 12 1.12674 12 0.949223C12 0.771804 11.9319 0.605509 11.8082 0.480765L11.415 0.0838844C11.1591 -0.174368 10.9225 0.222512 10.6667 0.480765L6.00224 5.46105Z"
                                            fill="#ffffff"></path>
                                    </svg>
                                </button>
                                <div class="dropdown-menu p-0 w-75 w-sm-50">
                                    <?php if(isset($landing_page_links['playstore_url_status']) && $landing_page_links['playstore_url_status'] == '1'): ?>
                                        <a href="<?php echo e($landing_page_links['playstore_url']); ?>" class="dropdown-item">
                                            <img src="<?php echo e(asset('/public/assets/landing/img/google-play.png')); ?>"
                                                alt="">
                                            <?php echo e(translate('google_play')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(isset($landing_page_links['apple_store_url_status']) && $landing_page_links['apple_store_url_status'] == '1'): ?>
                                        <a href="<?php echo e($landing_page_links['apple_store_url']); ?>" class="dropdown-item">
                                            <img src="<?php echo e(asset('/public/assets/landing/img/apple-store.png')); ?>"
                                                alt="">
                                            <?php echo e(translate('apple_store')); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-9">
                        <img class="mw-100"
                            src="<?php echo e(\App\CentralLogics\Helpers::get_full_url('download_user_app_image', isset($landing_data['download_user_app_image']) ? $landing_data['download_user_app_image'] : null, isset($landing_data['download_user_app_image_storage']) ? $landing_data['download_user_app_image_storage'] : 'public')); ?>"
                            alt="">
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- ==== Download App Ends Here ==== -->

    <!-- ==== Testimonial Starts Here ==== -->
    <?php ($testimonial = $landing_data['testimonials']); ?>
    <?php if($testimonial && count($testimonial) > 0): ?>
        <section class="testimonial-section overflow-hidden position-relative pt-80 pb-80">
            <div class="container">
                <div class="section-header wow fadeInUp mb-0">
                    <h2 class="title mb-0">
                        <?php echo e($landing_data['testimonial_title']); ?>

                        <span class="primary-color text-nowrap">color text</span>
                    </h2>
                </div>
                <div class="testimonial-slider overflow-hidden owl-theme owl-carousel wow fadeInUp">
                    <?php $__currentLoopData = $testimonial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="testimonial-item">
                            <svg width="24" height="20" viewBox="0 0 24 20" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M14.1 19.5V11.24C14.1 8.25333 15.0333 5.87333 16.9 4.1C18.8133 2.28 21.0767 1.16 23.69 0.739996V4.03C22.43 4.45 21.31 5.22 20.33 6.34C19.3967 7.46 18.93 8.81333 18.93 10.4H23.55V19.5H14.1ZM0.24 19.5V11.24C0.24 8.25333 1.17333 5.87333 3.04 4.1C4.95333 2.28 7.21667 1.16 9.83 0.739996V4.03C8.57 4.45 7.45 5.22 6.47 6.34C5.53667 7.46 5.07 8.81333 5.07 10.4H9.69V19.5H0.24Z"
                                    fill="#71DAA6" />
                            </svg>
                            <blockquote>
                                <?php echo e($data['review']); ?>

                            </blockquote>
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="user">
                                    <img src="<?php echo e($data['reviewer_image_full_url']); ?>" alt="image">
                                    <div>
                                        <h6 class="name"><?php echo e($data['name']); ?></h6>
                                        <span class="designation"><?php echo e($data['designation']); ?></span>
                                    </div>
                                </div>
                                <?php if(isset($data['company_image'])): ?>
                                    <img style="max-height: 35px; max-width:75px"
                                        src="<?php echo e($data['company_image_full_url']); ?>" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <svg class="testimonial-shape" viewBox="0 0 1362 379" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M213.286 24.3464L208.81 15.9086C207.191 12.8576 206.852 9.92199 207.793 7.10169C208.756 4.2085 210.454 1.84123 212.889 -0.000116383L214.672 3.3607C213.616 4.47068 212.892 5.86253 212.501 7.53626C212.157 9.18476 212.415 10.8194 213.275 12.4402L217.981 9.94347L222.913 19.2394L213.286 24.3464ZM199.166 31.8367L194.69 23.3989C193.072 20.3479 192.733 17.4123 193.673 14.592C194.636 11.6988 196.335 9.33153 198.77 7.49017L200.552 10.851C199.496 11.961 198.773 13.3528 198.381 15.0265C198.037 16.6751 198.295 18.3097 199.155 19.9305L203.862 17.4338L208.793 26.7296L199.166 31.8367Z"
                        fill="url(#paint0_linear_28_12)" />
                    <path
                        d="M490 59.723L473.339 54.2489C467.315 52.2695 463.131 48.8148 460.788 43.8848C458.382 38.8299 457.618 33.5349 458.498 27.9998L465.134 30.1802C465.149 32.993 465.962 35.7562 467.573 38.4698C469.215 41.0894 471.637 42.925 474.837 43.9765L477.89 34.6833L496.246 40.7141L490 59.723ZM480.84 87.6026L464.179 82.1285C458.155 80.1492 453.971 76.6945 451.628 71.7644C449.221 66.7096 448.458 61.4146 449.338 55.8795L455.974 58.0598C455.989 60.8727 456.802 63.6359 458.413 66.3494C460.055 68.9691 462.476 70.8047 465.677 71.8562L468.73 62.563L487.085 68.5938L480.84 87.6026Z"
                        fill="url(#paint1_linear_28_12)" />
                    <path
                        d="M445.754 314.114C444.951 313.941 444.324 313.504 443.875 312.801C443.541 312.124 443.461 311.38 443.635 310.569C443.809 309.759 444.181 308.869 444.749 307.901L458.987 286.067C459.86 284.801 460.703 283.953 461.515 283.522C462.353 282.975 463.461 282.85 464.837 283.146L470.517 284.367C471.435 284.564 472.106 285.072 472.53 285.89C472.775 286.428 472.822 287.044 472.673 287.738C472.598 288.086 472.466 288.421 472.277 288.743L463.187 312.593C462.006 315.852 460.038 317.186 457.285 316.594L445.754 314.114ZM473.291 320.036C472.487 319.863 471.861 319.425 471.412 318.723C471.078 318.045 470.998 317.301 471.172 316.491C471.421 315.333 471.792 314.443 472.286 313.823L486.524 291.989C487.397 290.723 488.239 289.874 489.052 289.443C489.89 288.897 490.998 288.771 492.374 289.067L498.054 290.289C498.972 290.486 499.643 290.994 500.067 291.812C500.312 292.349 500.359 292.965 500.21 293.66C500.135 294.007 500.003 294.342 499.814 294.665L490.724 318.514C489.543 321.774 487.575 323.107 484.822 322.515L473.291 320.036Z"
                        fill="url(#paint2_linear_28_12)" />
                    <path
                        d="M824.939 377.026C824.784 377.539 824.467 377.922 823.986 378.177C823.528 378.358 823.04 378.371 822.522 378.214C822.005 378.058 821.446 377.769 820.847 377.348L807.411 366.93C806.635 366.296 806.128 365.703 805.891 365.152C805.58 364.578 805.558 363.851 805.823 362.972L806.92 359.345C807.097 358.759 807.463 358.35 808.017 358.117C808.379 357.987 808.782 357.989 809.226 358.123C809.448 358.19 809.658 358.293 809.858 358.434L824.878 365.612C826.934 366.553 827.696 367.903 827.165 369.662L824.939 377.026ZM830.254 359.44C830.099 359.953 829.781 360.337 829.301 360.591C828.843 360.773 828.355 360.785 827.837 360.629C827.097 360.405 826.539 360.117 826.162 359.763L812.726 349.345C811.949 348.71 811.443 348.117 811.206 347.566C810.895 346.992 810.872 346.266 811.138 345.386L812.234 341.759C812.412 341.173 812.777 340.764 813.332 340.532C813.694 340.401 814.097 340.403 814.541 340.537C814.762 340.604 814.973 340.708 815.173 340.848L830.193 348.026C832.249 348.968 833.011 350.317 832.48 352.076L830.254 359.44Z"
                        fill="url(#paint3_linear_28_12)" />
                    <path
                        d="M258.024 329.025C257.706 329.406 257.296 329.619 256.793 329.662C256.336 329.651 255.915 329.485 255.53 329.163C255.144 328.842 254.772 328.393 254.413 327.817L246.718 314.052C246.285 313.229 246.067 312.539 246.065 311.982C246.007 311.379 246.251 310.751 246.797 310.097L249.048 307.397C249.411 306.961 249.872 306.744 250.43 306.747C250.786 306.767 251.129 306.914 251.46 307.19C251.625 307.327 251.767 307.492 251.887 307.684L262.109 319.257C263.523 320.806 263.685 322.235 262.594 323.544L258.024 329.025ZM268.936 315.936C268.618 316.318 268.208 316.531 267.705 316.574C267.248 316.562 266.827 316.396 266.442 316.075C265.891 315.616 265.519 315.167 265.325 314.728L257.63 300.964C257.197 300.14 256.979 299.45 256.977 298.894C256.919 298.291 257.163 297.663 257.709 297.008L259.96 294.309C260.323 293.872 260.784 293.656 261.342 293.658C261.698 293.678 262.041 293.826 262.372 294.101C262.537 294.239 262.679 294.404 262.799 294.596L273.021 306.169C274.435 307.718 274.597 309.147 273.506 310.456L268.936 315.936Z"
                        fill="url(#paint4_linear_28_12)" />
                    <path
                        d="M1083 309V297.283C1083 293.762 1083.63 290.132 1084.9 286.391C1086.23 282.595 1088.02 279.02 1090.29 275.664C1092.55 272.253 1095.06 269.365 1097.82 267L1108.34 273.271C1106.24 276.682 1104.48 280.285 1103.04 284.081C1101.61 287.876 1100.89 292.25 1100.89 297.2V309H1083ZM1110.66 309V297.283C1110.66 293.762 1111.29 290.132 1112.56 286.391C1113.89 282.595 1115.68 279.02 1117.95 275.664C1120.21 272.253 1122.72 269.365 1125.48 267L1136 273.271C1133.9 276.682 1132.14 280.285 1130.7 284.081C1129.26 287.876 1128.55 292.25 1128.55 297.2V309H1110.66Z"
                        fill="url(#paint5_linear_28_12)" />
                    <path
                        d="M1333.27 72.5454L1330.13 67.2076C1329.18 65.6038 1328.6 63.7173 1328.39 61.5481C1328.19 59.3337 1328.35 57.0476 1328.86 54.6899C1329.35 52.3071 1330.13 50.0714 1331.21 47.9827L1339.43 46.9874C1339.05 49.3095 1338.92 51.5981 1339.04 53.8529C1339.17 56.1078 1339.9 58.363 1341.23 60.6184L1344.39 65.9937L1333.27 72.5454ZM1350.47 62.4146L1347.32 57.0768C1346.38 55.473 1345.8 53.5865 1345.58 51.4173C1345.39 49.2029 1345.54 46.9168 1346.05 44.5591C1346.54 42.1763 1347.33 39.9406 1348.41 37.8519L1356.63 36.8566C1356.24 39.1787 1356.11 41.4672 1356.23 43.7221C1356.36 45.977 1357.09 48.2322 1358.42 50.4876L1361.59 55.8629L1350.47 62.4146Z"
                        fill="url(#paint6_linear_28_12)" />
                    <path
                        d="M1061.7 52.7623L1053.97 50.8621C1051.65 50.2912 1049.36 49.2837 1047.1 47.8397C1044.81 46.3504 1042.74 44.5874 1040.9 42.5505C1039.01 40.5047 1037.52 38.3799 1036.4 36.1759L1042.24 30.2574C1044.15 32.194 1046.24 33.9433 1048.51 35.5054C1050.78 37.0675 1053.55 38.25 1056.82 39.0529L1064.6 40.9664L1061.7 52.7623ZM1066.18 34.5224L1058.46 32.6223C1056.13 32.0513 1053.84 31.0439 1051.58 29.5999C1049.29 28.1106 1047.23 26.3475 1045.38 24.3107C1043.5 22.2649 1042 20.14 1040.89 17.9361L1046.73 12.0176C1048.64 13.9541 1050.73 15.7035 1053 17.2656C1055.27 18.8277 1058.04 20.0102 1061.3 20.8131L1069.08 22.7266L1066.18 34.5224Z"
                        fill="url(#paint7_linear_28_12)" />
                    <path
                        d="M14.6967 358.762L6.96991 356.862C4.64825 356.291 2.357 355.284 0.0961517 353.84C-2.19202 352.35 -4.25898 350.587 -6.10473 348.551C-7.98677 346.505 -9.48389 344.38 -10.5961 342.176L-4.75508 336.257C-2.84619 338.194 -0.756616 339.943 1.51364 341.505C3.7839 343.068 6.55145 344.25 9.81629 345.053L17.5975 346.966L14.6967 358.762ZM19.1822 340.522L11.4554 338.622C9.13373 338.051 6.84248 337.044 4.58164 335.6C2.29347 334.111 0.22651 332.348 -1.61925 330.311C-3.50128 328.265 -4.9984 326.14 -6.11061 323.936L-0.269597 318.018C1.63929 319.954 3.72887 321.703 5.99913 323.266C8.26939 324.828 11.0369 326.01 14.3018 326.813L22.083 328.727L19.1822 340.522Z"
                        fill="url(#paint8_linear_28_12)" />
                    <defs>
                        <linearGradient id="paint0_linear_28_12" x1="200.945" y1="6.33637" x2="211.111"
                            y2="25.5002" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint1_linear_28_12" x1="450.749" y1="51.5849" x2="488.589"
                            y2="64.0176" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint2_linear_28_12" x1="475.508" y1="285.44" x2="468.299"
                            y2="318.962" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint3_linear_28_12" x1="807.883" y1="356.158" x2="829.291"
                            y2="362.627" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint4_linear_28_12" x1="251.025" y1="305.025" x2="266.958"
                            y2="318.309" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint5_linear_28_12" x1="1109.5" y1="267" x2="1109.5"
                            y2="309" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint6_linear_28_12" x1="1338.47" y1="43.7059" x2="1349.75"
                            y2="62.8392" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint7_linear_28_12" x1="1038.3" y1="28.4759" x2="1065.99"
                            y2="35.287" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                        <linearGradient id="paint8_linear_28_12" x1="-8.70253" y1="334.476" x2="18.9942"
                            y2="341.287" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#ADD7C4" stop-opacity="0" />
                            <stop offset="1" stop-color="#9BFFD0" stop-opacity="0.4" />
                        </linearGradient>
                    </defs>
                </svg>
            </div>

        </section>
    <?php endif; ?>
    <!-- ==== Testimonial Ends Here ==== -->

    <?php if(isset($new_user) && $new_user == true): ?>
        <!-- Modal -->
        <div class="modal fade show" id="welcome-modal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0">
                    <div class="modal-header border-0 pt-4 px-4">
                        <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-sm-5 pb-5">
                        <div class="text-center">
                            <img src="<?php echo e(asset('/public/assets/landing/img/welcome.svg')); ?>" class="mw-100 mb-3"
                                alt="">
                            <h5 class="mb-3"><?php echo e(translate('Welcome_to')); ?> <?php echo e($business_name); ?>!</h5>
                            <p class="m-0 mb-4">
                                <?php echo e(translate('Thanks for joining us! Your registration is under review. Hang tight, we’ll notify you once approved!')); ?>

                            </p>
                            <button type="button" class="border-0 outline-0 shadow-none cmn--btn"
                                data-bs-dismiss="modal">
                                <?php echo e(translate('okay')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).ready(function() {
            $('#welcome-modal').modal('show');
        });
    </script>
    <script>
        "use strict";
        $(document).ready(function() {
            "use strict";
            $('.onerror-image').on('error', function() {
                let img = $(this).data('onerror-image')
                $(this).attr('src', img);
            });
        });
    </script>
    <script>
        var tooltipTriggerList = [].slice.call(
            document.querySelectorAll('[data-bs-toggle="tooltip"]')
        );
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))

        var popoverList = popoverTriggerList.map(function(popoverTriggerEl) {
            return new bootstrap.Popover(popoverTriggerEl)
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.landing.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tupatane/dukakiganjani.online/resources/views/home.blade.php ENDPATH**/ ?>