<?php $__env->startSection('title', translate('Zone Wise Module Setup')); ?>

<?php $__env->startPush('css_or_js'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(asset('public/assets/admin/img/edit.png')); ?>" class="w--26" alt="">
                </span>
                <span>
                   <?php echo e($zone->name); ?> <?php echo e(translate('Zone_Settings')); ?>

                </span>
            </h1>
        </div>
        <!-- End Page Header -->
        <form action="<?php echo e(route('admin.business-settings.zone.module-update', $zone->id)); ?>" method="post" id="zone_form" class="shadow--card">
            <?php echo csrf_field(); ?>
            <div class="row g-2">
                <div class="col-12">
                    <div class="d-flex flex-wrap select--all-checkes">
                        <h5 class="input-label m-0 text-capitalize"><?php echo e(translate('messages.Select_Payment_Method')); ?> </h5>
                    </div>
                    <span class="badge badge-soft-danger mt-2"><?php echo e(translate('NB:_MUST_select_at_least_‘one’_payment_method.')); ?></span>
                    <div class="check--item-wrapper mb-1">
                        <?php ($config=\App\CentralLogics\Helpers::get_business_settings('cash_on_delivery')); ?>
                        <?php if($config && $config['status']==1): ?>
                        <div class="check-item">
                            <div class="form-group form-check form--check">
                                <input type="checkbox" name="cash_on_delivery" value="cash_on_delivery" class="form-check-input"
                                       id="cash_on_delivery" <?php echo e($zone->cash_on_delivery == 1 ?'checked':''); ?>>
                                <label class="form-check-label qcont text-dark" for="cash_on_delivery"><?php echo e(translate('messages.Cash On Delivery')); ?></label>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php ($digital_payment=\App\CentralLogics\Helpers::get_business_settings('digital_payment')); ?>
                        <?php if($digital_payment && $digital_payment['status']==1): ?>
                        <div class="check-item">
                            <div class="form-group form-check form--check">
                                <input type="checkbox" name="digital_payment" value="digital_payment" class="form-check-input"
                                       id="digital_payment" <?php echo e($zone->digital_payment == 1 ?'checked':''); ?>>
                                <label class="form-check-label qcont text-dark" for="digital_payment"><?php echo e(translate('messages.digital payment')); ?></label>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php ($offline_payment=\App\CentralLogics\Helpers::get_business_settings('offline_payment_status')); ?>
                        <?php if($offline_payment && $offline_payment==1): ?>
                        <div class="check-item">
                            <div class="form-group form-check form--check">
                                <input type="checkbox" name="offline_payment" value="offline_payment" class="form-check-input"
                                       id="offline_payment" <?php echo e($zone->offline_payment == 1 ?'checked':''); ?>>
                                <label class="form-check-label qcont text-dark" for="offline_payment"><?php echo e(translate('messages.offline payment')); ?></label>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <div class="d-flex justify-content-between align-items-center">
                                <label class="input-label text-capitalize d-inline-flex alig-items-center"
                                    for="increased_delivery_fee">
                                    <span class="line--limit-1"><?php echo e(translate('messages.increase_delivery_charge')); ?> (%)
                                    <span data-toggle="tooltip" data-placement="right" data-original-title="<?php echo e(translate('messages.Set_an_additional_delivery_charge_in_percentage_for_any_emergency_situations._This_amount_will_be_added_to_the_delivery_charge.')); ?>" class="input-label-secondary"><img src="<?php echo e(asset('/public/assets/admin/img/info-circle.svg')); ?>" alt="<?php echo e(translate('messages.dm_maximum_order_hint')); ?>"></span>
                                </label>
                                <label class="toggle-switch toggle-switch-sm">
                                    <input type="checkbox" class="toggle-switch-input" name="increased_delivery_fee_status"
                                        id="increased_delivery_fee_status" value="1"
                                        <?php echo e($zone->increased_delivery_fee_status == 1 ? 'checked' : ''); ?>>
                                        <span class="toggle-switch-label">
                                            <div class="toggle-switch-indicator"></div>
                                        </span>
                                </label>
                            </div>
                            <input type="number" name="increased_delivery_fee" class="form-control"
                                id="increased_delivery_fee"
                                value="<?php echo e($zone->increased_delivery_fee ? $zone->increased_delivery_fee : ''); ?>" min="0" max="100"
                                step=".001" placeholder="<?php echo e(translate('messages.Ex:_100')); ?>" <?php echo e(($zone->increased_delivery_fee_status == 1) ? ' ' : 'readonly'); ?>>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <div class="d-flex justify-content-between align-items-center">
                                <label class="input-label text-capitalize d-inline-flex alig-items-center"
                                    for="increased_delivery_fee">
                                    <span class="line--limit-1"><?php echo e(translate('messages.increase_delivery_charge_message')); ?>

                                        <span data-toggle="tooltip" data-placement="right" data-original-title="<?php echo e(translate('messages.Customers_will_see_the_delivery_charge_increased_reason_on_the_website_and_customer_app.')); ?>" class="input-label-secondary"><img src="<?php echo e(asset('/public/assets/admin/img/info-circle.svg')); ?>" alt="<?php echo e(translate('messages.dm_maximum_order_hint')); ?>"></span>

                                </label>
                            </div>
                            <input type="text" name="increase_delivery_charge_message" class="form-control"
                                id="increase_delivery_charge_message"
                                value="<?php echo e($zone->increase_delivery_charge_message ? $zone->increase_delivery_charge_message : ''); ?>"
                                    placeholder="<?php echo e(translate('messages.Ex:_Rainy_season')); ?> " <?php echo e(($zone->increased_delivery_fee_status == 1) ? ' ' : 'readonly'); ?>>
                        </div>
                    </div>
                </div>


                    <div class="form-group mb-0">
                        <label class="input-label" for="exampleFormControlSelect1"><?php echo e(translate('Choose_Business_Module')); ?><span
                                class="input-label-secondary"></span></label>
                        <select name="module_id[]" id="choice_modules" class="form-control js-select2-custom"
                            multiple="multiple">
                            <?php ($modules_array = \App\Models\Module::get()->toArray()); ?>
                            <?php ($modules = \App\Models\Module::get()); ?>
                            <?php ($selected_modules = count($zone->modules) > 0 ? $zone->modules->pluck('id')->toArray() : []); ?>
                            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($module['id']); ?>"
                                    <?php echo e(in_array($module['id'], $selected_modules) ? 'selected' : ''); ?>>
                                    <?php echo e($module['module_name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="delivery_charge_options" id="delivery_charge_options">
                        <div class="row gy-1" id="mod-label">
                            <div class="col-sm-4">
                                <label for=""><?php echo e(translate('messages.Module Name')); ?></label>
                            </div>
                            <div class="col-sm-2">
                                <label for=""><?php echo e(translate('messages.per_km_delivery_charge')); ?> (<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>) <span class="input-label-secondary text-danger">*</span></label>
                            </div>
                            <div class="col-sm-2">
                                <label for=""><?php echo e(translate('messages.Minimum delivery charge')); ?> (<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>) <span class="input-label-secondary text-danger">*</span></label>
                            </div>
                            <div class="col-sm-2">
                                <label for=""><?php echo e(translate('messages.Maximum delivery charge')); ?> (<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>)</label>
                            </div>
                            <div class="col-sm-2">
                                <label for=""><?php echo e(translate('maximum_cod_order_amount')); ?> (<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>)</label>
                            </div>
                        </div>
                        <?php if(count($zone->modules) > 0): ?>
                            <?php $__currentLoopData = $zone->modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($module->module_type == 'parcel'): ?>
                            <div class="row gy-1 module-row" id="module_<?php echo e($module->id); ?>">
                                <div class="col-sm-4"><input type="text" class="form-control"
                                        value="<?php echo e($module->module_name); ?>"
                                        placeholder="<?php echo e(translate('messages.choice_title')); ?>" readonly></div>
                                <div class="col-sm-2"><input type="number" class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][per_km_shipping_charge]" step=".01"
                                        min="0" placeholder="<?php echo e(translate('Set charge from parcel category')); ?>"
                                        data-toggle="tooltip" data-placement="right"
                                        data-original-title="<?php echo e(translate('messages.You have to set category wise charge from parcel category')); ?>" readonly></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                        class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][minimum_shipping_charge]"
                                        placeholder="<?php echo e(translate('Set charge from parcel category')); ?>"
                                        data-toggle="tooltip" data-placement="right"
                                        data-original-title="<?php echo e(translate('messages.You have to set category wise charge from parcel category')); ?>" readonly></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                        class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][maximum_shipping_charge]"
                                        placeholder="<?php echo e(translate('Set charge from parcel category')); ?>"
                                        data-toggle="tooltip" data-placement="right"
                                        data-original-title="<?php echo e(translate('messages.You have to set category wise charge from parcel category')); ?>" readonly></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                    class="form-control"
                                    name="module_data[<?php echo e($module->id); ?>][maximum_cod_order_amount]"
                                    placeholder="<?php echo e(translate('enter_Amount')); ?>"
                                    title="<?php echo e(translate('set_maximum_cod_order_amount')); ?>"
                                    value="<?php echo e($module->pivot->maximum_cod_order_amount); ?>" readonly></div>
                            </div>
                            <?php else: ?>
                            <div class="row gy-1 module-row" id="module_<?php echo e($module->id); ?>">
                                <div class="col-sm-4"><input type="text" class="form-control"
                                        value="<?php echo e($module->module_name); ?>"
                                        placeholder="<?php echo e(translate('messages.choice_title')); ?>" readonly></div>
                                <div class="col-sm-2"><input type="number" class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][per_km_shipping_charge]" step=".01"
                                        min="0" placeholder="<?php echo e(translate('messages.enter_Amount')); ?>"
                                        title="<?php echo e(translate('messages.per_km_delivery_charge')); ?>"
                                        value="<?php echo e($module->pivot->per_km_shipping_charge); ?>" required></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                        class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][minimum_shipping_charge]"
                                        placeholder="<?php echo e(translate('messages.enter_Amount')); ?>"
                                        title="<?php echo e(translate('messages.Minimum delivery charge')); ?>"
                                        value="<?php echo e($module->pivot->minimum_shipping_charge); ?>" required></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                        class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][maximum_shipping_charge]"
                                        placeholder="<?php echo e(translate('messages.enter_Amount')); ?>"
                                        title="<?php echo e(translate('messages.maximum delivery charge')); ?>"
                                        value="<?php echo e($module->pivot->maximum_shipping_charge); ?>" ></div>
                                <div class="col-sm-2"><input type="number" step=".01" min="0"
                                        class="form-control"
                                        name="module_data[<?php echo e($module->id); ?>][maximum_cod_order_amount]"
                                        placeholder="<?php echo e(translate('enter_Amount')); ?>"
                                        title="<?php echo e(translate('set_maximum_cod_order_amount')); ?>"
                                        value="<?php echo e($module->pivot->maximum_cod_order_amount); ?>"></div>
                            </div>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="btn--container mt-3 justify-content-end">
                <button type="submit" class="btn btn--primary"><?php echo e(translate('messages.update')); ?></button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin')); ?>/js/tags-input.min.js"></script>
    <script>
        "use strict";

        $(document).on('ready', function() {
            $("#increased_delivery_fee_status").on('change', function() {
                if ($("#increased_delivery_fee_status").is(':checked')) {
                    $('#increased_delivery_fee').removeAttr('readonly');
                    $('#increase_delivery_charge_message').removeAttr('readonly');
                } else {
                    $('#increased_delivery_fee').attr('readonly', true);
                    $('#increase_delivery_charge_message').attr('readonly', true);
                    $('#increased_delivery_fee').val('Ex : 0');
                    $('#increase_delivery_charge_message').val('');
                }
            });
        });


        let modules = <?php echo json_encode($modules_array); ?>;
        let mod = <?php echo e(count($zone->modules)); ?>;
        if(mod>0){
            $('#mod-label').show();
        }else{
            $('#mod-label').hide();
        }
        $('#choice_modules').on('change', function() {
            $('#mod-label').show();
            let ids = $('.module-row').map(function() {
                return $(this).attr('id').split('_')[1];
            }).get();

            $.each($("#choice_modules option:selected"), function(index, element) {
                console.log($(this).val());
                if (ids.includes($(this).val())) {
                    ids = ids.filter(id => id !== $(this).val());
                } else {
                    let name = $('#choice_modules option[value="' + $(this).val() + '"]').html();
                    let found = modules.find(modul=> modul.id == $(this).val());
                    if (found.module_type == 'parcel'){

                        add_parcel_module($(this).val(), name.trim());
                    }else{

                        add_more_delivery_charge_option($(this).val(), name.trim());
                    }
                }
            });
            console.log(ids)
            if (ids.length > 0) {
                ids.forEach(element => {
                    console.log("module_", 3)
                    $("#module_" + element.trim()).remove();
                });
            }
        });

        function add_more_delivery_charge_option(i, name) {
            let n = name;
            $('#delivery_charge_options').append(
                '<div class="row gy-1 module-row" id="module_' + i +
                '"><div class="col-sm-4"><input type="text" class="form-control" value="' + n +
                '" placeholder="<?php echo e(translate('messages.choice_title')); ?>" readonly></div><div class="col-sm-2"><input type="number" class="form-control" name="module_data[' +
                i +
                '][per_km_shipping_charge]" step=".01" min="0" placeholder="<?php echo e(translate('messages.enter_Amount')); ?>" title="<?php echo e(translate('messages.per_km_delivery_charge')); ?>" required></div><div class="col-sm-2"><input type="number" step=".01" min="0" class="form-control" name="module_data[' +
                i +
                '][minimum_shipping_charge]" placeholder="<?php echo e(translate('messages.enter_Amount')); ?>" title="<?php echo e(translate('messages.Minimum delivery charge')); ?>" required></div><div class="col-sm-2"><input type="number" step=".01" min="0" class="form-control" name="module_data[' +
                i +
                '][maximum_shipping_charge]" placeholder="<?php echo e(translate('messages.enter_Amount')); ?>" title="<?php echo e(translate('messages.maximum delivery charge')); ?>"></div><div class="col-sm-2"><input type="number" step=".01" min="0" class="form-control" name="module_data[' +
                i +
                '][maximum_cod_order_amount]" placeholder="<?php echo e(translate('enter_Amount')); ?>" title="<?php echo e(translate('set_maximum_cod_order_amount')); ?>"></div></div>'
            );
        }
        function add_parcel_module(i, name) {
            let n = name;
            $('#delivery_charge_options').append(
                '<div class="row gy-1 module-row" id="module_' + i +
                '"><div class="col-sm-4"><input type="text" class="form-control" value="' + n +
                '" placeholder="<?php echo e(translate('messages.choice_title')); ?>" readonly></div><div class="col-sm-2"><input type="number" name="module_data[' +
                i +
                '][per_km_shipping_charge]" class="form-control" step=".01" min="0" placeholder="<?php echo e(translate('Set charge from parcel category')); ?>" value="" title="<?php echo e(translate('messages.per_km_delivery_charge')); ?>" readonly></div><div class="col-sm-2"><input type="number" name="module_data[' +
                i +
                '][minimum_shipping_charge]" step=".01" min="0" class="form-control" placeholder="<?php echo e(translate('Set charge from parcel category')); ?>" value="" title="<?php echo e(translate('messages.Minimum delivery charge')); ?>" readonly></div><div class="col-sm-2"><input type="number" name="module_data[' +
                i +
                '][maximum_shipping_charge]" step=".01" min="0" class="form-control" placeholder="<?php echo e(translate('Set charge from parcel category')); ?>" value="" title="<?php echo e(translate('messages.maximum delivery charge')); ?>" readonly></div><div class="col-sm-2"><input type="number" step=".01" min="0" class="form-control" name="module_data[' +
                i +
                '][maximum_cod_order_amount]" placeholder="<?php echo e(translate('enter_Amount')); ?>" title="<?php echo e(translate('set_maximum_cod_order_amount')); ?>" readonly></div></div>'
            );
        }
    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tupatane/dukakiganjani.online/resources/views/admin-views/zone/module-setup.blade.php ENDPATH**/ ?>