@extends('layouts.admin.app')

@section('title',translate('messages.Subscription'))

@section('subscription_index')
active
@endsection

@section('content')

    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center py-2">
                <div class="col-sm mb-2 mb-sm-0">
                    <div class="d-flex align-items-start">
                        <img src="{{asset('/public/assets/admin/img/create-package-icon.png')}}" width="24" alt="img">
                        <div class="w-0 flex-grow pl-2">
                            <h1 class="page-header-title">{{translate('Subscription Package')}}</h1>
                            <div class="page-header-text">{{ translate('Create_Subscriptions_Packages_for_Subscription_Business_Model') }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card mb-20">
            <div class="card-header">
                <div class="w-100 d-flex flex-wrap align-items-start gap-2">
                    <img src="{{asset('/public/assets/admin/img/material-symbols_featured-play-list.png')}}" width="18" alt="img" class="mt-1">
                    <div class="w-0 flex-grow">
                        <h5 class="text--title card-title">{{ translate('Package_Information') }}</h5>
                        <div class="fz-12px">{{ translate('Give_Subscriptions_Package_Information') }}</div>
                    </div>
                    <div class="text--primary-2 d-flex flex-wrap align-items-end" type="button" data-toggle="modal" data-target="#initial-modal">
                        <strong class="mr-2">{{ translate('How it Works') }}</strong>
                        <div class="blinkings">
                            <i class="tio-info-outined"></i>
                        </div>
                    </div>
                </div>
            </div>

    <form action="{{ route('admin.business-settings.subscriptionackage.store') }}" method="post">
        @csrf
        @method('post')

                <div class="card-body">
                        @if ($language)
                        <ul class="nav nav-tabs mb-3">
                            <li class="nav-item">
                                <a class="nav-link lang_link active"
                                href="#"
                                id="default-link">{{translate('messages.default')}}</a>
                            </li>
                            @foreach ($language as $lang)
                                <li class="nav-item">
                                    <a class="nav-link lang_link"
                                        href="#"
                                        id="{{ $lang }}-link">{{ \App\CentralLogics\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')' }}</a>
                                </li>
                            @endforeach
                        </ul>
                        @endif

                    <div class="row g-3">

                        <div class="col-lg-4 col-sm-6 lang_form" id="default-form">
                            <div class="form-group mb-0">
                                <label class="form-label input-label"
                                for="name">{{ translate('Package_Name') }} ({{ translate('Default') }})</label>
                                <input type="text" name="package_name[]" class="form-control" id="name" maxlength="191"  value="{{ old('package_name.0') }}"
                                placeholder="{{ translate('Package_Name') }}"
                                >
                            <input type="hidden" name="lang[]" value="default">
                            </div>
                        </div>

                        @if($language)
                                @foreach($language as $key => $lang)
                                <div class="col-lg-4 col-sm-6  d-none lang_form" id="{{$lang}}-form">
                                    <div class="form-group mb-0">
                                        <label class="form-label input-label"
                                        for="{{$lang}}_title">{{ translate('Package_Name') }} ({{strtoupper($lang)}})</label>
                                        <input type="text" name="package_name[]" class="form-control" id="{{$lang}}_title" maxlength="191"  value="{{ old('package_name.'.$key+1) }}"
                                        placeholder="{{ translate('Package_Name') }}"
                                        >
                                        <input type="hidden" name="lang[]" value="{{$lang}}">
                                    </div>
                                </div>
                                @endforeach
                        @endif


                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label">{{ translate('Package_Price') }} ({{ \App\CentralLogics\Helpers::currency_symbol() }})</label>
                                <input type="number" name="package_price" value="{{ old('package_price') }}" required  min="0.01" step="0.01" max="999999999" class="form-control" placeholder="{{ translate('Ex: 300') }}">
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label">{{ translate('Package_Validity') }} {{ translate('Days') }}</label>
                                <input type="number"   min="1" max="999999999"  value="{{ old('package_validity') }}"  required name="package_validity"  class="form-control" placeholder="{{ translate('Ex: 365') }}">
                            </div>
                        </div>


                        <div class="col-lg-4 col-sm-6 lang_form default-form" >
                            <div class="form-group m-0">
                                <label class="form-label input-label   text-capitalize"
                                    for="package_info">{{ translate('messages.package_info') }}</label>
                                <textarea class="form-control" placeholder="{{ translate('EX:_Value_for_money') }}"  name="text[]" id="package_info">{{ old('text.0') }}</textarea>
                            </div>
                        </div>

                        @if($language)
                        @foreach($language as $lang)
                        <div class="col-lg-4 col-sm-6 d-none lang_form" id="{{$lang}}-form1">
                            <div class="form-group m-0">
                                <label class="form-label input-label   text-capitalize"
                                    for="package_info">{{ translate('messages.package_info') }} ({{strtoupper($lang)}})</label>
                                <textarea class="form-control" name="text[]" placeholder="{{ translate('EX:_Value_for_money') }}" id="package_info">{{ old('text.'.$key+1) }}</textarea>
                            </div>
                        </div>
                        @endforeach
                        @endif

                    </div>
                </div>
            </div>
            <div class="card mb-20">
                <div class="card-header">
                    <div class="w-100 d-flex flex-wrap align-items-start gap-2">
                        <img src="{{asset('/public/assets/admin/img/material-symbols_featured-play-list-2.png')}}" alt="img" class="mt-1">
                        <div class="w-0 flex-grow">
                            <h5 class="text--title card-title d-flex gap-3 flex-wrap mb-1">
                                <div>
                                    {{ translate('Package_Available_Features') }}
                                </div>
                                <label class="form-group form-check form--check">
                                    <input type="checkbox" class="form-check-input" id="select-all">
                                    <span class="form-check-label text-dark font-regular text-14">{{ translate('Select_All') }}</span>
                                </label>
                            </h5>
                            <div class="fz-12px">{{ translate('Mark_the_feature_you_want_to_give_in_this_package') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="check--item-wrapper check--item-wrapper-2 mt-0">
                        <div class="check-item">
                            <label class="form-group form-check form--check">
                                <input type="checkbox" class="form-check-input package-available-feature"  {{ old('pos_system') == 1 ? 'checked' : '' }} name="pos_system" value="1">
                                <span class="form-check-label text-dark">{{ translate('messages.pos_system') }}</span>
                            </label>
                        </div>
                        <div class="check-item">
                            <label class="form-group form-check form--check">
                                <input type="checkbox" class="form-check-input package-available-feature" {{ old('self_delivery') == 1 ? 'checked' : '' }}  name="self_delivery" value="1">
                                <span class="form-check-label text-dark">{{ translate('messages.self_delivery') }}</span>
                            </label>
                        </div>
                        <div class="check-item">
                            <label class="form-group form-check form--check">
                                <input type="checkbox" class="form-check-input package-available-feature" {{ old('mobile_app') == 1 ? 'checked' : '' }}  name="mobile_app" value="1" >
                                <span class="form-check-label text-dark">{{ translate('messages.Mobile_App') }}</span>
                            </label>
                        </div>
                        <div class="check-item">
                            <label class="form-group form-check form--check">
                                <input type="checkbox" class="form-check-input package-available-feature" {{ old('review') == 1 ? 'checked' : '' }}  name="review" value="1" >
                                <span class="form-check-label text-dark">{{ translate('messages.review') }}</span>
                            </label>
                        </div>
                        <div class="check-item">
                            <label class="form-group form-check form--check">
                                <input type="checkbox" class="form-check-input package-available-feature" {{ old('chat') == 1 ? 'checked' : '' }}  name="chat" value="1" >
                                <span class="form-check-label text-dark">{{ translate('messages.chat') }}</span>
                            </label>
                        </div>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <div class="w-100 d-flex flex-wrap align-items-start gap-2">
                        <img src="{{asset('/public/assets/admin/img/bx_category.png')}}" alt="img" class="mt-1">
                        <div class="w-0 flex-grow">
                            <h5 class="text--title card-title d-flex gap-3 flex-wrap mb-1">
                                <div>
                                    {{ translate('Set_limit') }}
                                </div>
                            </h5>
                            <div class="fz-12px">{{ translate('Set_maximum_order_&_product_limit_for_this_package') }}</div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-wrap gap-3">
                        <div class="__bg-F8F9FC-card p-0">
                            <div class="card-body">
                                <div class="limit-item-card">
                                    <div class="form-group mb-0">
                                        <label class="form-label text-capitalize">{{ translate('Maximum_Order Limit') }}</label>
                                        <div class="d-flex flex-wrap items-center gap-2">
                                            <div class="resturant-type-group p-0">
                                                <label class="form-check form--check mr-2 mr-md-4">
                                                    <input class="form-check-input limit-input" type="radio" checked name="minimum_order_limit" >
                                                    <span class="form-check-label">
                                                        {{ translate('Unlimited') }} ({{ translate('Default') }})
                                                    </span>
                                                </label>
                                                <label class="form-check form--check mr-2 mr-md-4">
                                                    <input class="form-check-input limit-input" type="radio" name="minimum_order_limit" value="Use_Limit">
                                                    <span class="form-check-label">
                                                        {{ translate('Use_Limit') }}
                                                    </span>
                                                </label>
                                            </div>
                                            <div class="custom-limit-box">
                                                <input id="max_order" type="number" name="max_order" min="1" step="1" max="999999999" class="form-control max_required" placeholder="{{ translate('Ex: 1000') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="__bg-F8F9FC-card p-0">
                            <div class="card-body">
                                <div class="limit-item-card">
                                    <div class="form-group mb-0">
                                        <label class="form-label text-capitalize">{{ translate('Maximum_Item_Limit') }}</label>
                                        <div class="d-flex flex-wrap items-center gap-2">
                                            <div class="resturant-type-group p-0">
                                                <label class="form-check form--check mr-2 mr-md-4">
                                                    <input class="form-check-input limit-input" type="radio" checked name="maximum_item_limit" >
                                                    <span class="form-check-label">
                                                        {{ translate('Unlimited') }} ({{ translate('Default') }})
                                                    </span>
                                                </label>
                                                <label class="form-check form--check mr-2 mr-md-4">
                                                    <input class="form-check-input limit-input" type="radio" name="maximum_item_limit" value="Use_Limit" >
                                                    <span class="form-check-label">
                                                        {{ translate('Use_Limit') }}
                                                    </span>
                                                </label>
                                            </div>
                                            <div class="custom-limit-box">
                                                <input  id="max_product" type="number" name="max_product" min="1" step="1" max="999999999" class="form-control max_required" placeholder="{{ translate('Ex: 1000') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="btn--container justify-content-end mt-3">
                <button type="reset" id="reset_btn" class="btn btn--reset">
                    {{ translate('messages.reset') }}
                </button>
                <button type="submit" class="btn btn--primary">{{ translate('messages.submit') }}</button>
            </div>

        </form>

        <div class="modal fade show" id="initial-modal">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header pt-4">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true" class="tio-clear"></span>
                        </button>
                    </div>
                    <div class="modal-body px-4 pb-4 pt-0">
                        <div>
                            <div>
                                <div class="text-center">
                                    <h2 class="modal-title">{{ translate('Subscription_Packages') }}</h2>
                                </div>
                                <div class="text-center text-14 mb-4">
                                    {{ translate('Here_you_can_view_all_the_data_placements_in_a_package_card_in_the_subscription_UI_in_the_user_app_and_website') }}
                                </div>
                                <div class="text-center pt-2 text--base">
                                    <svg width="623" class="max-w-100" viewBox="0 0 623 298" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g filter="url(#filter0_d_7301_41)">
                                        <g clip-path="url(#clip0_7301_41)">
                                        <rect x="232" y="16" width="196" height="267" rx="8" fill="white"/>
                                        <g filter="url(#filter1_d_7301_41)">
                                        <path d="M428 23.793V327.207C428 331.519 424.058 335 419.175 335H240.825C235.942 335 232 331.519 232 327.207V23.793C232 19.4812 235.942 16 240.825 16H419.175C424.058 16 428 19.4812 428 23.793Z" fill="currentColor"/>
                                        <path d="M427.639 23.793V327.207C427.639 331.279 423.902 334.639 419.175 334.639H240.825C236.098 334.639 232.361 331.279 232.361 327.207V23.793C232.361 19.7212 236.098 16.3607 240.825 16.3607H419.175C423.902 16.3607 427.639 19.7212 427.639 23.793Z" stroke="#23B3AE" stroke-width="0.721461"/>
                                        </g>
                                        <circle cx="352" cy="31" r="107" fill="white" fill-opacity="0.05"/>
                                        <path d="M282.858 164.545C282.815 164.186 282.643 163.906 282.339 163.707C282.036 163.509 281.665 163.409 281.224 163.409C280.902 163.409 280.621 163.461 280.379 163.565C280.14 163.67 279.953 163.813 279.818 163.995C279.686 164.177 279.619 164.384 279.619 164.616C279.619 164.811 279.665 164.978 279.758 165.117C279.853 165.254 279.973 165.369 280.12 165.462C280.267 165.552 280.421 165.626 280.582 165.685C280.743 165.742 280.891 165.788 281.026 165.824L281.764 166.023C281.954 166.072 282.164 166.141 282.396 166.229C282.631 166.316 282.854 166.436 283.067 166.587C283.283 166.737 283.46 166.928 283.6 167.163C283.74 167.397 283.81 167.685 283.81 168.026C283.81 168.419 283.707 168.774 283.501 169.091C283.297 169.408 282.999 169.66 282.606 169.847C282.215 170.034 281.741 170.128 281.182 170.128C280.661 170.128 280.21 170.044 279.829 169.876C279.45 169.708 279.152 169.473 278.934 169.173C278.719 168.872 278.597 168.523 278.568 168.125H279.477C279.501 168.4 279.593 168.627 279.754 168.807C279.918 168.984 280.124 169.117 280.372 169.205C280.623 169.29 280.893 169.332 281.182 169.332C281.518 169.332 281.82 169.278 282.087 169.169C282.355 169.058 282.567 168.904 282.723 168.707C282.879 168.509 282.957 168.277 282.957 168.011C282.957 167.77 282.89 167.573 282.755 167.422C282.62 167.27 282.442 167.147 282.222 167.053C282.002 166.958 281.764 166.875 281.509 166.804L280.614 166.548C280.045 166.385 279.596 166.152 279.264 165.849C278.933 165.546 278.767 165.149 278.767 164.659C278.767 164.252 278.877 163.897 279.097 163.594C279.32 163.288 279.618 163.052 279.992 162.884C280.369 162.713 280.789 162.628 281.253 162.628C281.722 162.628 282.138 162.712 282.503 162.88C282.867 163.046 283.156 163.273 283.369 163.562C283.585 163.851 283.698 164.179 283.71 164.545H282.858ZM287.431 170.114C286.905 170.114 286.452 169.998 286.071 169.766C285.692 169.531 285.4 169.205 285.194 168.786C284.99 168.364 284.888 167.874 284.888 167.315C284.888 166.757 284.99 166.264 285.194 165.838C285.4 165.41 285.686 165.076 286.053 164.837C286.422 164.595 286.853 164.474 287.346 164.474C287.63 164.474 287.91 164.522 288.187 164.616C288.464 164.711 288.716 164.865 288.944 165.078C289.171 165.289 289.352 165.568 289.487 165.916C289.622 166.264 289.689 166.693 289.689 167.202V167.557H285.485V166.832H288.837C288.837 166.525 288.776 166.25 288.653 166.009C288.532 165.767 288.359 165.576 288.134 165.437C287.912 165.297 287.649 165.227 287.346 165.227C287.012 165.227 286.723 165.31 286.479 165.476C286.238 165.639 286.052 165.852 285.922 166.115C285.791 166.378 285.726 166.66 285.726 166.96V167.443C285.726 167.855 285.797 168.204 285.939 168.491C286.084 168.775 286.284 168.991 286.54 169.141C286.795 169.287 287.092 169.361 287.431 169.361C287.651 169.361 287.85 169.33 288.028 169.268C288.207 169.205 288.363 169.11 288.493 168.984C288.623 168.857 288.724 168.698 288.795 168.509L289.604 168.736C289.519 169.01 289.376 169.252 289.175 169.46C288.973 169.666 288.725 169.827 288.429 169.943C288.133 170.057 287.8 170.114 287.431 170.114ZM291.802 162.727V170H290.964V162.727H291.802ZM295.766 164.545V165.256H292.826V164.545H295.766ZM293.707 170V163.793C293.707 163.48 293.78 163.22 293.927 163.011C294.074 162.803 294.264 162.647 294.499 162.543C294.733 162.438 294.98 162.386 295.241 162.386C295.447 162.386 295.615 162.403 295.745 162.436C295.875 162.469 295.972 162.5 296.036 162.528L295.795 163.253C295.752 163.239 295.693 163.221 295.617 163.2C295.544 163.178 295.447 163.168 295.326 163.168C295.049 163.168 294.849 163.237 294.726 163.377C294.605 163.517 294.545 163.722 294.545 163.991V170H293.707ZM302.111 170H299.867V162.727H302.211C302.916 162.727 303.52 162.873 304.022 163.164C304.524 163.453 304.908 163.868 305.176 164.411C305.443 164.95 305.577 165.597 305.577 166.349C305.577 167.107 305.442 167.759 305.172 168.306C304.903 168.851 304.51 169.27 303.993 169.563C303.477 169.854 302.85 170 302.111 170ZM300.748 169.219H302.055C302.656 169.219 303.154 169.103 303.55 168.871C303.945 168.639 304.24 168.308 304.434 167.88C304.628 167.451 304.725 166.941 304.725 166.349C304.725 165.762 304.629 165.257 304.437 164.833C304.246 164.407 303.959 164.08 303.578 163.853C303.197 163.623 302.722 163.509 302.154 163.509H300.748V169.219ZM309.228 170.114C308.702 170.114 308.249 169.998 307.868 169.766C307.489 169.531 307.197 169.205 306.991 168.786C306.787 168.364 306.685 167.874 306.685 167.315C306.685 166.757 306.787 166.264 306.991 165.838C307.197 165.41 307.483 165.076 307.85 164.837C308.219 164.595 308.65 164.474 309.143 164.474C309.427 164.474 309.707 164.522 309.984 164.616C310.261 164.711 310.513 164.865 310.741 165.078C310.968 165.289 311.149 165.568 311.284 165.916C311.419 166.264 311.486 166.693 311.486 167.202V167.557H307.282V166.832H310.634C310.634 166.525 310.573 166.25 310.449 166.009C310.329 165.767 310.156 165.576 309.931 165.437C309.708 165.297 309.446 165.227 309.143 165.227C308.809 165.227 308.52 165.31 308.276 165.476C308.035 165.639 307.849 165.852 307.719 166.115C307.588 166.378 307.523 166.66 307.523 166.96V167.443C307.523 167.855 307.594 168.204 307.736 168.491C307.881 168.775 308.081 168.991 308.336 169.141C308.592 169.287 308.889 169.361 309.228 169.361C309.448 169.361 309.647 169.33 309.824 169.268C310.004 169.205 310.159 169.11 310.29 168.984C310.42 168.857 310.52 168.698 310.591 168.509L311.401 168.736C311.316 169.01 311.173 169.252 310.971 169.46C310.77 169.666 310.522 169.827 310.226 169.943C309.93 170.057 309.597 170.114 309.228 170.114ZM313.599 162.727V170H312.761V162.727H313.599ZM315.134 170V164.545H315.972V170H315.134ZM315.56 163.636C315.397 163.636 315.256 163.581 315.138 163.469C315.022 163.358 314.964 163.224 314.964 163.068C314.964 162.912 315.022 162.778 315.138 162.667C315.256 162.556 315.397 162.5 315.56 162.5C315.724 162.5 315.863 162.556 315.979 162.667C316.098 162.778 316.157 162.912 316.157 163.068C316.157 163.224 316.098 163.358 315.979 163.469C315.863 163.581 315.724 163.636 315.56 163.636ZM321.968 164.545L319.95 170H319.098L317.081 164.545H317.99L319.496 168.892H319.553L321.058 164.545H321.968ZM325.165 170.114C324.64 170.114 324.186 169.998 323.805 169.766C323.426 169.531 323.134 169.205 322.928 168.786C322.724 168.364 322.623 167.874 322.623 167.315C322.623 166.757 322.724 166.264 322.928 165.838C323.134 165.41 323.421 165.076 323.787 164.837C324.157 164.595 324.588 164.474 325.08 164.474C325.364 164.474 325.645 164.522 325.922 164.616C326.199 164.711 326.451 164.865 326.678 165.078C326.905 165.289 327.086 165.568 327.221 165.916C327.356 166.264 327.424 166.693 327.424 167.202V167.557H323.219V166.832H326.572C326.572 166.525 326.51 166.25 326.387 166.009C326.266 165.767 326.093 165.576 325.868 165.437C325.646 165.297 325.383 165.227 325.08 165.227C324.746 165.227 324.457 165.31 324.214 165.476C323.972 165.639 323.786 165.852 323.656 166.115C323.526 166.378 323.461 166.66 323.461 166.96V167.443C323.461 167.855 323.532 168.204 323.674 168.491C323.818 168.775 324.018 168.991 324.274 169.141C324.53 169.287 324.827 169.361 325.165 169.361C325.385 169.361 325.584 169.33 325.762 169.268C325.942 169.205 326.097 169.11 326.227 168.984C326.357 168.857 326.458 168.698 326.529 168.509L327.339 168.736C327.253 169.01 327.11 169.252 326.909 169.46C326.708 169.666 326.459 169.827 326.163 169.943C325.867 170.057 325.535 170.114 325.165 170.114ZM328.699 170V164.545H329.508V165.369H329.565C329.665 165.099 329.845 164.88 330.105 164.712C330.365 164.544 330.659 164.46 330.986 164.46C331.047 164.46 331.124 164.461 331.216 164.464C331.309 164.466 331.379 164.47 331.426 164.474V165.327C331.398 165.32 331.332 165.309 331.231 165.295C331.131 165.278 331.026 165.27 330.915 165.27C330.649 165.27 330.413 165.326 330.204 165.437C329.998 165.546 329.835 165.697 329.714 165.891C329.596 166.083 329.537 166.302 329.537 166.548V170H328.699ZM333.125 172.045C332.983 172.045 332.856 172.034 332.745 172.01C332.634 171.989 332.557 171.967 332.514 171.946L332.727 171.207C332.931 171.259 333.111 171.278 333.267 171.264C333.423 171.25 333.562 171.18 333.683 171.055C333.806 170.932 333.918 170.732 334.02 170.455L334.176 170.028L332.159 164.545H333.068L334.574 168.892H334.631L336.137 164.545H337.046L334.73 170.795C334.626 171.077 334.497 171.31 334.343 171.495C334.189 171.682 334.011 171.821 333.807 171.911C333.606 172 333.378 172.045 333.125 172.045Z" fill="white"/>
                                        <path d="M263 161C264.326 161 265.598 161.527 266.536 162.464C267.473 163.402 268 164.674 268 166C268 167.326 267.473 168.598 266.536 169.536C265.598 170.473 264.326 171 263 171C261.674 171 260.402 170.473 259.464 169.536C258.527 168.598 258 167.326 258 166C258 164.674 258.527 163.402 259.464 162.464C260.402 161.527 261.674 161 263 161ZM262.377 166.986L261.266 165.875C261.227 165.835 261.179 165.804 261.127 165.782C261.075 165.76 261.02 165.749 260.963 165.749C260.907 165.749 260.851 165.76 260.799 165.782C260.747 165.804 260.7 165.835 260.66 165.875C260.58 165.955 260.534 166.064 260.534 166.178C260.534 166.292 260.58 166.401 260.66 166.481L262.074 167.896C262.114 167.936 262.161 167.967 262.213 167.989C262.265 168.011 262.321 168.022 262.378 168.022C262.434 168.022 262.49 168.011 262.542 167.989C262.594 167.967 262.641 167.936 262.681 167.896L265.609 164.966C265.65 164.927 265.682 164.88 265.704 164.827C265.726 164.775 265.737 164.719 265.737 164.663C265.738 164.606 265.727 164.55 265.705 164.498C265.684 164.445 265.652 164.398 265.612 164.358C265.572 164.318 265.525 164.286 265.472 164.265C265.42 164.243 265.364 164.232 265.307 164.232C265.251 164.232 265.195 164.244 265.143 164.266C265.091 164.288 265.043 164.32 265.004 164.36L262.377 166.986Z" fill="white"/>
                                        <path opacity="0.2" d="M248 178C248.589 178 412 178 412 178" stroke="white" stroke-miterlimit="10"/>
                                        <path d="M278.881 194V186.727H281.338C281.909 186.727 282.375 186.83 282.737 187.036C283.102 187.24 283.372 187.516 283.547 187.864C283.722 188.212 283.81 188.6 283.81 189.028C283.81 189.457 283.722 189.846 283.547 190.197C283.374 190.547 283.107 190.826 282.744 191.035C282.382 191.241 281.918 191.344 281.352 191.344H279.591V190.562H281.324C281.714 190.562 282.028 190.495 282.265 190.36C282.502 190.225 282.673 190.043 282.78 189.813C282.889 189.581 282.943 189.32 282.943 189.028C282.943 188.737 282.889 188.477 282.78 188.247C282.673 188.018 282.5 187.838 282.261 187.707C282.022 187.575 281.705 187.509 281.31 187.509H279.761V194H278.881ZM291.365 190.364C291.365 191.131 291.226 191.794 290.949 192.352C290.672 192.911 290.292 193.342 289.809 193.645C289.326 193.948 288.775 194.099 288.154 194.099C287.534 194.099 286.983 193.948 286.5 193.645C286.017 193.342 285.637 192.911 285.36 192.352C285.083 191.794 284.944 191.131 284.944 190.364C284.944 189.597 285.083 188.934 285.36 188.375C285.637 187.816 286.017 187.385 286.5 187.082C286.983 186.779 287.534 186.628 288.154 186.628C288.775 186.628 289.326 186.779 289.809 187.082C290.292 187.385 290.672 187.816 290.949 188.375C291.226 188.934 291.365 189.597 291.365 190.364ZM290.512 190.364C290.512 189.734 290.407 189.202 290.196 188.769C289.988 188.336 289.705 188.008 289.348 187.786C288.993 187.563 288.595 187.452 288.154 187.452C287.714 187.452 287.315 187.563 286.958 187.786C286.603 188.008 286.32 188.336 286.109 188.769C285.901 189.202 285.797 189.734 285.797 190.364C285.797 190.993 285.901 191.525 286.109 191.958C286.32 192.391 286.603 192.719 286.958 192.942C287.315 193.164 287.714 193.276 288.154 193.276C288.595 193.276 288.993 193.164 289.348 192.942C289.705 192.719 289.988 192.391 290.196 191.958C290.407 191.525 290.512 190.993 290.512 190.364ZM296.823 188.545C296.78 188.186 296.607 187.906 296.304 187.707C296.001 187.509 295.63 187.409 295.189 187.409C294.867 187.409 294.586 187.461 294.344 187.565C294.105 187.67 293.918 187.813 293.783 187.995C293.65 188.177 293.584 188.384 293.584 188.616C293.584 188.811 293.63 188.978 293.723 189.117C293.817 189.254 293.938 189.369 294.085 189.462C294.232 189.552 294.386 189.626 294.547 189.685C294.708 189.742 294.855 189.788 294.99 189.824L295.729 190.023C295.918 190.072 296.129 190.141 296.361 190.229C296.596 190.316 296.819 190.436 297.032 190.587C297.248 190.737 297.425 190.928 297.565 191.163C297.705 191.397 297.775 191.685 297.775 192.026C297.775 192.419 297.672 192.774 297.466 193.091C297.262 193.408 296.964 193.66 296.571 193.847C296.18 194.034 295.705 194.128 295.147 194.128C294.626 194.128 294.175 194.044 293.794 193.876C293.415 193.708 293.117 193.473 292.899 193.173C292.683 192.872 292.561 192.523 292.533 192.125H293.442C293.466 192.4 293.558 192.627 293.719 192.807C293.882 192.984 294.088 193.117 294.337 193.205C294.588 193.29 294.858 193.332 295.147 193.332C295.483 193.332 295.785 193.278 296.052 193.169C296.32 193.058 296.532 192.904 296.688 192.707C296.844 192.509 296.922 192.277 296.922 192.011C296.922 191.77 296.855 191.573 296.72 191.422C296.585 191.27 296.407 191.147 296.187 191.053C295.967 190.958 295.729 190.875 295.473 190.804L294.578 190.548C294.01 190.385 293.56 190.152 293.229 189.849C292.898 189.546 292.732 189.149 292.732 188.659C292.732 188.252 292.842 187.897 293.062 187.594C293.285 187.288 293.583 187.052 293.957 186.884C294.333 186.713 294.754 186.628 295.218 186.628C295.686 186.628 296.103 186.712 296.468 186.88C296.832 187.046 297.121 187.273 297.334 187.562C297.55 187.851 297.663 188.179 297.675 188.545H296.823Z" fill="white"/>
                                        <path d="M263 185C264.326 185 265.598 185.527 266.536 186.464C267.473 187.402 268 188.674 268 190C268 191.326 267.473 192.598 266.536 193.536C265.598 194.473 264.326 195 263 195C261.674 195 260.402 194.473 259.464 193.536C258.527 192.598 258 191.326 258 190C258 188.674 258.527 187.402 259.464 186.464C260.402 185.527 261.674 185 263 185ZM262.377 190.986L261.266 189.875C261.227 189.835 261.179 189.804 261.127 189.782C261.075 189.76 261.02 189.749 260.963 189.749C260.907 189.749 260.851 189.76 260.799 189.782C260.747 189.804 260.7 189.835 260.66 189.875C260.58 189.955 260.534 190.064 260.534 190.178C260.534 190.292 260.58 190.401 260.66 190.481L262.074 191.896C262.114 191.936 262.161 191.967 262.213 191.989C262.265 192.011 262.321 192.022 262.378 192.022C262.434 192.022 262.49 192.011 262.542 191.989C262.594 191.967 262.641 191.936 262.681 191.896L265.609 188.966C265.65 188.927 265.682 188.88 265.704 188.827C265.726 188.775 265.737 188.719 265.737 188.663C265.738 188.606 265.727 188.55 265.705 188.498C265.684 188.445 265.652 188.398 265.612 188.358C265.572 188.318 265.525 188.286 265.472 188.265C265.42 188.243 265.364 188.232 265.307 188.232C265.251 188.232 265.195 188.244 265.143 188.266C265.091 188.288 265.043 188.32 265.004 188.36L262.377 190.986Z" fill="white"/>
                                        <path opacity="0.2" d="M248 202C248.589 202 412 202 412 202" stroke="white" stroke-miterlimit="10"/>
                                        <path d="M283.653 210.727H284.534V215.543C284.534 216.04 284.417 216.484 284.183 216.874C283.951 217.263 283.623 217.569 283.199 217.794C282.775 218.017 282.278 218.128 281.707 218.128C281.137 218.128 280.64 218.017 280.216 217.794C279.792 217.569 279.463 217.263 279.229 216.874C278.997 216.484 278.881 216.04 278.881 215.543V210.727H279.761V215.472C279.761 215.827 279.839 216.143 279.996 216.42C280.152 216.694 280.375 216.911 280.663 217.07C280.955 217.226 281.303 217.304 281.707 217.304C282.112 217.304 282.46 217.226 282.751 217.07C283.043 216.911 283.265 216.694 283.419 216.42C283.575 216.143 283.653 215.827 283.653 215.472V210.727ZM287.017 214.719V218H286.179V212.545H286.989V213.398H287.06C287.188 213.121 287.382 212.898 287.642 212.73C287.903 212.56 288.239 212.474 288.651 212.474C289.02 212.474 289.343 212.55 289.62 212.702C289.897 212.851 290.113 213.078 290.267 213.384C290.42 213.687 290.497 214.07 290.497 214.534V218H289.659V214.591C289.659 214.162 289.548 213.829 289.325 213.589C289.103 213.348 288.798 213.227 288.409 213.227C288.142 213.227 287.903 213.285 287.692 213.401C287.484 213.517 287.319 213.687 287.198 213.909C287.078 214.132 287.017 214.402 287.017 214.719ZM292.867 210.727V218H292.029V210.727H292.867ZM294.402 218V212.545H295.24V218H294.402ZM294.828 211.636C294.665 211.636 294.524 211.581 294.405 211.469C294.289 211.358 294.231 211.224 294.231 211.068C294.231 210.912 294.289 210.778 294.405 210.667C294.524 210.556 294.665 210.5 294.828 210.5C294.991 210.5 295.131 210.556 295.247 210.667C295.365 210.778 295.425 210.912 295.425 211.068C295.425 211.224 295.365 211.358 295.247 211.469C295.131 211.581 294.991 211.636 294.828 211.636ZM296.775 218V212.545H297.585V213.398H297.656C297.769 213.107 297.953 212.88 298.206 212.719C298.459 212.556 298.763 212.474 299.119 212.474C299.478 212.474 299.778 212.556 300.017 212.719C300.259 212.88 300.447 213.107 300.582 213.398H300.638C300.778 213.116 300.988 212.892 301.267 212.727C301.546 212.558 301.881 212.474 302.272 212.474C302.76 212.474 303.159 212.627 303.469 212.933C303.779 213.236 303.934 213.708 303.934 214.349V218H303.096V214.349C303.096 213.947 302.986 213.659 302.766 213.487C302.545 213.314 302.286 213.227 301.988 213.227C301.604 213.227 301.307 213.343 301.097 213.575C300.886 213.805 300.781 214.096 300.781 214.449V218H299.928V214.264C299.928 213.954 299.828 213.704 299.626 213.515C299.425 213.323 299.166 213.227 298.849 213.227C298.631 213.227 298.427 213.285 298.238 213.401C298.051 213.517 297.899 213.678 297.783 213.884C297.67 214.088 297.613 214.323 297.613 214.591V218H296.775ZM305.466 218V212.545H306.304V218H305.466ZM305.892 211.636C305.729 211.636 305.588 211.581 305.47 211.469C305.354 211.358 305.296 211.224 305.296 211.068C305.296 210.912 305.354 210.778 305.47 210.667C305.588 210.556 305.729 210.5 305.892 210.5C306.056 210.5 306.195 210.556 306.311 210.667C306.43 210.778 306.489 210.912 306.489 211.068C306.489 211.224 306.43 211.358 306.311 211.469C306.195 211.581 306.056 211.636 305.892 211.636ZM310.211 212.545V213.256H307.385V212.545H310.211ZM308.209 211.239H309.047V216.438C309.047 216.674 309.081 216.852 309.15 216.97C309.221 217.086 309.311 217.164 309.42 217.205C309.531 217.242 309.648 217.261 309.771 217.261C309.863 217.261 309.939 217.257 309.998 217.247C310.058 217.235 310.105 217.226 310.14 217.219L310.311 217.972C310.254 217.993 310.175 218.014 310.073 218.036C309.971 218.059 309.842 218.071 309.686 218.071C309.449 218.071 309.217 218.02 308.99 217.918C308.765 217.817 308.578 217.661 308.429 217.453C308.282 217.245 308.209 216.982 308.209 216.665V211.239ZM313.7 218.114C313.175 218.114 312.722 217.998 312.34 217.766C311.962 217.531 311.669 217.205 311.463 216.786C311.26 216.364 311.158 215.874 311.158 215.315C311.158 214.757 311.26 214.264 311.463 213.838C311.669 213.41 311.956 213.076 312.323 212.837C312.692 212.595 313.123 212.474 313.615 212.474C313.899 212.474 314.18 212.522 314.457 212.616C314.734 212.711 314.986 212.865 315.213 213.078C315.441 213.289 315.622 213.568 315.757 213.916C315.892 214.264 315.959 214.693 315.959 215.202V215.557H311.754V214.832H315.107C315.107 214.525 315.045 214.25 314.922 214.009C314.801 213.767 314.628 213.576 314.404 213.437C314.181 213.297 313.918 213.227 313.615 213.227C313.281 213.227 312.993 213.31 312.749 213.476C312.507 213.639 312.321 213.852 312.191 214.115C312.061 214.378 311.996 214.66 311.996 214.96V215.443C311.996 215.855 312.067 216.204 312.209 216.491C312.353 216.775 312.553 216.991 312.809 217.141C313.065 217.287 313.362 217.361 313.7 217.361C313.921 217.361 314.119 217.33 314.297 217.268C314.477 217.205 314.632 217.11 314.762 216.984C314.892 216.857 314.993 216.698 315.064 216.509L315.874 216.736C315.789 217.01 315.645 217.252 315.444 217.46C315.243 217.666 314.994 217.827 314.698 217.943C314.402 218.057 314.07 218.114 313.7 218.114ZM319.294 218.114C318.839 218.114 318.438 217.999 318.09 217.769C317.742 217.537 317.469 217.21 317.273 216.789C317.076 216.365 316.978 215.865 316.978 215.287C316.978 214.714 317.076 214.217 317.273 213.795C317.469 213.374 317.743 213.049 318.093 212.819C318.444 212.589 318.848 212.474 319.308 212.474C319.663 212.474 319.943 212.534 320.149 212.652C320.358 212.768 320.516 212.901 320.625 213.05C320.736 213.196 320.823 213.317 320.884 213.412H320.955V210.727H321.794V218H320.984V217.162H320.884C320.823 217.261 320.735 217.387 320.622 217.538C320.508 217.687 320.346 217.821 320.135 217.94C319.924 218.056 319.644 218.114 319.294 218.114ZM319.407 217.361C319.743 217.361 320.027 217.273 320.259 217.098C320.491 216.92 320.668 216.675 320.789 216.363C320.909 216.048 320.97 215.685 320.97 215.273C320.97 214.866 320.91 214.509 320.792 214.204C320.674 213.896 320.499 213.657 320.267 213.487C320.035 213.314 319.748 213.227 319.407 213.227C319.052 213.227 318.756 213.318 318.519 213.501C318.285 213.681 318.109 213.926 317.99 214.236C317.874 214.544 317.816 214.889 317.816 215.273C317.816 215.661 317.875 216.014 317.994 216.331C318.115 216.646 318.292 216.897 318.526 217.084C318.763 217.268 319.057 217.361 319.407 217.361ZM326.371 218V210.727H328.828C329.399 210.727 329.865 210.83 330.227 211.036C330.592 211.24 330.862 211.516 331.037 211.864C331.212 212.212 331.3 212.6 331.3 213.028C331.3 213.457 331.212 213.846 331.037 214.197C330.864 214.547 330.597 214.826 330.235 215.035C329.872 215.241 329.408 215.344 328.843 215.344H327.081V214.562H328.814C329.205 214.562 329.518 214.495 329.755 214.36C329.992 214.225 330.164 214.043 330.27 213.813C330.379 213.581 330.433 213.32 330.433 213.028C330.433 212.737 330.379 212.477 330.27 212.247C330.164 212.018 329.991 211.838 329.752 211.707C329.512 211.575 329.195 211.509 328.8 211.509H327.252V218H326.371ZM332.605 218V212.545H333.415V213.369H333.471C333.571 213.099 333.751 212.88 334.011 212.712C334.272 212.544 334.565 212.46 334.892 212.46C334.953 212.46 335.03 212.461 335.123 212.464C335.215 212.466 335.285 212.47 335.332 212.474V213.327C335.304 213.32 335.239 213.309 335.137 213.295C335.037 213.278 334.932 213.27 334.821 213.27C334.556 213.27 334.319 213.326 334.111 213.437C333.905 213.546 333.741 213.697 333.621 213.891C333.502 214.083 333.443 214.302 333.443 214.548V218H332.605ZM338.376 218.114C337.883 218.114 337.451 217.996 337.079 217.762C336.71 217.528 336.421 217.2 336.213 216.778C336.007 216.357 335.904 215.865 335.904 215.301C335.904 214.733 336.007 214.237 336.213 213.813C336.421 213.389 336.71 213.06 337.079 212.826C337.451 212.592 337.883 212.474 338.376 212.474C338.868 212.474 339.299 212.592 339.668 212.826C340.04 213.06 340.329 213.389 340.535 213.813C340.743 214.237 340.847 214.733 340.847 215.301C340.847 215.865 340.743 216.357 340.535 216.778C340.329 217.2 340.04 217.528 339.668 217.762C339.299 217.996 338.868 218.114 338.376 218.114ZM338.376 217.361C338.75 217.361 339.057 217.265 339.299 217.073C339.54 216.881 339.719 216.629 339.835 216.317C339.951 216.004 340.009 215.666 340.009 215.301C340.009 214.937 339.951 214.597 339.835 214.282C339.719 213.967 339.54 213.713 339.299 213.518C339.057 213.324 338.75 213.227 338.376 213.227C338.001 213.227 337.694 213.324 337.452 213.518C337.211 213.713 337.032 213.967 336.916 214.282C336.8 214.597 336.742 214.937 336.742 215.301C336.742 215.666 336.8 216.004 336.916 216.317C337.032 216.629 337.211 216.881 337.452 217.073C337.694 217.265 338.001 217.361 338.376 217.361ZM344.186 218.114C343.732 218.114 343.33 217.999 342.982 217.769C342.634 217.537 342.362 217.21 342.165 216.789C341.969 216.365 341.871 215.865 341.871 215.287C341.871 214.714 341.969 214.217 342.165 213.795C342.362 213.374 342.635 213.049 342.986 212.819C343.336 212.589 343.741 212.474 344.2 212.474C344.555 212.474 344.836 212.534 345.042 212.652C345.25 212.768 345.409 212.901 345.518 213.05C345.629 213.196 345.715 213.317 345.777 213.412H345.848V210.727H346.686V218H345.876V217.162H345.777C345.715 217.261 345.628 217.387 345.514 217.538C345.401 217.687 345.238 217.821 345.028 217.94C344.817 218.056 344.536 218.114 344.186 218.114ZM344.3 217.361C344.636 217.361 344.92 217.273 345.152 217.098C345.384 216.92 345.56 216.675 345.681 216.363C345.802 216.048 345.862 215.685 345.862 215.273C345.862 214.866 345.803 214.509 345.685 214.204C345.566 213.896 345.391 213.657 345.159 213.487C344.927 213.314 344.641 213.227 344.3 213.227C343.945 213.227 343.649 213.318 343.412 213.501C343.178 213.681 343.001 213.926 342.883 214.236C342.767 214.544 342.709 214.889 342.709 215.273C342.709 215.661 342.768 216.014 342.886 216.331C343.007 216.646 343.185 216.897 343.419 217.084C343.656 217.268 343.949 217.361 344.3 217.361ZM351.775 215.77V212.545H352.613V218H351.775V217.077H351.718C351.59 217.354 351.391 217.589 351.121 217.783C350.852 217.975 350.511 218.071 350.099 218.071C349.758 218.071 349.455 217.996 349.19 217.847C348.924 217.696 348.716 217.469 348.565 217.165C348.413 216.86 348.337 216.475 348.337 216.011V212.545H349.175V215.955C349.175 216.352 349.287 216.67 349.509 216.906C349.734 217.143 350.021 217.261 350.369 217.261C350.577 217.261 350.789 217.208 351.004 217.102C351.222 216.995 351.404 216.832 351.551 216.612C351.7 216.391 351.775 216.111 351.775 215.77ZM356.364 218.114C355.852 218.114 355.412 217.993 355.043 217.751C354.673 217.51 354.389 217.177 354.191 216.754C353.992 216.33 353.892 215.846 353.892 215.301C353.892 214.747 353.994 214.258 354.198 213.835C354.404 213.408 354.69 213.076 355.057 212.837C355.426 212.595 355.857 212.474 356.35 212.474C356.733 212.474 357.079 212.545 357.387 212.688C357.694 212.83 357.946 213.028 358.143 213.284C358.339 213.54 358.461 213.838 358.509 214.179H357.671C357.607 213.93 357.465 213.71 357.244 213.518C357.027 213.324 356.733 213.227 356.364 213.227C356.037 213.227 355.751 213.312 355.504 213.483C355.261 213.651 355.07 213.889 354.933 214.197C354.798 214.502 354.73 214.861 354.73 215.273C354.73 215.694 354.797 216.061 354.929 216.374C355.064 216.686 355.253 216.929 355.497 217.102C355.744 217.274 356.032 217.361 356.364 217.361C356.582 217.361 356.779 217.323 356.957 217.247C357.134 217.171 357.285 217.062 357.408 216.92C357.531 216.778 357.619 216.608 357.671 216.409H358.509C358.461 216.731 358.344 217.021 358.157 217.279C357.972 217.535 357.727 217.738 357.422 217.89C357.119 218.039 356.766 218.114 356.364 218.114ZM362.106 212.545V213.256H359.279V212.545H362.106ZM360.103 211.239H360.941V216.438C360.941 216.674 360.976 216.852 361.044 216.97C361.115 217.086 361.205 217.164 361.314 217.205C361.425 217.242 361.543 217.261 361.666 217.261C361.758 217.261 361.834 217.257 361.893 217.247C361.952 217.235 361.999 217.226 362.035 217.219L362.205 217.972C362.149 217.993 362.069 218.014 361.968 218.036C361.866 218.059 361.737 218.071 361.58 218.071C361.344 218.071 361.112 218.02 360.884 217.918C360.66 217.817 360.472 217.661 360.323 217.453C360.177 217.245 360.103 216.982 360.103 216.665V211.239ZM367.133 213.767L366.38 213.98C366.332 213.855 366.263 213.733 366.17 213.614C366.08 213.494 365.957 213.394 365.801 213.316C365.645 213.238 365.445 213.199 365.201 213.199C364.867 213.199 364.589 213.276 364.366 213.43C364.146 213.581 364.036 213.774 364.036 214.009C364.036 214.217 364.112 214.381 364.263 214.502C364.415 214.623 364.652 214.723 364.974 214.804L365.783 215.003C366.271 215.121 366.634 215.302 366.873 215.546C367.113 215.788 367.232 216.099 367.232 216.48C367.232 216.793 367.142 217.072 366.962 217.318C366.785 217.564 366.536 217.759 366.216 217.901C365.897 218.043 365.525 218.114 365.101 218.114C364.545 218.114 364.085 217.993 363.72 217.751C363.355 217.51 363.125 217.157 363.028 216.693L363.823 216.494C363.899 216.788 364.042 217.008 364.253 217.155C364.466 217.302 364.744 217.375 365.087 217.375C365.478 217.375 365.788 217.292 366.018 217.126C366.25 216.958 366.366 216.757 366.366 216.523C366.366 216.333 366.299 216.175 366.167 216.047C366.034 215.917 365.831 215.82 365.556 215.756L364.647 215.543C364.147 215.424 363.78 215.241 363.546 214.992C363.314 214.741 363.198 214.428 363.198 214.051C363.198 213.743 363.284 213.471 363.457 213.234C363.632 212.998 363.87 212.812 364.171 212.677C364.474 212.542 364.817 212.474 365.201 212.474C365.741 212.474 366.164 212.593 366.472 212.83C366.782 213.066 367.002 213.379 367.133 213.767Z" fill="white"/>
                                        <path d="M263 209C264.326 209 265.598 209.527 266.536 210.464C267.473 211.402 268 212.674 268 214C268 215.326 267.473 216.598 266.536 217.536C265.598 218.473 264.326 219 263 219C261.674 219 260.402 218.473 259.464 217.536C258.527 216.598 258 215.326 258 214C258 212.674 258.527 211.402 259.464 210.464C260.402 209.527 261.674 209 263 209ZM262.377 214.986L261.266 213.875C261.227 213.835 261.179 213.804 261.127 213.782C261.075 213.76 261.02 213.749 260.963 213.749C260.907 213.749 260.851 213.76 260.799 213.782C260.747 213.804 260.7 213.835 260.66 213.875C260.58 213.955 260.534 214.064 260.534 214.178C260.534 214.292 260.58 214.401 260.66 214.481L262.074 215.896C262.114 215.936 262.161 215.967 262.213 215.989C262.265 216.011 262.321 216.022 262.378 216.022C262.434 216.022 262.49 216.011 262.542 215.989C262.594 215.967 262.641 215.936 262.681 215.896L265.609 212.966C265.65 212.927 265.682 212.88 265.704 212.827C265.726 212.775 265.737 212.719 265.737 212.663C265.738 212.606 265.727 212.55 265.705 212.498C265.684 212.445 265.652 212.398 265.612 212.358C265.572 212.318 265.525 212.286 265.472 212.265C265.42 212.243 265.364 212.232 265.307 212.232C265.251 212.232 265.195 212.244 265.143 212.266C265.091 212.288 265.043 212.32 265.004 212.36L262.377 214.986Z" fill="white"/>
                                        <path opacity="0.2" d="M248 226C248.589 226 412 226 412 226" stroke="white" stroke-miterlimit="10"/>
                                        <path d="M283.653 234.727H284.534V239.543C284.534 240.04 284.417 240.484 284.183 240.874C283.951 241.263 283.623 241.569 283.199 241.794C282.775 242.017 282.278 242.128 281.707 242.128C281.137 242.128 280.64 242.017 280.216 241.794C279.792 241.569 279.463 241.263 279.229 240.874C278.997 240.484 278.881 240.04 278.881 239.543V234.727H279.761V239.472C279.761 239.827 279.839 240.143 279.996 240.42C280.152 240.694 280.375 240.911 280.663 241.07C280.955 241.226 281.303 241.304 281.707 241.304C282.112 241.304 282.46 241.226 282.751 241.07C283.043 240.911 283.265 240.694 283.419 240.42C283.575 240.143 283.653 239.827 283.653 239.472V234.727ZM287.017 238.719V242H286.179V236.545H286.989V237.398H287.06C287.188 237.121 287.382 236.898 287.642 236.73C287.903 236.56 288.239 236.474 288.651 236.474C289.02 236.474 289.343 236.55 289.62 236.702C289.897 236.851 290.113 237.078 290.267 237.384C290.42 237.687 290.497 238.07 290.497 238.534V242H289.659V238.591C289.659 238.162 289.548 237.829 289.325 237.589C289.103 237.348 288.798 237.227 288.409 237.227C288.142 237.227 287.903 237.285 287.692 237.401C287.484 237.517 287.319 237.687 287.198 237.909C287.078 238.132 287.017 238.402 287.017 238.719ZM292.867 234.727V242H292.029V234.727H292.867ZM294.402 242V236.545H295.24V242H294.402ZM294.828 235.636C294.665 235.636 294.524 235.581 294.405 235.469C294.289 235.358 294.231 235.224 294.231 235.068C294.231 234.912 294.289 234.778 294.405 234.667C294.524 234.556 294.665 234.5 294.828 234.5C294.991 234.5 295.131 234.556 295.247 234.667C295.365 234.778 295.425 234.912 295.425 235.068C295.425 235.224 295.365 235.358 295.247 235.469C295.131 235.581 294.991 235.636 294.828 235.636ZM296.775 242V236.545H297.585V237.398H297.656C297.769 237.107 297.953 236.88 298.206 236.719C298.459 236.556 298.763 236.474 299.119 236.474C299.478 236.474 299.778 236.556 300.017 236.719C300.259 236.88 300.447 237.107 300.582 237.398H300.638C300.778 237.116 300.988 236.892 301.267 236.727C301.546 236.558 301.881 236.474 302.272 236.474C302.76 236.474 303.159 236.627 303.469 236.933C303.779 237.236 303.934 237.708 303.934 238.349V242H303.096V238.349C303.096 237.947 302.986 237.659 302.766 237.487C302.545 237.314 302.286 237.227 301.988 237.227C301.604 237.227 301.307 237.343 301.097 237.575C300.886 237.805 300.781 238.096 300.781 238.449V242H299.928V238.264C299.928 237.954 299.828 237.704 299.626 237.515C299.425 237.323 299.166 237.227 298.849 237.227C298.631 237.227 298.427 237.285 298.238 237.401C298.051 237.517 297.899 237.678 297.783 237.884C297.67 238.088 297.613 238.323 297.613 238.591V242H296.775ZM305.466 242V236.545H306.304V242H305.466ZM305.892 235.636C305.729 235.636 305.588 235.581 305.47 235.469C305.354 235.358 305.296 235.224 305.296 235.068C305.296 234.912 305.354 234.778 305.47 234.667C305.588 234.556 305.729 234.5 305.892 234.5C306.056 234.5 306.195 234.556 306.311 234.667C306.43 234.778 306.489 234.912 306.489 235.068C306.489 235.224 306.43 235.358 306.311 235.469C306.195 235.581 306.056 235.636 305.892 235.636ZM310.211 236.545V237.256H307.385V236.545H310.211ZM308.209 235.239H309.047V240.438C309.047 240.674 309.081 240.852 309.15 240.97C309.221 241.086 309.311 241.164 309.42 241.205C309.531 241.242 309.648 241.261 309.771 241.261C309.863 241.261 309.939 241.257 309.998 241.247C310.058 241.235 310.105 241.226 310.14 241.219L310.311 241.972C310.254 241.993 310.175 242.014 310.073 242.036C309.971 242.059 309.842 242.071 309.686 242.071C309.449 242.071 309.217 242.02 308.99 241.918C308.765 241.817 308.578 241.661 308.429 241.453C308.282 241.245 308.209 240.982 308.209 240.665V235.239ZM313.7 242.114C313.175 242.114 312.722 241.998 312.34 241.766C311.962 241.531 311.669 241.205 311.463 240.786C311.26 240.364 311.158 239.874 311.158 239.315C311.158 238.757 311.26 238.264 311.463 237.838C311.669 237.41 311.956 237.076 312.323 236.837C312.692 236.595 313.123 236.474 313.615 236.474C313.899 236.474 314.18 236.522 314.457 236.616C314.734 236.711 314.986 236.865 315.213 237.078C315.441 237.289 315.622 237.568 315.757 237.916C315.892 238.264 315.959 238.693 315.959 239.202V239.557H311.754V238.832H315.107C315.107 238.525 315.045 238.25 314.922 238.009C314.801 237.767 314.628 237.576 314.404 237.437C314.181 237.297 313.918 237.227 313.615 237.227C313.281 237.227 312.993 237.31 312.749 237.476C312.507 237.639 312.321 237.852 312.191 238.115C312.061 238.378 311.996 238.66 311.996 238.96V239.443C311.996 239.855 312.067 240.204 312.209 240.491C312.353 240.775 312.553 240.991 312.809 241.141C313.065 241.287 313.362 241.361 313.7 241.361C313.921 241.361 314.119 241.33 314.297 241.268C314.477 241.205 314.632 241.11 314.762 240.984C314.892 240.857 314.993 240.698 315.064 240.509L315.874 240.736C315.789 241.01 315.645 241.252 315.444 241.46C315.243 241.666 314.994 241.827 314.698 241.943C314.402 242.057 314.07 242.114 313.7 242.114ZM319.294 242.114C318.839 242.114 318.438 241.999 318.09 241.769C317.742 241.537 317.469 241.21 317.273 240.789C317.076 240.365 316.978 239.865 316.978 239.287C316.978 238.714 317.076 238.217 317.273 237.795C317.469 237.374 317.743 237.049 318.093 236.819C318.444 236.589 318.848 236.474 319.308 236.474C319.663 236.474 319.943 236.534 320.149 236.652C320.358 236.768 320.516 236.901 320.625 237.05C320.736 237.196 320.823 237.317 320.884 237.412H320.955V234.727H321.794V242H320.984V241.162H320.884C320.823 241.261 320.735 241.387 320.622 241.538C320.508 241.687 320.346 241.821 320.135 241.94C319.924 242.056 319.644 242.114 319.294 242.114ZM319.407 241.361C319.743 241.361 320.027 241.273 320.259 241.098C320.491 240.92 320.668 240.675 320.789 240.363C320.909 240.048 320.97 239.685 320.97 239.273C320.97 238.866 320.91 238.509 320.792 238.204C320.674 237.896 320.499 237.657 320.267 237.487C320.035 237.314 319.748 237.227 319.407 237.227C319.052 237.227 318.756 237.318 318.519 237.501C318.285 237.681 318.109 237.926 317.99 238.236C317.874 238.544 317.816 238.889 317.816 239.273C317.816 239.661 317.875 240.014 317.994 240.331C318.115 240.646 318.292 240.897 318.526 241.084C318.763 241.268 319.057 241.361 319.407 241.361ZM332.507 238.364C332.507 239.131 332.369 239.794 332.092 240.352C331.815 240.911 331.435 241.342 330.952 241.645C330.469 241.948 329.917 242.099 329.297 242.099C328.677 242.099 328.125 241.948 327.642 241.645C327.159 241.342 326.779 240.911 326.502 240.352C326.225 239.794 326.087 239.131 326.087 238.364C326.087 237.597 326.225 236.934 326.502 236.375C326.779 235.816 327.159 235.385 327.642 235.082C328.125 234.779 328.677 234.628 329.297 234.628C329.917 234.628 330.469 234.779 330.952 235.082C331.435 235.385 331.815 235.816 332.092 236.375C332.369 236.934 332.507 237.597 332.507 238.364ZM331.655 238.364C331.655 237.734 331.55 237.202 331.339 236.769C331.131 236.336 330.848 236.008 330.49 235.786C330.135 235.563 329.737 235.452 329.297 235.452C328.857 235.452 328.458 235.563 328.1 235.786C327.745 236.008 327.462 236.336 327.252 236.769C327.043 237.202 326.939 237.734 326.939 238.364C326.939 238.993 327.043 239.525 327.252 239.958C327.462 240.391 327.745 240.719 328.1 240.942C328.458 241.164 328.857 241.276 329.297 241.276C329.737 241.276 330.135 241.164 330.49 240.942C330.848 240.719 331.131 240.391 331.339 239.958C331.55 239.525 331.655 238.993 331.655 238.364ZM333.874 242V236.545H334.684V237.369H334.741C334.84 237.099 335.02 236.88 335.281 236.712C335.541 236.544 335.835 236.46 336.161 236.46C336.223 236.46 336.3 236.461 336.392 236.464C336.485 236.466 336.554 236.47 336.602 236.474V237.327C336.573 237.32 336.508 237.309 336.406 237.295C336.307 237.278 336.202 237.27 336.09 237.27C335.825 237.27 335.588 237.326 335.38 237.437C335.174 237.546 335.011 237.697 334.89 237.891C334.772 238.083 334.713 238.302 334.713 238.548V242H333.874ZM339.489 242.114C339.034 242.114 338.633 241.999 338.285 241.769C337.937 241.537 337.665 241.21 337.468 240.789C337.272 240.365 337.173 239.865 337.173 239.287C337.173 238.714 337.272 238.217 337.468 237.795C337.665 237.374 337.938 237.049 338.289 236.819C338.639 236.589 339.044 236.474 339.503 236.474C339.858 236.474 340.139 236.534 340.345 236.652C340.553 236.768 340.712 236.901 340.82 237.05C340.932 237.196 341.018 237.317 341.08 237.412H341.151V234.727H341.989V242H341.179V241.162H341.08C341.018 241.261 340.931 241.387 340.817 241.538C340.703 241.687 340.541 241.821 340.33 241.94C340.12 242.056 339.839 242.114 339.489 242.114ZM339.602 241.361C339.939 241.361 340.223 241.273 340.455 241.098C340.687 240.92 340.863 240.675 340.984 240.363C341.105 240.048 341.165 239.685 341.165 239.273C341.165 238.866 341.106 238.509 340.987 238.204C340.869 237.896 340.694 237.657 340.462 237.487C340.23 237.314 339.943 237.227 339.602 237.227C339.247 237.227 338.951 237.318 338.715 237.501C338.48 237.681 338.304 237.926 338.186 238.236C338.07 238.544 338.012 238.889 338.012 239.273C338.012 239.661 338.071 240.014 338.189 240.331C338.31 240.646 338.487 240.897 338.722 241.084C338.959 241.268 339.252 241.361 339.602 241.361ZM345.927 242.114C345.401 242.114 344.948 241.998 344.567 241.766C344.188 241.531 343.896 241.205 343.69 240.786C343.486 240.364 343.384 239.874 343.384 239.315C343.384 238.757 343.486 238.264 343.69 237.838C343.896 237.41 344.182 237.076 344.549 236.837C344.919 236.595 345.349 236.474 345.842 236.474C346.126 236.474 346.406 236.522 346.683 236.616C346.96 236.711 347.213 236.865 347.44 237.078C347.667 237.289 347.848 237.568 347.983 237.916C348.118 238.264 348.186 238.693 348.186 239.202V239.557H343.981V238.832H347.333C347.333 238.525 347.272 238.25 347.149 238.009C347.028 237.767 346.855 237.576 346.63 237.437C346.408 237.297 346.145 237.227 345.842 237.227C345.508 237.227 345.219 237.31 344.975 237.476C344.734 237.639 344.548 237.852 344.418 238.115C344.288 238.378 344.222 238.66 344.222 238.96V239.443C344.222 239.855 344.294 240.204 344.436 240.491C344.58 240.775 344.78 240.991 345.036 241.141C345.291 241.287 345.588 241.361 345.927 241.361C346.147 241.361 346.346 241.33 346.524 241.268C346.704 241.205 346.859 241.11 346.989 240.984C347.119 240.857 347.22 240.698 347.291 240.509L348.1 240.736C348.015 241.01 347.872 241.252 347.671 241.46C347.469 241.666 347.221 241.827 346.925 241.943C346.629 242.057 346.296 242.114 345.927 242.114ZM349.46 242V236.545H350.27V237.369H350.327C350.426 237.099 350.606 236.88 350.867 236.712C351.127 236.544 351.421 236.46 351.747 236.46C351.809 236.46 351.886 236.461 351.978 236.464C352.07 236.466 352.14 236.47 352.188 236.474V237.327C352.159 237.32 352.094 237.309 351.992 237.295C351.893 237.278 351.788 237.27 351.676 237.27C351.411 237.27 351.174 237.326 350.966 237.437C350.76 237.546 350.597 237.697 350.476 237.891C350.358 238.083 350.298 238.302 350.298 238.548V242H349.46ZM357.045 237.767L356.292 237.98C356.245 237.855 356.175 237.733 356.082 237.614C355.992 237.494 355.869 237.394 355.713 237.316C355.557 237.238 355.357 237.199 355.113 237.199C354.779 237.199 354.501 237.276 354.278 237.43C354.058 237.581 353.948 237.774 353.948 238.009C353.948 238.217 354.024 238.381 354.175 238.502C354.327 238.623 354.564 238.723 354.886 238.804L355.695 239.003C356.183 239.121 356.546 239.302 356.786 239.546C357.025 239.788 357.144 240.099 357.144 240.48C357.144 240.793 357.054 241.072 356.874 241.318C356.697 241.564 356.448 241.759 356.129 241.901C355.809 242.043 355.437 242.114 355.013 242.114C354.457 242.114 353.997 241.993 353.632 241.751C353.268 241.51 353.037 241.157 352.94 240.693L353.735 240.494C353.811 240.788 353.954 241.008 354.165 241.155C354.378 241.302 354.656 241.375 354.999 241.375C355.39 241.375 355.7 241.292 355.93 241.126C356.162 240.958 356.278 240.757 356.278 240.523C356.278 240.333 356.211 240.175 356.079 240.047C355.946 239.917 355.743 239.82 355.468 239.756L354.559 239.543C354.059 239.424 353.692 239.241 353.458 238.992C353.226 238.741 353.11 238.428 353.11 238.051C353.11 237.743 353.196 237.471 353.369 237.234C353.545 236.998 353.782 236.812 354.083 236.677C354.386 236.542 354.729 236.474 355.113 236.474C355.653 236.474 356.076 236.593 356.384 236.83C356.694 237.066 356.915 237.379 357.045 237.767Z" fill="white"/>
                                        <path d="M263 233C264.326 233 265.598 233.527 266.536 234.464C267.473 235.402 268 236.674 268 238C268 239.326 267.473 240.598 266.536 241.536C265.598 242.473 264.326 243 263 243C261.674 243 260.402 242.473 259.464 241.536C258.527 240.598 258 239.326 258 238C258 236.674 258.527 235.402 259.464 234.464C260.402 233.527 261.674 233 263 233ZM262.377 238.986L261.266 237.875C261.227 237.835 261.179 237.804 261.127 237.782C261.075 237.76 261.02 237.749 260.963 237.749C260.907 237.749 260.851 237.76 260.799 237.782C260.747 237.804 260.7 237.835 260.66 237.875C260.58 237.955 260.534 238.064 260.534 238.178C260.534 238.292 260.58 238.401 260.66 238.481L262.074 239.896C262.114 239.936 262.161 239.967 262.213 239.989C262.265 240.011 262.321 240.022 262.378 240.022C262.434 240.022 262.49 240.011 262.542 239.989C262.594 239.967 262.641 239.936 262.681 239.896L265.609 236.966C265.65 236.927 265.682 236.88 265.704 236.827C265.726 236.775 265.737 236.719 265.737 236.663C265.738 236.606 265.727 236.55 265.705 236.498C265.684 236.445 265.652 236.398 265.612 236.358C265.572 236.318 265.525 236.286 265.472 236.265C265.42 236.243 265.364 236.232 265.307 236.232C265.251 236.232 265.195 236.244 265.143 236.266C265.091 236.288 265.043 236.32 265.004 236.36L262.377 238.986Z" fill="white"/>
                                        <path d="M288.472 61.5625C288.419 61.0663 288.195 60.6799 287.801 60.4034C287.411 60.1269 286.903 59.9886 286.278 59.9886C285.839 59.9886 285.462 60.0549 285.148 60.1875C284.833 60.3201 284.593 60.5 284.426 60.7273C284.259 60.9545 284.174 61.214 284.17 61.5057C284.17 61.7481 284.225 61.9583 284.335 62.1364C284.449 62.3144 284.602 62.4659 284.795 62.5909C284.989 62.7121 285.203 62.8144 285.438 62.8977C285.672 62.9811 285.909 63.0511 286.148 63.108L287.239 63.3807C287.678 63.483 288.1 63.6212 288.506 63.7955C288.915 63.9697 289.28 64.1894 289.602 64.4545C289.928 64.7197 290.186 65.0398 290.375 65.4148C290.564 65.7898 290.659 66.2292 290.659 66.733C290.659 67.4148 290.485 68.0152 290.136 68.5341C289.788 69.0492 289.284 69.4527 288.625 69.7443C287.97 70.0322 287.176 70.1761 286.244 70.1761C285.339 70.1761 284.553 70.036 283.886 69.7557C283.223 69.4754 282.705 69.0663 282.33 68.5284C281.958 67.9905 281.758 67.3352 281.727 66.5625H283.801C283.831 66.9678 283.956 67.3049 284.176 67.5739C284.396 67.8428 284.682 68.0436 285.034 68.1761C285.39 68.3087 285.788 68.375 286.227 68.375C286.686 68.375 287.087 68.3068 287.432 68.1705C287.78 68.0303 288.053 67.8371 288.25 67.5909C288.447 67.3409 288.547 67.0492 288.551 66.7159C288.547 66.4129 288.458 66.1629 288.284 65.9659C288.11 65.7652 287.866 65.5985 287.551 65.4659C287.241 65.3295 286.877 65.2083 286.46 65.1023L285.136 64.7614C284.178 64.5152 283.42 64.142 282.864 63.642C282.311 63.1383 282.034 62.4697 282.034 61.6364C282.034 60.9508 282.22 60.3504 282.591 59.8352C282.966 59.3201 283.475 58.9205 284.119 58.6364C284.763 58.3485 285.492 58.2045 286.307 58.2045C287.133 58.2045 287.856 58.3485 288.477 58.6364C289.102 58.9205 289.593 59.3163 289.949 59.8239C290.305 60.3277 290.489 60.9072 290.5 61.5625H288.472ZM292.027 60.1307V58.3636H301.311V60.1307H297.714V70H295.624V60.1307H292.027ZM303.189 70H300.939L305.036 58.3636H307.638L311.74 70H309.49L306.382 60.75H306.291L303.189 70ZM303.263 65.4375H309.399V67.1307H303.263V65.4375ZM322.835 58.3636V70H320.96L315.477 62.0739H315.381V70H313.273V58.3636H315.159L320.636 66.2955H320.739V58.3636H322.835ZM329.075 70H325.132V58.3636H329.155C330.31 58.3636 331.303 58.5966 332.132 59.0625C332.965 59.5246 333.606 60.1894 334.053 61.0568C334.5 61.9242 334.723 62.9621 334.723 64.1705C334.723 65.3826 334.498 66.4242 334.047 67.2955C333.6 68.1667 332.954 68.8352 332.109 69.3011C331.268 69.767 330.257 70 329.075 70ZM327.24 68.1761H328.973C329.784 68.1761 330.46 68.0284 331.001 67.733C331.543 67.4337 331.95 66.9886 332.223 66.3977C332.496 65.803 332.632 65.0606 332.632 64.1705C332.632 63.2803 332.496 62.5417 332.223 61.9545C331.95 61.3636 331.547 60.9223 331.013 60.6307C330.482 60.3352 329.823 60.1875 329.036 60.1875H327.24V68.1761ZM337.595 70H335.345L339.442 58.3636H342.044L346.146 70H343.896L340.788 60.75H340.697L337.595 70ZM337.669 65.4375H343.805V67.1307H337.669V65.4375ZM347.679 70V58.3636H352.043C352.937 58.3636 353.687 58.5189 354.293 58.8295C354.902 59.1402 355.363 59.5758 355.673 60.1364C355.988 60.6932 356.145 61.3428 356.145 62.0852C356.145 62.8314 355.986 63.4792 355.668 64.0284C355.353 64.5739 354.889 64.9962 354.276 65.2955C353.662 65.5909 352.908 65.7386 352.014 65.7386H348.906V63.9886H351.73C352.253 63.9886 352.681 63.9167 353.014 63.7727C353.348 63.625 353.594 63.411 353.753 63.1307C353.916 62.8466 353.997 62.4981 353.997 62.0852C353.997 61.6723 353.916 61.3201 353.753 61.0284C353.59 60.733 353.342 60.5095 353.009 60.358C352.675 60.2027 352.245 60.125 351.719 60.125H349.787V70H347.679ZM353.69 64.7273L356.571 70H354.219L351.389 64.7273H353.69ZM358.085 70V58.3636H365.653V60.1307H360.193V63.2898H365.261V65.0568H360.193V68.233H365.699V70H358.085ZM371.747 70H367.804V58.3636H371.827C372.982 58.3636 373.974 58.5966 374.804 59.0625C375.637 59.5246 376.277 60.1894 376.724 61.0568C377.171 61.9242 377.395 62.9621 377.395 64.1705C377.395 65.3826 377.17 66.4242 376.719 67.2955C376.272 68.1667 375.626 68.8352 374.781 69.3011C373.94 69.767 372.929 70 371.747 70ZM369.912 68.1761H371.645C372.455 68.1761 373.132 68.0284 373.673 67.733C374.215 67.4337 374.622 66.9886 374.895 66.3977C375.168 65.803 375.304 65.0606 375.304 64.1705C375.304 63.2803 375.168 62.5417 374.895 61.9545C374.622 61.3636 374.219 60.9223 373.685 60.6307C373.154 60.3352 372.495 60.1875 371.707 60.1875H369.912V68.1761Z" fill="#F9F8F7"/>
                                        <path d="M315.027 95.781V94H318.072V95.781C320.71 96.327 322.066 98.3768 322.066 101.628V102.376H318.547V101.384C318.547 99.6789 317.873 99.0236 316.683 99.0236C315.501 99.0236 314.819 99.6705 314.819 101.384C314.819 106.307 322.1 106.542 322.1 113.381C322.1 116.623 320.71 118.715 318.072 119.261V121H315.027V119.261C312.356 118.715 311 116.632 311 113.381V111.742H314.52V113.624C314.52 115.329 315.26 115.951 316.45 115.951C317.631 115.951 318.38 115.338 318.38 113.624C318.38 108.701 311.1 108.466 311.1 101.628C311.1 98.4104 312.423 96.3606 315.027 95.781Z" fill="white"/>
                                        <path d="M331.785 101.418C331.785 99.2673 331.044 98.6877 329.854 98.6877C328.673 98.6877 327.924 99.3345 327.924 101.048V102.586H324.404V101.283C324.404 97.4528 326.301 95.2686 329.954 95.2686C333.607 95.2686 335.504 97.4528 335.504 101.283V101.897C335.504 104.459 334.688 106.064 332.9 106.82C334.763 107.643 335.504 109.415 335.504 111.843V113.725C335.504 117.556 333.607 119.74 329.954 119.74C326.301 119.74 324.404 117.556 324.404 113.725V111.742H327.924V113.96C327.924 115.666 328.673 116.321 329.854 116.321C331.036 116.321 331.785 115.741 331.785 113.624V111.742C331.785 109.525 331.044 108.701 329.347 108.701H328.09V105.282H329.546C330.936 105.282 331.776 104.669 331.776 102.754V101.418H331.785Z" fill="white"/>
                                        <path d="M337.701 101.283C337.701 97.4528 339.698 95.2686 343.351 95.2686C347.004 95.2686 349 97.4528 349 101.283V113.725C349 117.556 347.004 119.74 343.351 119.74C339.698 119.74 337.701 117.556 337.701 113.725V101.283ZM341.429 113.96C341.429 115.666 342.178 116.321 343.359 116.321C344.541 116.321 345.289 115.674 345.289 113.96V101.04C345.289 99.3345 344.549 98.6793 343.359 98.6793C342.178 98.6793 341.429 99.3261 341.429 101.04V113.96Z" fill="white"/>
                                        <path opacity="0.2" d="M290.494 143.652V143.494H368.991V143.652H290.494Z" fill="white" stroke="white" stroke-width="0.988628"/>
                                        <path d="M314.206 136.099C313.907 136.095 313.609 136.038 313.311 135.929C313.013 135.82 312.74 135.637 312.494 135.379C312.248 135.118 312.05 134.767 311.901 134.324C311.752 133.879 311.677 133.32 311.677 132.648C311.677 132.004 311.738 131.433 311.858 130.936C311.979 130.437 312.154 130.016 312.384 129.675C312.614 129.332 312.891 129.072 313.215 128.894C313.542 128.717 313.91 128.628 314.319 128.628C314.727 128.628 315.089 128.71 315.406 128.873C315.726 129.034 315.986 129.259 316.187 129.548C316.388 129.836 316.519 130.169 316.578 130.545H315.711C315.631 130.219 315.475 129.948 315.243 129.732C315.011 129.517 314.703 129.409 314.319 129.409C313.756 129.409 313.312 129.654 312.988 130.144C312.666 130.634 312.504 131.322 312.501 132.207H312.558C312.691 132.006 312.848 131.835 313.03 131.692C313.215 131.548 313.419 131.437 313.641 131.359C313.864 131.281 314.099 131.241 314.348 131.241C314.764 131.241 315.146 131.346 315.491 131.554C315.837 131.76 316.114 132.045 316.322 132.41C316.531 132.772 316.635 133.188 316.635 133.656C316.635 134.106 316.534 134.518 316.333 134.892C316.132 135.264 315.849 135.56 315.484 135.78C315.122 135.998 314.696 136.104 314.206 136.099ZM314.206 135.318C314.504 135.318 314.772 135.244 315.008 135.094C315.247 134.945 315.436 134.745 315.573 134.494C315.713 134.243 315.782 133.964 315.782 133.656C315.782 133.356 315.715 133.082 315.58 132.836C315.447 132.587 315.264 132.39 315.03 132.243C314.798 132.096 314.532 132.023 314.234 132.023C314.009 132.023 313.8 132.068 313.606 132.158C313.411 132.245 313.241 132.366 313.094 132.52C312.95 132.674 312.836 132.85 312.753 133.049C312.67 133.246 312.629 133.453 312.629 133.67C312.629 133.959 312.696 134.229 312.831 134.48C312.969 134.731 313.156 134.933 313.392 135.087C313.632 135.241 313.903 135.318 314.206 135.318ZM320.403 136.099C319.868 136.099 319.413 135.954 319.036 135.663C318.66 135.369 318.372 134.944 318.173 134.388C317.974 133.829 317.875 133.154 317.875 132.364C317.875 131.578 317.974 130.906 318.173 130.35C318.374 129.791 318.663 129.365 319.04 129.072C319.418 128.776 319.873 128.628 320.403 128.628C320.934 128.628 321.387 128.776 321.763 129.072C322.142 129.365 322.431 129.791 322.63 130.35C322.831 130.906 322.932 131.578 322.932 132.364C322.932 133.154 322.832 133.829 322.633 134.388C322.435 134.944 322.147 135.369 321.771 135.663C321.394 135.954 320.938 136.099 320.403 136.099ZM320.403 135.318C320.934 135.318 321.346 135.062 321.639 134.551C321.933 134.04 322.079 133.311 322.079 132.364C322.079 131.734 322.012 131.198 321.877 130.755C321.744 130.312 321.553 129.975 321.302 129.743C321.053 129.511 320.754 129.395 320.403 129.395C319.878 129.395 319.467 129.654 319.171 130.173C318.875 130.689 318.727 131.419 318.727 132.364C318.727 132.993 318.793 133.528 318.926 133.969C319.059 134.409 319.249 134.744 319.498 134.974C319.749 135.203 320.051 135.318 320.403 135.318ZM329.168 136.114C328.713 136.114 328.312 135.999 327.964 135.769C327.616 135.537 327.343 135.21 327.147 134.789C326.95 134.365 326.852 133.865 326.852 133.287C326.852 132.714 326.95 132.217 327.147 131.795C327.343 131.374 327.617 131.049 327.967 130.819C328.318 130.589 328.722 130.474 329.182 130.474C329.537 130.474 329.817 130.534 330.023 130.652C330.232 130.768 330.39 130.901 330.499 131.05C330.61 131.196 330.697 131.317 330.758 131.412H330.829V128.727H331.668V136H330.858V135.162H330.758C330.697 135.261 330.609 135.387 330.496 135.538C330.382 135.687 330.22 135.821 330.009 135.94C329.798 136.056 329.518 136.114 329.168 136.114ZM329.281 135.361C329.617 135.361 329.901 135.273 330.133 135.098C330.365 134.92 330.542 134.675 330.663 134.363C330.783 134.048 330.844 133.685 330.844 133.273C330.844 132.866 330.784 132.509 330.666 132.204C330.548 131.896 330.373 131.657 330.141 131.487C329.909 131.314 329.622 131.227 329.281 131.227C328.926 131.227 328.63 131.318 328.393 131.501C328.159 131.681 327.983 131.926 327.864 132.236C327.748 132.544 327.69 132.889 327.69 133.273C327.69 133.661 327.749 134.014 327.868 134.331C327.989 134.646 328.166 134.897 328.4 135.084C328.637 135.268 328.931 135.361 329.281 135.361ZM334.924 136.128C334.578 136.128 334.265 136.063 333.983 135.933C333.701 135.8 333.477 135.609 333.312 135.361C333.146 135.11 333.063 134.807 333.063 134.452C333.063 134.139 333.125 133.886 333.248 133.692C333.371 133.495 333.535 133.341 333.741 133.23C333.947 133.119 334.175 133.036 334.423 132.982C334.674 132.925 334.926 132.88 335.18 132.847C335.511 132.804 335.78 132.772 335.986 132.751C336.194 132.727 336.346 132.688 336.44 132.634C336.537 132.579 336.586 132.484 336.586 132.349V132.321C336.586 131.971 336.49 131.698 336.298 131.504C336.109 131.31 335.821 131.213 335.435 131.213C335.035 131.213 334.722 131.301 334.494 131.476C334.267 131.651 334.107 131.838 334.015 132.037L333.219 131.753C333.361 131.421 333.551 131.163 333.788 130.979C334.027 130.792 334.287 130.661 334.569 130.588C334.853 130.512 335.132 130.474 335.407 130.474C335.582 130.474 335.783 130.496 336.011 130.538C336.24 130.579 336.462 130.663 336.675 130.79C336.89 130.918 337.069 131.111 337.211 131.369C337.353 131.627 337.424 131.973 337.424 132.406V136H336.586V135.261H336.543C336.486 135.38 336.392 135.506 336.259 135.641C336.127 135.776 335.95 135.891 335.73 135.986C335.51 136.08 335.241 136.128 334.924 136.128ZM335.052 135.375C335.383 135.375 335.663 135.31 335.89 135.18C336.119 135.049 336.292 134.881 336.408 134.675C336.527 134.469 336.586 134.253 336.586 134.026V133.259C336.55 133.301 336.472 133.34 336.351 133.376C336.233 133.409 336.096 133.438 335.94 133.464C335.786 133.488 335.635 133.509 335.489 133.528C335.344 133.545 335.227 133.559 335.137 133.571C334.919 133.599 334.716 133.646 334.526 133.71C334.339 133.771 334.188 133.865 334.072 133.99C333.958 134.113 333.901 134.281 333.901 134.494C333.901 134.786 334.009 135.006 334.224 135.155C334.442 135.302 334.718 135.375 335.052 135.375ZM339.298 138.045C339.156 138.045 339.029 138.034 338.918 138.01C338.807 137.989 338.73 137.967 338.687 137.946L338.9 137.207C339.104 137.259 339.284 137.278 339.44 137.264C339.596 137.25 339.735 137.18 339.856 137.055C339.979 136.932 340.091 136.732 340.193 136.455L340.349 136.028L338.332 130.545H339.241L340.747 134.892H340.804L342.309 130.545H343.218L340.903 136.795C340.799 137.077 340.67 137.31 340.516 137.495C340.362 137.682 340.183 137.821 339.98 137.911C339.779 138 339.551 138.045 339.298 138.045ZM348.188 131.767L347.435 131.98C347.388 131.855 347.318 131.733 347.226 131.614C347.136 131.494 347.013 131.394 346.857 131.316C346.7 131.238 346.5 131.199 346.256 131.199C345.923 131.199 345.645 131.276 345.422 131.43C345.202 131.581 345.092 131.774 345.092 132.009C345.092 132.217 345.167 132.381 345.319 132.502C345.47 132.623 345.707 132.723 346.029 132.804L346.839 133.003C347.327 133.121 347.69 133.302 347.929 133.546C348.168 133.788 348.288 134.099 348.288 134.48C348.288 134.793 348.198 135.072 348.018 135.318C347.84 135.564 347.592 135.759 347.272 135.901C346.953 136.043 346.581 136.114 346.157 136.114C345.601 136.114 345.14 135.993 344.776 135.751C344.411 135.51 344.18 135.157 344.083 134.693L344.879 134.494C344.954 134.788 345.098 135.008 345.308 135.155C345.521 135.302 345.8 135.375 346.143 135.375C346.533 135.375 346.844 135.292 347.073 135.126C347.305 134.958 347.421 134.757 347.421 134.523C347.421 134.333 347.355 134.175 347.222 134.047C347.09 133.917 346.886 133.82 346.612 133.756L345.703 133.543C345.203 133.424 344.836 133.241 344.602 132.992C344.37 132.741 344.254 132.428 344.254 132.051C344.254 131.743 344.34 131.471 344.513 131.234C344.688 130.998 344.926 130.812 345.227 130.677C345.53 130.542 345.873 130.474 346.256 130.474C346.796 130.474 347.22 130.593 347.528 130.83C347.838 131.066 348.058 131.379 348.188 131.767Z" fill="white" fill-opacity="0.8"/>
                                        <g filter="url(#filter2_d_7301_41)">
                                        <path d="M375.543 135.329L391.375 134.261C393.219 134.136 394.614 132.541 394.489 130.696C394.364 128.851 392.768 127.457 390.924 127.581L386.112 127.906C400.326 109.927 421.689 108.825 433.639 119.083C434.071 119.454 434.684 118.928 434.406 118.45C425.713 103.516 403.614 97.5586 383.528 114.899C381.604 116.598 379.721 118.37 377.878 120.204L377.589 115.931C377.465 114.087 375.868 112.692 374.025 112.817C372.18 112.941 370.785 114.536 370.911 116.381L371.979 132.214C372.102 134.059 373.698 135.453 375.543 135.329Z" fill="#334257"/>
                                        </g>
                                        </g>
                                        <rect x="232.361" y="16.3607" width="195.279" height="266.279" rx="7.63927" stroke="#F4F4F4" stroke-width="0.721461"/>
                                        </g>
                                        <g filter="url(#filter3_d_7301_41)">
                                        <rect x="95" y="21" width="117" height="31" rx="15.5" fill="white"/>
                                        </g>
                                        <path d="M115.041 41V32.2727H118.152C118.831 32.2727 119.393 32.3963 119.839 32.6435C120.285 32.8906 120.619 33.2287 120.841 33.6577C121.062 34.0838 121.173 34.5639 121.173 35.098C121.173 35.6349 121.061 36.1179 120.836 36.5469C120.615 36.973 120.279 37.3111 119.831 37.5611C119.385 37.8082 118.824 37.9318 118.147 37.9318H116.008V36.8153H118.028C118.457 36.8153 118.805 36.7415 119.072 36.5938C119.339 36.4432 119.535 36.2386 119.66 35.9801C119.785 35.7216 119.848 35.4276 119.848 35.098C119.848 34.7685 119.785 34.4759 119.66 34.2202C119.535 33.9645 119.338 33.7642 119.068 33.6193C118.801 33.4744 118.449 33.402 118.011 33.402H116.358V41H115.041ZM124.461 41.1449C124.046 41.1449 123.671 41.0682 123.336 40.9148C123 40.7585 122.735 40.5327 122.539 40.2372C122.346 39.9418 122.249 39.5795 122.249 39.1506C122.249 38.7812 122.32 38.4773 122.462 38.2386C122.604 38 122.796 37.8111 123.037 37.6719C123.279 37.5327 123.549 37.4276 123.847 37.3565C124.145 37.2855 124.449 37.2315 124.759 37.1946C125.151 37.1491 125.469 37.1122 125.713 37.0838C125.958 37.0526 126.135 37.0028 126.246 36.9347C126.357 36.8665 126.412 36.7557 126.412 36.6023V36.5724C126.412 36.2003 126.307 35.9119 126.097 35.7074C125.89 35.5028 125.58 35.4006 125.168 35.4006C124.739 35.4006 124.401 35.4957 124.154 35.6861C123.909 35.8736 123.74 36.0824 123.647 36.3125L122.449 36.0398C122.591 35.642 122.799 35.321 123.071 35.0767C123.347 34.8295 123.664 34.6506 124.022 34.5398C124.38 34.4261 124.756 34.3693 125.151 34.3693C125.412 34.3693 125.689 34.4006 125.982 34.4631C126.277 34.5227 126.553 34.6335 126.809 34.7955C127.067 34.9574 127.279 35.1889 127.444 35.4901C127.608 35.7884 127.691 36.1761 127.691 36.6534V41H126.446V40.1051H126.395C126.313 40.2699 126.189 40.4318 126.025 40.5909C125.86 40.75 125.648 40.8821 125.39 40.9872C125.131 41.0923 124.821 41.1449 124.461 41.1449ZM124.738 40.1222C125.09 40.1222 125.391 40.0526 125.641 39.9134C125.894 39.7741 126.086 39.5923 126.216 39.3679C126.35 39.1406 126.417 38.8977 126.417 38.6392V37.7955C126.371 37.8409 126.283 37.8835 126.152 37.9233C126.025 37.9602 125.878 37.9929 125.713 38.0213C125.549 38.0469 125.388 38.071 125.232 38.0938C125.076 38.1136 124.945 38.1307 124.84 38.1449C124.593 38.1761 124.367 38.2287 124.162 38.3026C123.961 38.3764 123.799 38.483 123.676 38.6222C123.557 38.7585 123.498 38.9403 123.498 39.1676C123.498 39.483 123.614 39.7216 123.847 39.8835C124.08 40.0426 124.377 40.1222 124.738 40.1222ZM132.145 41.1321C131.511 41.1321 130.966 40.9886 130.509 40.7017C130.054 40.4119 129.705 40.0128 129.46 39.5043C129.216 38.9957 129.094 38.4134 129.094 37.7571C129.094 37.0923 129.219 36.5057 129.469 35.9972C129.719 35.4858 130.071 35.0866 130.526 34.7997C130.98 34.5128 131.516 34.3693 132.132 34.3693C132.629 34.3693 133.072 34.4616 133.462 34.6463C133.851 34.8281 134.165 35.0838 134.403 35.4134C134.645 35.7429 134.788 36.1278 134.834 36.5682H133.594C133.526 36.2614 133.369 35.9972 133.125 35.7756C132.884 35.554 132.56 35.4432 132.153 35.4432C131.798 35.4432 131.487 35.5369 131.22 35.7244C130.956 35.9091 130.75 36.1733 130.602 36.517C130.455 36.858 130.381 37.2614 130.381 37.7273C130.381 38.2045 130.453 38.6165 130.598 38.9631C130.743 39.3097 130.947 39.5781 131.212 39.7685C131.479 39.9588 131.793 40.054 132.153 40.054C132.395 40.054 132.614 40.0099 132.81 39.9219C133.009 39.831 133.175 39.7017 133.308 39.5341C133.445 39.3665 133.54 39.1648 133.594 38.929H134.834C134.788 39.3523 134.651 39.7301 134.42 40.0625C134.19 40.3949 133.882 40.6562 133.496 40.8466C133.112 41.0369 132.662 41.1321 132.145 41.1321ZM137.368 38.7798L137.36 37.2244H137.581L140.189 34.4545H141.715L138.74 37.608H138.54L137.368 38.7798ZM136.196 41V32.2727H137.471V41H136.196ZM140.33 41L137.986 37.8892L138.864 36.9986L141.894 41H140.33ZM144.781 41.1449C144.366 41.1449 143.991 41.0682 143.656 40.9148C143.321 40.7585 143.055 40.5327 142.859 40.2372C142.666 39.9418 142.569 39.5795 142.569 39.1506C142.569 38.7812 142.64 38.4773 142.782 38.2386C142.924 38 143.116 37.8111 143.358 37.6719C143.599 37.5327 143.869 37.4276 144.167 37.3565C144.466 37.2855 144.77 37.2315 145.079 37.1946C145.471 37.1491 145.789 37.1122 146.034 37.0838C146.278 37.0526 146.456 37.0028 146.566 36.9347C146.677 36.8665 146.733 36.7557 146.733 36.6023V36.5724C146.733 36.2003 146.627 35.9119 146.417 35.7074C146.21 35.5028 145.9 35.4006 145.488 35.4006C145.059 35.4006 144.721 35.4957 144.474 35.6861C144.23 35.8736 144.061 36.0824 143.967 36.3125L142.77 36.0398C142.912 35.642 143.119 35.321 143.392 35.0767C143.667 34.8295 143.984 34.6506 144.342 34.5398C144.7 34.4261 145.076 34.3693 145.471 34.3693C145.733 34.3693 146.01 34.4006 146.302 34.4631C146.598 34.5227 146.873 34.6335 147.129 34.7955C147.387 34.9574 147.599 35.1889 147.764 35.4901C147.929 35.7884 148.011 36.1761 148.011 36.6534V41H146.767V40.1051H146.716C146.633 40.2699 146.51 40.4318 146.345 40.5909C146.18 40.75 145.968 40.8821 145.71 40.9872C145.451 41.0923 145.142 41.1449 144.781 41.1449ZM145.058 40.1222C145.41 40.1222 145.711 40.0526 145.961 39.9134C146.214 39.7741 146.406 39.5923 146.537 39.3679C146.67 39.1406 146.737 38.8977 146.737 38.6392V37.7955C146.691 37.8409 146.603 37.8835 146.473 37.9233C146.345 37.9602 146.199 37.9929 146.034 38.0213C145.869 38.0469 145.708 38.071 145.552 38.0938C145.396 38.1136 145.265 38.1307 145.16 38.1449C144.913 38.1761 144.687 38.2287 144.483 38.3026C144.281 38.3764 144.119 38.483 143.997 38.6222C143.877 38.7585 143.818 38.9403 143.818 39.1676C143.818 39.483 143.934 39.7216 144.167 39.8835C144.4 40.0426 144.697 40.1222 145.058 40.1222ZM152.452 43.5909C151.933 43.5909 151.485 43.5227 151.11 43.3864C150.738 43.25 150.434 43.0696 150.198 42.8452C149.962 42.6207 149.786 42.375 149.67 42.108L150.765 41.6562C150.842 41.7812 150.944 41.9134 151.072 42.0526C151.202 42.1946 151.379 42.3153 151.6 42.4148C151.825 42.5142 152.113 42.5639 152.465 42.5639C152.948 42.5639 153.347 42.446 153.663 42.2102C153.978 41.9773 154.136 41.6051 154.136 41.0938V39.8068H154.055C153.978 39.946 153.867 40.1009 153.722 40.2713C153.58 40.4418 153.384 40.5895 153.134 40.7145C152.884 40.8395 152.559 40.902 152.158 40.902C151.641 40.902 151.175 40.7812 150.761 40.5398C150.349 40.2955 150.022 39.9361 149.781 39.4616C149.542 38.9844 149.423 38.3977 149.423 37.7017C149.423 37.0057 149.54 36.4091 149.776 35.9119C150.015 35.4148 150.342 35.0341 150.756 34.7699C151.171 34.5028 151.641 34.3693 152.167 34.3693C152.573 34.3693 152.901 34.4375 153.151 34.5739C153.401 34.7074 153.596 34.8636 153.735 35.0426C153.877 35.2216 153.987 35.3793 154.063 35.5156H154.157V34.4545H155.406V41.1449C155.406 41.7074 155.275 42.169 155.013 42.5298C154.752 42.8906 154.398 43.1577 153.952 43.331C153.509 43.5043 153.009 43.5909 152.452 43.5909ZM152.44 39.8452C152.806 39.8452 153.116 39.7599 153.369 39.5895C153.624 39.4162 153.817 39.169 153.948 38.848C154.082 38.5241 154.148 38.1364 154.148 37.6847C154.148 37.2443 154.083 36.8565 153.952 36.5213C153.822 36.1861 153.63 35.9247 153.377 35.7372C153.124 35.5469 152.812 35.4517 152.44 35.4517C152.056 35.4517 151.737 35.5511 151.481 35.75C151.225 35.946 151.032 36.2131 150.901 36.5511C150.773 36.8892 150.71 37.267 150.71 37.6847C150.71 38.1136 150.775 38.4901 150.906 38.8139C151.036 39.1378 151.229 39.3906 151.485 39.5724C151.744 39.7543 152.062 39.8452 152.44 39.8452ZM159.935 41.1321C159.29 41.1321 158.735 40.9943 158.269 40.7188C157.806 40.4403 157.448 40.0497 157.195 39.5469C156.945 39.0412 156.82 38.4489 156.82 37.7699C156.82 37.0994 156.945 36.5085 157.195 35.9972C157.448 35.4858 157.8 35.0866 158.252 34.7997C158.707 34.5128 159.238 34.3693 159.846 34.3693C160.215 34.3693 160.573 34.4304 160.92 34.5526C161.266 34.6747 161.577 34.8665 161.853 35.1278C162.129 35.3892 162.346 35.7287 162.505 36.1463C162.664 36.5611 162.744 37.0653 162.744 37.6591V38.1108H157.54V37.1562H161.495C161.495 36.821 161.427 36.5241 161.29 36.2656C161.154 36.0043 160.962 35.7983 160.715 35.6477C160.471 35.4972 160.184 35.4219 159.854 35.4219C159.496 35.4219 159.184 35.5099 158.917 35.6861C158.653 35.8594 158.448 36.0866 158.303 36.3679C158.161 36.6463 158.09 36.9489 158.09 37.2756V38.0213C158.09 38.4588 158.167 38.831 158.32 39.1378C158.477 39.4446 158.694 39.679 158.972 39.8409C159.251 40 159.576 40.0795 159.948 40.0795C160.19 40.0795 160.41 40.0455 160.609 39.9773C160.808 39.9062 160.979 39.8011 161.124 39.6619C161.269 39.5227 161.38 39.3509 161.457 39.1463L162.663 39.3636C162.566 39.7187 162.393 40.0298 162.143 40.2969C161.896 40.5611 161.585 40.767 161.21 40.9148C160.837 41.0597 160.413 41.1321 159.935 41.1321ZM167.005 33.4062V32.2727H173.759V33.4062H171.036V41H169.724V33.4062H167.005ZM175.15 41V34.4545H176.424V41H175.15ZM175.793 33.4446C175.571 33.4446 175.381 33.3707 175.222 33.223C175.066 33.0724 174.988 32.8935 174.988 32.6861C174.988 32.4759 175.066 32.2969 175.222 32.1491C175.381 31.9986 175.571 31.9233 175.793 31.9233C176.015 31.9233 176.203 31.9986 176.36 32.1491C176.519 32.2969 176.598 32.4759 176.598 32.6861C176.598 32.8935 176.519 33.0724 176.36 33.223C176.203 33.3707 176.015 33.4446 175.793 33.4446ZM181.193 34.4545V35.4773H177.618V34.4545H181.193ZM178.577 32.8864H179.851V39.0781C179.851 39.3253 179.888 39.5114 179.962 39.6364C180.036 39.7585 180.131 39.8423 180.247 39.8878C180.366 39.9304 180.496 39.9517 180.635 39.9517C180.737 39.9517 180.827 39.9446 180.903 39.9304C180.98 39.9162 181.04 39.9048 181.082 39.8963L181.312 40.9489C181.239 40.9773 181.134 41.0057 180.997 41.0341C180.861 41.0653 180.69 41.0824 180.486 41.0852C180.151 41.0909 179.838 41.0312 179.548 40.9062C179.259 40.7812 179.024 40.5881 178.845 40.3267C178.666 40.0653 178.577 39.7372 178.577 39.3423V32.8864ZM184.017 32.2727V41H182.743V32.2727H184.017ZM188.553 41.1321C187.908 41.1321 187.352 40.9943 186.886 40.7188C186.423 40.4403 186.065 40.0497 185.812 39.5469C185.562 39.0412 185.438 38.4489 185.438 37.7699C185.438 37.0994 185.562 36.5085 185.812 35.9972C186.065 35.4858 186.418 35.0866 186.869 34.7997C187.324 34.5128 187.855 34.3693 188.463 34.3693C188.832 34.3693 189.19 34.4304 189.537 34.5526C189.884 34.6747 190.195 34.8665 190.47 35.1278C190.746 35.3892 190.963 35.7287 191.122 36.1463C191.281 36.5611 191.361 37.0653 191.361 37.6591V38.1108H186.158V37.1562H190.112C190.112 36.821 190.044 36.5241 189.908 36.2656C189.771 36.0043 189.58 35.7983 189.332 35.6477C189.088 35.4972 188.801 35.4219 188.472 35.4219C188.114 35.4219 187.801 35.5099 187.534 35.6861C187.27 35.8594 187.065 36.0866 186.92 36.3679C186.778 36.6463 186.707 36.9489 186.707 37.2756V38.0213C186.707 38.4588 186.784 38.831 186.938 39.1378C187.094 39.4446 187.311 39.679 187.589 39.8409C187.868 40 188.193 40.0795 188.565 40.0795C188.807 40.0795 189.027 40.0455 189.226 39.9773C189.425 39.9062 189.597 39.8011 189.741 39.6619C189.886 39.5227 189.997 39.3509 190.074 39.1463L191.28 39.3636C191.183 39.7187 191.01 40.0298 190.76 40.2969C190.513 40.5611 190.202 40.767 189.827 40.9148C189.455 41.0597 189.03 41.1321 188.553 41.1321Z" fill="#334257"/>
                                        <g filter="url(#filter4_d_7301_41)">
                                        <rect x="438" y="100" width="176" height="31" rx="15.5" fill="white"/>
                                        </g>
                                        <path d="M452.994 120V111.273H456.105C456.784 111.273 457.346 111.396 457.792 111.643C458.238 111.891 458.572 112.229 458.794 112.658C459.015 113.084 459.126 113.564 459.126 114.098C459.126 114.635 459.014 115.118 458.789 115.547C458.568 115.973 458.233 116.311 457.784 116.561C457.338 116.808 456.777 116.932 456.1 116.932H453.961V115.815H455.981C456.41 115.815 456.758 115.741 457.025 115.594C457.292 115.443 457.488 115.239 457.613 114.98C457.738 114.722 457.801 114.428 457.801 114.098C457.801 113.768 457.738 113.476 457.613 113.22C457.488 112.964 457.291 112.764 457.021 112.619C456.754 112.474 456.402 112.402 455.964 112.402H454.311V120H452.994ZM462.414 120.145C461.999 120.145 461.624 120.068 461.289 119.915C460.953 119.759 460.688 119.533 460.492 119.237C460.299 118.942 460.202 118.58 460.202 118.151C460.202 117.781 460.273 117.477 460.415 117.239C460.557 117 460.749 116.811 460.99 116.672C461.232 116.533 461.502 116.428 461.8 116.357C462.098 116.286 462.402 116.232 462.712 116.195C463.104 116.149 463.422 116.112 463.667 116.084C463.911 116.053 464.088 116.003 464.199 115.935C464.31 115.866 464.365 115.756 464.365 115.602V115.572C464.365 115.2 464.26 114.912 464.05 114.707C463.843 114.503 463.533 114.401 463.121 114.401C462.692 114.401 462.354 114.496 462.107 114.686C461.863 114.874 461.694 115.082 461.6 115.312L460.402 115.04C460.544 114.642 460.752 114.321 461.025 114.077C461.3 113.83 461.617 113.651 461.975 113.54C462.333 113.426 462.709 113.369 463.104 113.369C463.365 113.369 463.642 113.401 463.935 113.463C464.23 113.523 464.506 113.634 464.762 113.795C465.02 113.957 465.232 114.189 465.397 114.49C465.561 114.788 465.644 115.176 465.644 115.653V120H464.4V119.105H464.348C464.266 119.27 464.142 119.432 463.978 119.591C463.813 119.75 463.601 119.882 463.343 119.987C463.084 120.092 462.775 120.145 462.414 120.145ZM462.691 119.122C463.043 119.122 463.344 119.053 463.594 118.913C463.847 118.774 464.039 118.592 464.169 118.368C464.303 118.141 464.37 117.898 464.37 117.639V116.795C464.324 116.841 464.236 116.884 464.105 116.923C463.978 116.96 463.831 116.993 463.667 117.021C463.502 117.047 463.341 117.071 463.185 117.094C463.029 117.114 462.898 117.131 462.793 117.145C462.546 117.176 462.32 117.229 462.115 117.303C461.914 117.376 461.752 117.483 461.63 117.622C461.51 117.759 461.451 117.94 461.451 118.168C461.451 118.483 461.567 118.722 461.8 118.884C462.033 119.043 462.33 119.122 462.691 119.122ZM470.098 120.132C469.464 120.132 468.919 119.989 468.462 119.702C468.007 119.412 467.658 119.013 467.413 118.504C467.169 117.996 467.047 117.413 467.047 116.757C467.047 116.092 467.172 115.506 467.422 114.997C467.672 114.486 468.024 114.087 468.479 113.8C468.933 113.513 469.469 113.369 470.085 113.369C470.582 113.369 471.026 113.462 471.415 113.646C471.804 113.828 472.118 114.084 472.357 114.413C472.598 114.743 472.741 115.128 472.787 115.568H471.547C471.479 115.261 471.322 114.997 471.078 114.776C470.837 114.554 470.513 114.443 470.107 114.443C469.751 114.443 469.44 114.537 469.173 114.724C468.909 114.909 468.703 115.173 468.555 115.517C468.408 115.858 468.334 116.261 468.334 116.727C468.334 117.205 468.406 117.616 468.551 117.963C468.696 118.31 468.901 118.578 469.165 118.768C469.432 118.959 469.746 119.054 470.107 119.054C470.348 119.054 470.567 119.01 470.763 118.922C470.962 118.831 471.128 118.702 471.261 118.534C471.398 118.366 471.493 118.165 471.547 117.929H472.787C472.741 118.352 472.604 118.73 472.374 119.062C472.143 119.395 471.835 119.656 471.449 119.847C471.065 120.037 470.615 120.132 470.098 120.132ZM475.321 117.78L475.313 116.224H475.534L478.142 113.455H479.668L476.694 116.608H476.493L475.321 117.78ZM474.15 120V111.273H475.424V120H474.15ZM478.283 120L475.939 116.889L476.817 115.999L479.847 120H478.283ZM482.734 120.145C482.319 120.145 481.944 120.068 481.609 119.915C481.274 119.759 481.008 119.533 480.812 119.237C480.619 118.942 480.522 118.58 480.522 118.151C480.522 117.781 480.593 117.477 480.735 117.239C480.877 117 481.069 116.811 481.311 116.672C481.552 116.533 481.822 116.428 482.12 116.357C482.419 116.286 482.723 116.232 483.032 116.195C483.424 116.149 483.743 116.112 483.987 116.084C484.231 116.053 484.409 116.003 484.52 115.935C484.63 115.866 484.686 115.756 484.686 115.602V115.572C484.686 115.2 484.581 114.912 484.37 114.707C484.163 114.503 483.853 114.401 483.441 114.401C483.012 114.401 482.674 114.496 482.427 114.686C482.183 114.874 482.014 115.082 481.92 115.312L480.723 115.04C480.865 114.642 481.072 114.321 481.345 114.077C481.62 113.83 481.937 113.651 482.295 113.54C482.653 113.426 483.029 113.369 483.424 113.369C483.686 113.369 483.963 113.401 484.255 113.463C484.551 113.523 484.826 113.634 485.082 113.795C485.341 113.957 485.552 114.189 485.717 114.49C485.882 114.788 485.964 115.176 485.964 115.653V120H484.72V119.105H484.669C484.586 119.27 484.463 119.432 484.298 119.591C484.133 119.75 483.922 119.882 483.663 119.987C483.404 120.092 483.095 120.145 482.734 120.145ZM483.011 119.122C483.363 119.122 483.664 119.053 483.914 118.913C484.167 118.774 484.359 118.592 484.49 118.368C484.623 118.141 484.69 117.898 484.69 117.639V116.795C484.645 116.841 484.556 116.884 484.426 116.923C484.298 116.96 484.152 116.993 483.987 117.021C483.822 117.047 483.662 117.071 483.505 117.094C483.349 117.114 483.218 117.131 483.113 117.145C482.866 117.176 482.64 117.229 482.436 117.303C482.234 117.376 482.072 117.483 481.95 117.622C481.831 117.759 481.771 117.94 481.771 118.168C481.771 118.483 481.887 118.722 482.12 118.884C482.353 119.043 482.65 119.122 483.011 119.122ZM490.406 122.591C489.886 122.591 489.438 122.523 489.063 122.386C488.691 122.25 488.387 122.07 488.151 121.845C487.915 121.621 487.739 121.375 487.623 121.108L488.718 120.656C488.795 120.781 488.897 120.913 489.025 121.053C489.156 121.195 489.332 121.315 489.553 121.415C489.778 121.514 490.066 121.564 490.418 121.564C490.901 121.564 491.3 121.446 491.616 121.21C491.931 120.977 492.089 120.605 492.089 120.094V118.807H492.008C491.931 118.946 491.82 119.101 491.675 119.271C491.533 119.442 491.337 119.589 491.087 119.714C490.837 119.839 490.512 119.902 490.112 119.902C489.594 119.902 489.129 119.781 488.714 119.54C488.302 119.295 487.975 118.936 487.734 118.462C487.495 117.984 487.376 117.398 487.376 116.702C487.376 116.006 487.494 115.409 487.729 114.912C487.968 114.415 488.295 114.034 488.71 113.77C489.124 113.503 489.594 113.369 490.12 113.369C490.526 113.369 490.854 113.438 491.104 113.574C491.354 113.707 491.549 113.864 491.688 114.043C491.83 114.222 491.94 114.379 492.016 114.516H492.11V113.455H493.359V120.145C493.359 120.707 493.228 121.169 492.967 121.53C492.705 121.891 492.352 122.158 491.906 122.331C491.462 122.504 490.962 122.591 490.406 122.591ZM490.393 118.845C490.759 118.845 491.069 118.76 491.322 118.589C491.577 118.416 491.771 118.169 491.901 117.848C492.035 117.524 492.102 117.136 492.102 116.685C492.102 116.244 492.036 115.857 491.906 115.521C491.775 115.186 491.583 114.925 491.33 114.737C491.077 114.547 490.765 114.452 490.393 114.452C490.009 114.452 489.69 114.551 489.434 114.75C489.178 114.946 488.985 115.213 488.854 115.551C488.727 115.889 488.663 116.267 488.663 116.685C488.663 117.114 488.728 117.49 488.859 117.814C488.989 118.138 489.183 118.391 489.438 118.572C489.697 118.754 490.015 118.845 490.393 118.845ZM497.888 120.132C497.244 120.132 496.688 119.994 496.222 119.719C495.759 119.44 495.401 119.05 495.148 118.547C494.898 118.041 494.773 117.449 494.773 116.77C494.773 116.099 494.898 115.509 495.148 114.997C495.401 114.486 495.754 114.087 496.205 113.8C496.66 113.513 497.191 113.369 497.799 113.369C498.168 113.369 498.526 113.43 498.873 113.553C499.219 113.675 499.531 113.866 499.806 114.128C500.082 114.389 500.299 114.729 500.458 115.146C500.617 115.561 500.697 116.065 500.697 116.659V117.111H495.494V116.156H499.448C499.448 115.821 499.38 115.524 499.244 115.266C499.107 115.004 498.915 114.798 498.668 114.648C498.424 114.497 498.137 114.422 497.808 114.422C497.45 114.422 497.137 114.51 496.87 114.686C496.606 114.859 496.401 115.087 496.256 115.368C496.114 115.646 496.043 115.949 496.043 116.276V117.021C496.043 117.459 496.12 117.831 496.273 118.138C496.43 118.445 496.647 118.679 496.925 118.841C497.204 119 497.529 119.08 497.901 119.08C498.143 119.08 498.363 119.045 498.562 118.977C498.761 118.906 498.933 118.801 499.077 118.662C499.222 118.523 499.333 118.351 499.41 118.146L500.616 118.364C500.519 118.719 500.346 119.03 500.096 119.297C499.849 119.561 499.538 119.767 499.163 119.915C498.79 120.06 498.366 120.132 497.888 120.132ZM506.151 111.273L508.58 118.381H508.678L511.107 111.273H512.531L509.39 120H507.869L504.728 111.273H506.151ZM514.949 120.145C514.534 120.145 514.159 120.068 513.824 119.915C513.489 119.759 513.223 119.533 513.027 119.237C512.834 118.942 512.737 118.58 512.737 118.151C512.737 117.781 512.808 117.477 512.95 117.239C513.092 117 513.284 116.811 513.526 116.672C513.767 116.533 514.037 116.428 514.335 116.357C514.634 116.286 514.938 116.232 515.247 116.195C515.639 116.149 515.957 116.112 516.202 116.084C516.446 116.053 516.624 116.003 516.734 115.935C516.845 115.866 516.901 115.756 516.901 115.602V115.572C516.901 115.2 516.795 114.912 516.585 114.707C516.378 114.503 516.068 114.401 515.656 114.401C515.227 114.401 514.889 114.496 514.642 114.686C514.398 114.874 514.229 115.082 514.135 115.312L512.938 115.04C513.08 114.642 513.287 114.321 513.56 114.077C513.835 113.83 514.152 113.651 514.51 113.54C514.868 113.426 515.244 113.369 515.639 113.369C515.901 113.369 516.178 113.401 516.47 113.463C516.766 113.523 517.041 113.634 517.297 113.795C517.555 113.957 517.767 114.189 517.932 114.49C518.097 114.788 518.179 115.176 518.179 115.653V120H516.935V119.105H516.884C516.801 119.27 516.678 119.432 516.513 119.591C516.348 119.75 516.136 119.882 515.878 119.987C515.619 120.092 515.31 120.145 514.949 120.145ZM515.226 119.122C515.578 119.122 515.879 119.053 516.129 118.913C516.382 118.774 516.574 118.592 516.705 118.368C516.838 118.141 516.905 117.898 516.905 117.639V116.795C516.859 116.841 516.771 116.884 516.641 116.923C516.513 116.96 516.366 116.993 516.202 117.021C516.037 117.047 515.876 117.071 515.72 117.094C515.564 117.114 515.433 117.131 515.328 117.145C515.081 117.176 514.855 117.229 514.651 117.303C514.449 117.376 514.287 117.483 514.165 117.622C514.045 117.759 513.986 117.94 513.986 118.168C513.986 118.483 514.102 118.722 514.335 118.884C514.568 119.043 514.865 119.122 515.226 119.122ZM521.15 111.273V120H519.876V111.273H521.15ZM522.864 120V113.455H524.138V120H522.864ZM523.508 112.445C523.286 112.445 523.096 112.371 522.937 112.223C522.781 112.072 522.702 111.893 522.702 111.686C522.702 111.476 522.781 111.297 522.937 111.149C523.096 110.999 523.286 110.923 523.508 110.923C523.729 110.923 523.918 110.999 524.075 111.149C524.234 111.297 524.313 111.476 524.313 111.686C524.313 111.893 524.234 112.072 524.075 112.223C523.918 112.371 523.729 112.445 523.508 112.445ZM528.303 120.128C527.775 120.128 527.303 119.993 526.888 119.723C526.476 119.45 526.152 119.062 525.917 118.56C525.684 118.054 525.567 117.447 525.567 116.74C525.567 116.033 525.685 115.428 525.921 114.925C526.159 114.422 526.486 114.037 526.901 113.77C527.316 113.503 527.786 113.369 528.311 113.369C528.718 113.369 529.044 113.438 529.292 113.574C529.542 113.707 529.735 113.864 529.871 114.043C530.01 114.222 530.118 114.379 530.195 114.516H530.272V111.273H531.546V120H530.301V118.982H530.195C530.118 119.121 530.007 119.28 529.863 119.459C529.721 119.638 529.525 119.794 529.275 119.928C529.025 120.061 528.701 120.128 528.303 120.128ZM528.584 119.041C528.951 119.041 529.26 118.945 529.513 118.751C529.769 118.555 529.962 118.284 530.093 117.938C530.226 117.591 530.293 117.187 530.293 116.727C530.293 116.273 530.228 115.875 530.097 115.534C529.966 115.193 529.775 114.928 529.522 114.737C529.269 114.547 528.956 114.452 528.584 114.452C528.201 114.452 527.881 114.551 527.625 114.75C527.37 114.949 527.176 115.22 527.046 115.564C526.918 115.908 526.854 116.295 526.854 116.727C526.854 117.165 526.919 117.558 527.05 117.908C527.181 118.257 527.374 118.534 527.63 118.739C527.888 118.94 528.206 119.041 528.584 119.041ZM533.364 120V113.455H534.638V120H533.364ZM534.008 112.445C533.786 112.445 533.596 112.371 533.437 112.223C533.281 112.072 533.202 111.893 533.202 111.686C533.202 111.476 533.281 111.297 533.437 111.149C533.596 110.999 533.786 110.923 534.008 110.923C534.229 110.923 534.418 110.999 534.575 111.149C534.734 111.297 534.813 111.476 534.813 111.686C534.813 111.893 534.734 112.072 534.575 112.223C534.418 112.371 534.229 112.445 534.008 112.445ZM539.408 113.455V114.477H535.833V113.455H539.408ZM536.792 111.886H538.066V118.078C538.066 118.325 538.103 118.511 538.176 118.636C538.25 118.759 538.346 118.842 538.462 118.888C538.581 118.93 538.711 118.952 538.85 118.952C538.952 118.952 539.042 118.945 539.118 118.93C539.195 118.916 539.255 118.905 539.297 118.896L539.527 119.949C539.453 119.977 539.348 120.006 539.212 120.034C539.076 120.065 538.905 120.082 538.701 120.085C538.365 120.091 538.053 120.031 537.763 119.906C537.473 119.781 537.239 119.588 537.06 119.327C536.881 119.065 536.792 118.737 536.792 118.342V111.886ZM541.623 122.455C541.433 122.455 541.259 122.439 541.103 122.408C540.947 122.379 540.83 122.348 540.754 122.314L541.06 121.27C541.293 121.332 541.501 121.359 541.683 121.351C541.864 121.342 542.025 121.274 542.164 121.146C542.306 121.018 542.431 120.81 542.539 120.52L542.697 120.085L540.302 113.455H541.665L543.323 118.534H543.391L545.049 113.455H546.417L543.719 120.874C543.594 121.214 543.435 121.503 543.242 121.739C543.049 121.977 542.819 122.156 542.552 122.276C542.285 122.395 541.975 122.455 541.623 122.455ZM553.718 120H550.892V111.273H553.807C554.662 111.273 555.397 111.447 556.01 111.797C556.624 112.143 557.094 112.642 557.421 113.293C557.75 113.94 557.915 114.717 557.915 115.624C557.915 116.533 557.749 117.314 557.417 117.967C557.087 118.621 556.61 119.124 555.985 119.476C555.36 119.825 554.604 120 553.718 120ZM552.209 118.849H553.645C554.31 118.849 554.863 118.724 555.303 118.474C555.743 118.222 556.073 117.857 556.292 117.379C556.51 116.899 556.62 116.314 556.62 115.624C556.62 114.939 556.51 114.358 556.292 113.881C556.076 113.403 555.753 113.041 555.324 112.794C554.895 112.547 554.363 112.423 553.726 112.423H552.209V118.849ZM563.597 117.286V113.455H564.875V120H563.622V118.866H563.554C563.403 119.216 563.162 119.507 562.83 119.74C562.5 119.97 562.089 120.085 561.598 120.085C561.178 120.085 560.805 119.993 560.482 119.808C560.161 119.621 559.908 119.344 559.723 118.977C559.541 118.611 559.45 118.158 559.45 117.618V113.455H560.724V117.464C560.724 117.911 560.848 118.266 561.095 118.53C561.342 118.794 561.663 118.926 562.058 118.926C562.297 118.926 562.534 118.866 562.77 118.747C563.009 118.628 563.206 118.447 563.362 118.206C563.521 117.964 563.599 117.658 563.597 117.286ZM566.587 120V113.455H567.819V114.494H567.887C568.006 114.142 568.216 113.865 568.517 113.663C568.821 113.459 569.165 113.357 569.549 113.357C569.628 113.357 569.722 113.359 569.83 113.365C569.941 113.371 570.027 113.378 570.09 113.386V114.605C570.039 114.591 569.948 114.575 569.817 114.558C569.686 114.538 569.556 114.528 569.425 114.528C569.124 114.528 568.855 114.592 568.62 114.72C568.387 114.845 568.202 115.02 568.066 115.244C567.929 115.466 567.861 115.719 567.861 116.003V120H566.587ZM573.039 120.145C572.624 120.145 572.249 120.068 571.914 119.915C571.578 119.759 571.313 119.533 571.117 119.237C570.924 118.942 570.827 118.58 570.827 118.151C570.827 117.781 570.898 117.477 571.04 117.239C571.182 117 571.374 116.811 571.615 116.672C571.857 116.533 572.127 116.428 572.425 116.357C572.723 116.286 573.027 116.232 573.337 116.195C573.729 116.149 574.047 116.112 574.292 116.084C574.536 116.053 574.713 116.003 574.824 115.935C574.935 115.866 574.99 115.756 574.99 115.602V115.572C574.99 115.2 574.885 114.912 574.675 114.707C574.468 114.503 574.158 114.401 573.746 114.401C573.317 114.401 572.979 114.496 572.732 114.686C572.488 114.874 572.319 115.082 572.225 115.312L571.027 115.04C571.169 114.642 571.377 114.321 571.65 114.077C571.925 113.83 572.242 113.651 572.6 113.54C572.958 113.426 573.334 113.369 573.729 113.369C573.99 113.369 574.267 113.401 574.56 113.463C574.855 113.523 575.131 113.634 575.387 113.795C575.645 113.957 575.857 114.189 576.022 114.49C576.186 114.788 576.269 115.176 576.269 115.653V120H575.025V119.105H574.973C574.891 119.27 574.767 119.432 574.603 119.591C574.438 119.75 574.226 119.882 573.968 119.987C573.709 120.092 573.4 120.145 573.039 120.145ZM573.316 119.122C573.668 119.122 573.969 119.053 574.219 118.913C574.472 118.774 574.664 118.592 574.794 118.368C574.928 118.141 574.995 117.898 574.995 117.639V116.795C574.949 116.841 574.861 116.884 574.73 116.923C574.603 116.96 574.456 116.993 574.292 117.021C574.127 117.047 573.966 117.071 573.81 117.094C573.654 117.114 573.523 117.131 573.418 117.145C573.171 117.176 572.945 117.229 572.74 117.303C572.539 117.376 572.377 117.483 572.255 117.622C572.135 117.759 572.076 117.94 572.076 118.168C572.076 118.483 572.192 118.722 572.425 118.884C572.658 119.043 572.955 119.122 573.316 119.122ZM581.021 113.455V114.477H577.446V113.455H581.021ZM578.405 111.886H579.679V118.078C579.679 118.325 579.716 118.511 579.79 118.636C579.864 118.759 579.959 118.842 580.075 118.888C580.195 118.93 580.324 118.952 580.463 118.952C580.565 118.952 580.655 118.945 580.732 118.93C580.808 118.916 580.868 118.905 580.911 118.896L581.141 119.949C581.067 119.977 580.962 120.006 580.825 120.034C580.689 120.065 580.518 120.082 580.314 120.085C579.979 120.091 579.666 120.031 579.376 119.906C579.087 119.781 578.852 119.588 578.673 119.327C578.494 119.065 578.405 118.737 578.405 118.342V111.886ZM582.431 120V113.455H583.705V120H582.431ZM583.074 112.445C582.853 112.445 582.662 112.371 582.503 112.223C582.347 112.072 582.269 111.893 582.269 111.686C582.269 111.476 582.347 111.297 582.503 111.149C582.662 110.999 582.853 110.923 583.074 110.923C583.296 110.923 583.485 110.999 583.641 111.149C583.8 111.297 583.88 111.476 583.88 111.686C583.88 111.893 583.8 112.072 583.641 112.223C583.485 112.371 583.296 112.445 583.074 112.445ZM588.176 120.132C587.563 120.132 587.027 119.991 586.57 119.71C586.112 119.429 585.757 119.036 585.504 118.53C585.251 118.024 585.125 117.433 585.125 116.757C585.125 116.078 585.251 115.484 585.504 114.976C585.757 114.467 586.112 114.072 586.57 113.791C587.027 113.51 587.563 113.369 588.176 113.369C588.79 113.369 589.325 113.51 589.783 113.791C590.24 114.072 590.595 114.467 590.848 114.976C591.101 115.484 591.227 116.078 591.227 116.757C591.227 117.433 591.101 118.024 590.848 118.53C590.595 119.036 590.24 119.429 589.783 119.71C589.325 119.991 588.79 120.132 588.176 120.132ZM588.18 119.062C588.578 119.062 588.908 118.957 589.169 118.747C589.43 118.537 589.624 118.257 589.749 117.908C589.876 117.558 589.94 117.173 589.94 116.753C589.94 116.335 589.876 115.952 589.749 115.602C589.624 115.25 589.43 114.967 589.169 114.754C588.908 114.541 588.578 114.435 588.18 114.435C587.78 114.435 587.447 114.541 587.183 114.754C586.922 114.967 586.727 115.25 586.599 115.602C586.474 115.952 586.412 116.335 586.412 116.753C586.412 117.173 586.474 117.558 586.599 117.908C586.727 118.257 586.922 118.537 587.183 118.747C587.447 118.957 587.78 119.062 588.18 119.062ZM593.924 116.114V120H592.65V113.455H593.873V114.52H593.953C594.104 114.173 594.34 113.895 594.661 113.685C594.985 113.474 595.392 113.369 595.884 113.369C596.33 113.369 596.721 113.463 597.056 113.651C597.391 113.835 597.651 114.111 597.836 114.477C598.02 114.844 598.113 115.297 598.113 115.837V120H596.838V115.99C596.838 115.516 596.715 115.145 596.468 114.878C596.221 114.608 595.881 114.473 595.449 114.473C595.154 114.473 594.891 114.537 594.661 114.665C594.434 114.793 594.253 114.98 594.12 115.227C593.989 115.472 593.924 115.767 593.924 116.114Z" fill="#334257"/>
                                        <g filter="url(#filter5_d_7301_41)">
                                        <rect x="9" y="205" width="193" height="46" rx="23" fill="white"/>
                                        </g>
                                        <path d="M31.0487 228V219.273H34.1594C34.8384 219.273 35.4009 219.396 35.8469 219.643C36.293 219.891 36.6268 220.229 36.8484 220.658C37.07 221.084 37.1808 221.564 37.1808 222.098C37.1808 222.635 37.0685 223.118 36.8441 223.547C36.6225 223.973 36.2873 224.311 35.8384 224.561C35.3924 224.808 34.8313 224.932 34.1552 224.932H32.016V223.815H34.0359C34.4648 223.815 34.8129 223.741 35.0799 223.594C35.3469 223.443 35.543 223.239 35.668 222.98C35.793 222.722 35.8555 222.428 35.8555 222.098C35.8555 221.768 35.793 221.476 35.668 221.22C35.543 220.964 35.3455 220.764 35.0756 220.619C34.8086 220.474 34.4563 220.402 34.0188 220.402H32.3654V228H31.0487ZM40.4684 228.145C40.0536 228.145 39.6786 228.068 39.3434 227.915C39.0082 227.759 38.7425 227.533 38.5465 227.237C38.3533 226.942 38.2567 226.58 38.2567 226.151C38.2567 225.781 38.3278 225.477 38.4698 225.239C38.6119 225 38.8036 224.811 39.0451 224.672C39.2866 224.533 39.5565 224.428 39.8548 224.357C40.1531 224.286 40.457 224.232 40.7667 224.195C41.1587 224.149 41.4769 224.112 41.7212 224.084C41.9656 224.053 42.1431 224.003 42.2539 223.935C42.3647 223.866 42.4201 223.756 42.4201 223.602V223.572C42.4201 223.2 42.315 222.912 42.1048 222.707C41.8974 222.503 41.5877 222.401 41.1758 222.401C40.7468 222.401 40.4087 222.496 40.1616 222.686C39.9173 222.874 39.7482 223.082 39.6545 223.312L38.457 223.04C38.5991 222.642 38.8065 222.321 39.0792 222.077C39.3548 221.83 39.6715 221.651 40.0295 221.54C40.3874 221.426 40.7638 221.369 41.1587 221.369C41.4201 221.369 41.6971 221.401 41.9897 221.463C42.2852 221.523 42.5607 221.634 42.8164 221.795C43.0749 221.957 43.2866 222.189 43.4513 222.49C43.6161 222.788 43.6985 223.176 43.6985 223.653V228H42.4542V227.105H42.4031C42.3207 227.27 42.1971 227.432 42.0323 227.591C41.8675 227.75 41.6559 227.882 41.3974 227.987C41.1388 228.092 40.8292 228.145 40.4684 228.145ZM40.7454 227.122C41.0977 227.122 41.3988 227.053 41.6488 226.913C41.9016 226.774 42.0934 226.592 42.2241 226.368C42.3576 226.141 42.4244 225.898 42.4244 225.639V224.795C42.3789 224.841 42.2908 224.884 42.1602 224.923C42.0323 224.96 41.886 224.993 41.7212 225.021C41.5565 225.047 41.396 225.071 41.2397 225.094C41.0835 225.114 40.9528 225.131 40.8477 225.145C40.6005 225.176 40.3746 225.229 40.1701 225.303C39.9684 225.376 39.8065 225.483 39.6843 225.622C39.565 225.759 39.5053 225.94 39.5053 226.168C39.5053 226.483 39.6218 226.722 39.8548 226.884C40.0877 227.043 40.3846 227.122 40.7454 227.122ZM48.1527 228.132C47.5192 228.132 46.9737 227.989 46.5163 227.702C46.0618 227.412 45.7124 227.013 45.468 226.504C45.2237 225.996 45.1016 225.413 45.1016 224.757C45.1016 224.092 45.2266 223.506 45.4766 222.997C45.7266 222.486 46.0788 222.087 46.5334 221.8C46.9879 221.513 47.5234 221.369 48.1399 221.369C48.6371 221.369 49.0803 221.462 49.4695 221.646C49.8587 221.828 50.1726 222.084 50.4112 222.413C50.6527 222.743 50.7962 223.128 50.8416 223.568H49.6016C49.5334 223.261 49.3771 222.997 49.1328 222.776C48.8913 222.554 48.5675 222.443 48.1612 222.443C47.8061 222.443 47.495 222.537 47.228 222.724C46.9638 222.909 46.7578 223.173 46.6101 223.517C46.4624 223.858 46.3885 224.261 46.3885 224.727C46.3885 225.205 46.4609 225.616 46.6058 225.963C46.7507 226.31 46.9553 226.578 47.2195 226.768C47.4865 226.959 47.8004 227.054 48.1612 227.054C48.4027 227.054 48.6214 227.01 48.8175 226.922C49.0163 226.831 49.1825 226.702 49.3161 226.534C49.4524 226.366 49.5476 226.165 49.6016 225.929H50.8416C50.7962 226.352 50.6584 226.73 50.4283 227.062C50.1982 227.395 49.8899 227.656 49.5036 227.847C49.12 228.037 48.6697 228.132 48.1527 228.132ZM53.3761 225.78L53.3675 224.224H53.5891L56.1971 221.455H57.7227L54.7482 224.608H54.5479L53.3761 225.78ZM52.2042 228V219.273H53.4783V228H52.2042ZM56.3377 228L53.994 224.889L54.8718 223.999L57.9016 228H56.3377ZM60.7887 228.145C60.3739 228.145 59.9989 228.068 59.6637 227.915C59.3285 227.759 59.0629 227.533 58.8668 227.237C58.6737 226.942 58.5771 226.58 58.5771 226.151C58.5771 225.781 58.6481 225.477 58.7901 225.239C58.9322 225 59.1239 224.811 59.3654 224.672C59.6069 224.533 59.8768 224.428 60.1751 224.357C60.4734 224.286 60.7773 224.232 61.087 224.195C61.479 224.149 61.7972 224.112 62.0415 224.084C62.2859 224.053 62.4634 224.003 62.5742 223.935C62.685 223.866 62.7404 223.756 62.7404 223.602V223.572C62.7404 223.2 62.6353 222.912 62.4251 222.707C62.2177 222.503 61.908 222.401 61.4961 222.401C61.0671 222.401 60.729 222.496 60.4819 222.686C60.2376 222.874 60.0685 223.082 59.9748 223.312L58.7773 223.04C58.9194 222.642 59.1268 222.321 59.3995 222.077C59.6751 221.83 59.9918 221.651 60.3498 221.54C60.7077 221.426 61.0842 221.369 61.479 221.369C61.7404 221.369 62.0174 221.401 62.31 221.463C62.6055 221.523 62.881 221.634 63.1367 221.795C63.3952 221.957 63.6069 222.189 63.7717 222.49C63.9364 222.788 64.0188 223.176 64.0188 223.653V228H62.7745V227.105H62.7234C62.641 227.27 62.5174 227.432 62.3526 227.591C62.1879 227.75 61.9762 227.882 61.7177 227.987C61.4592 228.092 61.1495 228.145 60.7887 228.145ZM61.0657 227.122C61.418 227.122 61.7191 227.053 61.9691 226.913C62.2219 226.774 62.4137 226.592 62.5444 226.368C62.6779 226.141 62.7447 225.898 62.7447 225.639V224.795C62.6992 224.841 62.6112 224.884 62.4805 224.923C62.3526 224.96 62.2063 224.993 62.0415 225.021C61.8768 225.047 61.7163 225.071 61.56 225.094C61.4038 225.114 61.2731 225.131 61.168 225.145C60.9208 225.176 60.695 225.229 60.4904 225.303C60.2887 225.376 60.1268 225.483 60.0046 225.622C59.8853 225.759 59.8256 225.94 59.8256 226.168C59.8256 226.483 59.9421 226.722 60.1751 226.884C60.408 227.043 60.7049 227.122 61.0657 227.122ZM68.4602 230.591C67.9403 230.591 67.4929 230.523 67.1179 230.386C66.7457 230.25 66.4418 230.07 66.206 229.845C65.9702 229.621 65.794 229.375 65.6776 229.108L66.7727 228.656C66.8494 228.781 66.9517 228.913 67.0795 229.053C67.2102 229.195 67.3864 229.315 67.608 229.415C67.8324 229.514 68.1207 229.564 68.473 229.564C68.956 229.564 69.3551 229.446 69.6705 229.21C69.9858 228.977 70.1435 228.605 70.1435 228.094V226.807H70.0625C69.9858 226.946 69.875 227.101 69.7301 227.271C69.5881 227.442 69.392 227.589 69.142 227.714C68.892 227.839 68.5668 227.902 68.1662 227.902C67.6491 227.902 67.1832 227.781 66.7685 227.54C66.3565 227.295 66.0298 226.936 65.7884 226.462C65.5497 225.984 65.4304 225.398 65.4304 224.702C65.4304 224.006 65.5483 223.409 65.7841 222.912C66.0227 222.415 66.3494 222.034 66.7642 221.77C67.179 221.503 67.6491 221.369 68.1747 221.369C68.581 221.369 68.9091 221.438 69.1591 221.574C69.4091 221.707 69.6037 221.864 69.7429 222.043C69.8849 222.222 69.9943 222.379 70.071 222.516H70.1648V221.455H71.4134V228.145C71.4134 228.707 71.2827 229.169 71.0213 229.53C70.7599 229.891 70.4063 230.158 69.9602 230.331C69.517 230.504 69.017 230.591 68.4602 230.591ZM68.4474 226.845C68.8139 226.845 69.1236 226.76 69.3764 226.589C69.6321 226.416 69.8253 226.169 69.956 225.848C70.0895 225.524 70.1562 225.136 70.1562 224.685C70.1562 224.244 70.0909 223.857 69.9602 223.521C69.8295 223.186 69.6378 222.925 69.3849 222.737C69.1321 222.547 68.8196 222.452 68.4474 222.452C68.0639 222.452 67.7443 222.551 67.4886 222.75C67.233 222.946 67.0398 223.213 66.9091 223.551C66.7813 223.889 66.7173 224.267 66.7173 224.685C66.7173 225.114 66.7827 225.49 66.9134 225.814C67.044 226.138 67.2372 226.391 67.4929 226.572C67.7514 226.754 68.0696 226.845 68.4474 226.845ZM75.9432 228.132C75.2983 228.132 74.7429 227.994 74.277 227.719C73.8139 227.44 73.456 227.05 73.2031 226.547C72.9531 226.041 72.8281 225.449 72.8281 224.77C72.8281 224.099 72.9531 223.509 73.2031 222.997C73.456 222.486 73.8082 222.087 74.2599 221.8C74.7145 221.513 75.2457 221.369 75.8537 221.369C76.223 221.369 76.581 221.43 76.9276 221.553C77.2741 221.675 77.5852 221.866 77.8608 222.128C78.1364 222.389 78.3537 222.729 78.5128 223.146C78.6719 223.561 78.7514 224.065 78.7514 224.659V225.111H73.5483V224.156H77.5028C77.5028 223.821 77.4347 223.524 77.2983 223.266C77.1619 223.004 76.9702 222.798 76.723 222.648C76.4787 222.497 76.1918 222.422 75.8622 222.422C75.5043 222.422 75.1918 222.51 74.9247 222.686C74.6605 222.859 74.456 223.087 74.3111 223.368C74.169 223.646 74.098 223.949 74.098 224.276V225.021C74.098 225.459 74.1747 225.831 74.3281 226.138C74.4844 226.445 74.7017 226.679 74.9801 226.841C75.2585 227 75.5838 227.08 75.956 227.08C76.1974 227.08 76.4176 227.045 76.6165 226.977C76.8153 226.906 76.9872 226.801 77.1321 226.662C77.277 226.523 77.3878 226.351 77.4645 226.146L78.6705 226.364C78.5739 226.719 78.4006 227.03 78.1506 227.297C77.9034 227.561 77.5923 227.767 77.2173 227.915C76.8452 228.06 76.4205 228.132 75.9432 228.132ZM84.1804 228H82.7827L85.9233 219.273H87.4446L90.5852 228H89.1875L86.7202 220.858H86.652L84.1804 228ZM84.4148 224.582H88.9489V225.69H84.4148V224.582ZM96.5224 221.455L94.1488 228H92.7852L90.4073 221.455H91.7752L93.4329 226.491H93.5011L95.1545 221.455H96.5224ZM99.4371 228.145C99.0224 228.145 98.6474 228.068 98.3121 227.915C97.9769 227.759 97.7113 227.533 97.5153 227.237C97.3221 226.942 97.2255 226.58 97.2255 226.151C97.2255 225.781 97.2965 225.477 97.4386 225.239C97.5806 225 97.7724 224.811 98.0138 224.672C98.2553 224.533 98.5252 224.428 98.8235 224.357C99.1218 224.286 99.4258 224.232 99.7354 224.195C100.127 224.149 100.446 224.112 100.69 224.084C100.934 224.053 101.112 224.003 101.223 223.935C101.333 223.866 101.389 223.756 101.389 223.602V223.572C101.389 223.2 101.284 222.912 101.074 222.707C100.866 222.503 100.556 222.401 100.145 222.401C99.7156 222.401 99.3775 222.496 99.1303 222.686C98.886 222.874 98.717 223.082 98.6232 223.312L97.4258 223.04C97.5678 222.642 97.7752 222.321 98.0479 222.077C98.3235 221.83 98.6403 221.651 98.9982 221.54C99.3562 221.426 99.7326 221.369 100.127 221.369C100.389 221.369 100.666 221.401 100.958 221.463C101.254 221.523 101.529 221.634 101.785 221.795C102.044 221.957 102.255 222.189 102.42 222.49C102.585 222.788 102.667 223.176 102.667 223.653V228H101.423V227.105H101.372C101.289 227.27 101.166 227.432 101.001 227.591C100.836 227.75 100.625 227.882 100.366 227.987C100.108 228.092 99.7979 228.145 99.4371 228.145ZM99.7141 227.122C100.066 227.122 100.368 227.053 100.618 226.913C100.87 226.774 101.062 226.592 101.193 226.368C101.326 226.141 101.393 225.898 101.393 225.639V224.795C101.348 224.841 101.26 224.884 101.129 224.923C101.001 224.96 100.855 224.993 100.69 225.021C100.525 225.047 100.365 225.071 100.208 225.094C100.052 225.114 99.9215 225.131 99.8164 225.145C99.5692 225.176 99.3434 225.229 99.1388 225.303C98.9371 225.376 98.7752 225.483 98.6531 225.622C98.5337 225.759 98.4741 225.94 98.4741 226.168C98.4741 226.483 98.5906 226.722 98.8235 226.884C99.0565 227.043 99.3533 227.122 99.7141 227.122ZM104.364 228V221.455H105.638V228H104.364ZM105.008 220.445C104.786 220.445 104.596 220.371 104.437 220.223C104.281 220.072 104.202 219.893 104.202 219.686C104.202 219.476 104.281 219.297 104.437 219.149C104.596 218.999 104.786 218.923 105.008 218.923C105.229 218.923 105.418 218.999 105.575 219.149C105.734 219.297 105.813 219.476 105.813 219.686C105.813 219.893 105.734 220.072 105.575 220.223C105.418 220.371 105.229 220.445 105.008 220.445ZM108.627 219.273V228H107.353V219.273H108.627ZM112.246 228.145C111.831 228.145 111.456 228.068 111.121 227.915C110.786 227.759 110.52 227.533 110.324 227.237C110.131 226.942 110.034 226.58 110.034 226.151C110.034 225.781 110.105 225.477 110.247 225.239C110.389 225 110.581 224.811 110.822 224.672C111.064 224.533 111.334 224.428 111.632 224.357C111.93 224.286 112.234 224.232 112.544 224.195C112.936 224.149 113.254 224.112 113.499 224.084C113.743 224.053 113.92 224.003 114.031 223.935C114.142 223.866 114.197 223.756 114.197 223.602V223.572C114.197 223.2 114.092 222.912 113.882 222.707C113.675 222.503 113.365 222.401 112.953 222.401C112.524 222.401 112.186 222.496 111.939 222.686C111.695 222.874 111.526 223.082 111.432 223.312L110.234 223.04C110.376 222.642 110.584 222.321 110.857 222.077C111.132 221.83 111.449 221.651 111.807 221.54C112.165 221.426 112.541 221.369 112.936 221.369C113.197 221.369 113.474 221.401 113.767 221.463C114.063 221.523 114.338 221.634 114.594 221.795C114.852 221.957 115.064 222.189 115.229 222.49C115.393 222.788 115.476 223.176 115.476 223.653V228H114.232V227.105H114.18C114.098 227.27 113.974 227.432 113.81 227.591C113.645 227.75 113.433 227.882 113.175 227.987C112.916 228.092 112.607 228.145 112.246 228.145ZM112.523 227.122C112.875 227.122 113.176 227.053 113.426 226.913C113.679 226.774 113.871 226.592 114.001 226.368C114.135 226.141 114.202 225.898 114.202 225.639V224.795C114.156 224.841 114.068 224.884 113.938 224.923C113.81 224.96 113.663 224.993 113.499 225.021C113.334 225.047 113.173 225.071 113.017 225.094C112.861 225.114 112.73 225.131 112.625 225.145C112.378 225.176 112.152 225.229 111.947 225.303C111.746 225.376 111.584 225.483 111.462 225.622C111.342 225.759 111.283 225.94 111.283 226.168C111.283 226.483 111.399 226.722 111.632 226.884C111.865 227.043 112.162 227.122 112.523 227.122ZM117.275 228V219.273H118.549V222.516H118.626C118.7 222.379 118.806 222.222 118.946 222.043C119.085 221.864 119.278 221.707 119.525 221.574C119.772 221.438 120.099 221.369 120.505 221.369C121.034 221.369 121.505 221.503 121.92 221.77C122.335 222.037 122.66 222.422 122.896 222.925C123.135 223.428 123.254 224.033 123.254 224.74C123.254 225.447 123.136 226.054 122.9 226.56C122.664 227.062 122.341 227.45 121.929 227.723C121.517 227.993 121.047 228.128 120.518 228.128C120.12 228.128 119.795 228.061 119.542 227.928C119.292 227.794 119.096 227.638 118.954 227.459C118.812 227.28 118.703 227.121 118.626 226.982H118.52V228H117.275ZM118.524 224.727C118.524 225.187 118.591 225.591 118.724 225.938C118.858 226.284 119.051 226.555 119.304 226.751C119.556 226.945 119.866 227.041 120.233 227.041C120.613 227.041 120.931 226.94 121.187 226.739C121.443 226.534 121.636 226.257 121.767 225.908C121.9 225.558 121.967 225.165 121.967 224.727C121.967 224.295 121.902 223.908 121.771 223.564C121.643 223.22 121.45 222.949 121.191 222.75C120.936 222.551 120.616 222.452 120.233 222.452C119.863 222.452 119.551 222.547 119.295 222.737C119.042 222.928 118.85 223.193 118.72 223.534C118.589 223.875 118.524 224.273 118.524 224.727ZM125.959 219.273V228H124.685V219.273H125.959ZM130.494 228.132C129.849 228.132 129.294 227.994 128.828 227.719C128.365 227.44 128.007 227.05 127.754 226.547C127.504 226.041 127.379 225.449 127.379 224.77C127.379 224.099 127.504 223.509 127.754 222.997C128.007 222.486 128.359 222.087 128.811 221.8C129.265 221.513 129.797 221.369 130.404 221.369C130.774 221.369 131.132 221.43 131.478 221.553C131.825 221.675 132.136 221.866 132.412 222.128C132.687 222.389 132.904 222.729 133.064 223.146C133.223 223.561 133.302 224.065 133.302 224.659V225.111H128.099V224.156H132.054C132.054 223.821 131.985 223.524 131.849 223.266C131.713 223.004 131.521 222.798 131.274 222.648C131.029 222.497 130.743 222.422 130.413 222.422C130.055 222.422 129.743 222.51 129.475 222.686C129.211 222.859 129.007 223.087 128.862 223.368C128.72 223.646 128.649 223.949 128.649 224.276V225.021C128.649 225.459 128.725 225.831 128.879 226.138C129.035 226.445 129.252 226.679 129.531 226.841C129.809 227 130.135 227.08 130.507 227.08C130.748 227.08 130.968 227.045 131.167 226.977C131.366 226.906 131.538 226.801 131.683 226.662C131.828 226.523 131.939 226.351 132.015 226.146L133.221 226.364C133.125 226.719 132.951 227.03 132.701 227.297C132.454 227.561 132.143 227.767 131.768 227.915C131.396 228.06 130.971 228.132 130.494 228.132ZM137.994 228V219.273H143.406V220.406H139.311V223.065H143.018V224.195H139.311V228H137.994ZM147.263 228.132C146.619 228.132 146.063 227.994 145.597 227.719C145.134 227.44 144.776 227.05 144.523 226.547C144.273 226.041 144.148 225.449 144.148 224.77C144.148 224.099 144.273 223.509 144.523 222.997C144.776 222.486 145.129 222.087 145.58 221.8C146.035 221.513 146.566 221.369 147.174 221.369C147.543 221.369 147.901 221.43 148.248 221.553C148.594 221.675 148.906 221.866 149.181 222.128C149.457 222.389 149.674 222.729 149.833 223.146C149.992 223.561 150.072 224.065 150.072 224.659V225.111H144.869V224.156H148.823C148.823 223.821 148.755 223.524 148.619 223.266C148.482 223.004 148.29 222.798 148.043 222.648C147.799 222.497 147.512 222.422 147.183 222.422C146.825 222.422 146.512 222.51 146.245 222.686C145.981 222.859 145.776 223.087 145.631 223.368C145.489 223.646 145.418 223.949 145.418 224.276V225.021C145.418 225.459 145.495 225.831 145.648 226.138C145.805 226.445 146.022 226.679 146.3 226.841C146.579 227 146.904 227.08 147.276 227.08C147.518 227.08 147.738 227.045 147.937 226.977C148.136 226.906 148.308 226.801 148.452 226.662C148.597 226.523 148.708 226.351 148.785 226.146L149.991 226.364C149.894 226.719 149.721 227.03 149.471 227.297C149.224 227.561 148.913 227.767 148.538 227.915C148.165 228.06 147.741 228.132 147.263 228.132ZM153.39 228.145C152.975 228.145 152.6 228.068 152.265 227.915C151.93 227.759 151.664 227.533 151.468 227.237C151.275 226.942 151.179 226.58 151.179 226.151C151.179 225.781 151.25 225.477 151.392 225.239C151.534 225 151.725 224.811 151.967 224.672C152.208 224.533 152.478 224.428 152.777 224.357C153.075 224.286 153.379 224.232 153.689 224.195C154.081 224.149 154.399 224.112 154.643 224.084C154.887 224.053 155.065 224.003 155.176 223.935C155.287 223.866 155.342 223.756 155.342 223.602V223.572C155.342 223.2 155.237 222.912 155.027 222.707C154.819 222.503 154.51 222.401 154.098 222.401C153.669 222.401 153.331 222.496 153.083 222.686C152.839 222.874 152.67 223.082 152.576 223.312L151.379 223.04C151.521 222.642 151.728 222.321 152.001 222.077C152.277 221.83 152.593 221.651 152.951 221.54C153.309 221.426 153.686 221.369 154.081 221.369C154.342 221.369 154.619 221.401 154.912 221.463C155.207 221.523 155.483 221.634 155.738 221.795C155.997 221.957 156.208 222.189 156.373 222.49C156.538 222.788 156.62 223.176 156.62 223.653V228H155.376V227.105H155.325C155.243 227.27 155.119 227.432 154.954 227.591C154.789 227.75 154.578 227.882 154.319 227.987C154.061 228.092 153.751 228.145 153.39 228.145ZM153.667 227.122C154.02 227.122 154.321 227.053 154.571 226.913C154.824 226.774 155.015 226.592 155.146 226.368C155.279 226.141 155.346 225.898 155.346 225.639V224.795C155.301 224.841 155.213 224.884 155.082 224.923C154.954 224.96 154.808 224.993 154.643 225.021C154.478 225.047 154.318 225.071 154.162 225.094C154.005 225.114 153.875 225.131 153.77 225.145C153.522 225.176 153.297 225.229 153.092 225.303C152.89 225.376 152.728 225.483 152.606 225.622C152.487 225.759 152.427 225.94 152.427 226.168C152.427 226.483 152.544 226.722 152.777 226.884C153.01 227.043 153.306 227.122 153.667 227.122ZM161.373 221.455V222.477H157.798V221.455H161.373ZM158.756 219.886H160.031V226.078C160.031 226.325 160.067 226.511 160.141 226.636C160.215 226.759 160.31 226.842 160.427 226.888C160.546 226.93 160.675 226.952 160.815 226.952C160.917 226.952 161.006 226.945 161.083 226.93C161.16 226.916 161.219 226.905 161.262 226.896L161.492 227.949C161.418 227.977 161.313 228.006 161.177 228.034C161.04 228.065 160.87 228.082 160.665 228.085C160.33 228.091 160.018 228.031 159.728 227.906C159.438 227.781 159.204 227.588 159.025 227.327C158.846 227.065 158.756 226.737 158.756 226.342V219.886ZM166.929 225.286V221.455H168.207V228H166.954V226.866H166.886C166.735 227.216 166.494 227.507 166.162 227.74C165.832 227.97 165.422 228.085 164.93 228.085C164.51 228.085 164.137 227.993 163.814 227.808C163.493 227.621 163.24 227.344 163.055 226.977C162.873 226.611 162.782 226.158 162.782 225.618V221.455H164.056V225.464C164.056 225.911 164.18 226.266 164.427 226.53C164.674 226.794 164.995 226.926 165.39 226.926C165.629 226.926 165.866 226.866 166.102 226.747C166.341 226.628 166.538 226.447 166.694 226.206C166.853 225.964 166.931 225.658 166.929 225.286ZM169.919 228V221.455H171.151V222.494H171.219C171.338 222.142 171.548 221.865 171.849 221.663C172.153 221.459 172.497 221.357 172.881 221.357C172.96 221.357 173.054 221.359 173.162 221.365C173.273 221.371 173.359 221.378 173.422 221.386V222.605C173.371 222.591 173.28 222.575 173.149 222.558C173.018 222.538 172.888 222.528 172.757 222.528C172.456 222.528 172.188 222.592 171.952 222.72C171.719 222.845 171.534 223.02 171.398 223.244C171.261 223.466 171.193 223.719 171.193 224.003V228H169.919ZM177.111 228.132C176.466 228.132 175.911 227.994 175.445 227.719C174.982 227.44 174.624 227.05 174.371 226.547C174.121 226.041 173.996 225.449 173.996 224.77C173.996 224.099 174.121 223.509 174.371 222.997C174.624 222.486 174.976 222.087 175.428 221.8C175.882 221.513 176.414 221.369 177.022 221.369C177.391 221.369 177.749 221.43 178.096 221.553C178.442 221.675 178.753 221.866 179.029 222.128C179.304 222.389 179.522 222.729 179.681 223.146C179.84 223.561 179.919 224.065 179.919 224.659V225.111H174.716V224.156H178.671C178.671 223.821 178.603 223.524 178.466 223.266C178.33 223.004 178.138 222.798 177.891 222.648C177.647 222.497 177.36 222.422 177.03 222.422C176.672 222.422 176.36 222.51 176.093 222.686C175.828 222.859 175.624 223.087 175.479 223.368C175.337 223.646 175.266 223.949 175.266 224.276V225.021C175.266 225.459 175.343 225.831 175.496 226.138C175.652 226.445 175.87 226.679 176.148 226.841C176.426 227 176.752 227.08 177.124 227.08C177.365 227.08 177.586 227.045 177.784 226.977C177.983 226.906 178.155 226.801 178.3 226.662C178.445 226.523 178.556 226.351 178.632 226.146L179.838 226.364C179.742 226.719 179.569 227.03 179.319 227.297C179.071 227.561 178.76 227.767 178.385 227.915C178.013 228.06 177.588 228.132 177.111 228.132ZM186.238 223.053L185.083 223.257C185.035 223.109 184.958 222.969 184.853 222.835C184.751 222.702 184.612 222.592 184.435 222.507C184.259 222.422 184.039 222.379 183.775 222.379C183.414 222.379 183.113 222.46 182.871 222.622C182.63 222.781 182.509 222.987 182.509 223.24C182.509 223.459 182.59 223.635 182.752 223.768C182.914 223.902 183.175 224.011 183.536 224.097L184.576 224.335C185.178 224.474 185.627 224.689 185.923 224.979C186.218 225.268 186.366 225.645 186.366 226.108C186.366 226.5 186.252 226.849 186.025 227.156C185.8 227.46 185.487 227.699 185.083 227.872C184.683 228.045 184.218 228.132 183.69 228.132C182.957 228.132 182.359 227.976 181.896 227.663C181.433 227.348 181.148 226.901 181.043 226.321L182.275 226.134C182.352 226.455 182.509 226.697 182.748 226.862C182.987 227.024 183.298 227.105 183.681 227.105C184.099 227.105 184.433 227.018 184.683 226.845C184.933 226.669 185.058 226.455 185.058 226.202C185.058 225.997 184.981 225.825 184.827 225.686C184.677 225.547 184.445 225.442 184.133 225.371L183.025 225.128C182.414 224.989 181.962 224.767 181.67 224.463C181.38 224.159 181.235 223.774 181.235 223.308C181.235 222.922 181.343 222.584 181.559 222.294C181.775 222.004 182.073 221.778 182.454 221.616C182.835 221.452 183.271 221.369 183.762 221.369C184.469 221.369 185.026 221.523 185.433 221.83C185.839 222.134 186.107 222.541 186.238 223.053ZM89.326 243.124C88.7408 243.124 88.2365 243.017 87.8132 242.804C87.3928 242.591 87.0689 242.301 86.8416 241.935C86.6143 241.565 86.5007 241.148 86.5007 240.682C86.5007 240.327 86.5746 240.011 86.7223 239.736C86.87 239.457 87.076 239.2 87.3402 238.964C87.6044 238.729 87.9098 238.491 88.2564 238.253L89.6626 237.26C89.9013 237.104 90.0874 236.939 90.2209 236.766C90.3544 236.589 90.4212 236.372 90.4212 236.114C90.4212 235.909 90.3331 235.713 90.157 235.526C89.9808 235.338 89.745 235.244 89.4496 235.244C89.245 235.244 89.0646 235.294 88.9084 235.393C88.755 235.493 88.6342 235.621 88.5462 235.777C88.4609 235.93 88.4183 236.092 88.4183 236.263C88.4183 236.462 88.4723 236.662 88.5803 236.864C88.6911 237.065 88.8331 237.274 89.0064 237.49C89.1797 237.703 89.3615 237.925 89.5518 238.155L93.6044 243H92.1641L88.8104 239.058C88.5291 238.726 88.2678 238.413 88.0263 238.121C87.7848 237.825 87.5888 237.527 87.4382 237.226C87.2905 236.922 87.2166 236.594 87.2166 236.241C87.2166 235.841 87.3075 235.486 87.4893 235.176C87.674 234.864 87.9311 234.619 88.2607 234.443C88.5902 234.267 88.9766 234.179 89.4197 234.179C89.8686 234.179 90.2536 234.267 90.5746 234.443C90.8984 234.616 91.147 234.848 91.3203 235.138C91.4964 235.425 91.5845 235.739 91.5845 236.08C91.5845 236.494 91.4808 236.861 91.2734 237.179C91.0689 237.494 90.7862 237.784 90.4254 238.048L88.674 239.339C88.3331 239.589 88.0959 239.837 87.9624 240.081C87.8317 240.322 87.7663 240.511 87.7663 240.648C87.7663 240.898 87.8303 241.129 87.9581 241.342C88.0888 241.555 88.2706 241.726 88.5036 241.854C88.7393 241.982 89.0149 242.045 89.3303 242.045C89.6541 242.045 89.9695 241.976 90.2763 241.837C90.5859 241.695 90.8658 241.491 91.1158 241.227C91.3686 240.963 91.5689 240.646 91.7166 240.277C91.8643 239.908 91.9382 239.494 91.9382 239.037H93.0888C93.0888 239.599 93.0249 240.075 92.897 240.464C92.7692 240.851 92.6143 241.166 92.4325 241.411C92.2536 241.652 92.0845 241.841 91.9254 241.977C91.8743 242.023 91.826 242.068 91.7805 242.114C91.7351 242.159 91.6868 242.205 91.6357 242.25C91.3402 242.548 90.9822 242.768 90.5618 242.911C90.1442 243.053 89.7322 243.124 89.326 243.124ZM97.8807 243V234.273H99.1974V241.866H103.152V243H97.8807ZM104.552 243V236.455H105.826V243H104.552ZM105.195 235.445C104.974 235.445 104.783 235.371 104.624 235.223C104.468 235.072 104.39 234.893 104.39 234.686C104.39 234.476 104.468 234.297 104.624 234.149C104.783 233.999 104.974 233.923 105.195 233.923C105.417 233.923 105.606 233.999 105.762 234.149C105.921 234.297 106.001 234.476 106.001 234.686C106.001 234.893 105.921 235.072 105.762 235.223C105.606 235.371 105.417 235.445 105.195 235.445ZM107.54 243V236.455H108.763V237.52H108.844C108.98 237.159 109.203 236.878 109.513 236.676C109.823 236.472 110.194 236.369 110.625 236.369C111.063 236.369 111.429 236.472 111.725 236.676C112.023 236.881 112.243 237.162 112.385 237.52H112.453C112.61 237.17 112.858 236.892 113.199 236.685C113.54 236.474 113.946 236.369 114.418 236.369C115.012 236.369 115.496 236.555 115.871 236.928C116.249 237.3 116.438 237.861 116.438 238.611V243H115.164V238.73C115.164 238.287 115.043 237.966 114.801 237.767C114.56 237.568 114.272 237.469 113.936 237.469C113.522 237.469 113.199 237.597 112.969 237.852C112.739 238.105 112.624 238.43 112.624 238.828V243H111.354V238.649C111.354 238.294 111.243 238.009 111.022 237.793C110.8 237.577 110.512 237.469 110.157 237.469C109.915 237.469 109.692 237.533 109.488 237.661C109.286 237.786 109.123 237.96 108.998 238.185C108.875 238.409 108.814 238.669 108.814 238.964V243H107.54ZM118.146 243V236.455H119.42V243H118.146ZM118.789 235.445C118.567 235.445 118.377 235.371 118.218 235.223C118.062 235.072 117.984 234.893 117.984 234.686C117.984 234.476 118.062 234.297 118.218 234.149C118.377 233.999 118.567 233.923 118.789 233.923C119.011 233.923 119.2 233.999 119.356 234.149C119.515 234.297 119.594 234.476 119.594 234.686C119.594 234.893 119.515 235.072 119.356 235.223C119.2 235.371 119.011 235.445 118.789 235.445ZM124.189 236.455V237.477H120.614V236.455H124.189ZM121.573 234.886H122.847V241.078C122.847 241.325 122.884 241.511 122.958 241.636C123.032 241.759 123.127 241.842 123.243 241.888C123.363 241.93 123.492 241.952 123.631 241.952C123.733 241.952 123.823 241.945 123.9 241.93C123.976 241.916 124.036 241.905 124.078 241.896L124.309 242.949C124.235 242.977 124.13 243.006 123.993 243.034C123.857 243.065 123.686 243.082 123.482 243.085C123.147 243.091 122.834 243.031 122.544 242.906C122.255 242.781 122.02 242.588 121.841 242.327C121.662 242.065 121.573 241.737 121.573 241.342V234.886ZM130.398 238.053L129.243 238.257C129.195 238.109 129.118 237.969 129.013 237.835C128.911 237.702 128.772 237.592 128.596 237.507C128.419 237.422 128.199 237.379 127.935 237.379C127.574 237.379 127.273 237.46 127.032 237.622C126.79 237.781 126.669 237.987 126.669 238.24C126.669 238.459 126.75 238.635 126.912 238.768C127.074 238.902 127.336 239.011 127.696 239.097L128.736 239.335C129.338 239.474 129.787 239.689 130.083 239.979C130.378 240.268 130.526 240.645 130.526 241.108C130.526 241.5 130.412 241.849 130.185 242.156C129.961 242.46 129.647 242.699 129.243 242.872C128.843 243.045 128.378 243.132 127.85 243.132C127.117 243.132 126.519 242.976 126.056 242.663C125.593 242.348 125.309 241.901 125.203 241.321L126.435 241.134C126.512 241.455 126.669 241.697 126.908 241.862C127.147 242.024 127.458 242.105 127.841 242.105C128.259 242.105 128.593 242.018 128.843 241.845C129.093 241.669 129.218 241.455 129.218 241.202C129.218 240.997 129.141 240.825 128.988 240.686C128.837 240.547 128.605 240.442 128.293 240.371L127.185 240.128C126.574 239.989 126.123 239.767 125.83 239.463C125.54 239.159 125.395 238.774 125.395 238.308C125.395 237.922 125.503 237.584 125.719 237.294C125.935 237.004 126.233 236.778 126.614 236.616C126.995 236.452 127.431 236.369 127.922 236.369C128.63 236.369 129.186 236.523 129.593 236.83C129.999 237.134 130.267 237.541 130.398 238.053Z" fill="#334257"/>
                                        <g filter="url(#filter6_d_7301_41)">
                                        <path d="M274.94 55.3288L259.107 54.2608C257.263 54.1364 255.869 52.5405 255.993 50.6961C256.119 48.851 257.714 47.4569 259.559 47.5813L264.371 47.906C250.157 29.9268 228.794 28.8247 216.844 39.0826C216.412 39.4538 215.799 38.9277 216.076 38.4498C224.769 23.5162 246.869 17.5586 266.955 34.8992C268.878 36.5976 270.761 38.3705 272.605 40.2044L272.893 35.9309C273.017 34.0866 274.614 32.6917 276.458 32.8168C278.302 32.9413 279.697 34.5364 279.572 36.3815L278.504 52.2139C278.38 54.0591 276.784 55.4532 274.94 55.3288Z" fill="#334257"/>
                                        </g>
                                        <g filter="url(#filter7_d_7301_41)">
                                        <path d="M268.213 233.502L252.385 234.64C250.542 234.773 248.94 233.386 248.807 231.542C248.675 229.697 250.062 228.095 251.906 227.963L256.717 227.617C240.146 211.783 218.837 213.655 208.425 225.471C208.049 225.899 207.369 225.463 207.577 224.951C214.115 208.956 235.174 199.99 257.471 214.377C259.612 215.792 261.722 217.287 263.802 218.847L263.495 214.575C263.363 212.731 264.75 211.128 266.593 210.997C268.437 210.864 270.04 212.25 270.172 214.095L271.31 229.922C271.444 231.767 270.057 233.369 268.213 233.502Z" fill="#334257"/>
                                        </g>
                                        <defs>
                                        <filter id="filter0_d_7301_41" x="221.178" y="8.78539" width="217.644" height="288.644" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feOffset dy="3.60731"/>
                                        <feGaussianBlur stdDeviation="5.41096"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.379167 0 0 0 0 0.379167 0 0 0 0.15 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter1_d_7301_41" x="217.571" y="4.45662" width="224.858" height="347.858" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feOffset dy="2.88584"/>
                                        <feGaussianBlur stdDeviation="7.21461"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter2_d_7301_41" x="366.556" y="103.445" width="72.2669" height="39.7159" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feOffset dy="3.47757"/>
                                        <feGaussianBlur stdDeviation="2.17348"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.18 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter3_d_7301_41" x="86" y="12" width="135" height="49" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feMorphology radius="3" operator="erode" in="SourceAlpha" result="effect1_dropShadow_7301_41"/>
                                        <feOffset/>
                                        <feGaussianBlur stdDeviation="6"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0.2 0 0 0 0 0.258824 0 0 0 0 0.341176 0 0 0 0.2 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter4_d_7301_41" x="429" y="91" width="194" height="49" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feMorphology radius="3" operator="erode" in="SourceAlpha" result="effect1_dropShadow_7301_41"/>
                                        <feOffset/>
                                        <feGaussianBlur stdDeviation="6"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0.2 0 0 0 0 0.258824 0 0 0 0 0.341176 0 0 0 0.2 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter5_d_7301_41" x="0" y="196" width="211" height="64" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feMorphology radius="3" operator="erode" in="SourceAlpha" result="effect1_dropShadow_7301_41"/>
                                        <feOffset/>
                                        <feGaussianBlur stdDeviation="6"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0.2 0 0 0 0 0.258824 0 0 0 0 0.341176 0 0 0 0.2 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter6_d_7301_41" x="211.66" y="23.4451" width="72.2669" height="39.7159" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feOffset dy="3.47757"/>
                                        <feGaussianBlur stdDeviation="2.17348"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.18 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <filter id="filter7_d_7301_41" x="203.191" y="206.284" width="72.4749" height="36.1895" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                        <feOffset dy="3.47757"/>
                                        <feGaussianBlur stdDeviation="2.17348"/>
                                        <feComposite in2="hardAlpha" operator="out"/>
                                        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.18 0"/>
                                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_7301_41"/>
                                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_7301_41" result="shape"/>
                                        </filter>
                                        <clipPath id="clip0_7301_41">
                                        <rect x="232" y="16" width="196" height="267" rx="8" fill="white"/>
                                        </clipPath>
                                        </defs>
                                        </svg>

                                </div>
                            </div>
                            <div class="btn--container justify-content-end">
                                <button type="reset" class="btn btn--primary" data-dismiss="modal">
                                    {{ translate('Okay') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




@endsection

@push('script_2')

<script>
"use strict";
    $('#select-all').on('change', function(){
        if($(this).is(':checked')){
            $('.package-available-feature').prop('checked', true);
        }else{
            $('.package-available-feature').prop('checked', false);
        }
    })
    $('.package-available-feature').on('change', function(){
        if($(this).is(':checked')){
            if($('.package-available-feature').length == $('.package-available-feature:checked').length){
                $('#select-all').prop('checked', true);
            }
        }else{
            $('#select-all').prop('checked', false);
        }
    })

    $('.limit-input').on('change', function(){
            if($(this).is(':checked')){
                if($(this).val() == 'Use_Limit'){
                $(this).closest('.limit-item-card').find('.custom-limit-box').show();
                $(this).closest('.limit-item-card').find('.max_required').prop('required', true);
            } else {
                $(this).closest('.limit-item-card').find('.custom-limit-box').hide();
                $(this).closest('.limit-item-card').find('.max_required').removeAttr('required');
            }
        }
    })




    $(document).on("click", ".btn--reset", function () {
        $('.custom-limit-box').hide();
        $('.max_required').removeAttr('required');
    });

</script>

@endpush

